
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)connect.c	1.12	(NCSA)	8/10/87";
#endif lint

/*
** telnet program connect routines
*/

#include <sys/types.h>
#include <sys/file.h>
#include <errno.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sgtty.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>
#include <suntool/panel.h>
#include <sunwindow/defaults.h>
#include <sunwindow/notify.h>
#include "defs.h"
#include "session.h"

extern Scrollbar scrx, scry;
extern Panel menubar;
Notify_value nethandler();

get_connect(host)
char *host;
{

	extern Frame base_frame;
	struct hostent *hp;
	struct servent *sp;
	struct protoent *pp;
	struct sockaddr_in neta;
	unsigned long inet_addr();

	int n;

	/*
	** look up the host we want to connect to
	*/

	hourglasscursor(menubar);
	hourglasscursor(Session.s_canvas);

	bzero((char *)&neta, sizeof(neta));

	hp = gethostbyname(host);

	if (hp == 0) {
		neta.sin_family = AF_INET;
		neta.sin_addr.s_addr = inet_addr(host);
		if (neta.sin_addr.s_addr == -1L) {
			errmsg("No such host %s",host);
			normalcursor(menubar);
			normalcursor(Session.s_canvas);
			return 0;
		}
	}
	else {
		neta.sin_family = hp->h_addrtype;
		bcopy(hp->h_addr, (char *)&neta.sin_addr, hp->h_length);
	}

	/*
	** look up the port and protocol for telnet.  It must use
	** tcp.
	*/

	sp = getservbyname("telnet","tcp");

	if (sp == 0) {
		(void)errmsg("can't lookup telnet service",(char *) 0);
		normalcursor(menubar);
		normalcursor(Session.s_canvas);
		return 0;
	}

	/*
	** find out all about tcp protocol
	*/

	pp = getprotobyname(sp->s_proto);

	if (pp == 0) {
		(void)errmsg("no such protocol, %s\n",sp->s_proto);
		normalcursor(Session.s_canvas);
		normalcursor(menubar);
		return 0;
	}

	/*
	** open the network connection
	*/

	Session.s_fd = socket(AF_INET, SOCK_STREAM, pp->p_proto);

	if (Session.s_fd < 0) {
		syserr("socket");
		normalcursor(Session.s_canvas);
		normalcursor(menubar);
		return 0;
	}

	/*
	** now set up the address to connect to.  first zero it,
	** then install the host address we looked up with
	** gethostbyname
	*/

	neta.sin_port = sp->s_port;		/* seems to work on 386 */

	/*
	** attempt to connect to the telnet port on the host
	*/

	if (connect(Session.s_fd, (struct sockaddr *)&neta, sizeof(neta)) < 0) {
		syserr("connect");
		normalcursor(menubar);
		normalcursor(Session.s_canvas);
		return 0;
	}

	Session.s_valid = TRUE;
	strcpy(Session.s_hostn, host);

	/*
	** turn on non-blocking i/o for net descriptor
	*/

	(void)fcntl(Session.s_fd, F_SETFL, FNDELAY);

	/*
	** zap old session window, and make new one
	*/

	VSdestroy(Session.s_winval);

	scrollbar_set(scrx,SCROLL_VIEW_START,0,0);
	scrollbar_set(scry,SCROLL_VIEW_START,0,0);

	scrollbar_set(scrx,SCROLL_OBJECT_LENGTH, 132, 0);
	scrollbar_set(scry,SCROLL_OBJECT_LENGTH,
		(Session.s_scroll == 0) ? 25 : Session.s_scroll,0);

	scrollbar_set(scrx, SCROLL_VIEW_LENGTH, 80, 0);
	scrollbar_set(scry, SCROLL_VIEW_LENGTH, 
		(Session.s_scroll == 0) ? 25 : Session.s_scroll,0);

	scrollbar_paint(scrx);
	scrollbar_paint(scry);

	Session.s_winval = VSnewscreen((Session.s_scroll == 0) ? 25 :  
			Session.s_scroll, 1, 132, 1);

	RSattach(0, base_frame, Session.s_winval, Session.s_canvas, 
		Session.s_fd, scrx, scry);

	notify_set_input_func(Session.s_canvas, nethandler, Session.s_fd);

	/*
	** clear the virtual screen
	*/

	VSclear(0);

	/*
	** set the telnet the way we want it.
	*/

	netwrite(Session.s_winval,"\377\375\001\377\375\003",6);	

	normalcursor(menubar);
	normalcursor(Session.s_canvas);
	return 1;
}

/*
** read from the network and display output
** a read count of zero should terminate the connection
*/

char buffer[128];

Notify_value nethandler(me, fd)
Notify_client me;
int fd;
{
	int count;
	int i, n;

	/*
	** figure out where to read from
	*/

	if (Session.s_lock)
		return;

	count = read(fd, buffer, sizeof(buffer));

	/*
	** read of zero.  Close window and terminate session
	*/

	if (count == 0) {
		char buf[128];

		strcpy(buf, "Connection Closed.");
		VSwrite(Session.s_winval, buf, strlen(buf));
		closecon();

		return NOTIFY_DONE;

	}

	/*
	** do the telnet processing
	*/

	parse(&Session,buffer,count);

	return NOTIFY_DONE;
}

/*
** kill the connection
*/

closecon()
{

	extern Frame base_frame;
	extern Icon fr_icon;
	extern char *prog_name, labelname[];
	extern captureflag;
	extern FILE *capf;

	notify_set_input_func(Session.s_canvas, NOTIFY_FUNC_NULL, 
						  Session.s_fd);

	if(close(Session.s_fd) < 0)
		syserr("close");

	Session.s_hostn[0] = '\0';
	Session.s_valid = FALSE;
	Session.s_fd = -1;
	Session.s_telstate = 0;
	Session.s_termstate = VTTYPE;
	Session.s_echo = 1;
	Session.s_linemode[0] = '\0';

	strcpy(labelname, prog_name);
	strcat(labelname, "Not Connected");
	icon_set(fr_icon, ICON_LABEL, "N.C.", 0);
	window_set(base_frame, FRAME_LABEL, labelname, FRAME_ICON, fr_icon, 0);
	
	invalidate_menus();

	if (captureflag > 0) {
		int cstat;

		if (captureflag == 1)
			cstat = fclose(capf);
		else
			cstat = pclose(capf);
		if (cstat == EOF)
			syserr(close);
		captureflag = 0;
	}

	return;
}

/*
** initialize data structures
*/

initcon()
{

	Session.s_special[0] =
			get_special(defaults_get_string("/Teltool/Erase_Char","^?",0));

	Session.s_special[1] =
			get_special(defaults_get_string("/Teltool/Erase_Line","^U",0));

	Session.s_special[2] =
			get_special(defaults_get_string("/Teltool/Interrupt_Proc","^C",0));

	Session.s_special[3] =
			get_special(defaults_get_string("/Teltool/Abort_Output","^O",0));

	Session.s_special[4] =
			get_special(defaults_get_string("/Teltool/Send_Break","^A",0));

	Session.s_special[5] =
			get_special(defaults_get_string("/Teltool/Scroll_Lock","^S",0));

	Session.s_spcflag = FALSE;
	Session.s_valid = FALSE;
	Session.s_fd = -1;
	Session.s_hostn[0] = '\0';
	Session.s_telstate = 0;
	Session.s_termstate = VTTYPE;
	Session.s_echo = 1;
	Session.s_linemode[0] = '\0';

}

/*
** send some output back to das net
*/

netwrite(w, buf, len)
int w;
char *buf;
int len;
{

	(void)write(Session.s_fd, buf, len);
}

/*
** redraw
*/

redraw(canvas, pixwin, repaint_area)
Canvas canvas;
Pixwin *pixwin;
Rectlist *repaint_area;
{

	debug(5,"In redraw\r\n");
	VSredraw(RSgetwin(canvas), 0, 0, 79, 23);
	Session.s_termstate = VTTYPE;

}
