#include "globals.h"

int	getToken(stringPtr, scanPtr, tokenList)
unsigned char **stringPtr, **scanPtr, **tokenList;
/* Get the next valid token. */
{
	unsigned char *ptr, *tPtr, c;
	unsigned char tStr[100];
	int	token;
	
	ptr = *stringPtr;
	for(;;) {
		while((c = *ptr) && Sissep(c))	/* Get rid of junk before token */
			ptr++;
		if(c == 0)
			return(EOS);
		tPtr = tStr;
		while((c = *ptr++) && !Sissep(c))
			*tPtr++ = c;
		if(c == 0)
			return(EOS);
		*tPtr = 0;
		for(token=0; *tokenList[token] && strcmp(tokenList[token], tStr); token++);
		*scanPtr = ptr;
		while((c = *ptr++) && c != '\n' && c != '\r');
		*stringPtr = ptr;
		if(*tokenList[token])
			return(token+1);
	}
}

int scanInt(scanPtr)
unsigned char **scanPtr;
/* Scan for either "%u," or "%u\n", update scanPtr and return value.
   Return -1 if scan failed.*/
{
	unsigned char *ptr, c;
	int value;
	
	ptr = *scanPtr;
	if(sscanf(ptr, "%u", &value) == 0)
		return(-1);
	while((c = *ptr++) && c != ',' && c != '\n' && c != '\r');
	*scanPtr = ptr;
	return(value);
}

Sissep(c)
	unsigned char c;
	{
	if (c == ' ' || c == '=' || c == '\t' || c == '\n' || c == '\r')
		return(1);
		
	return(0);
	
}