/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMSCDEFS.H - definitions for scanner
 *
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:18:12  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMSCDEFS.H_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:18:12   gfoster
 * Removed unnecessary revision comment lines added by
 * PVSC to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 16:38:28   gfoster
 * Copyright text was reformated.
 * 
 *    Rev 1.0   27 May 1992 16:18:16   gfoster
 * Initial revision.
 *
*/

#define tokEOF 0                /* end of file token */

#define STRSPACESZ 16384        /* size of a string space */
#define MXCSTRSP 128            /* max number of string spaces */
#define MXDFINT 11              /* max number of digits in an integer */

#define MXLV 3                      /* max level of include files */

extern BOOL NEAR fNoStr;            /* flag to not output strings */
extern BOOL NEAR fPrintIname;       /* flag to print include file names */

extern USHORT NEAR cErr;            /* error counter */
extern USHORT NEAR cWarn;           /* warning counter */

extern FILE * NEAR fhIn;            /* current input file handle */
extern PSZ NEAR pszInFile;          /* current input file name */
extern PSZ NEAR pszBaseFile;        /* base input file name */
extern USHORT NEAR usLineNo;        /* current line number */
extern USHORT NEAR usColNo;         /* current char position on line */
extern USHORT NEAR usTokLineNo;     /* line where token starts */
extern USHORT NEAR usTokColNo;      /* column where token starts */
extern SHORT NEAR sTokType;         /* token type */
extern PSZ NEAR pszTokVal;          /* literal value of current token */


extern USHORT NEAR usInclLevel;     /* current level of include files */
extern FILE * NEAR afhIn[MXLV];     /* file handle stack */
extern PSZ NEAR apszInFile[MXLV];   /* file name stack */
extern USHORT NEAR ausLineNo[MXLV]; /* line number stack */
extern USHORT NEAR ausColNo[MXLV];  /* column position stack */
extern INT NEAR aLexChar[MXLV];     /* input char stack */

extern BYTE * NEAR pbStrSpace;      /* ptr to current string space */
extern USHORT NEAR usStrSpaceSz;    /* size of current string space */
extern USHORT NEAR usStrSpaceIndx;  /* current position in string space */
extern USHORT NEAR usStrSpaceTokIndx;/* position of start of current token */
extern USHORT NEAR cStrSpace;       /* number of string spaces */
extern BYTE * NEAR apbStrSpace[MXCSTRSP];/* ptrs for string spaces */
extern USHORT NEAR ausStrSpaceSz[MXCSTRSP];/* actual amount of space used */

extern INT NEAR LexChar;            /* current(or next) input character */
extern CHAR szTok[2];               /* place to store single char tokens */
extern CHAR szNum[MXDFINT+1];       /* place to store a number */

extern PSZ NEAR pszY1optString;      /* where the -Y1 string is stored if any */
extern PSZ NEAR pszY2optString;      /* where the -Y2 string is stored if any */

#ifdef __STDC__
INT  yylex(VOID);
BOOL yylexinit(VOID);
VOID yyerror(PSZ pszMsg, ...);
VOID smerror(PSZ pszFn, USHORT usLineNo, USHORT usColNo, PSZ pszMsg, ...);
VOID yywarning(PSZ pszMsg, ...);
VOID smwarning(PSZ pszFn, USHORT usLineNo, USHORT usColNo, PSZ pszMsg, ...);
PSZ  yylexstr(PSZ pszV);
VOID yyterm(VOID);
BOOL isKWlistSorted(VOID);
VOID freqKWhash(VOID);
VOID makeKWdef(VOID);
VOID makeKWundef(VOID);
BOOL addSMIitem(PSZ pszNa);
USHORT getKWuse(USHORT iKW);
SHORT getKWindex(PSZ pszName, BOOL fDef);
USHORT checkSMIname(PSZ pszNa, USHORT *pusIndx);
#else
INT  yylex();
BOOL yylexinit();
VOID yyfatal();
VOID smfatal();
VOID yyerror();
VOID smerror();
VOID yywarning();
VOID smwarning();
PSZ  yylexstr();
VOID yyterm();
BOOL isKWlistSorted();
VOID freqKWhash();
VOID makeKWdef();
VOID makeKWundef();
BOOL addSMIitem();
USHORT getKWuse();
SHORT getKWindex();
USHORT checkSMIname();
#endif /* __STDC__ */

/* return codes from checkSMIname */
#define SMISTnsmi 1             /* not SMI name */
#define SMISTad   2             /* name already defined */
#define SMISTsmi  3             /* is SMI name */

/* end of file: SMSCDEFS.H */
