/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMIC.H - compiler globals and functions
 *
 * $Revision:   1.4  $ $Date:   27 Jul 1992 19:54:44  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMIC.H_V  $
 * 
 *    Rev 1.4   27 Jul 1992 19:54:44   gfoster
 * Change the variable name fNoCheckIndxSeq
 * to fCheckIndxSeq to accommodate the -7
 * option providing stricter index item checking
 * instead of looser checking.
 * 
 *    Rev 1.3   08 Jul 1992 17:16:42   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.2   29 Jun 1992 20:03:58   gfoster
 * Added the non-ANSI C external function declarations
 * for the addMODalias, addSYMalias, and newIMPI
 * functions.
 * 
 *    Rev 1.1   19 Jun 1992 16:37:00   gfoster
 * Copyright text was reformated.
 * 
 * Definitions were reordered.
 * 
 * Name of variable "usOptChar" changed to "chOptChar".
 * 
 *    Rev 1.0   27 May 1992 16:21:40   gfoster
 * Initial revision.
 *
*/


extern USHORT cStrAlloc;
extern USHORT cStrUsed;

extern FILE *fhOut;
extern FILE *fhMsg;

extern CHAR chOptChar;
extern CHAR chSepChar;
extern CHAR chDirChar;
extern PSZ pszSmicIncl;

#define SMICINCL "SMICINCL"     /* name of environment variable
                                    that has list of directories */


#define MXOIDL 64               /* max nesting of OIDs */

#define MIBOIDACT 30            /* number of oid objects to allocate */
extern MIBSYM *pOidAvail;              /* available list ptr to oid objects */
extern MIBSYM *pOidGHL;                /* header of global list of oid objects */
extern MIBSYM *pOidGTL;                /* tail of global list of oid objects */
extern MIBSYM OidRoot;                 /* root of OID tree (note: must be init'ed) */
extern USHORT cOidUsed;                /* number of oid objects allocated */
extern USHORT cOidAlloc;               /* number of oid objects used */
extern CHAR szBuf[80];                 /* temp formatting area */

#define MIBMODACT 5             /* number of modules to allocate */
extern MIBSYM *pModAvail;              /* available list ptr to modules */
extern MIBSYM *pModGHL;                /* header of global list of modules */
extern MIBSYM *pModGTL;                /* tail of global list of modules */
extern USHORT cModUsed;                /* number of modules used */
extern USHORT cModAlloc;               /* number of modules allocated */

#define MIBMODREFACT 8          /* number of module refs to allocate */
extern MIBMODREF *pModRefAvail;        /* available list ptr to module refs */
extern USHORT cModRefUsed;             /* number of module refs used */
extern USHORT cModRefAlloc;            /* number of module refs allocated */

#define MIBIMPIACT 20           /* number of imported items to allocate */
extern MIBIMPI *pImpiAvail;            /* available list ptr to imported items */
extern USHORT cImpiUsed;               /* number of imported items used */
extern USHORT cImpiAlloc;              /* number of imported items allocated */

#define MIBIMPACT 20            /* number of imported items to allocate */
extern MIBSYM *pImpAvail;              /* available list ptr to imported items */
extern MIBSYM *pImpGHL;                /* header of global list of imports */
extern MIBSYM *pImpGTL;                /* tail of global list of imports */
extern USHORT cImpUsed;                /* number of imports used */
extern USHORT cImpAlloc;               /* number of imports allocated */

#define MIBALACT 10             /* number of alias items to allocate */
extern MIBSYM *pAlAvail;               /* available list ptr to imported items */
extern MIBSYM *pAlGHL;                 /* header of global list of imports */
extern MIBSYM *pAlGTL;                 /* tail of global list of imports */
extern USHORT cAlUsed;                 /* number of imports used */
extern USHORT cAlAlloc;                /* number of imports allocated */

#define MIBSMIACT 8             /* number of smi items to allocate */
extern MIBSYM *pSmiAvail;              /* available list ptr to smi items */
extern MIBSYM *pSmiGHL;                /* header of global list of smi items */
extern MIBSYM *pSmiGTL;                /* tail of global list of smi items */
extern USHORT cSmiUsed;                /* number of SMI items used */
extern USHORT cSmiAlloc;               /* number of SMI items allocated */

/* Definitions from SMTR.C */
#define MIBTRACT 20             /* number of traps to allocate */
extern MIBSYM *pTrAvail;               /* available list ptr to traps */
extern MIBSYM *pTrGHL;                 /* header of global list of traps */
extern MIBSYM *pTrGTL;                 /* tail of global list of traps */
extern USHORT cTrUsed;                 /* number of traps used */
extern USHORT cTrAlloc;                /* number of traps allocated */

#define MIBVARACT 20            /* number of trap variables to allocate */
extern MIBVAR *pVarAvail;              /* available list ptr to trap vars */
extern USHORT cVarUsed;                /* number of trap variables used */
extern USHORT cVarAlloc;               /* number of trap variables allocated */

#define MIBENTACT 5             /* number of Enterprises to allocate */
extern MIBENT *pEntAvail;              /* available list ptr to enterprises */
extern MIBENT *pEntGHL;                /* header of global list of enterprises */
extern MIBENT *pEntGTL;                /* tail of global list of enterprises */
extern USHORT cEntUsed;                /* number of enterprises used */
extern USHORT cEntAlloc;               /* number of enterprises allocated */

#define MIBTCACT 5              /* number of tc objects to allocate */
extern MIBSYM *pTcAvail;               /* available list ptr to tc objects */
extern MIBSYM *pTcGHL;                 /* header of global list of tc objects */
extern MIBSYM *pTcGTL;                 /* tail of global list of tc objects */
extern USHORT cTcUsed;                 /* number of tc objects used */
extern USHORT cTcAlloc;                /* number of tc objects allocated */

#define MIBSEQACT 10            /* number of sequence objects to allocate */
extern MIBSYM *pSeqAvail;              /* available list ptr to seq objects */
extern MIBSYM *pSeqGHL;                /* header of global list of seq objects */
extern MIBSYM *pSeqGTL;                /* tail of global list of seq objects */
extern USHORT cSeqUsed;                /* number of sequence objects used */
extern USHORT cSeqAlloc;               /* number of sequence objects allocated */

#define MIBSEQIACT 20           /* number of sequence items to allocate */
extern MIBSEQI *pSeqiAvail;            /* available list ptr to sequence items */
extern USHORT cSeqiUsed;               /* number of sequence items used */
extern USHORT cSeqiAlloc;              /* number of sequence items allocated */

#define MIBENUMACT 20           /* number of enumerated items to allocate */
extern MIBENUM *pEnumAvail;            /* available list ptr to enumerated items */
extern USHORT cEnumUsed;               /* number of enumerated items used */
extern USHORT cEnumAlloc;              /* number of enumerated items allocated */

#define MIBINDXACT 20           /* number of index items to allocate */
extern MIBINDX *pIndxAvail;            /* available list ptr to index items */
extern USHORT cIndxUsed;               /* number of index items used */
extern USHORT cIndxAlloc;              /* number of index items allocated */

extern BOOL fDebugStrTab;              /* dump string table */
extern BOOL fDebugMOD;                 /* dump module names */
extern BOOL fDebugOID;                 /* dump OID table */
extern BOOL fDebugOIDtree;             /* dump OID tree */
extern BOOL fDebugName;                /* dump Names of OID items */
extern BOOL fDebugIMP;                 /* dump IMP names */
extern BOOL fDebugAL;                  /* dump Alias names */
extern BOOL fDebugSMI;                 /* dump SMI names */
extern BOOL fDebugTRAP;                /* dump trap names */
extern BOOL fDebugTC;                  /* dump textual conventions */
extern BOOL fDebugSEQ;                 /* dump Sequences */
extern BOOL fDebugStats;               /* dump resource statistics */
extern BOOL fDumpMosy;                 /* dump in Mosy format */
extern BOOL fDumpExtMosy;              /* dump in Extended Mosy format */
extern BOOL fDumpInterm;               /* dump in Intermediate format */
extern BOOL fDumpGdmo;                 /* dump in GDMO format */

extern BOOL fCheckRoIndx;              /* check that access for INDEX obs is RO */
extern BOOL fCheckSEQ;                 /* strong check of seq item syntax */
extern BOOL fCheckSR;                  /* check that all objects have size/range
                                          where appropriate */
extern BOOL fCheckISR;                 /* strong check on size/range of
                                          index items */
extern BOOL fCheckIndxSeq;             /* check that all index items are in seq */
extern BOOL fNoCheckTab;               /* no check that TABLE, ROW, SEQUENCE
                                          have related Names */
extern BOOL fNoSeqTcErr;               /* no error if syntax of item in sequence
                                          doesn't match syntax of object
                                          when object syntax is a TC and
                                          syntax in sequence is base type */
extern BOOL fAllowIndx;                /* allow INDEX clause for leaf objects */
extern BOOL fNoUnUsedWarn;             /* no warnings for unused IMPORTs and TCs */
extern BOOL fAllowAccess;              /* allow "not-accessible" and "write-only"
                                          access on leaf objects */
extern BOOL fAllowOpt;                 /* allow status of "optional" */
extern BOOL fAllowDV;                  /* allow default value for counters & gauges */

extern BOOL NEAR fPrintIname;          /* flag to print include file names */


/* functions */
#ifdef __STDC__
BOOL allocStrSp(VOID);
VOID initOIDroot(VOID);
MIBSYM *newOID(STRTAB *pNa, MIBSYM *pMod);
MIBSYM *newAL(MIBSYM *pSym, STRTAB *pAlNa);
MIBSYM *newTR(STRTAB *pNa, MIBSYM *pMod);
MIBENT *newENT(MIBSYM *pFrTr);
MIBVAR *newVAR(MIBSYM *pTr, MIBSYM *pOid);
MIBSYM *newTC(STRTAB *pNa, MIBSYM *pMod);
MIBSYM *newSEQ(STRTAB *pNa, MIBSYM *pMod);
MIBSEQI *newSEQI(MIBSYM *pSeq, MIBSYM *pOid, MIBSYN *pSyn);
MIBSYM *newMOD(STRTAB *pNa);
MIBMODREF *newMODREF(MIBSYM *pMod);
MIBSYM *newIMP(MIBSYM *pMod, MIBSYM *pSym, STRTAB *pNa);
MIBIMPI *newIMPI(MIBMODREF *pModRef, STRTAB *pNa);
MIBSYM *newSMI(STRTAB *pNa, MIBSYM *pMod);
MIBSYM *addMODname(STRTAB *pNa);
MIBSYM *addSMIname(STRTAB *pNa, MIBSYM *pMod);
MIBSYM *addOIDname(STRTAB *pNa, STRTAB *pNaPar, ULONG ulVal, MIBSYM *pMod);
MIBSYM *addOTname(STRTAB *pNa, MIBSYM *pMod);
MIBSYM *addSEQname(STRTAB *pNa, MIBSYM *pMod);
BOOL  addSEQitem(MIBSYM *pSeq, STRTAB *pNa, MIBSYN *pSyn, MIBSYM *pMod);
MIBSYM *addTCname(STRTAB *pNa, MIBSYM *pMod);
MIBSYM *addTRname(STRTAB *pNa, MIBSYM *pMod);
BOOL addENUMitem(STRTAB *pNa, ULONG ulVal, MIBSYN *pSyn);
BOOL addINDXitem(MIBSYM *pOid, USHORT usItype, STRTAB *pNa,
            ULONG ulLow, ULONG ulHigh, MIBSYM *pMod);
BOOL addDV(MIBSYM *pOid, USHORT usDefVal, STRTAB *pVal,
                 ULONG ulVal, MIBSYM *pComp);
BOOL addVAR(MIBSYM *pTr, STRTAB *pNa, MIBSYM *pMod);
BOOL addMODalias(STRTAB *pNa, STRTAB *pAlNa);
BOOL addSYMalias(STRTAB *pModNa, STRTAB *pNa, STRTAB *pAlNa);
MIBSYM *fixupImport(MIBSYM *pMod);
MIBSYM *finishImport(MIBSYM *pMod, STRTAB *pNa);
MIBSYM *finishOT(MIBSYM *pOid, MIBSYN *pSyn, USHORT usAccess,
                USHORT usStatus, STRTAB *pDesc, STRTAB *pRefer,
                STRTAB *pNaPar, ULONG ulVal);
MIBSYM *finishSEQ(MIBSYM *pSeq);
MIBSYM *finishTC(MIBSYM *pTc, MIBSYN *pSyn);
MIBSYM *finishTR(MIBSYM *pTr, STRTAB *pNaEnt, STRTAB *pDesc,
                STRTAB *pRefer, ULONG ulVal);
VOID finishMODid(VOID);
VOID checkOIDs(MIBSYM *pMod);
VOID checkIMPs(MIBSYM *pMod);
VOID checkSEQs(MIBSYM *pMod);
VOID checkTRs(MIBSYM *pMod);
VOID checkTCs(MIBSYM *pMod);
MIBSYM *checkOIDcomp(MIBSYM *pPar, STRTAB *pNa, ULONG ulVal, MIBSYM *pMod);
BOOL checkSyntax(MIBSYN *pSyn, STRTAB *pNa, USHORT usSyntax,
            USHORT usSizeRange, ULONG ulFirst,
            ULONG ulSecond, MIBSYM *pMod);
ULONG bstrToVal(STRTAB *pVal);
ULONG hstrToVal(STRTAB *pVal);

INT yyparse(VOID);
VOID yystats(VOID);
VOID yylexout(SHORT sChar);
INT  yylexin(VOID);
BOOL pushOpt(VOID);
BOOL popOpt(VOID);
VOID printOpt(VOID);
BOOL addOpt(STRTAB *pVal);
BOOL removeOpt(STRTAB *pVal);
BOOL openInclude(STRTAB *pNa);
VOID dirHelp(VOID);
VOID walkOIDtree(VOID (*pFunc)(MIBSYM *pO, ULONG aulOid[], USHORT usLevel));
VOID walkOIDsubtree(VOID (*pFunc)(MIBSYM *pO, ULONG aulOid[], USHORT usLevel), MIBSYM *pT);
PSZ symStatus(USHORT usStatus);
VOID StrTabDump(VOID);
VOID dumpMOD(VOID);
VOID dumpOID(VOID);
VOID dumpSMI(VOID);
VOID dumpIMP(VOID);
VOID dumpAL(VOID);
VOID dumpOIDtree(VOID);
VOID dumpOIDname(VOID);
ULONG dumpStats(VOID);
VOID dumpTRAP(VOID);
VOID dumpTC(VOID);
VOID dumpSEQ(VOID);
VOID dumpMosy(VOID);
VOID dumpExtMosy(VOID);
VOID dumpInterm(VOID);
VOID dumpGdmo(VOID);
VOID dumpSYM(MIBSYM *pSym);
VOID dumpSYNshort(MIBSYN *pSyn);
PSZ dumpSR(MIBSYN *pSyn);
PSZ getVer(VOID);
VOID prVer(VOID);
VOID prCpyrt(VOID);
#else
BOOL allocStrSp();
VOID initOIDroot();
MIBSYM *newOID();
MIBSYM *newAL();
MIBSYM *newTR();
MIBENT *newENT();
MIBVAR *newVAR();
MIBSYM *newTC();
MIBSYM *newSEQ();
MIBSEQI *newSEQI();
MIBSYM *newMOD();
MIBMODREF *newMODREF();
MIBSYM *newIMP();
MIBIMPI *newIMPI();
MIBSYM *newSMI();
MIBSYM *addMODname();
MIBSYM *addSMIname();
MIBSYM *addOIDname();
MIBSYM *addOTname();
MIBSYM *addSEQname();
BOOL  addSEQitem();
MIBSYM *addTCname();
MIBSYM *addTRname();
BOOL addENUMitem();
BOOL addINDXitem();
BOOL addDV();
BOOL addVAR();
BOOL addMODalias();
BOOL addSYMalias();
MIBSYM *fixupImport();
MIBSYM *finishImport();
MIBSYM *finishOT();
MIBSYM *finishSEQ();
MIBSYM *finishTC();
MIBSYM *finishTR();
VOID finishMODid();
VOID checkOIDs();
VOID checkIMPs();
VOID checkSEQs();
VOID checkTRs();
VOID checkTCs();
MIBSYM *checkOIDcomp();
BOOL checkSyntax();
ULONG bstrToVal();
ULONG hstrToVal();

INT yyparse();
VOID yystats();
VOID yylexout();
INT  yylexin();
BOOL pushOpt();
BOOL popOpt();
VOID printOpt();
BOOL addOpt();
BOOL removeOpt();
BOOL openInclude();
VOID dirHelp();
VOID walkOIDtree();
VOID walkOIDsubtree();
PSZ symStatus();
VOID StrTabDump();
VOID dumpMOD();
VOID dumpOID();
VOID dumpSMI();
VOID dumpIMP();
VOID dumpAL();
VOID dumpOIDtree();
VOID dumpOIDname();
ULONG dumpStats();
VOID dumpTRAP();
VOID dumpTC();
VOID dumpSEQ();
VOID dumpMosy();
VOID dumpExtMosy();
VOID dumpInterm();
VOID dumpGdmo();
VOID dumpSYM();
VOID dumpSYNshort();
PSZ dumpSR();
PSZ getVer();
VOID prVer();
VOID prCpyrt();
#endif /* __STDC__ */


/* end of file: SMIC.H */
