/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMCOM.C - misc functions common to compiler and all backends
 * 
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:25:50  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMCOM.C_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:25:50   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 15:53:06   gfoster
 * Copyright text was reformatted.
 * 
 * Function dumpStats changed to return ULONG, which
 * is the number of bytes allocated by the compiler
 * for data structures.
 * 
 * Dump of Opaque will print size, if given in MIB.
 * 
 *    Rev 1.0   27 May 1992 16:14:08   gfoster
 * Initial revision.
 *
*/

#include <stdio.h>

#ifdef MS_DOS
#include <stdlib.h>
#endif /* MS_DOS */

#include <string.h>

#include "tds.h"
#include "smscdefs.h"
#include "smstdefs.h"
#include "smsydefs.h"
#include "smic.h"


/** walkOIDtree - walk OID tree and call function
*
* call with:
*   pFunc - function to call
*/
    VOID
#ifdef __STDC__
walkOIDtree(VOID (*pFunc)(MIBSYM *pO, ULONG aulOid[], USHORT usLevel))
#else
walkOIDtree(pFunc)
    VOID (*pFunc)();
#endif /* __STDC__ */
{
    USHORT i;
    MIBSYM *pT;
    ULONG aulOid[MXOIDL];


    pT = &OidRoot;              /* root of the tree */

    pT = pT->ut.oid.pChild;     /* get ptr to first child */
    i = 0;
    if (pT == NULL)             /* check for empty tree */
        return;

    /* do pre-order traversal */
    for(;;) {
        /* do root (of subtree) */
        (*pFunc)(pT, aulOid, i);

        /* do child if present */
        if (pT->ut.oid.pChild != NULL) {
            aulOid[i++] = pT->ut.oid.ulVal;
            pT = pT->ut.oid.pChild;

            if (i == MXOIDL) {
                fprintf(fhOut, "***OIDs nested too deep***\n");
                return;
            }
            continue;
        }

        /* do sibling if present */
        if (pT->ut.oid.pSib != NULL) {
            pT = pT->ut.oid.pSib;
            continue;
        }

        /* otherwise do sibling of a superior */
        for(;;) {
            if (pT->ut.oid.pPar == &OidRoot) {
                return;
            }

            pT = pT->ut.oid.pPar;
            i--;

            if (pT->ut.oid.pSib != NULL) {
                pT = pT->ut.oid.pSib;
                break;
            }
        }
    }

} /* walkOIDtree */

/** walkOIDsubtree - walk OID subtree and call function
*
* call with:
*   pFunc - function to call
*   pT    - point in subtree
*/
    VOID
#ifdef __STDC__
walkOIDsubtree(VOID (*pFunc)(MIBSYM *pO, ULONG aulOid[], USHORT usLevel),
            MIBSYM *pT)
#else
walkOIDsubtree(pFunc, pT)
    VOID (*pFunc)();
    MIBSYM *pT;
#endif /* __STDC__ */
{
    USHORT i;
    ULONG aulOid[MXOIDL];


    /* pT = pT->ut.oid.pChild;     ?? get ptr to first child */
    i = 0;
    if (pT == NULL)             /* check for empty tree */
        return;

#if 0
    /* do pre-order traversal */
    for(;;) {
#endif
        /* do root (of subtree) */
        (*pFunc)(pT, aulOid, i);

        /* do child if present */
        if (pT->ut.oid.pChild != NULL) {
            aulOid[i++] = pT->ut.oid.ulVal;
            pT = pT->ut.oid.pChild;

            if (i == MXOIDL) {
                fprintf(fhOut, "***OIDs nested too deep***\n");
                return;
            }
            /* continue; */
        }

#if 0
    }
#endif

} /* walkOIDsubtree */


/** dumpSR - dump size/range info
*
* call with:
*   pSyn - syntax info
*
* returns:
*   ptr to string
*/
    PSZ
#ifdef __STDC__
dumpSR(MIBSYN *pSyn)
#else
dumpSR(pSyn)
    MIBSYN *pSyn;
#endif /* __STDC__ */
{
    switch(pSyn->usSizeRange) {
    case MIBSRno:   /* no size or range */
        szBuf[0] = 0;
        break;
    case MIBSRfs:   /* fixed size (value in usSize[0]) */
        sprintf(szBuf, " (SIZE(%u))", pSyn->usr.usSize[0]);
        break;
    case MIBSRvs:   /* variable size */
        sprintf(szBuf, " (SIZE(%u..%u))",
                pSyn->usr.usSize[0], pSyn->usr.usSize[1]);
        break;
    case MIBSRpp:   /* positive to positive range */
        sprintf(szBuf, " (%lu..%lu)",
                pSyn->usr.ulRange[0], pSyn->usr.ulRange[1]);
        break;
    case MIBSRnp:   /* negative to positive range */
        sprintf(szBuf, " (-%lu..%lu)",
                pSyn->usr.ulRange[0], pSyn->usr.ulRange[1]);
        break;
    case MIBSRnn:   /* negative to negative range */
        sprintf(szBuf, " (-%lu..-%lu)",
                pSyn->usr.ulRange[0], pSyn->usr.ulRange[1]);
        break;
    default:
        sprintf(szBuf," **unknown s/r(%d)**", pSyn->usSizeRange);
        break;
    }

    return(&szBuf[0]);

} /* dumpSR */


/** dumpSYNshort - dump syntax info (short form)
*
* call with:
*   pSyn - syntax info
*/
    VOID
#ifdef __STDC__
dumpSYNshort(MIBSYN *pSyn)
#else
dumpSYNshort(pSyn)
    MIBSYN *pSyn;
#endif /* __STDC__ */
{
    switch(pSyn->usSyntax) {
    case MIBSYNnu:
        fprintf(fhOut, "**syntax not used\n");
        break;
    case MIBSYNbad:
        fprintf(fhOut, "**bad syntax\n");
        break;
    case MIBSYNint:
        fprintf(fhOut, "INTEGER%s\n", dumpSR(pSyn));
        break;
    case MIBSYNoctstr:
        fprintf(fhOut, "OCTET STRING%s\n", dumpSR(pSyn));
        break;
    case MIBSYNoid:
        fprintf(fhOut, "OBJECT IDENTIFIER\n");
        break;
    case MIBSYNnull:
        fprintf(fhOut, "NULL\n");
        break;
    case MIBSYNnaddr:
        fprintf(fhOut, "NetworkAddress\n");
        break;
    case MIBSYNipaddr:
        fprintf(fhOut, "IpAddress\n");
        break;
    case MIBSYNcntr:
        fprintf(fhOut, "Counter\n");
        break;
    case MIBSYNgauge:
        fprintf(fhOut, "Gauge\n");
        break;
    case MIBSYNticks:
        fprintf(fhOut, "TimeTicks\n");
        break;
    case MIBSYNopaque:
        fprintf(fhOut, "Opaque%s\n", dumpSR(pSyn));
        break;
    case MIBSYNenum:
        fprintf(fhOut, "Enum\n");
        break;
    case MIBSYNseqOf:
        fprintf(fhOut, "SEQUENCE OF %s\n", (pSyn->usi.pSeq)->pszName);
        break;
    case MIBSYNseq:
        fprintf(fhOut, "SEQUENCE %s\n", (pSyn->usi.pSeq)->pszName);
        break;
    case MIBSYNtc:
        fprintf(fhOut, "%s%s\n",
                (pSyn->usi.pTC)->pszName, dumpSR(pSyn));
        break;
    default:
        fprintf(fhOut, "**unknown value(%d)\n", pSyn->usSyntax);
        break;
    }
} /* dumpSYNshort */


/** dumpStats - dump resource usage statistics
*
*/
    ULONG
#ifdef __STDC__
dumpStats(VOID)
#else
dumpStats()
#endif /* __STDC__ */
{
    ULONG ulSum;
    ULONG ul;
    MIBSYM *pT;
    USHORT cOid;
    USHORT cTab;
    USHORT cRow;
    USHORT cObj;
    USHORT cOth;

    
    ulSum = 0L;
    fprintf(fhOut, "Statistics:\n");
    ul = (LONG)cStrSpace*STRSPACESZ;
    ulSum += ul;
    fprintf(fhOut, "    String Space: %lu\n", ul);

    ul = (LONG)cStrUsed*(sizeof(STRTAB));
    ulSum += ul;
    fprintf(fhOut, "    Strings: %u %u(%lu)\n", cStrAlloc, cStrUsed, ul);

    ul = (LONG)cModUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    Modules: %u %u(%lu)\n", cModAlloc, cModUsed, ul);

    ul = (LONG)cModRefUsed*(sizeof(MIBMODREF));
    ulSum += ul;
    fprintf(fhOut, "    Mod Refs: %u %u(%lu)\n", cModRefAlloc, cModRefUsed, ul);

    ul = (LONG)cImpiUsed*(sizeof(MIBIMPI));
    ulSum += ul;
    fprintf(fhOut, "    Imported items: %u %u(%lu)\n", cImpiAlloc, cImpiUsed, ul);

    ul = (LONG)cImpUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    Imports: %u %u(%lu)\n", cImpAlloc, cImpUsed, ul);

    ul = (LONG)cAlUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    Aliases: %u %u(%lu)\n", cAlAlloc, cAlUsed, ul);

    ul = (LONG)cSmiUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    SMI items: %u %u(%lu)\n", cSmiAlloc, cSmiUsed, ul);

    ul = (LONG)cOidUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    OID items: %u %u(%lu)\n", cOidAlloc, cOidUsed, ul);

    cOid = 0;
    cTab = 0;
    cRow = 0;
    cObj = 0;
    cOth = 0;
    for (pT = pOidGHL; pT != NULL; pT = pT->pNext) {
        switch (pT->ut.oid.usOType) {
        case MIBOToid:
            /* pure OID */
            cOid++;
            break;

            
        case MIBOTtab:
            /* SNMP table */
            cTab++;
            break;

        case MIBOTrow:
            /* SNMP row */
            cRow++;
            break;

        case MIBOTobj:
            /* SNMP object */
            cObj++;
            break;

        default:
            /* anything else */
            cOth++;
            break;
        }
    }
    fprintf(fhOut, "      RegPt/group: %u\n", cOid);
    fprintf(fhOut, "            Table: %u\n", cTab);
    fprintf(fhOut, "              Row: %u\n", cRow);
    fprintf(fhOut, "             Leaf: %u\n", cObj);
    if (cOth != 0)
        fprintf(fhOut, "            Other: %u\n", cOth);

    ul = (LONG)cEnumUsed*(sizeof(MIBENUM));
    ulSum += ul;
    fprintf(fhOut, "    Enum items: %u %u(%lu)\n", cEnumAlloc, cEnumUsed, ul);

    ul = (LONG)cIndxUsed*(sizeof(MIBINDX));
    ulSum += ul;
    fprintf(fhOut, "    Index items: %u %u(%lu)\n", cIndxAlloc, cIndxUsed, ul);

    ul = (LONG)cSeqUsed*(sizeof(MIBSEQ));
    ulSum += ul;
    fprintf(fhOut, "    Sequences: %u %u(%lu)\n", cSeqAlloc, cSeqUsed, ul);

    ul = (LONG)cSeqiUsed*(sizeof(MIBSEQI));
    ulSum += ul;
    fprintf(fhOut, "    Sequence members: %u %u(%lu)\n", cSeqiAlloc, cSeqiUsed, ul);

    ul = (LONG)cTcUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    Text conv: %u %u(%lu)\n", cTcAlloc, cTcUsed, ul);

    ul = (LONG)cTrUsed*(sizeof(MIBSYM));
    ulSum += ul;
    fprintf(fhOut, "    Traps: %u %u(%lu)\n", cTrAlloc, cTrUsed, ul);

    ul = (LONG)cVarUsed*(sizeof(MIBVAR));
    ulSum += ul;
    fprintf(fhOut, "    Trap vars: %u %u(%lu)\n", cVarAlloc, cVarUsed, ul);

    ul = (LONG)cEntUsed*(sizeof(MIBENT));
    ulSum += ul;
    fprintf(fhOut, "    Trap ents: %u %u(%lu)\n", cEntAlloc, cEntUsed, ul);


    fprintf(fhOut, "Dynamic memory used: %lu\n", ulSum);

    return(ulSum);

} /* dumpStats */


/** yystats - print resource use statistics */
    VOID
#ifdef __STDC__
yystats(VOID)
#else
yystats()
#endif /* __STDC__ */
{
    dumpStats();
} /* yystats */


/** yyterm - unrecoverable scanning/parsing error */
    VOID
#ifdef __STDC__
yyterm(VOID)
#else
yyterm()
#endif /* __STDC__ */
{
    fprintf(fhMsg, "Unrecoveralble error - program terminating\n");
    exit(1);
} /* yyterm */


/** allocStrSp - allocate string space
*
* returns:
*   TRUE - success
*   FALSE - failure
*/
    BOOL
#ifdef __STDC__
allocStrSp(VOID)
#else
allocStrSp()
#endif /* __STDC__ */
{
    BYTE *pbSTR;


    /* check to make sure there is room in string space vector */
    if (cStrSpace >= MXCSTRSP) {
        yyerror("allocStrSp: Out of string space");
        yystats();
        return(FALSE);
    }

    /* save current size */
    if (cStrSpace != 0)
        ausStrSpaceSz[cStrSpace-1] = usStrSpaceIndx;

    /* allocate the memory for the string space */
    if ((pbSTR = (BYTE *)malloc(STRSPACESZ)) == NULL) {
        yyerror("allocStrSp: out of heap memory for string space");
        yystats();
        return(FALSE);
    }

    apbStrSpace[cStrSpace++] = pbSTR;
    pbStrSpace = pbSTR;
    usStrSpaceSz = STRSPACESZ;  /* size of string space */
    usStrSpaceIndx = 0;         /* current position in string space */
    memset(pbStrSpace, 0, STRSPACESZ); /* zero string space */

    return(TRUE);

} /* allocStrSp */


#ifdef OLD
/** yylexin - get character
*
* NOTE: the "optimized" version
*
* returns:
*   next character read
*   (and updates usLineNo and usColNo)
*/
    INT
#ifdef __STDC__
yylexin(VOID)
#else
yylexin()
#endif /* __STDC__ */
{
    register INT i;


    if (--(fhIn->_cnt) >= 0)
        i = 0xff & (*fhIn->_ptr++);
    else
        i = getc(fhIn);
    if (i == 0x1A) {
        /* Ctrl Z -- return EOF */
        return(-1);
    }
    if (i == '\n') {
        usLineNo++;
        usColNo = 0;
    } else
        usColNo++;
        
    return(i);
} /* yylexIn */
#else
/** yylexin - get character
*
* NOTE: the "getc" function is rather slow, this could
*       be changed to improve performance
*
* returns:
*   next character read
*   (and updates usLineNo and usColNo)
*/
    INT
#ifdef __STDC__
yylexin(VOID)
#else
yylexin()
#endif /* __STDC__ */
{
    register INT i;

    i = getc(fhIn);
    if (i == 0x1A) {
        /* Ctrl Z -- return EOF */
        return(-1);
    }
    if (i == '\n') {
        usLineNo++;
        usColNo = 0;
    } else
        usColNo++;
        
    return(i);
} /* yylexIn */
#endif


/** yylexout - put character in token buffer
*
* call with:
*   sChar - character to add
*
*/
    VOID
#ifdef __STDC__
yylexout(SHORT sChar)
#else
yylexout(sChar)
    SHORT sChar;
#endif /* __STDC__ */
{
    register USHORT cByte;


    if (usStrSpaceIndx >= usStrSpaceSz) {
        /* char won't fit in current string space */

        /* check if token too big (ie run-on string) */
        cByte = usStrSpaceIndx - usStrSpaceTokIndx;
        if (cByte >= usStrSpaceSz) {
            yyerror("Token too big");
            yyterm();           /* terminate program */
            return;
        }
        usStrSpaceIndx -= cByte; /* recover bytes from string space */

        /* allocate new string space */
        if (!allocStrSp()) {
            yyterm();           /* terminate program */
            return;
        }

        /* copy old partial token */
        memcpy(&(pbStrSpace[usStrSpaceIndx]), pszTokVal, cByte);

        /* zero old value */
        memset(pszTokVal, 0, cByte);

        /* point to new place */
        pszTokVal = (PSZ)&(pbStrSpace[usStrSpaceIndx]);
        usStrSpaceTokIndx = usStrSpaceIndx;

        usStrSpaceIndx += cByte; /* position to place to add new byte */
    }
    pbStrSpace[usStrSpaceIndx++] = (CHAR)sChar;

} /* yylexout */


/* end of file: SMCOM.C */
