--# 1 "vtt.mibii.gdmo" 
--
-- GDMO produced by *modified* SMIC version 1.0.9, July 23, 1992. 
--

--
-- Notes:
--  1. Notifications are handled by internetSystem
--     NOTIFICATION internet alarm.
--  2. Remeber to define ASN.1 modules IimcAssignedOids
--     and iimcCommonDef as in Sect 4.2 of [IMIBTRANS]
--  3. \-\-\* *\-\- comments are hints to reader.
--
-- PostProcessing should be done for:
--  1. "MATCHES FOR" matching rules
--     Only a best guess is genertated.
--  2. Parsable BEHAVIOUR clauses.
--  3. Comments with %ERR<txt>% indicate problems.
--  4. Comments with %PP% are for post processing
--     E.g. where CREATE/DELETE or DELETE<ATT/VAL>
--     statements may be needed in NAME BINDINGS.
--  5. Check the generated ASN.1 support file.
--
-- References:
--  ISO/CCITT and Internet Management Coexistence (IIMC):
--  Translation of Internet MIBs to ISO/CCITT GDMO MIBs
--  (IIMCIMIBTRANS), Internet Draft 4 (OMNIPOINT-1 ?),
--  Lee LaBarre (Editor)
--
--  ISO/CCITT and Internet Management Coexistence (IIMC):
--  Translation of Internet MIB-II (RFC1213)
--  (IIMCMIB-II), Internet Draft 4 (OMNIPOINT-1 ?)
--  Lee LaBarre (Editor)
--

-- ##############################################################
--     Converted from SNMP MIB/SMI Module : RFC1155-SMI
--     Converted from SNMP MIB/SMI Module : RFC-1212
--     Converted from SNMP MIB/SMI Module : RFC-1215
--     Converted from SNMP MIB/SMI Module : RFC1213-MIB
--     Converted from SNMP MIB/SMI Module : RFC1215-TRAP
--     Converted from SNMP MIB/SMI Module : RFC1354-MIB
-- ##############################################################


--
-- Translated SNMPv1 Group MOCs 
--


internetSystem MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY internetSystemPkg PACKAGE
  BEHAVIOUR internetSystemPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "system"
      group with object id {mib-2 1} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    internetSystemId	GET	--*IIMC naming attribute*-- ,
    sysDescr	GET,
    sysObjectID	GET,
    sysUpTime	GET,
    sysContact	GET-REPLACE,
    sysName	GET-REPLACE,
    sysLocation	GET-REPLACE,
    sysServices	GET;
  NOTIFICATIONS	{iimcIIMCIMIBTRANS}:internetAlarm;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 } ;

internetSystem-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS internetSystem
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE internetSystemId ;
  BEHAVIOUR internetSystem-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 1 } ;

internetSystemId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.InternetSystemIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR internetSystemIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "internetSystem". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 1 };



interfaces MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY interfacesPkg PACKAGE
  BEHAVIOUR interfacesPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "interfaces"
      group with object id {mib-2 2} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    interfacesId	GET	--*IIMC naming attribute*-- ,
    ifNumber	GET;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 } ;

interfaces-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS interfaces
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE interfacesId ;
  BEHAVIOUR interfaces-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 2 } ;

interfacesId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.InterfacesIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR interfacesIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "interfaces". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 2 };



at MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY atPkg PACKAGE
  BEHAVIOUR atPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "at"
      group with object id {mib-2 3} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    atId	GET	--*IIMC naming attribute*-- ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 3 } ;

at-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS at
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE atId ;
  BEHAVIOUR at-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 3 } ;

atId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.AtIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR atIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "at". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 3 };



ip MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY ipPkg PACKAGE
  BEHAVIOUR ipPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "ip"
      group with object id {mib-2 4} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    ipId	GET	--*IIMC naming attribute*-- ,
    ipForwarding	GET-REPLACE,
    ipDefaultTTL	GET-REPLACE,
    ipInReceives	GET,
    ipInHdrErrors	GET,
    ipInAddrErrors	GET,
    ipForwDatagrams	GET,
    ipInUnknownProtos	GET,
    ipInDiscards	GET,
    ipInDelivers	GET,
    ipOutRequests	GET,
    ipOutDiscards	GET,
    ipOutNoRoutes	GET,
    ipReasmTimeout	GET,
    ipReasmReqds	GET,
    ipReasmOKs	GET,
    ipReasmFails	GET,
    ipFragOKs	GET,
    ipFragFails	GET,
    ipFragCreates	GET,
    ipRoutingDiscards	GET;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 } ;

ip-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS ip
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE ipId ;
  BEHAVIOUR ip-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 4 } ;

ipId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IpIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR ipIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "ip". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 4 };



icmp MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY icmpPkg PACKAGE
  BEHAVIOUR icmpPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "icmp"
      group with object id {mib-2 5} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    icmpId	GET	--*IIMC naming attribute*-- ,
    icmpInMsgs	GET,
    icmpInErrors	GET,
    icmpInDestUnreachs	GET,
    icmpInTimeExcds	GET,
    icmpInParmProbs	GET,
    icmpInSrcQuenchs	GET,
    icmpInRedirects	GET,
    icmpInEchos	GET,
    icmpInEchoReps	GET,
    icmpInTimestamps	GET,
    icmpInTimestampReps	GET,
    icmpInAddrMasks	GET,
    icmpInAddrMaskReps	GET,
    icmpOutMsgs	GET,
    icmpOutErrors	GET,
    icmpOutDestUnreachs	GET,
    icmpOutTimeExcds	GET,
    icmpOutParmProbs	GET,
    icmpOutSrcQuenchs	GET,
    icmpOutRedirects	GET,
    icmpOutEchos	GET,
    icmpOutEchoReps	GET,
    icmpOutTimestamps	GET,
    icmpOutTimestampReps	GET,
    icmpOutAddrMasks	GET,
    icmpOutAddrMaskReps	GET;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 } ;

icmp-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS icmp
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE icmpId ;
  BEHAVIOUR icmp-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 5 } ;

icmpId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IcmpIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR icmpIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "icmp". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 5 };



tcp MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY tcpPkg PACKAGE
  BEHAVIOUR tcpPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "tcp"
      group with object id {mib-2 6} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    tcpId	GET	--*IIMC naming attribute*-- ,
    tcpRtoAlgorithm	GET,
    tcpRtoMin	GET,
    tcpRtoMax	GET,
    tcpMaxConn	GET,
    tcpActiveOpens	GET,
    tcpPassiveOpens	GET,
    tcpAttemptFails	GET,
    tcpEstabResets	GET,
    tcpCurrEstab	GET,
    tcpInSegs	GET,
    tcpOutSegs	GET,
    tcpRetransSegs	GET,
    tcpInErrs	GET,
    tcpOutRsts	GET;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 } ;

tcp-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS tcp
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE tcpId ;
  BEHAVIOUR tcp-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 6 } ;

tcpId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.TcpIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR tcpIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "tcp". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 6 };



udp MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY udpPkg PACKAGE
  BEHAVIOUR udpPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "udp"
      group with object id {mib-2 7} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    udpId	GET	--*IIMC naming attribute*-- ,
    udpInDatagrams	GET,
    udpNoPorts	GET,
    udpInErrors	GET,
    udpOutDatagrams	GET;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 } ;

udp-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS udp
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE udpId ;
  BEHAVIOUR udp-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 7 } ;

udpId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.UdpIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR udpIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "udp". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 7 };



egp MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY egpPkg PACKAGE
  BEHAVIOUR egpPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "egp"
      group with object id {mib-2 8} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    egpId	GET	--*IIMC naming attribute*-- ,
    egpInMsgs	GET,
    egpInErrors	GET,
    egpOutMsgs	GET,
    egpOutErrors	GET,
    egpAs	GET;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 } ;

egp-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS egp
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE egpId ;
  BEHAVIOUR egp-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 8 } ;

egpId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.EgpIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR egpIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "egp". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 8 };



snmp MANAGED OBJECT CLASS	--*SNMPv1 Group*--
  DERIVED FROM "Rec X.721 | ISO/IEC 10165-2:1992":top;
  CHARACTERIZED BY snmpPkg PACKAGE
  BEHAVIOUR snmpPkgBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    REFERENCE !!
      This managed object class maps to the "snmp"
      group with object id {mib-2 11} in module RFC1213-MIB.
    !!;
  ENDPARSE!;;
  ATTRIBUTES
    snmpId	GET	--*IIMC naming attribute*-- ,
    snmpInPkts	GET,
    snmpOutPkts	GET,
    snmpInBadVersions	GET,
    snmpInBadCommunityNames	GET,
    snmpInBadCommunityUses	GET,
    snmpInASNParseErrs	GET,
    snmpInTooBigs	GET,
    snmpInNoSuchNames	GET,
    snmpInBadValues	GET,
    snmpInReadOnlys	GET,
    snmpInGenErrs	GET,
    snmpInTotalReqVars	GET,
    snmpInTotalSetVars	GET,
    snmpInGetRequests	GET,
    snmpInGetNexts	GET,
    snmpInSetRequests	GET,
    snmpInGetResponses	GET,
    snmpInTraps	GET,
    snmpOutTooBigs	GET,
    snmpOutNoSuchNames	GET,
    snmpOutBadValues	GET,
    snmpOutGenErrs	GET,
    snmpOutGetRequests	GET,
    snmpOutGetNexts	GET,
    snmpOutSetRequests	GET,
    snmpOutGetResponses	GET,
    snmpOutTraps	GET,
    snmpEnableAuthenTraps	GET-REPLACE;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 } ;

snmp-systemNB NAME BINDING
  SUBORDINATE OBJECT CLASS snmp
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS 
    "Rec X.721 | ISO/IEC 10165-2:1992" :system
        AND SUBCLASSES;
  WITH ATTRIBUTE snmpId ;
  BEHAVIOUR snmp-systemNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX NULL;
  ENDPARSE!;;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 11 } ;

snmpId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.SnmpIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR snmpIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "snmp". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 11 };



--
-- Translated MOCs and Attributes 
--

sysDescr ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:displayString ;
  BEHAVIOUR sysDescrBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysDescr"
        with object identifier {system 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A textual description of the entity.  This value
        should include the full name and version
        identification of the system's hardware type,
        software operating-system, and networking
        software.  It is mandatory that this only contain
        printable ASCII characters.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 1 } ;

sysObjectID ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.ObjectIdentifier ;
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR sysObjectIDBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysObjectID"
        with object identifier {system 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The vendor's authoritative identification of the
        network management subsystem contained in the
        entity.  This value is allocated within the SMI
        enterprises subtree (1.3.6.1.4.1) and provides an
        easy and unambiguous means for determining `what
        kind of box' is being managed.  For example, if
        vendor `Flintstones, Inc.' was assigned the
        subtree 1.3.6.1.4.1.4242, it could assign the
        identifier 1.3.6.1.4.1.4242.1.1 to its `Fred
        Router'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 2 } ;

sysUpTime ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:timeTicks ;
  BEHAVIOUR sysUpTimeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysUpTime"
        with object identifier {system 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The time (in hundredths of a second) since the
        network management portion of the system was last
        re-initialized.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 3 } ;

sysContact ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:displayString ;
  BEHAVIOUR sysContactBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysContact"
        with object identifier {system 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The textual identification of the contact person
        for this managed node, together with information
        on how to contact this person.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 4 } ;

sysName ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:displayString ;
  BEHAVIOUR sysNameBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysName"
        with object identifier {system 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An administratively-assigned name for this
        managed node.  By convention, this is the node's
        fully-qualified domain name.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 5 } ;

sysLocation ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:displayString ;
  BEHAVIOUR sysLocationBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysLocation"
        with object identifier {system 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The physical location of this node (e.g.,
        `telephone closet, 3rd floor').
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 6 } ;

sysServices ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer128 ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR sysServicesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "sysServices"
        with object identifier {system 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A value which indicates the set of services that
        this entity primarily offers.
        
        The value is a sum.  This sum initially takes the
        value zero, Then, for each layer, L, in the range
        1 through 7, that this node performs transactions
        for, 2 raised to (L - 1) is added to the sum.  For
        example, a node which performs primarily routing
        functions would have a value of 4 (2^(3-1)).  In
        contrast, a node which is a host offering
        application services would have a value of 72
        (2^(4-1) + 2^(7-1)).  Note that in the context of
        the Internet suite of protocols, values should be
        calculated accordingly:
        
             layer  functionality
                 1  physical (e.g., repeaters)
                 2  datalink/subnetwork (e.g., bridges)
                 3  internet (e.g., IP gateways)
                 4  end-to-end  (e.g., IP hosts)
                 7  applications (e.g., mail relays)
        
        For systems including OSI protocols, layers 5 and
        6 may also be counted.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 1 7 } ;

ifNumber ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ifNumberBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifNumber"
        with object identifier {interfaces 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of network interfaces (regardless of
        their current state) present on this system.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 1 } ;


ifEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    ifEntryPkg PACKAGE
  BEHAVIOUR ifEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "ifEntry" object
        with object identifier {ifTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An interface entry containing objects at the
        subnetwork layer and below for a particular
        interface.
      !!;
      INDEX
        RFC1213-MIB.ifIndex ;
    ENDPARSE!;;
  ATTRIBUTES
    ifEntryId	GET	--*IIMC naming attribute*-- ,
    ifIndex	GET ,
    ifDescr	GET ,
    ifType	GET ,
    ifMtu	GET ,
    ifSpeed	GET ,
    ifPhysAddress	GET ,
    ifAdminStatus	GET-REPLACE ,
    ifOperStatus	GET ,
    ifLastChange	GET ,
    ifInOctets	GET ,
    ifInUcastPkts	GET ,
    ifInNUcastPkts	GET ,
    ifInDiscards	GET ,
    ifInErrors	GET ,
    ifInUnknownProtos	GET ,
    ifOutOctets	GET ,
    ifOutUcastPkts	GET ,
    ifOutNUcastPkts	GET ,
    ifOutDiscards	GET ,
    ifOutErrors	GET ,
    ifOutQLen	GET ,
    ifSpecific	GET ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 } ;

ifEntry-interfacesNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS ifEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS interfaces
        AND SUBCLASSES;
  WITH ATTRIBUTE ifEntryId ;
  BEHAVIOUR ifEntry-interfacesNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.ifIndex ;
    --* *--
    --* *--
  ENDPARSE!;;
  --* *--
  --* *--
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 2 2 1 } ;

ifEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IfEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR ifEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "ifEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 2 2 1 };


ifIndex ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ifIndexBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifIndex"
        with object identifier {ifEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A unique value for each interface.  Its value
        ranges between 1 and the value of ifNumber.  The
        value for each interface must remain constant at
        least from one re-initialization of the entity's
        network management system to the next re-
        initialization.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 1 } ;

ifDescr ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:displayString ;
  BEHAVIOUR ifDescrBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifDescr"
        with object identifier {ifEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A textual string containing information about the
        interface.  This string should include the name of
        the manufacturer, the product name and the version
        of the hardware interface.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 2 } ;

ifType ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IfType ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ifTypeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifType"
        with object identifier {ifEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The type of interface, distinguished according to
        the physical/link protocol(s) immediately `below'
        the network layer in the protocol stack.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 3 } ;

ifMtu ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ifMtuBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifMtu"
        with object identifier {ifEntry 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The size of the largest datagram which can be
        sent/received on the interface, specified in
        octets.  For interfaces that are used for
        transmitting network datagrams, this is the size
        of the largest network datagram that can be sent
        on the interface.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 4 } ;

ifSpeed ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:gauge32 ;
  BEHAVIOUR ifSpeedBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifSpeed"
        with object identifier {ifEntry 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An estimate of the interface's current bandwidth
        in bits per second.  For interfaces which do not
        vary in bandwidth or for those where no accurate
        estimation can be made, this object should contain
        the nominal bandwidth.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 5 } ;

ifPhysAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:physAddress ;
  BEHAVIOUR ifPhysAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifPhysAddress"
        with object identifier {ifEntry 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The interface's address at the protocol layer
        immediately `below' the network layer in the
        protocol stack.  For interfaces which do not have
        such an address (e.g., a serial line), this object
        should contain an octet string of zero length.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 6 } ;

ifAdminStatus ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IfAdminStatus ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ifAdminStatusBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifAdminStatus"
        with object identifier {ifEntry 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The desired state of the interface.  The
        testing(3) state indicates that no operational
        packets can be passed.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 7 } ;

ifOperStatus ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IfOperStatus ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ifOperStatusBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOperStatus"
        with object identifier {ifEntry 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The current operational state of the interface.
        The testing(3) state indicates that no operational
        packets can be passed.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 8 } ;

ifLastChange ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:timeTicks ;
  BEHAVIOUR ifLastChangeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifLastChange"
        with object identifier {ifEntry 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The value of sysUpTime at the time the interface
        entered its current operational state.  If the
        current state was entered prior to the last re-
        initialization of the local network management
        subsystem, then this object contains a zero
        value.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 9 } ;

ifInOctets ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifInOctetsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifInOctets"
        with object identifier {ifEntry 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of octets received on the
        interface, including framing characters.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 10 } ;

ifInUcastPkts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifInUcastPktsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifInUcastPkts"
        with object identifier {ifEntry 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of subnetwork-unicast packets
        delivered to a higher-layer protocol.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 11 } ;

ifInNUcastPkts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifInNUcastPktsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifInNUcastPkts"
        with object identifier {ifEntry 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of non-unicast (i.e., subnetwork-
        broadcast or subnetwork-multicast) packets
        delivered to a higher-layer protocol.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 12 } ;

ifInDiscards ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifInDiscardsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifInDiscards"
        with object identifier {ifEntry 13}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of inbound packets which were chosen
        to be discarded even though no errors had been
        detected to prevent their being deliverable to a
        higher-layer protocol.  One possible reason for
        discarding such a packet could be to free up
        buffer space.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 13 } ;

ifInErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifInErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifInErrors"
        with object identifier {ifEntry 14}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of inbound packets that contained
        errors preventing them from being deliverable to a
        higher-layer protocol.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 14 } ;

ifInUnknownProtos ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifInUnknownProtosBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifInUnknownProtos"
        with object identifier {ifEntry 15}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of packets received via the interface
        which were discarded because of an unknown or
        unsupported protocol.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 15 } ;

ifOutOctets ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifOutOctetsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOutOctets"
        with object identifier {ifEntry 16}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of octets transmitted out of the
        interface, including framing characters.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 16 } ;

ifOutUcastPkts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifOutUcastPktsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOutUcastPkts"
        with object identifier {ifEntry 17}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of packets that higher-level
        protocols requested be transmitted to a
        subnetwork-unicast address, including those that
        were discarded or not sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 17 } ;

ifOutNUcastPkts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifOutNUcastPktsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOutNUcastPkts"
        with object identifier {ifEntry 18}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of packets that higher-level
        protocols requested be transmitted to a non-
        unicast (i.e., a subnetwork-broadcast or
        subnetwork-multicast) address, including those
        that were discarded or not sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 18 } ;

ifOutDiscards ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifOutDiscardsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOutDiscards"
        with object identifier {ifEntry 19}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of outbound packets which were chosen
        to be discarded even though no errors had been
        detected to prevent their being transmitted.  One
        possible reason for discarding such a packet could
        be to free up buffer space.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 19 } ;

ifOutErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ifOutErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOutErrors"
        with object identifier {ifEntry 20}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of outbound packets that could not be
        transmitted because of errors.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 20 } ;

ifOutQLen ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:gauge32 ;
  BEHAVIOUR ifOutQLenBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifOutQLen"
        with object identifier {ifEntry 21}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The length of the output packet queue (in
        packets).
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 21 } ;

ifSpecific ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.ObjectIdentifier ;
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ifSpecificBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ifSpecific"
        with object identifier {ifEntry 22}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A reference to MIB definitions specific to the
        particular media being used to realize the
        interface.  For example, if the interface is
        realized by an ethernet, then the value of this
        object refers to a document defining objects
        specific to ethernet.  If this information is not
        present, its value should be set to the OBJECT
        IDENTIFIER { 0 0 }, which is a syntatically valid
        object identifier, and any conformant
        implementation of ASN.1 and BER must be able to
        generate and recognize this value.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 2 2 1 22 } ;


atEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    atEntryPkg PACKAGE
  BEHAVIOUR atEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "atEntry" object
        with object identifier {atTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Each entry contains one NetworkAddress to
        `physical' address equivalence.
      !!;
      INDEX
        RFC1213-MIB.atIfIndex ,
        RFC1213-MIB.atNetAddress ;
    ENDPARSE!;;
  ATTRIBUTES
    atEntryId	GET	--*IIMC naming attribute*-- ,
    atIfIndex	GET	--*access mode change (INDEX)*-- ,
    atPhysAddress	GET-REPLACE ,
    atNetAddress	GET	--*access mode change (INDEX)*-- ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 3 1 1 } ;

atEntry-atNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS atEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS at
        AND SUBCLASSES;
  WITH ATTRIBUTE atEntryId ;
  BEHAVIOUR atEntry-atNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.atIfIndex ,
      RFC1213-MIB.atNetAddress ;
    DELETEATT atPhysAddress ;
    DELETEVALUE ''h ;
  ENDPARSE!;;
  CREATE  WITH-AUTOMATIC-INSTANCE-NAMING, WITH-REFERENCE-OBJECT ;
  DELETE  DELETES-CONTAINED-OBJECTS ;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 3 1 1 } ;

atEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.AtEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR atEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "atEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 3 1 1 };


atIfIndex ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR atIfIndexBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "atIfIndex"
        with object identifier {atEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The interface on which this entry's equivalence
        is effective.  The interface identified by a
        particular value of this index is the same
        interface as identified by the same value of
        ifIndex.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 3 1 1 1 } ;

atPhysAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:physAddress ;
  BEHAVIOUR atPhysAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "atPhysAddress"
        with object identifier {atEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The media-dependent `physical' address.
        
        Setting this object to a null string (one of zero
        length) has the effect of invaliding the
        corresponding entry in the atTable object.  That
        is, it effectively dissasociates the interface
        identified with said entry from the mapping
        identified with said entry.  It is an
        implementation-specific matter as to whether the
        agent removes an invalidated entry from the table.
        Accordingly, management stations must be prepared
        to receive tabular information from agents that
        corresponds to entries not currently in use.
        Proper interpretation of such entries requires
        examination of the relevant atPhysAddress object.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 3 1 1 2 } ;

atNetAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR atNetAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "atNetAddress"
        with object identifier {atEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The NetworkAddress (e.g., the IP address)
        corresponding to the media-dependent `physical'
        address.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 3 1 1 3 } ;

ipForwarding ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IpForwarding ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipForwardingBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwarding"
        with object identifier {ip 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The indication of whether this entity is acting
        as an IP gateway in respect to the forwarding of
        datagrams received by, but not addressed to, this
        entity.  IP gateways forward datagrams.  IP hosts
        do not (except those source-routed via the host).
        
        Note that for some managed nodes, this object may
        take on only a subset of the values possible.
        Accordingly, it is appropriate for an agent to
        return a `badValue' response if a management
        station attempts to change this object to an
        inappropriate value.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 1 } ;

ipDefaultTTL ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipDefaultTTLBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipDefaultTTL"
        with object identifier {ip 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The default value inserted into the Time-To-Live
        field of the IP header of datagrams originated at
        this entity, whenever a TTL value is not supplied
        by the transport layer protocol.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 2 } ;

ipInReceives ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipInReceivesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipInReceives"
        with object identifier {ip 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of input datagrams received from
        interfaces, including those received in error.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 3 } ;

ipInHdrErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipInHdrErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipInHdrErrors"
        with object identifier {ip 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of input datagrams discarded due to
        errors in their IP headers, including bad
        checksums, version number mismatch, other format
        errors, time-to-live exceeded, errors discovered
        in processing their IP options, etc.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 4 } ;

ipInAddrErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipInAddrErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipInAddrErrors"
        with object identifier {ip 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of input datagrams discarded because
        the IP address in their IP header's destination
        field was not a valid address to be received at
        this entity.  This count includes invalid
        addresses (e.g., 0.0.0.0) and addresses of
        unsupported Classes (e.g., Class E).  For entities
        which are not IP Gateways and therefore do not
        forward datagrams, this counter includes datagrams
        discarded because the destination address was not
        a local address.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 5 } ;

ipForwDatagrams ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipForwDatagramsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwDatagrams"
        with object identifier {ip 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of input datagrams for which this
        entity was not their final IP destination, as a
        result of which an attempt was made to find a
        route to forward them to that final destination.
        In entities which do not act as IP Gateways, this
        counter will include only those packets which were
        Source-Routed via this entity, and the Source-
        Route option processing was successful.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 6 } ;

ipInUnknownProtos ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipInUnknownProtosBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipInUnknownProtos"
        with object identifier {ip 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of locally-addressed datagrams
        received successfully but discarded because of an
        unknown or unsupported protocol.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 7 } ;

ipInDiscards ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipInDiscardsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipInDiscards"
        with object identifier {ip 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of input IP datagrams for which no
        problems were encountered to prevent their
        continued processing, but which were discarded
        (e.g., for lack of buffer space).  Note that this
        counter does not include any datagrams discarded
        while awaiting re-assembly.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 8 } ;

ipInDelivers ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipInDeliversBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipInDelivers"
        with object identifier {ip 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of input datagrams successfully
        delivered to IP user-protocols (including ICMP).
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 9 } ;

ipOutRequests ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipOutRequestsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipOutRequests"
        with object identifier {ip 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of IP datagrams which local IP
        user-protocols (including ICMP) supplied to IP in
        requests for transmission.  Note that this counter
        does not include any datagrams counted in
        ipForwDatagrams.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 10 } ;

ipOutDiscards ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipOutDiscardsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipOutDiscards"
        with object identifier {ip 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of output IP datagrams for which no
        problem was encountered to prevent their
        transmission to their destination, but which were
        discarded (e.g., for lack of buffer space).  Note
        that this counter would include datagrams counted
        in ipForwDatagrams if any such packets met this
        (discretionary) discard criterion.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 11 } ;

ipOutNoRoutes ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipOutNoRoutesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipOutNoRoutes"
        with object identifier {ip 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of IP datagrams discarded because no
        route could be found to transmit them to their
        destination.  Note that this counter includes any
        packets counted in ipForwDatagrams which meet this
        `no-route' criterion.  Note that this includes any
        datagarms which a host cannot route because all of
        its default gateways are down.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 12 } ;

ipReasmTimeout ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipReasmTimeoutBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipReasmTimeout"
        with object identifier {ip 13}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The maximum number of seconds which received
        fragments are held while they are awaiting
        reassembly at this entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 13 } ;

ipReasmReqds ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipReasmReqdsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipReasmReqds"
        with object identifier {ip 14}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of IP fragments received which needed
        to be reassembled at this entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 14 } ;

ipReasmOKs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipReasmOKsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipReasmOKs"
        with object identifier {ip 15}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of IP datagrams successfully re-
        assembled.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 15 } ;

ipReasmFails ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipReasmFailsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipReasmFails"
        with object identifier {ip 16}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of failures detected by the IP re-
        assembly algorithm (for whatever reason: timed
        out, errors, etc).  Note that this is not
        necessarily a count of discarded IP fragments
        since some algorithms (notably the algorithm in
        RFC 815) can lose track of the number of fragments
        by combining them as they are received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 16 } ;

ipFragOKs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipFragOKsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipFragOKs"
        with object identifier {ip 17}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of IP datagrams that have been
        successfully fragmented at this entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 17 } ;

ipFragFails ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipFragFailsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipFragFails"
        with object identifier {ip 18}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of IP datagrams that have been
        discarded because they needed to be fragmented at
        this entity but could not be, e.g., because their
        Don't Fragment flag was set.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 18 } ;

ipFragCreates ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipFragCreatesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipFragCreates"
        with object identifier {ip 19}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of IP datagram fragments that have
        been generated as a result of fragmentation at
        this entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 19 } ;


ipAddrEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    ipAddrEntryPkg PACKAGE
  BEHAVIOUR ipAddrEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "ipAddrEntry" object
        with object identifier {ipAddrTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The addressing information for one of this
        entity's IP addresses.
      !!;
      INDEX
        RFC1213-MIB.ipAdEntAddr ;
    ENDPARSE!;;
  ATTRIBUTES
    ipAddrEntryId	GET	--*IIMC naming attribute*-- ,
    ipAdEntAddr	GET ,
    ipAdEntIfIndex	GET ,
    ipAdEntNetMask	GET ,
    ipAdEntBcastAddr	GET ,
    ipAdEntReasmMaxSize	GET ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 20 1 } ;

ipAddrEntry-ipNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS ipAddrEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS ip
        AND SUBCLASSES;
  WITH ATTRIBUTE ipAddrEntryId ;
  BEHAVIOUR ipAddrEntry-ipNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.ipAdEntAddr ;
    --* *--
    --* *--
  ENDPARSE!;;
  --* *--
  --* *--
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 4 20 1 } ;

ipAddrEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IpAddrEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR ipAddrEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "ipAddrEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 4 20 1 };


ipAdEntAddr ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipAdEntAddrBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipAdEntAddr"
        with object identifier {ipAddrEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The IP address to which this entry's addressing
        information pertains.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 20 1 1 } ;

ipAdEntIfIndex ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipAdEntIfIndexBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipAdEntIfIndex"
        with object identifier {ipAddrEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The index value which uniquely identifies the
        interface to which this entry is applicable.  The
        interface identified by a particular value of this
        index is the same interface as identified by the
        same value of ifIndex.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 20 1 2 } ;

ipAdEntNetMask ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipAdEntNetMaskBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipAdEntNetMask"
        with object identifier {ipAddrEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The subnet mask associated with the IP address of
        this entry.  The value of the mask is an IP
        address with all the network bits set to 1 and all
        the hosts bits set to 0.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 20 1 3 } ;

ipAdEntBcastAddr ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipAdEntBcastAddrBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipAdEntBcastAddr"
        with object identifier {ipAddrEntry 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The value of the least-significant bit in the IP
        broadcast address used for sending datagrams on
        the (logical) interface associated with the IP
        address of this entry.  For example, when the
        Internet standard all-ones broadcast address is
        used, the value will be 1.  This value applies to
        both the subnet and network broadcasts addresses
        used by the entity on this (logical) interface.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 20 1 4 } ;

ipAdEntReasmMaxSize ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer64k ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipAdEntReasmMaxSizeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipAdEntReasmMaxSize"
        with object identifier {ipAddrEntry 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The size of the largest IP datagram which this
        entity can re-assemble from incoming IP fragmented
        datagrams received on this interface.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 20 1 5 } ;


ipRouteEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    ipRouteEntryPkg PACKAGE
  BEHAVIOUR ipRouteEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "ipRouteEntry" object
        with object identifier {ipRouteTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A route to a particular destination.
      !!;
      INDEX
        RFC1213-MIB.ipRouteDest ;
    ENDPARSE!;;
  ATTRIBUTES
    ipRouteEntryId	GET	--*IIMC naming attribute*-- ,
    ipRouteDest	GET	--*access mode change (INDEX)*-- ,
    ipRouteIfIndex	GET-REPLACE ,
    ipRouteMetric1	GET-REPLACE ,
    ipRouteMetric2	GET-REPLACE ,
    ipRouteMetric3	GET-REPLACE ,
    ipRouteMetric4	GET-REPLACE ,
    ipRouteNextHop	GET-REPLACE ,
    ipRouteType	GET-REPLACE ,
    ipRouteProto	GET ,
    ipRouteAge	GET-REPLACE ,
    ipRouteMask	GET-REPLACE ,
    ipRouteMetric5	GET-REPLACE ,
    ipRouteInfo	GET ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 } ;

ipRouteEntry-ipNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS ipRouteEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS ip
        AND SUBCLASSES;
  WITH ATTRIBUTE ipRouteEntryId ;
  BEHAVIOUR ipRouteEntry-ipNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.ipRouteDest ;
    DELETEATT ipRouteType ;
    DELETEVALUE 2 ;
  ENDPARSE!;;
  CREATE  WITH-AUTOMATIC-INSTANCE-NAMING, WITH-REFERENCE-OBJECT ;
  DELETE  DELETES-CONTAINED-OBJECTS ;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 4 21 1 } ;

ipRouteEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IpRouteEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR ipRouteEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "ipRouteEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 4 21 1 };


ipRouteDest ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipRouteDestBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteDest"
        with object identifier {ipRouteEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The destination IP address of this route.  An
        entry with a value of 0.0.0.0 is considered a
        default route.  Multiple routes to a single
        destination can appear in the table, but access to
        such multiple entries is dependent on the table-
        access mechanisms defined by the network
        management protocol in use.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 1 } ;

ipRouteIfIndex ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteIfIndexBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteIfIndex"
        with object identifier {ipRouteEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The index value which uniquely identifies the
        local interface through which the next hop of this
        route should be reached.  The interface identified
        by a particular value of this index is the same
        interface as identified by the same value of
        ifIndex.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 2 } ;

ipRouteMetric1 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteMetric1Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteMetric1"
        with object identifier {ipRouteEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The primary routing metric for this route.  The
        semantics of this metric are determined by the
        routing-protocol specified in the route's
        ipRouteProto value.  If this metric is not used,
        its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 3 } ;

ipRouteMetric2 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteMetric2Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteMetric2"
        with object identifier {ipRouteEntry 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric for this route.  The
        semantics of this metric are determined by the
        routing-protocol specified in the route's
        ipRouteProto value.  If this metric is not used,
        its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 4 } ;

ipRouteMetric3 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteMetric3Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteMetric3"
        with object identifier {ipRouteEntry 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric for this route.  The
        semantics of this metric are determined by the
        routing-protocol specified in the route's
        ipRouteProto value.  If this metric is not used,
        its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 5 } ;

ipRouteMetric4 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteMetric4Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteMetric4"
        with object identifier {ipRouteEntry 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric for this route.  The
        semantics of this metric are determined by the
        routing-protocol specified in the route's
        ipRouteProto value.  If this metric is not used,
        its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 6 } ;

ipRouteNextHop ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipRouteNextHopBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteNextHop"
        with object identifier {ipRouteEntry 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The IP address of the next hop of this route.
        (In the case of a route bound to an interface
        which is realized via a broadcast media, the value
        of this field is the agent's IP address on that
        interface.)
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 7 } ;

ipRouteType ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IpRouteType ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipRouteTypeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteType"
        with object identifier {ipRouteEntry 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The type of route.  Note that the values
        direct(3) and indirect(4) refer to the notion of
        direct and indirect routing in the IP
        architecture.
        
        Setting this object to the value invalid(2) has
        the effect of invalidating the corresponding entry
        in the ipRouteTable object.  That is, it
        effectively dissasociates the destination
        identified with said entry from the route
        identified with said entry.  It is an
        implementation-specific matter as to whether the
        agent removes an invalidated entry from the table.
        Accordingly, management stations must be prepared
        to receive tabular information from agents that
        corresponds to entries not currently in use.
        Proper interpretation of such entries requires
        examination of the relevant ipRouteType object.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 8 } ;

ipRouteProto ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IpRouteProto ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipRouteProtoBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteProto"
        with object identifier {ipRouteEntry 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The routing mechanism via which this route was
        learned.  Inclusion of values for gateway routing
        protocols is not intended to imply that hosts
        should support those protocols.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 9 } ;

ipRouteAge ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteAgeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteAge"
        with object identifier {ipRouteEntry 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of seconds since this route was last
        updated or otherwise determined to be correct.
        Note that no semantics of `too old' can be implied
        except through knowledge of the routing protocol
        by which the route was learned.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 10 } ;

ipRouteMask ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipRouteMaskBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteMask"
        with object identifier {ipRouteEntry 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Indicate the mask to be logical-ANDed with the
        destination address before being compared to the
        value in the ipRouteDest field.  For those systems
        that do not support arbitrary subnet masks, an
        agent constructs the value of the ipRouteMask by
        determining whether the value of the correspondent
        ipRouteDest field belong to a class-A, B, or C
        network, and then using one of:
        
             mask           network
             255.0.0.0      class-A
             255.255.0.0    class-B
             255.255.255.0  class-C
        
        If the value of the ipRouteDest is 0.0.0.0 (a
        default route), then the mask value is also
        0.0.0.0.  It should be noted that all IP routing
        subsystems implicitly use this mechanism.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 11 } ;

ipRouteMetric5 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipRouteMetric5Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteMetric5"
        with object identifier {ipRouteEntry 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric for this route.  The
        semantics of this metric are determined by the
        routing-protocol specified in the route's
        ipRouteProto value.  If this metric is not used,
        its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 12 } ;

ipRouteInfo ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.ObjectIdentifier ;
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipRouteInfoBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRouteInfo"
        with object identifier {ipRouteEntry 13}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A reference to MIB definitions specific to the
        particular routing protocol which is responsible
        for this route, as determined by the value
        specified in the route's ipRouteProto value.  If
        this information is not present, its value should
        be set to the OBJECT IDENTIFIER { 0 0 }, which is
        a syntatically valid object identifier, and any
        conformant implementation of ASN.1 and BER must be
        able to generate and recognize this value.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 21 1 13 } ;


ipNetToMediaEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    ipNetToMediaEntryPkg PACKAGE
  BEHAVIOUR ipNetToMediaEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "ipNetToMediaEntry" object
        with object identifier {ipNetToMediaTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Each entry contains one IpAddress to `physical'
        address equivalence.
      !!;
      INDEX
        RFC1213-MIB.ipNetToMediaIfIndex ,
        RFC1213-MIB.ipNetToMediaNetAddress ;
    ENDPARSE!;;
  ATTRIBUTES
    ipNetToMediaEntryId	GET	--*IIMC naming attribute*-- ,
    ipNetToMediaIfIndex	GET	--*access mode change (INDEX)*-- ,
    ipNetToMediaPhysAddress	GET-REPLACE ,
    ipNetToMediaNetAddress	GET	--*access mode change (INDEX)*-- ,
    ipNetToMediaType	GET-REPLACE ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 22 1 } ;

ipNetToMediaEntry-ipNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS ipNetToMediaEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS ip
        AND SUBCLASSES;
  WITH ATTRIBUTE ipNetToMediaEntryId ;
  BEHAVIOUR ipNetToMediaEntry-ipNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.ipNetToMediaIfIndex ,
      RFC1213-MIB.ipNetToMediaNetAddress ;
    DELETEATT ipNetToMediaType ;
    DELETEVALUE 2 ;
  ENDPARSE!;;
  CREATE  WITH-AUTOMATIC-INSTANCE-NAMING, WITH-REFERENCE-OBJECT ;
  DELETE  DELETES-CONTAINED-OBJECTS ;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 4 22 1 } ;

ipNetToMediaEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IpNetToMediaEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR ipNetToMediaEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "ipNetToMediaEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 4 22 1 };


ipNetToMediaIfIndex ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipNetToMediaIfIndexBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipNetToMediaIfIndex"
        with object identifier {ipNetToMediaEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The interface on which this entry's equivalence
        is effective.  The interface identified by a
        particular value of this index is the same
        interface as identified by the same value of
        ifIndex.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 22 1 1 } ;

ipNetToMediaPhysAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:physAddress ;
  BEHAVIOUR ipNetToMediaPhysAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipNetToMediaPhysAddress"
        with object identifier {ipNetToMediaEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The media-dependent `physical' address.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 22 1 2 } ;

ipNetToMediaNetAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipNetToMediaNetAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipNetToMediaNetAddress"
        with object identifier {ipNetToMediaEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The IpAddress corresponding to the media-
        dependent `physical' address.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 22 1 3 } ;

ipNetToMediaType ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IpNetToMediaType ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipNetToMediaTypeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipNetToMediaType"
        with object identifier {ipNetToMediaEntry 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The type of mapping.
        
        Setting this object to the value invalid(2) has
        the effect of invalidating the corresponding entry
        in the ipNetToMediaTable.  That is, it effectively
        dissasociates the interface identified with said
        entry from the mapping identified with said entry.
        It is an implementation-specific matter as to
        whether the agent removes an invalidated entry
        from the table.  Accordingly, management stations
        must be prepared to receive tabular information
        from agents that corresponds to entries not
        currently in use.  Proper interpretation of such
        entries requires examination of the relevant
        ipNetToMediaType object.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 22 1 4 } ;

ipRoutingDiscards ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR ipRoutingDiscardsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipRoutingDiscards"
        with object identifier {ip 23}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of routing entries which were chosen
        to be discarded even though they are valid.  One
        possible reason for discarding such an entry could
        be to free-up buffer space for other routing
        entries.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 23 } ;

ipForwardNumber ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:gauge32 ;
  BEHAVIOUR ipForwardNumberBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardNumber"
        with object identifier {ipForward 1}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The number of current  ipForwardTable  entries
        that are not invalid.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 1 } ;


ipForwardEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    ipForwardEntryPkg PACKAGE
  BEHAVIOUR ipForwardEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "ipForwardEntry" object
        with object identifier {ipForwardTable 1}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        A particular route to  a  particular  destina-
        tion, under a particular policy.
      !!;
      INDEX
        RFC1354-MIB.ipForwardDest ,
        RFC1354-MIB.ipForwardProto ,
        RFC1354-MIB.ipForwardPolicy ,
        RFC1354-MIB.ipForwardNextHop ;
    ENDPARSE!;;
  ATTRIBUTES
    ipForwardEntryId	GET	--*IIMC naming attribute*-- ,
    ipForwardDest	GET ,
    ipForwardMask	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardMask	GET-REPLACE ,
    ipForwardPolicy	GET ,
    ipForwardNextHop	GET ,
    ipForwardIfIndex	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardIfIndex	GET-REPLACE ,
    ipForwardType	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardType	GET-REPLACE ,
    ipForwardProto	GET ,
    ipForwardAge	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardAge	GET ,
    ipForwardInfo	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardInfo	GET-REPLACE ,
    ipForwardNextHopAS	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardNextHopAS	GET-REPLACE ,
    ipForwardMetric1	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardMetric1	GET-REPLACE ,
    ipForwardMetric2	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardMetric2	GET-REPLACE ,
    ipForwardMetric3	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardMetric3	GET-REPLACE ,
    ipForwardMetric4	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardMetric4	GET-REPLACE ,
    ipForwardMetric5	DEFAULT VALUE IIMCRFC12131354ASN1.c-ipForwardMetric5	GET-REPLACE ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 } ;

ipForwardEntry-ipNB NAME BINDING --RFC1354-MIB--
  SUBORDINATE OBJECT CLASS ipForwardEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS ip
        AND SUBCLASSES;
  WITH ATTRIBUTE ipForwardEntryId ;
  BEHAVIOUR ipForwardEntry-ipNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1354-MIB.ipForwardDest ,
      RFC1354-MIB.ipForwardProto ,
      RFC1354-MIB.ipForwardPolicy ,
      RFC1354-MIB.ipForwardNextHop ;
    DELETEATT ipForwardType ;
    DELETEVALUE 2 ;
  ENDPARSE!;;
  CREATE  WITH-AUTOMATIC-INSTANCE-NAMING, WITH-REFERENCE-OBJECT ;
  DELETE  DELETES-CONTAINED-OBJECTS ;
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 4 24 2 1 } ;

ipForwardEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.IpForwardEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR ipForwardEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "ipForwardEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 4 24 2 1 };


ipForwardDest ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipForwardDestBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardDest"
        with object identifier {ipForwardEntry 1}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The destination IP address of this route.   An
        entry  with  a value of 0.0.0.0 is considered a
        default route.
        
        This object may not take a Multicast (Class  D)
        address value.
        
        Any assignment (implicit or  otherwise)  of  an
        instance  of  this  object to a value x must be
        rejected if the bitwise logical-AND of  x  with
        the  value of the corresponding instance of the
        ipForwardMask object is not equal to x.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 1 } ;

ipForwardMask ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipForwardMaskBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardMask"
        with object identifier {ipForwardEntry 2}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        Indicate the mask to be logical-ANDed with the
        destination  address  before  being compared to
        the value  in  the  ipForwardDest  field.   For
        those  systems  that  do  not support arbitrary
        subnet masks, an agent constructs the value  of
        the  ipForwardMask  by  reference to the IP Ad-
        dress Class.
        
        Any assignment (implicit or  otherwise)  of  an
        instance  of  this  object to a value x must be
        rejected if the bitwise logical-AND of  x  with
        the  value of the corresponding instance of the
        ipForwardDest object is not equal to ipForward-
        Dest.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 2 } ;

ipForwardPolicy ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardPolicyBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardPolicy"
        with object identifier {ipForwardEntry 3}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The general set of conditions that would cause
        the  selection  of  one multipath route (set of
        next hops for a given destination) is  referred
        to as 'policy'.
        
        Unless the mechanism indicated by ipForwardPro-
        to specifies otherwise, the policy specifier is
        the IP TOS Field.  The encoding of IP TOS is as
        specified  by  the  following convention.  Zero
        indicates the default path if no more  specific
        policy applies.
        
        +-----+-----+-----+-----+-----+-----+-----+-----+
        |                 |                       |     |
        |   PRECEDENCE    |    TYPE OF SERVICE    |  0  |
        |                 |                       |     |
        +-----+-----+-----+-----+-----+-----+-----+-----+
        
                 IP TOS                IP TOS
            Field     Policy      Field     Policy
            Contents    Code      Contents    Code
            0 0 0 0  ==>   0      0 0 0 1  ==>   2
            0 0 1 0  ==>   4      0 0 1 1  ==>   6
            0 1 0 0  ==>   8      0 1 0 1  ==>  10
            0 1 1 0  ==>  12      0 1 1 1  ==>  14
            1 0 0 0  ==>  16      1 0 0 1  ==>  18
            1 0 1 0  ==>  20      1 0 1 1  ==>  22
            1 1 0 0  ==>  24      1 1 0 1  ==>  26
            1 1 1 0  ==>  28      1 1 1 1  ==>  30
        
        Protocols defining 'policy' otherwise must  ei-
        ther define a set of values which are valid for
        this  object  or  must  implement  an  integer-
        instanced  policy table for which this object's
        value acts as an index.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 3 } ;

ipForwardNextHop ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR ipForwardNextHopBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardNextHop"
        with object identifier {ipForwardEntry 4}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        On remote routes, the address of the next sys-
        tem en route; Otherwise, 0.0.0.0.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 4 } ;

ipForwardIfIndex ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardIfIndexBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardIfIndex"
        with object identifier {ipForwardEntry 5}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The ifIndex value which identifies  the  local
        interface  through  which  the next hop of this
        route should be reached.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 5 } ;

ipForwardType ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IpForwardType ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipForwardTypeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardType"
        with object identifier {ipForwardEntry 6}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The type of route.  Note that local(3)  refers
        to  a route for which the next hop is the final
        destination; remote(4) refers to  a  route  for
        which  the  next  hop is not the final destina-
        tion.
        
        Setting this object to the value invalid(2) has
        the  effect  of  invalidating the corresponding
        entry in the ipForwardTable object.   That  is,
        it  effectively  disassociates  the destination
        identified with said entry from the route iden-
        tified    with    said   entry.    It   is   an
        implementation-specific matter  as  to  whether
        the agent removes an invalidated entry from the
        table.  Accordingly, management  stations  must
        be prepared to receive tabular information from
        agents that corresponds to entries not current-
        ly  in  use.  Proper interpretation of such en-
        tries requires examination of the relevant  ip-
        ForwardType object.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 6 } ;

ipForwardProto ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.IpForwardProto ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipForwardProtoBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardProto"
        with object identifier {ipForwardEntry 7}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The routing mechanism via which this route was
        learned.  Inclusion of values for gateway rout-
        ing protocols is not  intended  to  imply  that
        hosts should support those protocols.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 7 } ;

ipForwardAge ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardAgeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardAge"
        with object identifier {ipForwardEntry 8}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The number of seconds  since  this  route  was
        last  updated  or  otherwise  determined  to be
        correct.  Note that no semantics of  `too  old'
        can  be implied except through knowledge of the
        routing  protocol  by  which  the   route   was
        learned.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 8 } ;

ipForwardInfo ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.ObjectIdentifier ;
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR ipForwardInfoBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardInfo"
        with object identifier {ipForwardEntry 9}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        A reference to MIB definitions specific to the
        particular  routing protocol which is responsi-
        ble for this route, as determined by the  value
        specified  in the route's ipForwardProto value.
        If this information is not present,  its  value
        should be set to the OBJECT IDENTIFIER { 0 0 },
        which is a syntactically valid object  identif-
        ier, and any implementation conforming to ASN.1
        and the Basic Encoding Rules must  be  able  to
        generate and recognize this value.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 9 } ;

ipForwardNextHopAS ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardNextHopASBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardNextHopAS"
        with object identifier {ipForwardEntry 10}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The Autonomous System Number of the Next  Hop.
        When  this  is  unknown  or not relevant to the
        protocol indicated by ipForwardProto, zero.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 10 } ;

ipForwardMetric1 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardMetric1Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardMetric1"
        with object identifier {ipForwardEntry 11}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        The primary routing  metric  for  this  route.
        The  semantics of this metric are determined by
        the routing-protocol specified in  the  route's
        ipForwardProto  value.   If  this metric is not
        used, its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 11 } ;

ipForwardMetric2 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardMetric2Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardMetric2"
        with object identifier {ipForwardEntry 12}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric  for  this  route.
        The  semantics of this metric are determined by
        the routing-protocol specified in  the  route's
        ipForwardProto  value.   If  this metric is not
        used, its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 12 } ;

ipForwardMetric3 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardMetric3Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardMetric3"
        with object identifier {ipForwardEntry 13}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric  for  this  route.
        The  semantics of this metric are determined by
        the routing-protocol specified in  the  route's
        ipForwardProto  value.   If  this metric is not
        used, its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 13 } ;

ipForwardMetric4 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardMetric4Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardMetric4"
        with object identifier {ipForwardEntry 14}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric  for  this  route.
        The  semantics of this metric are determined by
        the routing-protocol specified in  the  route's
        ipForwardProto  value.   If  this metric is not
        used, its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 14 } ;

ipForwardMetric5 ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR ipForwardMetric5Behaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "ipForwardMetric5"
        with object identifier {ipForwardEntry 15}
        in module RFC1354-MIB.
      !!;
      DESCRIPTION !!
        An alternate routing metric  for  this  route.
        The  semantics of this metric are determined by
        the routing-protocol specified in  the  route's
        ipForwardProto  value.   If  this metric is not
        used, its value should be set to -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 4 24 2 1 15 } ;

icmpInMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInMsgs"
        with object identifier {icmp 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of ICMP messages which the
        entity received.  Note that this counter includes
        all those counted by icmpInErrors.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 1 } ;

icmpInErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInErrors"
        with object identifier {icmp 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP messages which the entity
        received but determined as having ICMP-specific
        errors (bad ICMP checksums, bad length, etc.).
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 2 } ;

icmpInDestUnreachs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInDestUnreachsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInDestUnreachs"
        with object identifier {icmp 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Destination Unreachable
        messages received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 3 } ;

icmpInTimeExcds ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInTimeExcdsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInTimeExcds"
        with object identifier {icmp 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Time Exceeded messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 4 } ;

icmpInParmProbs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInParmProbsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInParmProbs"
        with object identifier {icmp 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Parameter Problem messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 5 } ;

icmpInSrcQuenchs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInSrcQuenchsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInSrcQuenchs"
        with object identifier {icmp 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Source Quench messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 6 } ;

icmpInRedirects ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInRedirectsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInRedirects"
        with object identifier {icmp 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Redirect messages received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 7 } ;

icmpInEchos ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInEchosBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInEchos"
        with object identifier {icmp 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Echo (request) messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 8 } ;

icmpInEchoReps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInEchoRepsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInEchoReps"
        with object identifier {icmp 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Echo Reply messages received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 9 } ;

icmpInTimestamps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInTimestampsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInTimestamps"
        with object identifier {icmp 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Timestamp (request) messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 10 } ;

icmpInTimestampReps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInTimestampRepsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInTimestampReps"
        with object identifier {icmp 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Timestamp Reply messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 11 } ;

icmpInAddrMasks ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInAddrMasksBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInAddrMasks"
        with object identifier {icmp 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Address Mask Request messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 12 } ;

icmpInAddrMaskReps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpInAddrMaskRepsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpInAddrMaskReps"
        with object identifier {icmp 13}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Address Mask Reply messages
        received.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 13 } ;

icmpOutMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutMsgs"
        with object identifier {icmp 14}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of ICMP messages which this
        entity attempted to send.  Note that this counter
        includes all those counted by icmpOutErrors.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 14 } ;

icmpOutErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutErrors"
        with object identifier {icmp 15}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP messages which this entity did
        not send due to problems discovered within ICMP
        such as a lack of buffers.  This value should not
        include errors discovered outside the ICMP layer
        such as the inability of IP to route the resultant
        datagram.  In some implementations there may be no
        types of error which contribute to this counter's
        value.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 15 } ;

icmpOutDestUnreachs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutDestUnreachsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutDestUnreachs"
        with object identifier {icmp 16}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Destination Unreachable
        messages sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 16 } ;

icmpOutTimeExcds ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutTimeExcdsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutTimeExcds"
        with object identifier {icmp 17}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Time Exceeded messages sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 17 } ;

icmpOutParmProbs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutParmProbsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutParmProbs"
        with object identifier {icmp 18}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Parameter Problem messages
        sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 18 } ;

icmpOutSrcQuenchs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutSrcQuenchsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutSrcQuenchs"
        with object identifier {icmp 19}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Source Quench messages sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 19 } ;

icmpOutRedirects ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutRedirectsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutRedirects"
        with object identifier {icmp 20}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Redirect messages sent.  For a
        host, this object will always be zero, since hosts
        do not send redirects.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 20 } ;

icmpOutEchos ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutEchosBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutEchos"
        with object identifier {icmp 21}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Echo (request) messages sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 21 } ;

icmpOutEchoReps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutEchoRepsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutEchoReps"
        with object identifier {icmp 22}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Echo Reply messages sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 22 } ;

icmpOutTimestamps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutTimestampsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutTimestamps"
        with object identifier {icmp 23}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Timestamp (request) messages
        sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 23 } ;

icmpOutTimestampReps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutTimestampRepsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutTimestampReps"
        with object identifier {icmp 24}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Timestamp Reply messages
        sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 24 } ;

icmpOutAddrMasks ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutAddrMasksBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutAddrMasks"
        with object identifier {icmp 25}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Address Mask Request messages
        sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 25 } ;

icmpOutAddrMaskReps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR icmpOutAddrMaskRepsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "icmpOutAddrMaskReps"
        with object identifier {icmp 26}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of ICMP Address Mask Reply messages
        sent.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 5 26 } ;

tcpRtoAlgorithm ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.TcpRtoAlgorithm ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR tcpRtoAlgorithmBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpRtoAlgorithm"
        with object identifier {tcp 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The algorithm used to determine the timeout value
        used for retransmitting unacknowledged octets.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 1 } ;

tcpRtoMin ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR tcpRtoMinBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpRtoMin"
        with object identifier {tcp 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The minimum value permitted by a TCP
        implementation for the retransmission timeout,
        measured in milliseconds.  More refined semantics
        for objects of this type depend upon the algorithm
        used to determine the retransmission timeout.  In
        particular, when the timeout algorithm is rsre(3),
        an object of this type has the semantics of the
        LBOUND quantity described in RFC 793.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 2 } ;

tcpRtoMax ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR tcpRtoMaxBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpRtoMax"
        with object identifier {tcp 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The maximum value permitted by a TCP
        implementation for the retransmission timeout,
        measured in milliseconds.  More refined semantics
        for objects of this type depend upon the algorithm
        used to determine the retransmission timeout.  In
        particular, when the timeout algorithm is rsre(3),
        an object of this type has the semantics of the
        UBOUND quantity described in RFC 793.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 3 } ;

tcpMaxConn ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR tcpMaxConnBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpMaxConn"
        with object identifier {tcp 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The limit on the total number of TCP connections
        the entity can support.  In entities where the
        maximum number of connections is dynamic, this
        object should contain the value -1.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 4 } ;

tcpActiveOpens ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpActiveOpensBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpActiveOpens"
        with object identifier {tcp 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of times TCP connections have made a
        direct transition to the SYN-SENT state from the
        CLOSED state.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 5 } ;

tcpPassiveOpens ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpPassiveOpensBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpPassiveOpens"
        with object identifier {tcp 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of times TCP connections have made a
        direct transition to the SYN-RCVD state from the
        LISTEN state.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 6 } ;

tcpAttemptFails ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpAttemptFailsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpAttemptFails"
        with object identifier {tcp 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of times TCP connections have made a
        direct transition to the CLOSED state from either
        the SYN-SENT state or the SYN-RCVD state, plus the
        number of times TCP connections have made a direct
        transition to the LISTEN state from the SYN-RCVD
        state.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 7 } ;

tcpEstabResets ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpEstabResetsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpEstabResets"
        with object identifier {tcp 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of times TCP connections have made a
        direct transition to the CLOSED state from either
        the ESTABLISHED state or the CLOSE-WAIT state.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 8 } ;

tcpCurrEstab ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:gauge32 ;
  BEHAVIOUR tcpCurrEstabBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpCurrEstab"
        with object identifier {tcp 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of TCP connections for which the
        current state is either ESTABLISHED or CLOSE-
        WAIT.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 9 } ;

tcpInSegs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpInSegsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpInSegs"
        with object identifier {tcp 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of segments received, including
        those received in error.  This count includes
        segments received on currently established
        connections.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 10 } ;

tcpOutSegs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpOutSegsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpOutSegs"
        with object identifier {tcp 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of segments sent, including
        those on current connections but excluding those
        containing only retransmitted octets.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 11 } ;

tcpRetransSegs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpRetransSegsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpRetransSegs"
        with object identifier {tcp 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of segments retransmitted - that
        is, the number of TCP segments transmitted
        containing one or more previously transmitted
        octets.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 12 } ;


tcpConnEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    tcpConnEntryPkg PACKAGE
  BEHAVIOUR tcpConnEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "tcpConnEntry" object
        with object identifier {tcpConnTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Information about a particular current TCP
        connection.  An object of this type is transient,
        in that it ceases to exist when (or soon after)
        the connection makes the transition to the CLOSED
        state.
      !!;
      INDEX
        RFC1213-MIB.tcpConnLocalAddress ,
        RFC1213-MIB.tcpConnLocalPort ,
        RFC1213-MIB.tcpConnRemAddress ,
        RFC1213-MIB.tcpConnRemPort ;
    ENDPARSE!;;
  ATTRIBUTES
    tcpConnEntryId	GET	--*IIMC naming attribute*-- ,
    tcpConnState	GET-REPLACE ,
    tcpConnLocalAddress	GET ,
    tcpConnLocalPort	GET ,
    tcpConnRemAddress	GET ,
    tcpConnRemPort	GET ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 13 1 } ;

tcpConnEntry-tcpNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS tcpConnEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS tcp
        AND SUBCLASSES;
  WITH ATTRIBUTE tcpConnEntryId ;
  BEHAVIOUR tcpConnEntry-tcpNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.tcpConnLocalAddress ,
      RFC1213-MIB.tcpConnLocalPort ,
      RFC1213-MIB.tcpConnRemAddress ,
      RFC1213-MIB.tcpConnRemPort ;
    --* *--
    --* *--
  ENDPARSE!;;
  --* *--
  --* *--
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 6 13 1 } ;

tcpConnEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.TcpConnEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR tcpConnEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "tcpConnEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 6 13 1 };


tcpConnState ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.TcpConnState ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR tcpConnStateBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpConnState"
        with object identifier {tcpConnEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The state of this TCP connection.
        
        The only value which may be set by a management
        station is deleteTCB(12).  Accordingly, it is
        appropriate for an agent to return a `badValue'
        response if a management station attempts to set
        this object to any other value.
        
        If a management station sets this object to the
        value deleteTCB(12), then this has the effect of
        deleting the TCB (as defined in RFC 793) of the
        corresponding connection on the managed node,
        resulting in immediate termination of the
        connection.
        
        As an implementation-specific option, a RST
        segment may be sent from the managed node to the
        other TCP endpoint (note however that RST segments
        are not sent reliably).
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 13 1 1 } ;

tcpConnLocalAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR tcpConnLocalAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpConnLocalAddress"
        with object identifier {tcpConnEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The local IP address for this TCP connection.  In
        the case of a connection in the listen state which
        is willing to accept connections for any IP
        interface associated with the node, the value
        0.0.0.0 is used.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 13 1 2 } ;

tcpConnLocalPort ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer64k ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR tcpConnLocalPortBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpConnLocalPort"
        with object identifier {tcpConnEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The local port number for this TCP connection.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 13 1 3 } ;

tcpConnRemAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR tcpConnRemAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpConnRemAddress"
        with object identifier {tcpConnEntry 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The remote IP address for this TCP connection.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 13 1 4 } ;

tcpConnRemPort ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer64k ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR tcpConnRemPortBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpConnRemPort"
        with object identifier {tcpConnEntry 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The remote port number for this TCP connection.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 13 1 5 } ;

tcpInErrs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpInErrsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpInErrs"
        with object identifier {tcp 14}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of segments received in error
        (e.g., bad TCP checksums).
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 14 } ;

tcpOutRsts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR tcpOutRstsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "tcpOutRsts"
        with object identifier {tcp 15}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of TCP segments sent containing the
        RST flag.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 6 15 } ;

udpInDatagrams ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR udpInDatagramsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "udpInDatagrams"
        with object identifier {udp 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of UDP datagrams delivered to
        UDP users.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 1 } ;

udpNoPorts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR udpNoPortsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "udpNoPorts"
        with object identifier {udp 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of received UDP datagrams for
        which there was no application at the destination
        port.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 2 } ;

udpInErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR udpInErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "udpInErrors"
        with object identifier {udp 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of received UDP datagrams that could
        not be delivered for reasons other than the lack
        of an application at the destination port.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 3 } ;

udpOutDatagrams ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR udpOutDatagramsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "udpOutDatagrams"
        with object identifier {udp 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of UDP datagrams sent from this
        entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 4 } ;


udpEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    udpEntryPkg PACKAGE
  BEHAVIOUR udpEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "udpEntry" object
        with object identifier {udpTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Information about a particular current UDP
        listener.
      !!;
      INDEX
        RFC1213-MIB.udpLocalAddress ,
        RFC1213-MIB.udpLocalPort ;
    ENDPARSE!;;
  ATTRIBUTES
    udpEntryId	GET	--*IIMC naming attribute*-- ,
    udpLocalAddress	GET ,
    udpLocalPort	GET ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 5 1 } ;

udpEntry-udpNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS udpEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS udp
        AND SUBCLASSES;
  WITH ATTRIBUTE udpEntryId ;
  BEHAVIOUR udpEntry-udpNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.udpLocalAddress ,
      RFC1213-MIB.udpLocalPort ;
    --* *--
    --* *--
  ENDPARSE!;;
  --* *--
  --* *--
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 7 5 1 } ;

udpEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.UdpEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR udpEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "udpEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 7 5 1 };


udpLocalAddress ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR udpLocalAddressBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "udpLocalAddress"
        with object identifier {udpEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The local IP address for this UDP listener.  In
        the case of a UDP listener which is willing to
        accept datagrams for any IP interface associated
        with the node, the value 0.0.0.0 is used.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 5 1 1 } ;

udpLocalPort ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer64k ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR udpLocalPortBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "udpLocalPort"
        with object identifier {udpEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The local port number for this UDP listener.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 7 5 1 2 } ;

egpInMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpInMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpInMsgs"
        with object identifier {egp 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP messages received without
        error.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 1 } ;

egpInErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpInErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpInErrors"
        with object identifier {egp 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP messages received that proved
        to be in error.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 2 } ;

egpOutMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpOutMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpOutMsgs"
        with object identifier {egp 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of locally generated EGP
        messages.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 3 } ;

egpOutErrors ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpOutErrorsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpOutErrors"
        with object identifier {egp 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of locally generated EGP messages not
        sent due to resource limitations within an EGP
        entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 4 } ;


egpNeighEntry MANAGED OBJECT CLASS --*row*--
  DERIVED FROM "Rec. X.721 | ISO/IEC 10165-2:1992":top ;
  CHARACTERIZED BY
    egpNeighEntryPkg PACKAGE
  BEHAVIOUR egpNeighEntryPkgBehaviour
  BEHAVIOUR DEFINED AS
    !BEGINPARSE
      REFERENCE !!
        This managed object class maps to the "egpNeighEntry" object
        with object identifier {egpNeighTable 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Information about this entity's relationship with
        a particular EGP neighbor.
      !!;
      INDEX
        RFC1213-MIB.egpNeighAddr ;
    ENDPARSE!;;
  ATTRIBUTES
    egpNeighEntryId	GET	--*IIMC naming attribute*-- ,
    egpNeighState	GET ,
    egpNeighAddr	GET ,
    egpNeighAs	GET ,
    egpNeighInMsgs	GET ,
    egpNeighInErrs	GET ,
    egpNeighOutMsgs	GET ,
    egpNeighOutErrs	GET ,
    egpNeighInErrMsgs	GET ,
    egpNeighOutErrMsgs	GET ,
    egpNeighStateUps	GET ,
    egpNeighStateDowns	GET ,
    egpNeighIntervalHello	GET ,
    egpNeighIntervalPoll	GET ,
    egpNeighMode	GET ,
    egpNeighEventTrigger	GET-REPLACE ;;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 } ;

egpNeighEntry-egpNB NAME BINDING --RFC1213-MIB--
  SUBORDINATE OBJECT CLASS egpNeighEntry
        AND SUBCLASSES;
  NAMED BY SUPERIOR OBJECT CLASS egp
        AND SUBCLASSES;
  WITH ATTRIBUTE egpNeighEntryId ;
  BEHAVIOUR egpNeighEntry-egpNBBehaviour
  BEHAVIOUR DEFINED AS
  !BEGINPARSE
    INDEX
      RFC1213-MIB.egpNeighAddr ;
    --* *--
    --* *--
  ENDPARSE!;;
  --* *--
  --* *--
REGISTERED AS { iimcAutoNameBinding 1 3 6 1 2 1 8 5 1 } ;

egpNeighEntryId ATTRIBUTE
    WITH ATTRIBUTE SYNTAX
        IIMCRFC12131354ASN1.EgpNeighEntryIdValue ;
    MATCHES FOR	EQUALITY;
    BEHAVIOUR egpNeighEntryIdBehaviour
    BEHAVIOUR DEFINED AS
    ! The naming attribute for managed object class "egpNeighEntry". !;;
REGISTERED AS { iimcAutoName 1 3 6 1 2 1 8 5 1 };


egpNeighState ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.EgpNeighState ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR egpNeighStateBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighState"
        with object identifier {egpNeighEntry 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The EGP state of the local system with respect to
        this entry's EGP neighbor.  Each EGP state is
        represented by a value that is one greater than
        the numerical value associated with said state in
        RFC 904.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 1 } ;

egpNeighAddr ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:ipAddress ;
  BEHAVIOUR egpNeighAddrBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighAddr"
        with object identifier {egpNeighEntry 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The IP address of this entry's EGP neighbor.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 2 } ;

egpNeighAs ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR egpNeighAsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighAs"
        with object identifier {egpNeighEntry 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The autonomous system of this EGP peer.  Zero
        should be specified if the autonomous system
        number of the neighbor is not yet known.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 3 } ;

egpNeighInMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighInMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighInMsgs"
        with object identifier {egpNeighEntry 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP messages received without error
        from this EGP peer.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 4 } ;

egpNeighInErrs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighInErrsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighInErrs"
        with object identifier {egpNeighEntry 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP messages received from this EGP
        peer that proved to be in error (e.g., bad EGP
        checksum).
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 5 } ;

egpNeighOutMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighOutMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighOutMsgs"
        with object identifier {egpNeighEntry 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of locally generated EGP messages to
        this EGP peer.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 6 } ;

egpNeighOutErrs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighOutErrsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighOutErrs"
        with object identifier {egpNeighEntry 7}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of locally generated EGP messages not
        sent to this EGP peer due to resource limitations
        within an EGP entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 7 } ;

egpNeighInErrMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighInErrMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighInErrMsgs"
        with object identifier {egpNeighEntry 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP-defined error messages received
        from this EGP peer.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 8 } ;

egpNeighOutErrMsgs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighOutErrMsgsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighOutErrMsgs"
        with object identifier {egpNeighEntry 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP-defined error messages sent to
        this EGP peer.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 9 } ;

egpNeighStateUps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighStateUpsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighStateUps"
        with object identifier {egpNeighEntry 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP state transitions to the UP
        state with this EGP peer.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 10 } ;

egpNeighStateDowns ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR egpNeighStateDownsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighStateDowns"
        with object identifier {egpNeighEntry 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The number of EGP state transitions from the UP
        state to any other state with this EGP peer.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 11 } ;

egpNeighIntervalHello ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR egpNeighIntervalHelloBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighIntervalHello"
        with object identifier {egpNeighEntry 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The interval between EGP Hello command
        retransmissions (in hundredths of a second).  This
        represents the t1 timer as defined in RFC 904.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 12 } ;

egpNeighIntervalPoll ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR egpNeighIntervalPollBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighIntervalPoll"
        with object identifier {egpNeighEntry 13}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The interval between EGP poll command
        retransmissions (in hundredths of a second).  This
        represents the t3 timer as defined in RFC 904.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 13 } ;

egpNeighMode ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.EgpNeighMode ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR egpNeighModeBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighMode"
        with object identifier {egpNeighEntry 14}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The polling mode of this EGP entity, either
        passive or active.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 14 } ;

egpNeighEventTrigger ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.EgpNeighEventTrigger ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR egpNeighEventTriggerBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpNeighEventTrigger"
        with object identifier {egpNeighEntry 15}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        A control variable used to trigger operator-
        initiated Start and Stop events.  When read, this
        variable always returns the most recent value that
        egpNeighEventTrigger was set to.  If it has not
        been set since the last initialization of the
        network management subsystem on the node, it
        returns a value of `stop'.
        
        When set, this variable causes a Start or Stop
        event on the specified neighbor, as specified on
        pages 8-10 of RFC 904.  Briefly, a Start event
        causes an Idle peer to begin neighbor acquisition
        and a non-Idle peer to reinitiate neighbor
        acquisition.  A stop event causes a non-Idle peer
        to return to the Idle state until a Start event
        occurs, either via egpNeighEventTrigger or
        otherwise.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 5 1 15 } ;

egpAs ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.Integer ;
  MATCHES FOR	    EQUALITY, ORDERING ;
  BEHAVIOUR egpAsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "egpAs"
        with object identifier {egp 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The autonomous system number of this EGP entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 8 6 } ;

snmpInPkts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInPktsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInPkts"
        with object identifier {snmp 1}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of Messages delivered to the
        SNMP entity from the transport service.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 1 } ;

snmpOutPkts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutPktsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutPkts"
        with object identifier {snmp 2}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Messages which were
        passed from the SNMP protocol entity to the
        transport service.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 2 } ;

snmpInBadVersions ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInBadVersionsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInBadVersions"
        with object identifier {snmp 3}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Messages which were
        delivered to the SNMP protocol entity and were for
        an unsupported SNMP version.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 3 } ;

snmpInBadCommunityNames ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInBadCommunityNamesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInBadCommunityNames"
        with object identifier {snmp 4}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Messages delivered to
        the SNMP protocol entity which used a SNMP
        community name not known to said entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 4 } ;

snmpInBadCommunityUses ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInBadCommunityUsesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInBadCommunityUses"
        with object identifier {snmp 5}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Messages delivered to
        the SNMP protocol entity which represented an SNMP
        operation which was not allowed by the SNMP
        community named in the Message.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 5 } ;

snmpInASNParseErrs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInASNParseErrsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInASNParseErrs"
        with object identifier {snmp 6}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of ASN.1 or BER errors
        encountered by the SNMP protocol entity when
        decoding received SNMP Messages.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 6 } ;

snmpInTooBigs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInTooBigsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInTooBigs"
        with object identifier {snmp 8}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        delivered to the SNMP protocol entity and for
        which the value of the error-status field is
        `tooBig'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 8 } ;

snmpInNoSuchNames ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInNoSuchNamesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInNoSuchNames"
        with object identifier {snmp 9}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        delivered to the SNMP protocol entity and for
        which the value of the error-status field is
        `noSuchName'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 9 } ;

snmpInBadValues ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInBadValuesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInBadValues"
        with object identifier {snmp 10}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        delivered to the SNMP protocol entity and for
        which the value of the error-status field is
        `badValue'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 10 } ;

snmpInReadOnlys ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInReadOnlysBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInReadOnlys"
        with object identifier {snmp 11}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number valid SNMP PDUs which were
        delivered to the SNMP protocol entity and for
        which the value of the error-status field is
        `readOnly'.  It should be noted that it is a
        protocol error to generate an SNMP PDU which
        contains the value `readOnly' in the error-status
        field, as such this object is provided as a means
        of detecting incorrect implementations of the
        SNMP.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 11 } ;

snmpInGenErrs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInGenErrsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInGenErrs"
        with object identifier {snmp 12}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        delivered to the SNMP protocol entity and for
        which the value of the error-status field is
        `genErr'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 12 } ;

snmpInTotalReqVars ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInTotalReqVarsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInTotalReqVars"
        with object identifier {snmp 13}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of MIB objects which have been
        retrieved successfully by the SNMP protocol entity
        as the result of receiving valid SNMP Get-Request
        and Get-Next PDUs.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 13 } ;

snmpInTotalSetVars ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInTotalSetVarsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInTotalSetVars"
        with object identifier {snmp 14}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of MIB objects which have been
        altered successfully by the SNMP protocol entity
        as the result of receiving valid SNMP Set-Request
        PDUs.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 14 } ;

snmpInGetRequests ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInGetRequestsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInGetRequests"
        with object identifier {snmp 15}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Get-Request PDUs which
        have been accepted and processed by the SNMP
        protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 15 } ;

snmpInGetNexts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInGetNextsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInGetNexts"
        with object identifier {snmp 16}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Get-Next PDUs which have
        been accepted and processed by the SNMP protocol
        entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 16 } ;

snmpInSetRequests ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInSetRequestsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInSetRequests"
        with object identifier {snmp 17}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Set-Request PDUs which
        have been accepted and processed by the SNMP
        protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 17 } ;

snmpInGetResponses ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInGetResponsesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInGetResponses"
        with object identifier {snmp 18}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Get-Response PDUs which
        have been accepted and processed by the SNMP
        protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 18 } ;

snmpInTraps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpInTrapsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpInTraps"
        with object identifier {snmp 19}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Trap PDUs which have
        been accepted and processed by the SNMP protocol
        entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 19 } ;

snmpOutTooBigs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutTooBigsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutTooBigs"
        with object identifier {snmp 20}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        generated by the SNMP protocol entity and for
        which the value of the error-status field is
        `tooBig.'
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 20 } ;

snmpOutNoSuchNames ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutNoSuchNamesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutNoSuchNames"
        with object identifier {snmp 21}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        generated by the SNMP protocol entity and for
        which the value of the error-status is
        `noSuchName'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 21 } ;

snmpOutBadValues ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutBadValuesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutBadValues"
        with object identifier {snmp 22}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        generated by the SNMP protocol entity and for
        which the value of the error-status field is
        `badValue'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 22 } ;

snmpOutGenErrs ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutGenErrsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutGenErrs"
        with object identifier {snmp 24}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP PDUs which were
        generated by the SNMP protocol entity and for
        which the value of the error-status field is
        `genErr'.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 24 } ;

snmpOutGetRequests ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutGetRequestsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutGetRequests"
        with object identifier {snmp 25}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Get-Request PDUs which
        have been generated by the SNMP protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 25 } ;

snmpOutGetNexts ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutGetNextsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutGetNexts"
        with object identifier {snmp 26}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Get-Next PDUs which have
        been generated by the SNMP protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 26 } ;

snmpOutSetRequests ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutSetRequestsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutSetRequests"
        with object identifier {snmp 27}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Set-Request PDUs which
        have been generated by the SNMP protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 27 } ;

snmpOutGetResponses ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutGetResponsesBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutGetResponses"
        with object identifier {snmp 28}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Get-Response PDUs which
        have been generated by the SNMP protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 28 } ;

snmpOutTraps ATTRIBUTE
  DERIVED FROM {iimcIIMCIMIBTRANS}:counter32 ;
  BEHAVIOUR snmpOutTrapsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpOutTraps"
        with object identifier {snmp 29}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        The total number of SNMP Trap PDUs which have
        been generated by the SNMP protocol entity.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 29 } ;

snmpEnableAuthenTraps ATTRIBUTE
  WITH ATTRIBUTE SYNTAX IIMCRFC12131354ASN1.SnmpEnableAuthenTraps ; --*ENUM*--
  MATCHES FOR	    EQUALITY ;
  BEHAVIOUR snmpEnableAuthenTrapsBehaviour
  BEHAVIOUR DEFINED AS 
    !BEGINPARSE
      REFERENCE !!
        This attribute maps to "snmpEnableAuthenTraps"
        with object identifier {snmp 30}
        in module RFC1213-MIB.
      !!;
      DESCRIPTION !!
        Indicates whether the SNMP agent process is
        permitted to generate authentication-failure
        traps.  The value of this object overrides any
        configuration information; as such, it provides a
        means whereby all authentication-failure traps may
        be disabled.
        
        Note that it is strongly recommended that this
        object be stored in non-volatile memory so that it
        remains constant between re-initializations of the
        network management system.
      !!;
    ENDPARSE!;;
REGISTERED AS { iimcAutoObjAndAttr 1 3 6 1 2 1 11 30 } ;


--
-- Translated Traps/Notifications
--
-- SNMP Traps are handled by the
-- "internetSystem" NOTIFICATION: internetAlarm
-- as discussed in [IIMCITRANMIB] Section 2.1.2.2,
-- Trap/Notification Registration

