/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMTC.C - Textual conventions functions
 *
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:39:32  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMTC.C_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:39:32   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 16:34:28   gfoster
 * Copyright text was reformated.
 * 
 *    Rev 1.0   27 May 1992 16:08:18   gfoster
 * Initial revision.
 *
*/

#include <stdio.h>

#ifdef MS_DOS
#include <stdlib.h>
#endif /* MS_DOS */

#include <ctype.h>

#include "tds.h"
#include "smscdefs.h"
#include "smstdefs.h"
#include "smsydefs.h"
#include "smic.h"


/* addTCname - add new textual convention (start definition)
*
* call with:
*   pNa - textual convention name
*   pMod - containing module
*
* returns:
*   ptr to new textual convention or NULL if error
*/
    MIBSYM *
#ifdef __STDC__
addTCname(STRTAB *pNa, MIBSYM *pMod)
#else
addTCname(pNa, pMod)
    STRTAB *pNa;
    MIBSYM *pMod;
#endif /* __STDC__ */
{

    MIBSYM *pSym;
    MIBSYM *pTc;


    /* check if item already defined */
    pSym = pNa->pSym;
    if ((pSym != NULL) && (pSym->pMod == pMod)) {
        /* item already defined */
        yyerror("\"%s\" already defined in current module",
                pSym->pszName);
#ifdef OLD
        yyterm();
#endif
        return(NULL);
    }

    /* check case of name */
    if (!isupper(*(pNa->pszVal))) {
        yyerror("Name of Textual Convention \"%s\" must start with uppercase letter",
                pNa->pszVal);
    }

    /* item not defined */
    /* allocate new symbol */
    pTc = newTC(pNa, pMod);

    /* mark as TC being defined */
    pTc->usType |= MIBSYMtc | MIBSYMDF;

    return(pTc);

} /* addTCname */


/** checkTCs - check reference counts for TCs in module
*
* call with:
*   pMod - module
*/
    VOID
#ifdef __STDC__
checkTCs(MIBSYM *pMod)
#else
checkTCs(pMod)
    MIBSYM *pMod;
#endif /* __STDC__ */
{
    MIBSYM *pT;

    for (pT = pTcGHL; pT != NULL; pT = pT->pNext) {
        if (pT->pMod != pMod)
            continue;

        if (pT->ut.tc.cUse == 0) {
            if (!fNoUnUsedWarn)
                yywarning("\"%s\" defined but not used",
                        pT->pszName);
        }
    }
} /* checkTCs */


/* end of file: SMTC.C */
