struct event {
    struct event *event_next;
    struct event *event_correlated;

    oid	    *event_objectClass;
    u_char  event_objectClassLength;
    u_char  *event_objectInstance;
    u_char  event_objectInstanceLength;
    int	    event_alarmType;
    u_long  event_time;
    int	    event_probableCause;
    int	    event_specificProblem;
    int	    event_perceivedSeverity;
    int	    event_backUpStatus;
    u_char  *event_backUpObjectInstance;
    u_char  event_backUpObjectInstanceLength;
    int	    event_trendIndication;
    oid	    *event_triggeredThreshold;
    u_char  event_triggeredThresholdLength;
    int	    event_thresholdLevel;
    int	    event_thresholdObservedValue;
    u_char  *event_notificationID;
    u_char  event_notificationIDLength;
    u_char  *event_correlatedNotifications;
    int	    event_correlatedNotificationsLength;
    int	    event_operState;
    int	    event_adminState;
    u_char  *event_monitoredAttributes;
    int	    event_monitoredAttributesLength;
    char    *event_proposedRepairAction;
    int	    event_proposedRepairActionLength;
    u_char  *event_problemData;
    int	    event_problemDataLength;
    char    *event_problemText;
    int	    event_problemTextLength;
    int	    event_credibility;
    int	    event_index;
    int	    event_status;

    int	    event_handle;
    u_long  event_timeout;
    int	    event_old_thread;
    struct  snmp_session *event_session;
};

struct notificationID {
    u_long ipaddr;
    long process;
    long index;
};

/* Alarm types */
#define OTHERERROR		    1
#define COMMUNICATIONERROR	    2
#define QUALITYOFSERVICEERROR	    3
#define PROCESSINGERROR		    4
#define EQUIPMENTERROR		    5
#define ENVIRONMENTERROR	    6
#define UNKNOWNERROR		    7

/* 
 * The following are probable cause types
 * for each of the alarm types.
 */
#define OTHERFAILURE		    1		/* None of the following */

/* Communications Errors */
#define LOSSOFSIGNAL		    2
#define FRAMINGERROR		    3
#define LOCALTRANSMISSIONERROR	    4
#define REMOTETRANSMISSIONERROR	    5
#define CALLESTABLISHMENTERROR	    6

/* Quality of Service Errors */
#define RESPONSETIMEEXCESSIVE	    7
#define QUEUESIZEEXCEEDED	    8
#define BANDWIDTHREDUCED	    9
#define RETRANSMISSIONRATEEXCESSIVE 10

/* Processing errors */
#define STORAGECAPACITYPROBLEM	    11
#define VERSIONMISMATCH		    12
#define CORRUPTDATA		    13
#define CPUCYCLESLIMITEXCEEDED	    14
#define SOFTWAREERROR		    15
#define OUTOFMEMORY		    16

/* Equipment errors */
#define POWERPROBLEM		    17
#define TIMINGPROBLEM		    18
#define TRUNKCARDPROBLEM	    19
#define LINECARDPROBLEM		    20
#define PROCESSORPROBLEM	    21
#define TERMINALPROBLEM		    22
#define EXTERNALINTERFACEDEVICEPROBLEM	23
#define DATASETPROBLEM		    24
#define MULTIPLEXORPROBLEM	    25

/* Environmental Errors */
#define SMOKEDETECTION		    26
#define ENCLOSUREDOOROPEN	    27
#define AMBIENTTEMPERATUREPROBLEM   28
#define HUMIDITYPROBLEM		    29
#define INTRUSIONDETECTION	    30

#define UNKNOWNFAILURE		    31	/* An error whose cause is not
					known and cannot be determined */


/* perceived severity */
#define SEVERITY_INDETERMINATE	1
#define SEVERITY_CLEARED	2	/* clears one or more previously reported alarms */
#define SEVERITY_CRITICAL	3	/* immediate action required */
#define SEVERITY_MAJOR		4	/* urgent action required */
#define SEVERITY_MINOR		5	/* an error condition not currently degrading service */
#define SEVERITY_WARNING	6	/* a potential or impending fault */


/* backup status */
#define BACKUP_UNKNOWN		    1
#define BACKUP_BACKEDUP		    2
#define BACKUP_NOTBACKEDUP	    3

/* Trend indication */
#define TREND_UNKNOWN		    1
#define TREND_MORESEVERE	    2
#define TREND_NOCHANGE		    3
#define TREND_LESSSEVERE	    4


/* Operational/administrative state */
#define STATE_UP		1
#define STATE_DOWN		2
#define STATE_TESTING		3

#define STATUS_PENDING		1
#define STATUS_NOTPENDING	2   /* Sets timeout timer running */
#define STATUS_INVALID		3


struct event *event_createNull();
event_free();
int event_add();
event_newStatus();
struct event *event_getPointer();
event_correlate();
event_change();
event_forceChange();
event_state();
event_timer();
event_delete();
u_char *event_getnotificationID();
u_char *event_writenotificationID();
