#include "globals.h"
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

/*
 * Finds keyword within string, ignores case.
 */
char *
str_str(s, k)
register char *s, *k;
{
	register char *r;
	register char rl, sl, kl;

	kl = utol[*k];
	for (r = k; *r && *s; s++)
	{
		rl = utol[*r]; sl = utol[*s];
		r = (rl == sl) ? r + 1 : (kl == sl) ? k + 1 : k;
	}

	return(*r ? (char *) NULL : s - strlen(k));
}

int
cleanup(s)
char *s;
{
	for (; *s; s++)
		if (!isprint(*s))
			*s = '\0';
}

unsigned long get_minute(start, end, hours)
   char *start;
   char *end;
   time_t hours;
{
   char time_str[13];
   int i;
   time_t s_time_sec, e_time_sec;
   struct tm *gmt_time_tm;
   unsigned long get_time();

   strcpy(time_str, start);
   for(i=strlen(time_str);i<12;time_str[i++]='0');
   time_str[12]='\0';
   
   s_time_sec=get_time(time_str); 
   
   if (!(strcmp(end, "now"))) {
      e_unixtime=e_time_sec=time(0);
      e_time_sec=time(0);
      gmt_time_tm=gmtime(&e_time_sec);
      gmt_time_tm->tm_isdst=1;
      e_time_sec=mktime(gmt_time_tm); 
   } else {
      strcpy(time_str, end);
      for(i=strlen(time_str);i<12;time_str[i++]='0');
      time_str[12]='\0';
      e_unixtime=e_time_sec=get_time(time_str);
   }
       
   if (sflag)
      s_unixtime = s_time_sec;
   else
      s_unixtime = time(0) - hours*SECS_PER_HOUR;

   return (e_time_sec-s_time_sec)/60;
}

unsigned long get_time(time_str)
   char *time_str;
{
   struct tm time_tm;
   int i;

   i=atoi(time_str+10);
   time_tm.tm_sec = (i==0) ? 0 : i-1; 
   time_str[10]='\0';
   i=atoi(time_str+8);
   time_tm.tm_min = (i==0) ? 0 : i-1; 
   time_str[8]='\0';
   i=atoi(time_str+6);
   time_tm.tm_hour = (i==0) ? 0 : i-1; 
   time_str[6]='\0';
   time_tm.tm_mday = atoi(time_str+4); 
   time_str[4]='\0';
   i=atoi(time_str+2);
   time_tm.tm_mon = (i==0) ? 0 : i-1; 
   time_str[2]='\0';
   time_tm.tm_year = atoi(time_str); 
   time_tm.tm_wday=0;
   time_tm.tm_yday=0;
   time_tm.tm_isdst=1;
 
   return mktime(&time_tm);
}

void insert_data(name, min)
    char *name;
    unsigned int  min;
{
   char name1[40], *name2, *colon_ptr;
   group *gptr;
   unit  *uptr;

   group *add_group();
   unit  *add_unit(); 

   strcpy(name1, name); 

   if ((colon_ptr = (char *) strchr(name1, ':')) == NULL) 
      name2 = name1 + strlen(name1); 
   else {
      *colon_ptr = '\0';
      name2 = colon_ptr + 1;
   }; 

   for (gptr=ghead; (gptr != NULL) && (gptr->next != NULL) && (strcmp(gptr->name1, name1) != 0); gptr=gptr->next); 
      
   if (gptr == NULL) {
      ghead = add_group(name1, min, NULL, NULL, NULL);
      ghead->uhead = add_unit(name2, min, NULL, NULL);
   } else
   if (strcmp(gptr->name1, name1) == 0) {
      gptr->avg = (gptr->avg * gptr->total + min)/(gptr->total + 1);
      (gptr->total)++;
      for (uptr=gptr->uhead; (uptr->next != NULL) && (strcmp(uptr->name2, name2) != 0); uptr=uptr->next); 
      if (strcmp(uptr->name2, name2) == 0) {
         if (min > 0) {
            uptr->sum = uptr->sum + min;
            if (gptr->sum < uptr->sum)
               gptr->sum = uptr->sum;
            if (uptr->max < min) 
               uptr->max = min;
            uptr->num++;
         };
      } else 
         uptr->next = add_unit(name2, min, NULL, uptr); 
   } else {
      gptr->next = add_group(name1, min, NULL ,gptr ,NULL);
      gptr->next->uhead = add_unit(name2, min, NULL, NULL);
   }; 
}

group *add_group(name1, sum, next, prev, uhead)
      char *name1;
      unsigned long sum;
      group *next;
      group *prev;
      unit  *uhead;
{
   static group *gs;

   gs = (group *) malloc(sizeof(group));

   strcpy(gs->name1, name1);
   gs->sum = sum;
   gs->total = 1;
   gs->avg = (float) sum;
   gs->next = next;
   gs->prev = prev;
   gs->uhead = uhead; 

   return gs;
}

unit *add_unit(name2, min, next, prev)
     char *name2;
     unsigned int min;
     unit *next;
     unit *prev;
{
   static unit *us;

   us = (unit *) malloc(sizeof(unit));

   strcpy(us->name2, name2);

   us->sum = min;
   us->max = min;
  
   if (min > 0)
      us->num = 1;

   us->next = next;
   us->prev = prev;

   return us;
}

void print_report(less, greater)
     float less;
     float greater;
{
   unsigned long gsum, usum;
   float gavg;
   char name[40];
   group *gptr, *max_gptr;
   unit  *uptr, *max_uptr;
   float percent;
   int cnt;

   while (ghead != NULL) {

      gsum = 0;
      gavg = 0;

      for (gptr=ghead; gptr != NULL; gptr=gptr->next) 
         if (gptr->sum > gsum) {
            gavg = gptr->avg;
            gsum = gptr->sum;
            max_gptr = gptr;
         } else
         if ((gptr->sum == gsum) && (gptr->avg >= gavg)) {
            gavg = gptr->avg;
            gsum = gptr->sum;
            max_gptr = gptr;
         };

      if (max_gptr->next == NULL) 
         if (max_gptr->prev == NULL)
            ghead = NULL;
         else
            max_gptr->prev->next = NULL;
      else
         if (max_gptr->prev == NULL) {
            ghead = max_gptr->next;
            max_gptr->next->prev = NULL;
         } else {
            max_gptr->prev->next = max_gptr->next;
            max_gptr->next->prev = max_gptr->prev;
         };
            
      cnt = 0;

      while (max_gptr->uhead !=NULL) {

         usum = 0;

         for (uptr=max_gptr->uhead; uptr != NULL; uptr=uptr->next) 
            if (uptr->sum >= usum) {
               usum = uptr->sum;
               max_uptr = uptr;
         };

         if (max_uptr->next == NULL) 
            if (max_uptr->prev == NULL)
               max_gptr->uhead = NULL;
            else
               max_uptr->prev->next = NULL;
         else
            if (max_uptr->prev == NULL) {
               max_gptr->uhead = max_uptr->next;
               max_uptr->next->prev = NULL;
            } else {
               max_uptr->prev->next = max_uptr->next;
               max_uptr->next->prev = max_uptr->prev;
            };

          strcpy(name, max_gptr->name1);

          if (strcmp(max_uptr->name2, "") != 0) {
             strcat(name, ":");
             strcat(name, max_uptr->name2);
          };

          if (strlen(name) < 14)
             if (strlen(name) < 10)
                strcat(name, "      ");
             else
                strcat(name, "    ");
         
          percent = (float) (1 - ((float) max_uptr->sum / (float) minute)) * 100;

          if ((uflag && (percent >= less)) || (oflag && (percent <= greater))) {
             /* do nothing here */
          } else {
            cnt++;
            fprintf(outfp, " %-30s\t    %8d       %5d    %8d      %5.2f%%\n", name, max_uptr->sum, max_uptr->num, max_uptr->max, percent);
          };
          free(max_uptr);
      };
      if (cnt > 0)
         fprintf(outfp, " \n");
      free(max_gptr);
   };
   fflush(outfp);
}

void print_ethernet(less, greater)
     float less;
     float greater;
{
   char name[40];
   group *gptr;
   unit  *uptr;
   ether *eptr, *eptr2;
   float percent;

   void add_ether();

   ehead = NULL;

   for (gptr=ghead; gptr != NULL; gptr=gptr->next) 
      for (uptr=gptr->uhead; uptr != NULL; uptr=uptr->next) {
         strcpy(name, gptr->name1);
         if (strcmp(uptr->name2, "") != 0) {
            strcat(name, ":");
            strcat(name, uptr->name2);
         };
         if (strstr(name, "Eth"))
	    add_ether(name, uptr->sum);
      };

   for (eptr=ehead; eptr != NULL; eptr=eptr2) {
      if (strlen(eptr->name) < 10)
         strcat(eptr->name, "      ");
      else
      if (strlen(eptr->name) < 14)
         strcat(eptr->name, "    ");
      percent = (float) (1 - ((float) eptr->sum / (float) minute)) * 100;
      if ((uflag && (percent >= less)) || (oflag && (percent <= greater))) {
         /* do nothing here */
      } else 
         fprintf(outfp, " %-30s\t  %5.2f%%\n", eptr->name, percent);
      eptr2 = eptr->next;
      free(eptr);
   };

   fflush(outfp);
}

void add_ether(name, sum)
   char *name;
   unsigned long sum;
{
   static ether *eptr;
   ether *eptr2;

   eptr = (ether *) malloc(sizeof(ether));
   eptr->sum = sum;
   strcpy(eptr->name, name);

   if (ehead == NULL) {
      ehead = eptr;
      eptr->next = NULL;
   } else {
      for (eptr2=ehead;(eptr2->next!=NULL)&&(eptr2->next->sum>sum);eptr2=eptr2->next);
      if ((eptr2 == ehead) && (eptr2->sum < sum)) {
         eptr->next = eptr2;
         ehead = eptr;
      } else {
         eptr->next = eptr2->next;
         eptr2->next = eptr;
      };
   };
   return;
}
