/************************************************************************
 *  mib_descio.c - mib description I/O routines - we do caching		*
 ************************************************************************/

#include <stdio.h>
#include "mib_descio.h"
#include <string.h>

struct mibtype {
        char *name;
        char *mibid;
        char *type;
        struct mibtype *Next;
} *MIBHead=NULL, *MIBTail=NULL;

static struct mibtype *ReadMIB();


int myverbose=0;

static struct mibtype *ReadMIB()
{
FILE *stream;
char buffer[150];
struct mibtype *p,*M;

	if ((stream=fopen("/etc/mib_desc","r")) == NULL)
		fastsnmpsyserr("ReadMIB: fopen /etc/mib_desc file");

	while( fgets( buffer, sizeof(buffer), stream ) != NULL ) {
		if ( buffer[0] == '#' ) continue;
		
		if ((M = ( struct mibtype * ) malloc( sizeof(struct mibtype))) == NULL ) {
			sprintf( buffer,"ReadMIB: %s line %d malloc failed\n",
					__FILE__,__LINE__);	
			fastsnmpsyserr( buffer );
		}
		if ((M->name= ( char * ) malloc( sizeof(buffer))) == NULL ) {
			sprintf( buffer,"ReadMIB: %s line %d malloc buffer failed\n",
					__FILE__,__LINE__);	
			fastsnmpsyserr( buffer );
		}
		strcpy( M->name, buffer );
		if (( M->name = strtok( M->name, " \t\n" )) == NULL ) {
			if (myverbose) fprintf(stderr,"mib_desc: empty line\n");
			free( M );
			continue;
		}
		if (( M->mibid = strtok( NULL, " \t\n" )) == NULL ) {
			if (myverbose) fprintf(stderr,"mib_desc: empty mibid\n");
			free( M );
			continue;
		}
		if (( M->type= strtok( NULL, " \t\n" )) == NULL ) {
			if (myverbose) fprintf(stderr,"mib_desc: empty mib type\n");
			/*free( M );  be forgiving - we don't use this anyway */
			/*continue;*/
		}
		M->Next=NULL;
		if ( MIBHead == NULL ) 
			MIBHead = MIBTail = M;
		else {
			MIBTail->Next=M;
			MIBTail=M;
		}
	}	
#ifdef STANDALONETEST
	for( p=MIBHead; p!=NULL; p=p->Next ) 
		printf("%s %s %s\n",p->name,p->mibid,p->type );
#endif
}

static int virgin=1;	/* This flag tells weather to read MIB_DESC or NOT */

char *IDtoName( ID )
char *ID;
{
struct mibtype *p,*bestfit=NULL;
static char buffer[200];

	if ( virgin ) {
		ReadMIB();
		virgin=0;
	}
	for( p=MIBHead; p != NULL; p=p->Next)
		if (strncmp(ID,p->mibid,strlen(p->mibid))==0) {
			if ( bestfit==NULL) bestfit=p;
			else
				if (strlen(p->mibid)>strlen(bestfit->mibid))
					bestfit=p;
		}
	if ( bestfit == NULL ) return(ID);
	strcpy(buffer,bestfit->name);	strcat(buffer,".");
	strcat(buffer,&ID[strlen(bestfit->mibid)]);
	return(buffer);
}



char *NametoID( Name )
char *Name;
{
struct mibtype *p;
static char buffer[200];

	if ( virgin ) {
		ReadMIB();
		virgin=0;
	}
	for( p=MIBHead; p != NULL; p=p->Next)
		if (strcmp(Name,p->name)==0) {
			strcpy( buffer, p->mibid );
			return( buffer );
		}
	return(NULL);
}

char *lookup_SNMP_name( Name )
char *Name;
{
	return(NametoID( Name ) );
}


#ifdef STANDALONE
main(argc,argv)
int argc;
char *argv[];
{
char *p;

	if ( argc == 2 ) {
	p=IDtoName(argv[1]);
	printf("%s\n",p);
	} else {
		fprintf(stderr,"Usage(): %s oid\n",argv[0]);
		exit(1);
	}
}
#endif
