/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * There are five things to do for distributed rovers
 *
 *	1) Fetch the CMU SNMP2.2 code from lancaster.andrew.cmu.edu
 *	2) modify the agent Makefile to define:
 *ROVEROBJECTS=   /u2/wbn/src//rovers/src/ProblemManager/snmp_access.o /u2/wbn/src//rovers/lib/libProblemManager.a /u2/wbn/src//rovers/lib/libctools.a
 *	3) Make the snmpd link with the rover objects:
 *snmpd:  snmpd.o kernel.o ${LIBS} snmp_agent.o snmp_vars.o snmp_var_route.o party_vars.o context_vars.o acl_vars.o view_vars.o view_parse.o alarm.o event.o route_write.o
 *	 ${CC} -o $@ snmpd.o kernel.o snmp_agent.o snmp_vars.o snmp_var_route.o party_vars.o context_vars.o acl_vars.o view_vars.o view_parse.o alarm.o event.o route_write.o  ${ROVEROBJECTS} ${LIBS}
 *	4) Modify snmp_vars.c to include rover hooks code
 *		a) rover tree prefix and suffix
 *		b) rover tree size 
 *		c) actual rover hooks code that calls this files' routines
 *		based on what object is selected.
 *	5) Modify snmp_vars.h to include rover MIB definitions
 *	6) Voila - instant distributed rovers.  Wait 3 minutes and serve.
 */

/*#define STANDALONE 1	/*  */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <pwd.h>
#include <sys/param.h>

#include "pathnames.h"
#include "CommonDefs.h"
#include "problem.h"

static int NumProblems = 0;
struct ProblemType ProblemArray[MAXPROBLEMS];

static char *DefaultPingkyDir = DEFAULT_PINGKY_DIR;
static char *PingkyDir;

static char Problem_File[MAXPATHLEN]; 

static char buffer[BUFSIZ];		/* static buffer for misc uses */
char *progname;

static time_t ProblemFileLastUpdated;

static int ProblemFileChanged = 0;
static int virgin=1;

static void Refresh()
{

        ProblemFileChanged = 0;
        if (virgin) {
                /* set-up config files we will access */
                if ((PingkyDir = getenv("PINGKYDIR")) == NULL)
                        PingkyDir = DefaultPingkyDir;
                sprintf(Problem_File, "%s/%s", PingkyDir, PROBLEM_FILE);
                virgin = 0;
        }

        /* reread problem file if it has changed */
        if (FileChanged(Problem_File, &ProblemFileLastUpdated)) {
                NumProblems = ReadProblemFile(ProblemArray, Problem_File);
                FileChanged(Problem_File, &ProblemFileLastUpdated);
        }
}

int GetNumProblems(   )
{
	Refresh();
	return( NumProblems );
}

#ifdef OLD
unsigned long GetTableTime(   )
{
time_t TimeNow=time(0);

	Refresh();
	return( TimeNow-ProblemFileLastUpdated );
}
#endif

unsigned long GetTimeStamp( ProblemNum )
int ProblemNum;
{
time_t TimeNow=time(0);

	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(0);
	else return( TimeNow - ProblemArray[ ProblemNum-1 ].TimeStamp );
}
char *GetNodeName( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].Name );
}
char *GetUniqueID( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].UniqueID);
}
char *GetTestName( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].TestName);
}
char *GetStatusLine( ProblemNum )
int ProblemNum;
{
	Refresh();
	if ( ProblemNum <=0 || ProblemNum > NumProblems ) return(NULL);
	else return( ProblemArray[ ProblemNum-1 ].StatusLine);
}


#ifdef STANDALONE

main(argc, argv)
int argc;
char *argv[];
{
	Refresh();
	printf("%d problems\n",GetNumProblems());
}
#endif
