/* dixie.h */
/*
 * Copyright (c) 1990 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#define DXI_PORT 	96

#define K		1024
#define MAX_PKT_SIZE	(30*K)
#define MAX_PKT_FRAG	(K/2)

/* dixie op codes */
#define DXI_READ		0x01
#define DXI_WRITE		0x02
#define DXI_SEARCH		0x03
#define DXI_BIND		0x04
#define DXI_SEARCH1		0x05
#define DXI_ACK			0x06
#define DXI_NACK		0x07
#define DXI_SEARCH_APPROX	0x08
#define DXI_SEARCH_EXACT	0x09
#define DXI_RESEND		0x0a
#define DXI_PING		0x0b
#define DXI_SEARCH_ISUB		0x0c
#define DXI_SEARCH_FSUB		0x0d
#define DXI_SEARCH_IFSUB	0x0e
#define DXI_SEARCH_GEN		0x0f

/* dixie search types */
#define DXI_SRCH_EXACT		0x01
#define DXI_SRCH_APPROX		0x02
#define DXI_SRCH_ISUB		0x03
#define DXI_SRCH_FSUB		0x04
#define DXI_SRCH_IFSUB		0x05
#define DXI_SRCH_PRESENT	0x06
#define DXI_SRCH_LEQ		0x07
#define DXI_SRCH_GEQ		0x08
#define DXI_SRCH_AND		0x09
#define DXI_SRCH_OR		0x0a

/* dixie search scopes */
#define DXI_SRCH_BASE		0x01
#define DXI_SRCH_ONELEVEL	0x02
#define DXI_SRCH_SUBTREE	0x03

/* dixie return values */
#define DXI_SUCCESS	0x01
#define DXI_NOTFOUND	0x02
#define DXI_ERROR	0x03
#define DXI_BADCMD	0x04
#define DXI_REFUSED	0x05
#define DXI_BADDN	0x06
#define DXI_LIMIT	0x07
#define DXI_NOTCONN	0x08
#define DXI_SEQNOTFOUND	0x09
#define DXI_BAD_ATTR	0x0a
#define DXI_NEX_ATTR	0x0b
#define DXI_BAD_ATTRVAL	0x0c
#define DXI_NEX_ATTRVAL	0x0d
#define DXI_NO_RDN_MOD	0x0e
#define DXI_NAME_ERROR	0x0f
#define DXI_REFER_ERROR 0x10
#define DXI_DSA_DOWN	0x11

#define DXI_VAL_SEP	0x01
#define DXI_ATR_SEP	0x02
#define DXI_DNS_SEP	0x03

#define DXI_H_RC		0	/* char */
#define DXI_H_OP		0	/* char */
#define DXI_H_ID		1	/* short */
#define DXI_H_TOTLEN		3	/* long */
#define DXI_H_SEQUENCE		7	/* short */
#define DXI_H_FILEATTRS		9	/* char */
#define DXI_H_SRCH_TYPE 	10	/* char */
#define DXI_H_SRCH_SCOPE	11	/* char */
#define DXI_H_SIZE		16	/* unused */

#define ID	short

char *dxi_firstentry();
char *dxi_nextentry();
char *dxi_getdn();
char *dxi_lastdncomp();
char **dxi_getvalues();
extern int dxi_debug;
extern int dxi_errno;
