/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "pathnames.h"
#include "CommonDefs.h"

#define CACHESIZE	500

struct AddrCacheType {
	char Address[40];
	char Name[60];
} AddrCache[CACHESIZE];

int AddrCachei = 1;

static char file[MAXPATHLEN];
extern char * getenv();

ReadCache()
{
	char *dir;
	FILE *fp;

	AddrCachei = 1;
	if ((dir = getenv("PINGKYDIR")) == NULL)
		dir = DEFAULT_PINGKY_DIR;
	sprintf(file, "%s/%s", dir, DNSCACHEFILE);
	if ((fp = fopen(file, "r")) == NULL) {
		perror("fopen");
		return(-1);
	}
	while(fscanf(fp,"%s %s", AddrCache[AddrCachei].Address,
					AddrCache[AddrCachei].Name) == 2)
		AddrCachei++;
	fclose(fp);
	return(0);
}


SaveCache( )
{
	register int i;
	FILE *fp;
	char *dir;

	if ((dir = getenv("PINGKYDIR")) == NULL)
		dir = DEFAULT_PINGKY_DIR;
	sprintf(file, "%s/%s", dir, DNSCACHEFILE);

	if ((fp = fopen(file, "w")) == NULL) {
		syserr("Writing DNS cache file\n");
		/*NOTREACHED*/
	}
        for (i = 1; i < AddrCachei; i++)
		fprintf(fp, "%s\t%s\n", AddrCache[i].Address, 
							AddrCache[i].Name);
	fclose(fp);
}

AddrInCache( addr )
char *addr;
{
	register int i;

	for (i = 1; i < AddrCachei; i++)
		if (strcmp(AddrCache[i].Address, addr) == 0)
			return(i);
	return(0);
}

NameInCache( name )
char *name;
{
	register int i;

        for (i = 1; i < AddrCachei; i++)
                if (strcmp(AddrCache[i].Name, name) == 0)
                        return(i);
        return(0);
}

char *nametoaddrstr(name)
char *name;
{
	int i;

	if (i = NameInCache(name)) 
		return(AddrCache[i].Address);
	fprintf(stderr,
		"Panic: %s name not found - enhance to use name server\n",name);
	
        strcpy(AddrCache[AddrCachei].Address, name);
        strcpy(AddrCache[AddrCachei++].Name, name);
        if (AddrCachei >= CACHESIZE ) {
                fprintf(stderr,"Panic: TOO MANY NODES (Max=%d)\n", CACHESIZE);
                exit(1);
		/*NOTREACHED*/
        }
	SaveCache();
	return(name);
}

char *addrstrtoname(addrstr)
char *addrstr;
{
	char *p;
	static struct hostent *hp;
	char address[40];
	int i;
	static int virgin = 1;
	struct in_addr ipaddr;

	if (virgin) 
		virgin = ReadCache();
	printf("addrstrtoname( addrstr=%s\n", addrstr);
	if (i = AddrInCache(addrstr)) 
		return(AddrCache[i].Name);
	printf("%d Using Name Server to resolve %s to name ....",
							AddrCachei, addrstr);
	fflush(stdout);
        strcpy(address, addrstr);
	if ((ipaddr.s_addr = inet_addr(address)) == (unsigned long) -1L) {
		perror("inet_addr");
		return(NULL);
	}
        if ((hp = gethostbyaddr((char *) &ipaddr, sizeof(struct in_addr), 
							AF_INET)) == NULL)
        	return(NULL);
	p = hp->h_name;
	strcpy(AddrCache[AddrCachei].Address, addrstr);
	strcpy(AddrCache[AddrCachei++].Name, p);
	if (AddrCachei >= CACHESIZE) {
		fprintf(stderr,"Panic: TOO MANY NODES (Max=%d)\n", CACHESIZE);
		exit(1);
		/*NOTREACHED*/
	}
	printf("%s\n",p);
	SaveCache();
	return(p);
}

char *AStoname(as)
char *as;
{
	FILE *fp;
	char buffer[BUFSIZ], *p, *q, *dir;
	static char returnbuffer[2 * BUFSIZ];
	int ASNum, x;

	if ((ASNum = atoi(as)) == 0) 
		return(NULL);

	if ((dir = getenv("PINGKYDIR")) == NULL)
		dir = DEFAULT_PINGKY_DIR;
	sprintf(file, "%s/%s", dir, ASCACHEFILE);
	if ((fp = fopen(file, "r")) == NULL) {
		perror("fopen");
		return(NULL);
	}

	while (fgets(buffer, sizeof(buffer), fp)) {
		p = buffer;
		x = atoi(p);
		if ((x = atoi(p)) == 0) 
			continue;
		if (x == ASNum) {
			for ( ; *p != '\0' && *p != ' '; p++)
				;  /* Skip AS #'s */
			if (*p == '\0') 
				continue;
			for ( ; *p != '\0' && *p == ' '; p++)
				;  /* Skip blanks */
			if (*p == '\0') 
				continue;
			for ( ; *p != '\0' && *p != ' '; p++)
				;  /* Skip NSS #'s */
			if (*p == '\0') 
				continue;
			for( ; *p != '\0' && *p == ' '; p++)
				;  /* Skip blanks */
			if ( *p == '\0' ) 
				continue;

			for(q = p; *q != '\0'; q++)
				if (isspace(*q))
					 *q='_';
			strcpy(returnbuffer, p);
				/**** enss131-1023(----) 15 chars */
			returnbuffer[MAXNODENAME - 15] = '\0';
			fclose(fp);
			return(returnbuffer);
		}
	}
	fclose(fp);
	return((char *) NULL);
}

#ifdef STANDALONE
static char *addr="35.1.1.135";
main( argc, argv )
int argc;
char *argv[];
{
	char *name,*addrstr;

	name=addrstrtoname( addr );
        printf("%s=%s\n",addr,name );
	addrstr=nametoaddrstr( name );
	printf("Name=%s Addr=%s\n",name,addrstr);
}

#endif
