/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#ifndef _COMMONDEFS

#define _COMMONDEFS

#ifndef FreeBSD
#define FALSE 0
#define TRUE 1
#endif

#include <sys/param.h>

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#define DELIMITERS " \t\n"

#define MAXNODES        2000
#define MAXPROBLEMS     MAXNODES

#define MAXNODENAME 50	/* Size of Node Name */
#define MAXUNIQUEID 42	/* SIZE OF UNIQUE ID (USUALLY IP ADDR) */
#define MAXTESTNAME 15  /* SIZE OF TEST NAME THAT FAILED		*/

#define MAXLINE 400	/* MAXIMUM INPUT FILE LINE */ 

/*
 * Attempt to configure for type of function returned by signal-catching
 * functions (which signal and sigvec.sv_handler take a pointer to).
 */
#if defined(BSD) && BSD >= 199006 || defined(sun)
#define SIG_FN  void            /* signal-catching functions return void */
#else
#ifdef SYSV
#define SIG_FN  void            /* signal-catching functions return void */
#else
#define SIG_FN  int             /* signal-catching functions return int */
#endif
#endif

#define MAXNEIGHBORS 50
#define MAXIPADDRESS 16

#define NODE		1      
#define LINK		2     
#define LASTLINETYPE	2

#define NR 	1	/* Node/Link is Not Reachable */
#define DOWN 	2	/* Node/Link deduced to be DOWN */
#define BUSY 	3	/* Node/Link was seen UP by someone */
#define UP 	4	/* Node/Link was deduced or queried and found to be UP*/
#define MOVED   5	/* Link has MOVED - Link to be deleted after reported*/
#define LASTSTATETYPE 5

#define MERIT 		1
#define NSFNET 		2
#define NSFNETT3 	3
#define NSFNETT3R 	4
#define GENERICNET	5
#define LASTNETWORKTYPE 5

#define NONQUERYABLE 0
#define QUERYABLE 1

#define NSS 		1
#define PCP 		2
#define SCP 		3
#define NETWORK		4
#define AS 		5
#define EGPPEER 	6
#define GENNODE		7
#define LASTNODETYPE 	7
			
#define INPLINK		1	/* Merit Internal link */
#define ISISLINK	2
#define EGPLINK		3
#define ASLINK		4
#define GENLINK		5
#define LASTLINKTYPE    5

struct NodeType {
	time_t TimeStamp;
	char Name[ MAXNODENAME ];
	char IPAddress[ 34 ];
	int State;	/* UP, DOWN, NR */
	int Type;	/* NSS, SCP, PCP etc */
	int Queryable;	/* 1 if Queryable */
	struct NodeType *Next;
};

struct LinkType {
	time_t TimeStamp;
	char Node1[ MAXNODENAME ];
	char Node2[ MAXNODENAME ];
	int State;	/* UP, DOWN */
	int Type;	/* Link Type */
	struct LinkType *Next;
};

struct NetworkType {
	int Type;
	char ConfigFile[MAXPATHLEN];
	int GotOne;	/* Count of nodes responding to query */
	struct NodeType *NodeHead, *NodeTail;
	struct LinkType *LinkHead, *LinkTail;
	struct NetworkType *Next;
	time_t TimeStamp;	/* Time Stamp of this Network Information */
}; 
	
struct NeighborTableType {
	char Name[ MAXNODENAME ];
	char IPAddress[ MAXIPADDRESS ];
	int State;
	int Queryable;
	int Type;		/* Remote Node Type */
	int LinkType;		/* Type of link */
};

#endif
