#include "snmptable2.h"
#include "CommonDefs.h"
#include "ctools.h"
#include "problem.h"
#include <string.h>
#include <time.h>

int io_debug;

/*int MaxSecsB4Retry=5;
int MaxSNMPRetries=5;*/
extern int MaxSecsB4Retry;
extern int MaxSNMPRetries;
extern int verbose;

/*int DebugOnFailure=0;*/

/*char *Variables[]= { "problemTimeStamp", "problemNodeName","problemUniqueID","problemTest","problemStatus"};*/
char *Variables[]= { "problem" };

char *progname;

struct ProblemType Problem[1000];
static int NumProblems=0;

#include "version.h"
void Usage()
{
	fprintf(stderr,"\n\n%s\n\n",Version);
	fprintf(stderr,"Usage: %s -g|-n [ -v -d ] [ -t timeout ] [ -r retries] -h <address> [-h address ... -h address ] -c community table [ table ... table ]\n",progname);
	fprintf(stderr,"\nWhere:\n-g performs gets\n-n performs a get-next\n-v turns on verbosity\n-d turns on verbosity and Network I/O debugging\n");
	fprintf(stderr,"-t timeout specifies the timeout between retries.. Default=%d\n",MaxSecsB4Retry);
	fprintf(stderr,"-r retries specifies the number of retries if request timed out..Default=%d\n",MaxSNMPRetries);
	fprintf(stderr,"-h hostname specifies which host(s) to query\n-c communityname specifies the community name to use for the queries\n");
	fprintf(stderr,"table specifies which table(s) or MIB variable(s) to fetch\n");
	fprintf(stderr,"\n\nAll requested variables MUST exist in /etc/mib_desc file\n\n\n");
	exit(2);
}

void PrintReport(A)
     struct AddressListType *A;
{
struct bindings *b;
struct VarList *v;
extern char *IDtoName();
int i;
char *c,buffer[200],*instance;
time_t TimeNow=time(0);
static offset=0;
int count;
int TableTime=0;

	count=0;
	if ( A->ResponseListHead == NULL ) {
		/*printf("%s Did not respond\n",A->Address);*/
		/*printf("%ul %s %s NOT_REACHABLE\n",TimeNow,A->Address,A->Address);	/* PROBLEM.FILE */
		Problem[offset].TimeStamp=TimeNow;
		strcpy(Problem[offset].Name,A->Address);
		strcpy(Problem[offset].UniqueID,A->Address);
		strcpy(Problem[offset].TestName,"ROVER_DEAD!");
		strcpy(Problem[offset].StatusLine,"");
		NumProblems=++offset;
		return;
	}
	for( v=A->ResponseListHead; v!=NULL; v=v->Next)
		for( b=v->Head; b!=NULL; b=b->Next ) {
		/* Here we need to find the varname, the instance, and the
		value, and insert them into our data structure */
			c=IDtoName(b->instance);  /* get our varname+instance */
			/*fprintf(stderr,"Got %s\n",c);*/
			if ( c == NULL ) fprintf("Could not find var %s - maybe no /etc/mib_desc file????\n",b->instance);
			else {
				strcpy( buffer, c );  /* make a copy to parse */
				instance=strtok( buffer, ".");
				instance=strtok( NULL, ".");
				i=atoi(instance);
				if (i>count) count=i;
				if ( strncmp(c,"problemTimeStamp",16) == 0 )
					Problem[i-1+offset].TimeStamp=atol(b->value);
				else if ( strncmp(c,"problemNodeName",15) == 0)
					strcpy(Problem[i-1+offset].Name,b->value);
				else if ( strncmp(c,"problemUniqueID",15) == 0)
					strcpy(Problem[i-1+offset].UniqueID,b->value);
				else if ( strncmp(c,"problemTest",11) == 0)
					strcpy(Problem[i-1+offset].TestName,b->value);
				else if ( strncmp(c,"problemStatus",13) == 0)
					strcpy(Problem[i-1+offset].StatusLine,b->value);
				else if ( strncmp(c,"problemTableTime",16) == 0)
					TableTime=atoi(b->value);
				else; /*fprintf(stderr,"Agent returned something weird %s\n",IDtoName(b->instance));*/
			}
		}

#ifdef DEBUG
		for( i=0; i<offset+count; i++ )  /* PROBLEM.FILE */
			printf("%d %u %s %s %s %s\n",
				i,Problem[i].TimeStamp,Problem[i].Name,
				Problem[i].UniqueID,Problem[i].TestName,
				Problem[i].StatusLine);
#endif
		/*fprintf(stderr," TableTime=%d\n",TableTime );*/
		NumProblems=offset=offset+count;
}

void main( argc, argv )
int argc;
char *argv[];
{
char *Community=NULL;
struct AddressListType *AddressListHead=NULL, *A;
struct VarList *QueryListHead=NULL;
extern int io_debug;
int Cmd=SNMPTABLE,i;
char *Pingkydir,ProblemFile[MAXPATHLEN];

	progname=argv[0];
        argv++; argc--;
	while(*argv!=NULL && argv[0][0] == '-') {
                switch(argv[0][1]) {
		case 'd':
				io_debug=1;
                case 'v':	verbose=1; 
                                argv++; argc--;
                                break;
		case 'h':
			AddressListHead=AddAddress( AddressListHead, argv[1] );
                       	argv++; argc--;
                       	argv++; argc--;
			break;
		case 'c':
                       	argv++; argc--;
			Community=*argv;
                       	argv++; argc--;
			break;
		case 'r':
                       	argv++; argc--;
			if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
				MaxSNMPRetries=atoi(argv[0]);
                       		argv++; argc--;
			}
			else fprintf(stderr,"Invalid retry specification\n");
			break;
		case 't':
                       	argv++; argc--;
			if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
				MaxSecsB4Retry=atoi(argv[0]);
                       		argv++; argc--;
			}
			else fprintf(stderr,"Invalid retry specification\n");
			break;
                default:
                        fprintf(stderr,"unknown option %s ignored\n(Valid options are: -v )\n",argv[1]);
                        argv++; argc--;
                        break;
                }
        }
		
	for( i=0; i<(sizeof(Variables)/sizeof(char *)); i++ ) 
		QueryListHead=AddVar( QueryListHead, Variables[i] );
	if ((AddressListHead==NULL)||(Community==NULL)||(QueryListHead==NULL)) 
		Usage();

	if (Cmd==SNMPTABLE)
		AddressListHead=GetTable(AddressListHead, Community, QueryListHead); 
	for( A=AddressListHead; A!=NULL; A=A->Next )
		PrintReport( A );

	if ( (Pingkydir=getenv("PINGKYDIR"))==NULL) Pingkydir="./";
	strcpy( ProblemFile, Pingkydir );
	strcat( ProblemFile, "/" );
	strcat( ProblemFile, "PROBLEM.FILE" );
	WriteProblemFile( Problem, ProblemFile, NumProblems );
}
