/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <stdio.h>
#include "CommonDefs.h"

/************************************************************************
 *  DisplayNodeChain() - Debug - used to print entire Chain of nodes	*
 ************************************************************************/
void DisplayNodeChain( NPtr )
struct NodeType *NPtr;
{
	extern char *PrintState(), *PrintNodeType();

	for ( ; NPtr != NULL; NPtr = NPtr->Next) {
                printf("%s %s\t%s\t%s\t%s\n",
                        PrintTime(NPtr->TimeStamp), 
			NPtr->IPAddress,
			NPtr->Name, 
			PrintNodeType(NPtr->Type),
			PrintState(NPtr->State));
        }
}

/************************************************************************
 *  DisplayLinkChain() - Debug - used to print entire Chain of Links	*
 ************************************************************************/
void DisplayLinkChain( LPtr )
struct LinkType *LPtr;
{
	extern char *PrintState(), *PrintLinkType();

	for ( ; LPtr != NULL; LPtr = LPtr->Next) {
                printf("%s %s %s-%s\t%s\n",
                        PrintTime(LPtr->TimeStamp),
			PrintLinkType(LPtr->Type),
			LPtr->Node1,
			LPtr->Node2,
			PrintState(LPtr->State));
        }
}

/************************************************************************
 *	DisplayNetwork	- debug - used to dispaly entire network of	*
 *			structures.					*
 ************************************************************************/
void DisplayNetwork( Network )
struct NetworkType *Network;
{
        printf("\n******** Network Node Table ********\n\n");
        printf("Network\t\tNode\tType\tState\tQueryable\tTimeStamp\n");
        printf("-------\t\t----\t----\t-----\t---------\t-----------\n");
	DisplayNodeChain( Network->NodeHead );

        printf("\n******** Network Link Table ********\n\n");
        printf("Network\t\tNode1\tNode2\tState\tTimeStamp\n");
        printf("-------\t\t-----\t-----\t-----\t-----------\n");
	DisplayLinkChain( Network->LinkHead );

}	
