/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <stdio.h>
#include <string.h>
#include "CommonDefs.h"
#include "pathnames.h"
#include "GetNeighborTable.h"

extern char *communityname;

/************************************************************************
 * BuildNetworkTable - We were called with a Network Structure that	*
 *		       corresponds with "What Should Be" in the Network *
 *		       Build a Network Table Like it, make all the nodes*
 *		       and links NR, and cycle through the Queryable    *
 *		       Nodes, updating all nodes and links in the Net.  *
 ************************************************************************/
struct NetworkType *BuildNetworkTable( NetworkBase )
struct NetworkType *NetworkBase;
{
static struct NetworkType Net;
void DupNetwork();

	/* Make a copy, all state NR */
	DupNetwork( NetworkBase , &Net );
	Net.GotOne = 0;

	return( GetNeighbors(&Net) );
}

/************************************************************************
 *  DupNetwork- Make a duplicate copy of this Network Structure, but    *
 *              with the state being "NR".				*
 ************************************************************************/
void DupNetwork(NetworkBase, Net)
struct NetworkType *NetworkBase, *Net;
{
	register struct NodeType *np;
	register struct LinkType *lp;

	InitNetwork(Net, NetworkBase->Type, NetworkBase->ConfigFile );

	for (np = NetworkBase->NodeHead; np != NULL; np = np->Next)
		AddNode(Net, np->Name, np->Type, np->Queryable, NR, 
						np->TimeStamp, np->IPAddress);

	for (lp = NetworkBase->LinkHead; lp != NULL; lp = lp->Next)
		AddLink(Net, lp->Node1, lp->Node2, NR, lp->TimeStamp, lp->Type);

}
