/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Internet Rover miscellaneous "C" Tools
 *
 */

char	*itoa();	/* int  -> string */
char	*ltoa();	/* long -> string */

void Log();		/* append a timestamped log record to file */
void LogChecking(); 	/*  */
void Empty_File();	/* empty this file */
int FileChanged(); 	/* returns true if file has been modified */
time_t LastMod();  	/* returns last mod time (st_mtime) */

void panic();		/* print string and die   */
void syserr(); 		/* print sys call error and terminate */

char lock();    	/* lock a file */
void unlock(); 		/* unlock a file */
char *lockpath(); 	/* return a lock file name   */

char *_Day(), *_Time(); /* return Mon and 04:34 respectively 	*/
char *PrintTime();	/* */
char *ElapsedTime();	/* */
char *GetTime();	/* place a "Mon Mar 23 13:23\0" time string here */

char *trim();		/* replace /t/n with spaces */
char *datestr();	/* given an int showing # of days ago, give datestr */
char *cvt_time_to_datestr(); /* given time_t, return datestr        */
#ifndef time_t
#include <time.h>
#endif
time_t mktime();	/* Convert tm struct to unsigned long */
