#include <stdio.h>

/* Motif Include Files */
#include "motif.h"
#include "../ProblemManager/ProblemManager.h"
Widget pane,text1,text2;	/* Define our application widgets */

UpdateScreen()
{
extern struct ProblemType ProblemArray[];/*In Coreversion of existing problems*/
extern int NumProblems;
int i;
static char panebuffer[5000],buffer[100],outstr[100];

        Problem_Manager( CHECK, NULL, NULL, NULL, NULL );
        strcpy( panebuffer, "" );
        for( i=0; i<NumProblems; i++ ) {
                strcpy( buffer, ProblemArray[i].Name ); strcat( buffer, " ");
                strcat( buffer, ProblemArray[i].UniqueID );strcat( buffer, " ");
                strcat( buffer, ProblemArray[i].TestName );
                sprintf( outstr,"%2.2d %s_%s %-40s %-18s\n",i+1,
			_Day(ProblemArray[i].TimeStamp),
			_Time(ProblemArray[i].TimeStamp),
			buffer,ProblemArray[i].StatusLine );
                strcat( panebuffer, outstr );
        }
        XmTextSetString( text1, panebuffer );
        XmTextSetString( text2, panebuffer );

}

Refresh()
{
	UpdateScreen();
	printf("Updating\n");
	XtAddTimeOut( 20*1000, Refresh, NULL );
}

/************************************************************************
 *	main()								*
 ************************************************************************/
char *programname;
char *pingkydir,Problem_File[100],*DefaultPingkyDir='./';

main( argc, argv )
int argc;
char *argv[];
{
Widget toplevel;
Arg	myArgs[10];
Cardinal i;
char *getenv();

	programname=argv[0];
	if ((pingkydir=getenv("PINGKYDIR"))==NULL) pingkydir=DefaultPingkyDir;
	strcpy(Problem_File,pingkydir); strcat(Problem_File ,"/PROBLEM.FILE");


	toplevel = XtInitialize(argv[0],		/* ShellName	*/
				"Main",			/* Application Class */
				NULL,			/* Options	*/
				0,			/* Num Options	*/
				&argc,			/* Num Args 	*/
				argv );			/* Arg List	*/

	pane = XmCreatePanedWindow( toplevel,	/* Parent 	*/
				"pane",		/* Name		*/
				myArgs,			/* Widget Args  */
				0 );			/* # Widget Args*/
	XtManageChild( pane );
	text1 = XmCreateScrolledText( pane,	/* Parent 	*/
				"text1",		/* Name		*/
				myArgs,			/* Widget Args  */
				0 );			/* # Widget Args*/
	XmTextSetString( text1, "Hello pane1");
	XtManageChild( text1 );
	text2 = XmCreateScrolledText( pane,	/* Parent 	*/
				"text2",		/* Name		*/
				myArgs,			/* Widget Args  */
				0 );			/* # Widget Args*/
	XmTextSetString( text2, "Hello pane2");
	XtManageChild( text2 );
	
	/****************************
	 * Power on the Application *
	 ****************************/
	XtRealizeWidget( toplevel );	/* Bring up & manage toplevel widget */
	UpdateScreen();
	XtMainLoop();			/* Main Event handler loop	*/

}

