#include <stdio.h>

/* Motif Include Files */
#include "motif.h"
#include "../ProblemManager/ProblemFileio.h"
#include "../InetRover/Hostfileio.h"

static char *DefaultPingkyDir=".//";
char *pingkydir,InetHfile[100],InetPfile[100],MeritPfile[100],InetLogFile[100];
Widget toplevel;		/* Mother of all widgets */
Widget pane,text1,text2;	/* Define our application widgets */
Widget viewdialog,dialogmain,text,donepb,viewpane;

UpdateScreen()
{
struct ProblemType ProblemArray[100];
int NumProblems;
int i;
static char panebuffer[5000],buffer[100],outstr[100];

	NumProblems=ReadProblemFile( ProblemArray, InetPfile );
        strcpy( panebuffer, "" );
        for( i=0; i<NumProblems; i++ ) {
                strcpy( buffer, ProblemArray[i].Name ); strcat( buffer, " ");
                strcat( buffer, ProblemArray[i].UniqueID );strcat( buffer, " ");
                strcat( buffer, ProblemArray[i].TestName );
                sprintf( outstr,"%2.2d %s_%s %-40s %-18s\n",i+1,
			_Day(ProblemArray[i].TimeStamp),
			_Time(ProblemArray[i].TimeStamp),
			buffer,ProblemArray[i].StatusLine );
                strcat( panebuffer, outstr );
        }
        XmTextSetString( text1, panebuffer );
	NumProblems=ReadProblemFile( ProblemArray, MeritPfile );
        strcpy( panebuffer, "" );
        for( i=0; i<NumProblems; i++ ) {
                strcpy( buffer, ProblemArray[i].Name ); strcat( buffer, " ");
                strcat( buffer, ProblemArray[i].UniqueID );strcat( buffer, " ");
                strcat( buffer, ProblemArray[i].TestName );
                sprintf( outstr,"%2.2d %s_%s %-40s %-18s\n",i+1,
			_Day(ProblemArray[i].TimeStamp),
			_Time(ProblemArray[i].TimeStamp),
			buffer,ProblemArray[i].StatusLine );
                strcat( panebuffer, outstr );
        }
        XmTextSetString( text2, panebuffer );

}

Refresh()
{
	UpdateScreen();
	XtAddTimeOut( 20*1000, Refresh, NULL );
}


Quit()
{
extern int In_Critical_Section;

	if ( In_Critical_Section ) return;
	exit(0);
}

DoneView()
{

	XtUnmanageChild( dialogmain );
}

ViewLfile()
{
Arg myArgs[10];
Cardinal n=0;

Widget dialog,filesel;

       n=0;
       XtSetArg( myArgs[n], XmNallowResize, True ); n++;
       dialog = XmCreateDialogShell( toplevel, "InetRover_Problem_Log", myArgs, n );

	printf("Filter=%s\n",InetLogFile );
       n=0;
       XtSetArg( myArgs[n], XmNdirMask, XmStringCreateLtoR(InetLogFile,XmSTRING_DEFAULT_CHARSET) ); n++;
       /*XtSetArg( myArgs[n], XmNdirMask, XmStringCreateLtoR("problemlog.*",XmSTRING_DEFAULT_CHARSET) ); n++;*/
       filesel = XmCreateFileSelectionBox( dialog, "filesel", myArgs, n );
       XtManageChild( filesel );

}

ViewHfile()
{
int i,j,k;
Arg myArgs[10];
Cardinal n=0;
static struct NodeType *Node;
extern int NumNodes;
char buffer[160], FileBuffer[60000];
XmString hostlist[1000];
Cardinal hostlistcount=0;
Widget menubar,cascade,pulldown;

	Node = ReadNodeFile( InetHfile );

	strcpy( FileBuffer, "" );
	for( i=0; i<NumNodes; i++ ) {
		sprintf( buffer, "%-20s %-16s %-20s Tests: ",Node[i].NodeName,Node[i].UniqueID,Node[i].Helpfilename );
		strcat( FileBuffer, buffer );
		for( j=0; Node[i].Test[j].argv[0][0]!='\0' && j<MAXTESTS; j++ ) {
			strcat(FileBuffer, Node[i].Test[j].argv[0] );
			strcat(FileBuffer, "(");
			for( k=1; Node[i].Test[j].argv[k]!=NULL && k<MAXARGS; k++ ) {
				strcat(FileBuffer, Node[i].Test[j].argv[k] );
				if (Node[i].Test[j].argv[k+1]!=NULL)
					strcat(FileBuffer, " ");
			}
			strcat(FileBuffer, ") ");
		}
		hostlist[hostlistcount++]=XmStringCreateLtoR( FileBuffer , XmSTRING_DEFAULT_CHARSET );
		
		strcat( FileBuffer, "\n");
		strcpy(FileBuffer,"");
	}

	n=0;
	XtSetArg( myArgs[n], XmNallowResize, True ); n++;
	viewdialog = XmCreateDialogShell( toplevel, "Internet_Rover_HostFile", myArgs, n );

	n=0;
	XtSetArg( myArgs[n], XmNshowSeparator, True ); n++;
	dialogmain = XmCreateMainWindow( viewdialog, "viewmain", myArgs, n );
       menubar = XmCreateMenuBar(dialogmain,         /* Parent       */
                                "vmenubar",      /* Name         */
                                myArgs,         /* Widget Args  */
                                0 );            /* # Widget Args*/
        XtManageChild( menubar );
        pulldown = XmCreatePulldownMenu(menubar,/* Parent       */
                                "vpulldown",     /* Name         */
                                myArgs,         /* Widget Args  */
                                0 );            /* # Widget Args*/
        XtSetArg( myArgs[0], XmNsubMenuId, pulldown );
        cascade = XmCreateCascadeButton( menubar, "Commands", myArgs, 1 );
        XtManageChild( cascade );
	donepb = XmCreatePushButtonGadget(pulldown,/* Parent       */
                                "done",        /* Name         */
                                myArgs,        /* Widget Args  */
                                0 );           /* # Widget Args*/
	XtAddCallback( donepb, XmNactivateCallback, DoneView, NULL );
	XtManageChild( donepb );

	n=0;
	XtSetArg( myArgs[n], XmNlistItems, hostlist  ); n++;
	XtSetArg( myArgs[n], XmNlistItemCount, hostlistcount  ); n++;
	XtSetArg( myArgs[n], XmNlistVisibleItemCount, 20 ); n++;
	text = XmCreateSelectionBox( dialogmain, "text", myArgs, n );
	XtManageChild( text );

	XtManageChild( dialogmain );
}

char *programname;

main( argc, argv )
int argc;
char *argv[];
{
Arg	myArgs[10];
Cardinal i;
char *getenv(),*rindex();
Widget pb,menubar,pulldown,cascade,pulldown2,cascade2,logpb,hfilepb;

	programname=argv[0];
	if ((pingkydir=getenv("PINGKYDIR"))==NULL) pingkydir=DefaultPingkyDir;
	*rindex(pingkydir,'/')='\0';
	strcpy(InetPfile,pingkydir);strcat(InetPfile,"/InetRover/PROBLEM.FILE");
	strcpy(InetHfile,pingkydir); strcat( InetHfile,"/InetRover/hostfile");
	strcpy(InetLogFile,pingkydir); strcat( InetLogFile,"/InetRover/problemlog.*");
	strcpy(MeritPfile,pingkydir); strcat( MeritPfile,"/MeritRover/PROBLEM.FILE");


	toplevel = XtInitialize(argv[0],	/* ShellName	*/
				"XDisplay2",	/* Application Class */
				NULL,		/* Options	*/
				0,		/* Num Options	*/
				&argc,		/* Num Args 	*/
				argv );		/* Arg List	*/

	pane = XmCreatePanedWindow( toplevel,	/* Parent 	*/
				"pane",		/* Name		*/
				myArgs,		/* Widget Args  */
				0 );		/* # Widget Args*/
	XtManageChild( pane );

	menubar = XmCreateMenuBar(pane,		/* Parent       */
                                "menubar",	/* Name         */
                                myArgs,         /* Widget Args  */
                                0 );            /* # Widget Args*/
	XtManageChild( menubar );

	pulldown = XmCreatePulldownMenu(menubar,/* Parent       */
                                "pulldown",     /* Name         */
                                myArgs,         /* Widget Args  */
                                0 );            /* # Widget Args*/
	XtSetArg( myArgs[0], XmNsubMenuId, pulldown );
	cascade = XmCreateCascadeButton( menubar, "Commands", myArgs, 1 );
	XtManageChild( cascade );
	pb = XmCreatePushButtonGadget(pulldown,/* Parent       */
                                "quit",        /* Name         */
                                myArgs,        /* Widget Args  */
                                0 );           /* # Widget Args*/
	XtManageChild( pb );
	XtAddCallback( pb, XmNactivateCallback, Quit, NULL );

	pulldown2 = XmCreatePulldownMenu(menubar,/* Parent       */
                                "pulldown2",     /* Name         */
                                myArgs,         /* Widget Args  */
                                0 );            /* # Widget Args*/
	XtSetArg( myArgs[0], XmNsubMenuId, pulldown2 );
	cascade2 = XmCreateCascadeButton( menubar, "View", myArgs, 1 );
	XtManageChild( cascade2 );

	logpb = XmCreatePushButtonGadget(pulldown2,/* Parent       */
                                "Logs",        /* Name         */
                                myArgs,        /* Widget Args  */
                                0 );           /* # Widget Args*/
	XtAddCallback( logpb, XmNactivateCallback, ViewLfile, NULL );
	hfilepb = XmCreatePushButtonGadget(pulldown2,/* Parent       */
                                "Configfile",        /* Name         */
                                myArgs,        /* Widget Args  */
                                0 );           /* # Widget Args*/
	XtAddCallback( hfilepb, XmNactivateCallback, ViewHfile, NULL );
	XtManageChild( logpb );
	XtManageChild( hfilepb );

	i=0;
        XtSetArg( myArgs[i], XmNwidth, 500); i++;
        XtSetArg( myArgs[i], XmNheight, 300 ); i++;

	text1 = XmCreateText( pane,	/* Parent 	*/
				"text1",	/* Name		*/
				myArgs,		/* Widget Args  */
				i );		/* # Widget Args*/
	XtManageChild( text1 );
	text2 = XmCreateText( pane,	/* Parent 	*/
				"text2",	/* Name		*/
				myArgs,		/* Widget Args  */
				i );		/* # Widget Args*/
	XtManageChild( text2 );
	
	/****************************
	 * Power on the Application *
	 ****************************/
	XtRealizeWidget( toplevel );	/* Bring up & manage toplevel widget */
	UpdateScreen();
	XtAddTimeOut( 20*1000, Refresh, NULL );
	XtMainLoop();			/* Main Event handler loop	*/

}

