#include <stdio.h>
#include <sys/types.h>
#include <arpa/nameser.h>
#include <netinet/in.h>
#include <resolv.h>

char answer[PACKETSZ];
extern int h_errno;

main(argc, argv)
int argc;
char *argv[];
{
#ifndef RES_NSSET
	fprintf(stderr, "You cannot use %s without using the UM resolver\n", argv[0]);
	exit(0);
#else
	int shh = 1;

	if (argc < 2 || argc > 3) {
		fprintf(stderr, "Usage:  %s [-v] nameserver-address\n", argv[0]);
		exit(5);
	}

	if (argc == 3)
		if (!(strcmp(argv[1], "-v"))) {
			shh--;
			argv[1] = argv[2];
		}
		else {
			fprintf(stderr, "Usage:  %s [-v] nameserver-address\n", argv[0]);
			exit(5);
		}
	/* set the nameserver */
	if ((_res.nsaddr_list[0].sin_addr.s_addr = inet_addr(argv[1])) == -1) {
		printf("[%s] is not a valid Internet address.\n", argv[1]);
		exit(5);
	}

	/* don't read /etc/resolv.conf in the resolver */
	_res.options |= RES_NSSET;

	/* do the query */
	if (res_query("umich.edu", C_IN, T_ANY, answer, PACKETSZ) < 0) {
		if (!shh)
			printf("Nameserver at %s is having problems\n", argv[1]);
		exit(7);
	}
	else {
		if (!shh)
			printf("Nameserver at %s is alive and well\n", argv[1]);
		exit(0);
	}
#endif
}
