/*
 *	Connect to random hosts and ports ...
 */
        
# include <stdio.h>
# include <signal.h>
# include <ctype.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <errno.h>
# include "connect.h"
# include <sys/param.h>
# include <malloc.h>

#ifndef lint
static char rcsid[] = "$Source: /u/paul/connectify/RCS/main.c,v $";
#endif

/*
 *	$Log:	main.c,v $
 * Revision 1.11  89/05/15  12:00:50  paul
 * malloc and fill in a hostent structure when internet address
 * is specified and the reverse query fails.
 * 
 * 
 * Revision 1.10  89/04/25  16:39:35  paul
 * handle case where reverse query fails better.  use 127 addr for 4.2 machines.
 * 
 * Revision 1.9  89/03/21  18:48:44  paul
 * if there is more than one a record for a host, try them all until
 * a success or they are used up.
 * 
 * Revision 1.8  89/03/21  18:15:11  paul
 * added herrno calls.  fixed stupid bug in dereferencing a pointer.
 * 
 * 
 * Revision 1.7  89/03/13  14:21:19  paul
 * added exit statuses in connect.h.  Changed verbose output a bit.
 * 
 * 
 * Revision 1.6  89/03/13  12:20:22  paul
 * added -s (service) as synonym for -p (port).  Added -v (verbose) flag.
 * Print verbose-toggled stuff on stdout, and error only on stderr.
 * 
 * Revision 1.5  89/03/11  13:27:07  paul
 * Use gethostbyaddr() to do a reverse lookup if a host is specified by
 * number.  Print unknown if query fails.
 * 
 * Revision 1.4  89/03/11  13:07:11  paul
 * Have usage print the program name as well.
 * 
 * Revision 1.3  89/03/10  15:44:35  paul
 * *really* added rcs header info.
 * 
 */

main(argc, argv)
	int argc;
	char * argv[];

{                                               
	extern herror();
	extern int h_errno;
	register struct hostent *hp;
	int s;
	struct sockaddr_in i;
	char *p = (char *)0, *h = (char *)0;
	char *default_port = "smtp";
#if BSD == 43
	char *default_host = "0.0.0.0";
#else
	char *default_host = "127.0.0.1";
#endif
	char *progname = argv[0];
	int verbose = 0;
	int status = 0;


	while (--argc > 0)
	{
		char *c = *++argv;

		if (*c == '-')
		{
			switch (*++c)
			{
				case 'p':	/* port */
				case 's':	/* service, whatever */
					p = *++argv;
					argc--;
					break;

				case 'h':	/* host */
					h = *++argv;
					argc--;
					break;

				case 'v':	/* be verbose */
					verbose++;
					break;

				default:
					fprintf(stderr, "unknown option:  %s\n", c);
					usage(progname);
					exit(USAGE);
			}
		}
		else
		{
			fprintf(stderr, "unknown option:  %s\n", c);
			usage(progname);
			exit(USAGE);
		}
			
	}

	/* Name or number? */
                        
	if (h == NULL)
		h = default_host;

	if (p == NULL)
		p = default_port;

	if (isdigit(*h))
	{
		i.sin_addr.s_addr = inet_addr(h);
		hp = gethostbyaddr((char *)&i.sin_addr.s_addr, 4, AF_INET);
		if (hp == NULL)
		{
			fprintf(stderr, "Warning:  Can't do reverse query on %s\n", h);
			if (errno)
				perror("gethostbyaddr");
			if (h_errno)
				herror("gethostbyaddr");
			/*
			 * stuff my own hostent together ...
			 */

			 hp = (struct hostent *)malloc(sizeof(*hp));
			 hp->h_name = malloc(strlen("unknown")+1);
			 strcpy(hp->h_name, "unknown");
			 hp->h_aliases = 0;
			 hp->h_addrtype = AF_INET;
			 hp->h_length = 4;
			 hp->h_addr_list = (char **)malloc(2*(sizeof(char **)));
			 hp->h_addr_list[0] = malloc(sizeof (char *));
			 *(int *)hp->h_addr_list[0] = inet_addr(h);
			 hp->h_addr_list[1] = 0;
		}
	}		
	else
	{
		hp = gethostbyname(h);

		if (hp == NULL)
		{
			fprintf(stderr, "%s: unknown host %s\n", progname, h);
			
			if (errno)
				perror("gethostbyname");
			if (h_errno)
				herror("gethostbyname");
			exit(HOST_NAME);
		}
	}
	i.sin_family = AF_INET;

	if (isdigit(*p))
		i.sin_port = atoi(p);
	else
	{
		/* assume tcp */
		register struct servent *sp = getservbyname(p, "tcp");
		if (sp == NULL)
		{
			fprintf(stderr, "%s: unknown service %s\n", progname, p);
			exit(BAD_SERVICE);
		}
		i.sin_port = sp->s_port;
	}
	

	/* try and connect */
	do
	{
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0)
	{
		perror("socket");
		exit(BAD_SOCKET);
	}

	if (hp != NULL)
		bcopy(*hp->h_addr_list, &i.sin_addr, hp->h_length);
	if (verbose)
		fprintf(stdout, "connecting to host %s (%s), port %d (%s)\n",
			inet_ntoa(i.sin_addr.s_addr), hp ? hp->h_name : "unknown", 
			 ntohl(i.sin_port), getservbyport(i.sin_port, "tcp")->s_name);

	if (connect(s, &i, sizeof (i)) < 0)
	{
		status = CONNECT_PROBLEM;
		perror("connect");
		close(s);
	}
	else
	{
		if (verbose)
			fprintf(stdout,"connect OK\n");
		close(s);
		break;
	}
	hp->h_addr_list++;
	}
        while (hp != NULL && hp->h_addr_list != NULL && *hp->h_addr_list != NULL);
	exit(status);
}


usage(name)
	char *name;
{
	fprintf(stderr, "usage -- %s: -p port -h host\n", name);
	return 0;
}
