/**********************************************************************
 * File: fileio.c        Problem file and hostfile reader / writer    *
 *  Version 1.0       Author: WB Norton  Merit Computer Network       *
 *  Modification History:                                             *
 *  written 5/18/89   Bill Norton, Merit Computer Network             *
 *  08/09/89 - Allow Spaces in parm lists for Appletalk parms   @wbn1 *
 *             We do this by substituting paren enclosed spaces       *
 *             with 0x01 - our white separator                        *
 **********************************************************************/
#include <stdio.h>
#include <string.h>
#include "../INCLUDE/defs.h"
#include "../INCLUDE/fileio.h"

static char delimiters[]=DELIMITERS;

/*********************************************************/
/*#define TESTING 1  /* For use in single module testing */
/*#define DEBUG 1	/*   */
/*********************************************************/
#ifdef TESTING
struct NodeType Node[MAXNODES];
struct ProblemType Problem[MAXPROBLEMS];
int NumProblems=0;
char Problem_File[]="../BIN/PROBLEM.FILE";
int NumNodes=0;
char hostfile[]="../BIN/hostfile";
main()
{
   printf("Starting hostfile read \n");
   NumNodes=ReadNodeFile(Node,hostfile);
   printf("There are %d net work nodes in file %s\n",NumNodes,hostfile);
   PrintNodes(NumNodes,Node);

   NumProblems=ReadProblemFile(Problem,Problem_File);
   PrintProblems(NumProblems,Problem);
   printf("There are %d problems in file %s\n",NumProblems,Problem_File);

   Problem[1].Name[0]='\0';
   WriteProblemFile(Problem,Problem_File,NumProblems);
   NumProblems=ReadProblemFile(Problem,Problem_File);
   printf("Now There are %d problems in file %s\n",NumProblems,Problem_File);
}
#endif

/*****************************************************************************
 * ReadProblemFile:  Read the Problems from file into our internal format.   *
 *****************************************************************************/
int ReadProblemFile(Problem,file) /* Read and Store hostfile - return # read */
struct ProblemType *Problem;   	  /* Network Entities Structure Array        */
char *file;               	  /* Filename to read these from             */
{
FILE *stream;
char buffer[100],*p;
BOOLEAN Error=FALSE;
int i,line;

   if ((stream=fopen(file,"r")) == NULL)
      syserr("fopen PROBLEM FILE");
   for(i=0,line=0;((fgets(buffer,100,stream)!= NULL)&&(i<MAXPROBLEMS));line++) {
      if (Error==TRUE) {
      /*   printf("Error in line %d of Problem File - IGNORED\n",line); */
      }
      Error=TRUE;       /* Assume a bad line */
      if (buffer[0]=='#') { Error=FALSE; continue; } /* COMMENT */

      if ( (p=strtok(buffer,delimiters)) == NULL ) continue;
      strncpy(Problem[i].Day,p,MAXDAY);   /* Pull off Problem Day */
      Problem[i].Day[MAXDAY-1]='\0';         /* Null Terminate!    */

      if ( (p=strtok(NULL,delimiters)) == NULL ) continue;
      strncpy(Problem[i].Time,p,MAXTIME);   /* Pull off Problem Time */
      Problem[i].Time[MAXTIME-1]='\0';         /* Null Terminate!    */

      if ( (p=strtok(NULL,delimiters)) == NULL ) continue;
      strncpy(Problem[i].Name,p,MAXNODENAME);      /* Pull off Node name */
      Problem[i].Name[MAXNODENAME-1]='\0';         /* Null Terminate!    */

      if ( (p=strtok(NULL,delimiters)) == NULL ) continue;
      strncpy(Problem[i].Addr,p,MAXADDRESS);       /* Pull off Node Address */
      Problem[i].Addr[MAXADDRESS-1]='\0';          /* Null Terminate! */

      if ( (p=strtok(NULL,delimiters)) == NULL ) continue;
      strncpy(Problem[i].NetProto,p,MAXPROTOENTRY); /* Pull off Node Address */
      Problem[i].NetProto[MAXPROTOENTRY-1]='\0';    /* Null Terminate! */

      Error=FALSE;                              /* Pull off NetMgmtProtocols */
      Problem[i].Status[0]='\0';
      while( (p=strtok(NULL,delimiters)) != NULL)  {
         strncat(Problem[i].Status,p,MAXSTATUS-strlen(Problem[i].Status));
         strncat(Problem[i].Status," ",MAXSTATUS-strlen(Problem[i].Status));
      }
      Problem[i].Status[MAXSTATUS-1]='\0';
      i++;              /** Yea! We have a valid line **/
   }
   fclose(stream);
   return(i);
}

/*****************************************************************************
 * WriteProblemFile:  Write our problems to disk.   			     *
 *****************************************************************************/
WriteProblemFile(Problem,Problem_File,NumProblems)
struct ProblemType *Problem;
char *Problem_File;
{
FILE *stream;
int i;


   if ((stream=fopen(Problem_File,"w"))==NULL) {
      perror("PROBLEM FILE NOT FOUND! Error.");
      exit(1);
   }
   else {
      for(i=0; i<3; i++) {
         if (!lock("PFILE.BUSY")) {
            printf("<File Busy..please wait>");
            sleep(5);
         }
         else break;
      }
      if (i==3) {printf("WriteProblemFile: Update Lock Failed!");return;} /* lock failed*/

      for(i=0; i<NumProblems; i++) {
         if (Problem[i].Name[0]!='\0')
            fprintf(stream,"%s %s %s %s %s %s\n",
                   Problem[i].Day,Problem[i].Time,Problem[i].Name,
                   Problem[i].Addr,Problem[i].NetProto,Problem[i].Status);
      }
      unlock("PFILE.BUSY");
   }
   fclose(stream);
}

/*****************************************************************************
 * ReadNodeFile:  Read the list of nodes we are responsible for.       @bev  *
 *****************************************************************************/
int ReadNodeFile(Node,file)  /* Read and Store hostfile - return # read */
struct NodeType *Node;	  /* Network Entities Structure Array */
char *file;		  /* Filename to read these from */
{
FILE *stream;
char buffer[MAXNODES][MAXLINE],*p,*parmsptr;
BOOLEAN Parm=FALSE,Error=FALSE;
int i,j,k,nest,line;
  
   if ((stream=fopen(file,"r")) == NULL)
      syserr("fopen monitoring configuration file");
   for(i=0,line=0; ((fgets(buffer[i],MAXLINE,stream) != NULL)&&(i<MAXNODES));line++) {
      if (Error==TRUE) { 
 	 printf("Error in line %d of hostfile - IGNORED\n",line);
      }
      Error=TRUE;	/* Assume a bad line */

      /* Pre parse the line and replace blanks WITHIN parens with 0x01 @wbn1 */
      /* This way our tokenizer will not think parms are individual tokens */
      for(j=0,nest=0; j<strlen(buffer[i]); j++)
         switch( buffer[i][j] ) {
         case '(': if (Parm==TRUE) { 
					nest++; 
				   } 
		   Parm=TRUE; break;
         case ')': if (nest) nest--; if (nest==0) Parm=FALSE; break;
         case ' ': if ( Parm == TRUE ) buffer[i][j]=0x01; break;
         default: break;
      }
#ifdef DEBUG
      printf("After parse, buffer[%d]=%s\n",i,buffer[i]);
#endif
      if (buffer[i][0]=='#') { Error=FALSE; continue; } /* COMMENT */

      if ( (p=strtok(buffer[i]," \t\n")) == NULL ) { Error=FALSE;  continue; }
      strncpy(Node[i].Name,p,MAXNODENAME); 	/* Pull off Node name */
      Node[i].Name[MAXNODENAME-1]='\0';    	/* Null Terminate!    */

      if ( (p=strtok(NULL," \t\n")) == NULL ) continue; 
      strncpy(Node[i].Addr,p,MAXADDRESS); 	/* Pull off Node Address */
      Node[i].Addr[MAXADDRESS-1]='\0';    	/* Null Terminate! */

      if ( (p=strtok(NULL," \t\n")) == NULL ) continue; 
      strncpy(Node[i].Help,p,MAXHELP); 		/* Pull off HelpFile name */
      Node[i].Help[MAXHELP-1]='\0';    		/* Null Terminate! */

      Error=FALSE;				/* Pull off NetMgmtProtocols */
      for(j=0; (j<MAXPROTOS-1)&&((p=strtok(NULL," \t\n")) != NULL); j++) {
         p[strlen(p)-1]='\0';   /* Kill ending paren */
#ifdef DEBUG
	 printf("Processing protocol %s\n",p);
#endif
         for( k=0; k<MAXPROTOPARMS; k++) Node[i].Protocols[j].parms[k]=NULL;
         Node[i].Protocols[j].parms[0]=p;
   	 parmsptr=p;
	 for(k=0; *parmsptr != '(' && *parmsptr != '\0'; parmsptr++);
	 *parmsptr++ = '\0';     
         k=1;
         Node[i].Protocols[j].parms[1]=parmsptr;
         for(; *parmsptr!='\0' ; parmsptr++) {
      	    if ( *parmsptr == 0x01 ) *parmsptr=' ';
            else if (*parmsptr==',') {
               *parmsptr='\0';
               Node[i].Protocols[j].parms[++k]=parmsptr+1;
            }
         }
         if (strlen(Node[i].Protocols[j].parms[k])==0) 
	    Node[i].Protocols[j].parms[k]=NULL;
      }
#ifdef DEBUG
         printf("For this node %s\n",Node[i].Name);
         for(j=0; j<MAXPROTOS && Node[i].Protocols[j].parms[0]!=NULL; j++)
             
         printf("***protocol=%s parms[1]=%s parms[2]=%s parms[3]=%s\n",
         Node[i].Protocols[j].parms[0],Node[i].Protocols[j].parms[1],
	 Node[i].Protocols[j].parms[2],Node[i].Protocols[j].parms[3]);
#endif

      i++;		/** Yea! We have a valid line **/
   }
   fclose(stream);
   return(i);
}
   
void PrintProblems(NumProblems,Problem)
int NumProblems;
struct ProblemType *Problem;
{
int i;

   for(i=0; i<NumProblems; i++) {
      printf("Day: %s Time:%s Node: %s [%s] Failed %s Test Status: %s \n",
           Problem[i].Day,Problem[i].Time,Problem[i].Name,Problem[i].Addr,Problem[i].NetProto,Problem[i].Status);
   }
}

void PrintNodes(NumNodes,Node)
int NumNodes;
struct NodeType *Node;
{
int i,j,k;

   for(i=0; i<NumNodes; i++) {
      printf("%s Node [%s] uses Help: %s & Protos \n",
           Node[i].Name,Node[i].Addr,Node[i].Help); 
      for(j=0; (( Node[i].Protocols[j].parms[0] != NULL ) 
	     && (j<MAXPROTOS)); j++) {
            printf(" %s(",Node[i].Protocols[j].parms[0]);
            for(k=1; (( Node[i].Protocols[j].parms[k] != NULL) 
                   && (k<MAXPROTOPARMS)) ; k++)
                printf("%s,",Node[i].Protocols[j].parms[k]);
           if (k!=1) printf("%c",8);
           printf(")");
      }
      printf("\n");
   }
}
