/********************************************************
 *   Here we are mapping out the hostfile fields.       *
 ********************************************************/
#define HOSTNAME        1       /* Hostname - */
#define HOSTIPADDR      2       /* Host's IP ADDRESS -we all key on this field*/
#define HELPFILE        3       /* Help file for user   */
#define NODEUPFIELD     4       /* What module determines if node is up? */
#define NETPROTOS       5       /* List of host network protocols that should */
                                /* be called in background pingky. */

#define MAXNODES        400     /* Maximum manageable nodes */
#define MAXPROBLEMS     MAXNODES /* Max 500 Problems */
#define MAXLINE         160     /* Maximum line 160 characters */ 

#define STATUSX 57      /* X location to go to update the status field */
                /* These defines describe how the screen will be mapped out */
/*************************** Problem File Defs ******************************/
#define MAXDAY 4
#define MAXTIME 6
/***************** Common Defs ******************/
#define MAXNODENAME 20
#define MAXADDRESS 17
#define MAXPROTONAME   10	/* Max space protocol NAME that failed */
#define MAXPROTOPARMS 10 /* Max space for Net Protocol parms */
#define MAXPROTOENTRY (MAXPROTONAME+MAXPROTOPARMS+2)

#define MAXHELP 100	/* Max path name for help file */
#define MAXPROTOS 10     /* Max of 10 NetMgmt protocols for each node */
#define MAXSTATUS 80-STATUSX

#define DELIMITERS " \t\n"

/**************************************************
 * Node Table and Problem Table Field Definitions *
 *------------------------------------------------*/
struct NetProtoType {
char *parms[MAXPROTOPARMS];
};

struct NodeType {
char Name[MAXNODENAME];
char Addr[MAXADDRESS];
char Help[MAXHELP];
struct NetProtoType Protocols[MAXPROTOS];
} ;

 struct ProblemType {
char Day[MAXDAY];
char Time[MAXTIME];
char Name[MAXNODENAME];
char Addr[MAXADDRESS];
char NetProto[MAXPROTOENTRY];
char Status[MAXSTATUS];
} ;

/********************* Forward Declarations *******************************/
int ReadProblemFile();	/* read Problems into ProblemType Array from File */
int WriteProblemFile(); /* write Problems into Problem File               */
int ReadNodeFile();     /* Read node file into nodetype array from file   */
void PrintProblems();   /*                     Debug                      */
void PrintNodes();      /*                     Debug                      */
