/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       PROTO.H
**     SYSTEM   NAME:       Sage
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       
**
** DESCRIPTION: internal include file for the MIB library
**		needed only when building the lib.
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
/* internal MIB api */
/* mib.c */
void MibInitialise __((void));
int MibNameHash __((char *name));
void MibAddHash __((char *name, MIBNODE *ptr));
MIBNODE *MibResolveHash __((char *name));
MIBNODE *MibFindChild __((MIBNODE *fPtr, int index));
MIBNODE *MibFindNode __((char *name));
int MibAddNode __((MIBNODE *node, MIBNODE *fnode));
int MibFillID __((MIBNODE *node, int *id));
MIBNODE *MibFindID __((int *id, int nr));
MIBNODE *MibFindID2 __((int *id, int nr, int *nrmatched));
void MibDumpTree __((MIBNODE *first));
void MibDumpHash __((void));
/* parse.c */
MIBNODE *MibCreateNode __((char *name, char *position));
MIBNODE *MibScanLine __((char *line));
int MibFindChunks __((char *line, char **chunks, int *clens));
int MibDecodeType __((char *type));
int MibDecodeMode __((char *mode));
int MibDecodeStatus __((char *status));
/* mibapi.c */
int MibInit __((void));
int MibFullMib __((void));
int MibReadMib __((FILE *fp));
int MibName2ID __((int *id, char *name));
char *MibID2Name __((int *id, int nr));
char *MibID2Name2 __((int *id, int nr, int *nrmatched));
int MibIDType __((int *id, int nr));
int MibIDMode __((int *id, int nr));
int MibIDStatus __((int *id, int nr));
int MibNameType __((char *name));
int MibNameMode __((char *name));
int MibNameStatus __((char *name));
char *MibGetFirstChild __((char *name));
char *MibGetNextChild __((char *name));
