.TH Tricklet 1 local
.SH NAME
snmp-getnext \- SNMP-getnext command
.SH SYNOPSIS
.B snmp-getnext <host>
[
.B <community> <timeout> <retries> <port> 
] file
.SH DESCRIPTION
.I snmp-getnext
send snmp GETNEXT requests to the snmp agent on the specified host.
snmp-getnext reads line from stdin and interprets each line as a group of
snmp GETNEXT requests seperated by semicolons. Such a group is send as one
SNMP message to the host. Seperate lines are send as
seperate snmp messages. Output of snmp-get is send to stdout.
.br
The format of the input to snmp-get is the same as the output
generated by snmp-get.

for a full description of the format see the man page of snmp-get.

.SH DEFAULTS

community == "public"
.br
timeout == 5 secs
.br
retries == 3
.br
port == 161


.SH EXAMPLES
The following example retrieves the mib variable 'sysDescr' 
(system description) from the snmp agent on host dnpap.et.tuddelft.nl:
.br

\<-- echo "sysDescr" | snmp-getnext dnpap.et.tudelft.nl
.br
--\> sysObjectID[0]=1.3.6.1.4.1.42.2.1.1
.br

The next example shows that the output of one command can be used as
input for a next command:
.br

\<-- echo "sysDescr" | snmp-get dnpap | snmp-getnext dnpap
.br
--\> sysObjectID[0]=1.3.6.1.4.1.42.2.1.1
.br

.SH FILES
$(MIBHOME)/mibs		list of MOSY MIB definition files
$(MIBHOME)/*.defs	     MOSY MIB definitions files
.br
$(BIN)/snmp-getnext		executable
.SH SEE ALSO
.IR snmp-get(l)
.IR snmp-set(l)
.IR snmp-table(l)
.br
