#include <stdlib.h>
#include <stdio.h>
#include <dnpap.h>
#include <snmp.h>
#include <mib.h>
#include "parse.h"



int GetList(char *line, pkt_obj *list, int listSize, int *listLength) 
{
	int i=0,r=0,n=0;
	char *name;
	pkt_obj *object;

	if((r=GetObject(line+i,list+n))<0)
		return -1;
	i+=r;
	n++;
	while(line[i]==' ' || line[i]=='\t')
		i++;
	while(line[i]==';')
	{
		if (n>=listSize)
			return -1;
		i++;
		if((r=GetObject(line+i,list+n))<0)
			return -1;
		i+=r;
		n++;
		while(line[i]==' ' || line[i]=='\t')
			i++;
	}
	if(line[i]=='.' && line[i+1]=='.' && line[i+2]=='.')
	{
		i+=3;
		object=list+n-1;
		name=MibID2Name2((int *) object->ObjOji,object->ObjOjiLen,&r);
		while((name=MibGetNextChild(name))!=NULL &&
n<PKT_SZERORLST )
		{
			memcpy(list+n,object,sizeof(*object));
			MibName2ID((int *) list[n].ObjOji,name);	
			n++;
		}
	}
	*listLength=n;
	return i;
}	

int GetObject(char *line, pkt_obj *object)
{
	int i=0,r=0,n=0;
	char name[80];

	while(line[i]==' ' || line[i]=='\t')
		i++;
	if((r=GetName(line+i,name,sizeof(name)))<0)
		return -1;
	object->ObjOjiLen=MibName2ID((int *) object->ObjOji, name);
	if ( object->ObjOjiLen<0)
		return -1;
	i+=r;
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if (line[i]=='[')
	{
		if((r=GetIndex(line+i,(int *) object->ObjOji+object->ObjOjiLen,
			PKT_SZEOJI-object->ObjOjiLen,&n))<0)
			return -1;
		object->ObjOjiLen+=n;
		i+=r;
	}
	else
	{
		object->ObjOji[object->ObjOjiLen]=0;
		object->ObjOjiLen++;
	}
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if (line[i]=='=')
	{
		i++;	
		object->ObjTag=MibNameType(name);
		if((r=GetValue(line+i,object))<0)
			return -1;
		i+=r;
	}
	else
	{
		object->ObjTag=PKT_NULL;
		object->ObjSyn.SynLngUns=0L;
	}
	return i;
}

int GetName(char *line, char *name, int nameSize)
{
	int i=0,r=0,n=0;
	
	while(line[i]==' ' || line[i]=='\t')
		i++;
	while(isalnum(line[i]) || line[i] == '.' || line[i] == '-')
	{
		name[n++]=line[i++];
	}
	name[n]=0;
	return i;
}

int GetValue(char *line, pkt_obj *object)
{
	int i=0,r=0,n=0,u;
	char c;

	while(line[i]==' ' || line[i]=='\t')
		i++;
	switch(object->ObjTag)
	{
		case PKT_NULL:
			break;
		case PKT_INTEGER:
			sscanf(line+i,"%ld%n",&object->ObjSyn.SynLngInt,&r);
			i+=r;
			break;
		case PKT_OCTETSTRING:
			if (line[i]=='"')
			{
				i++;
				while(line[i]!='"' && line[i]!='\0')
				{
					object->ObjSyn.SynBufChr[n++]=line[i++];
				}
				if (line[i]=='"')
					i++;
				object->ObjSynLen=n;
			}
			else
			{
				if (sscanf(line+i, "%x%n", &u, &r) != 1)
					return (-1);
				object->ObjSyn.SynBufChr[n++]=u;
				i += r;
				while (sscanf(line+i, "%1[.:-]%x%n",&c, &u, &r) == 1)
				{
					object->ObjSyn.SynBufChr[n++]=u;
					i += r;
				}
				object->ObjSynLen=n;
			}
			break;
		case PKT_OBJECTIDENTIFIER:
			if (sscanf(line+i, "%u%n", &u, &r) != 1)
                		return (-1);
			object->ObjSyn.SynBufInt[n++]=u;
			i += r;
            		while (sscanf(line+i, ".%u%n", &u, &r) == 1)
            		{
				object->ObjSyn.SynBufInt[n++]=u;
				i += r;
            		}
			object->ObjSynLen=n;
			break;
		case PKT_IPADDRESS:
			if (sscanf(line+i, "%u%n", &u, &r) != 1)
                		return (-1);
			object->ObjSyn.SynBufChr[n++]=u;
			i += r;
            		while (sscanf(line+i, ".%u%n", &u, &r) == 1)
            		{
				object->ObjSyn.SynBufChr[n++]=u;
				i += r;
            		}
			object->ObjSynLen=n;
			break;
		case PKT_COUNTER:
        	case PKT_GAUGE:
        	case PKT_TIMETICKS:
            		sscanf (line+i, "%lu%n", &object->ObjSyn.SynLngUns,&r);
			i +=r;
            		break;
		case PKT_OPAQUE:
            		break;
	}	
	return i;
}

	


int GetIndex(char *line, int *index, int indexSize, int *indexLength)
{	
	int i=0,r=0,n=0,u;

	if(line[i]!='[')
		return -1;
	i++;
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if(line[i]==']')
	{	
		i++;
		*indexLength=0;
		return i;
	}
 	if (sscanf(line+i, "%u%n", &u, &r) != 1)
		return (-1);
	i+=r;
	index[n++]=u;
	while(line[i]=='.' || line[i]==',')
	{
		i++;
	 	if (sscanf(line+i, "%u%n", &u, &r) != 1)
			return (-1);
		i+=r;
		index[n++]=u;
		while(line[i]==' ' || line[i]=='\t')
			i++;
	}
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if(line[i]!=']')
		return -1;
	i++;
	*indexLength=n;
	return i;
}
		
int PutList(pkt_obj *list, int listLength, char *line, int lineSize)
{
	int i=0,r=0,n=0;

	if((r=PutObject(list+n,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	for(n=1;n<listLength;n++)
	{
		line[i]=';';
		i++;
		line[i]=' ';
		i++;
		if((r=PutObject(list+n,line+i,lineSize-i))<0)
			return -1;
		i+=r;
	}
	line[i]='\0';
	i++;
	return i;
}

int PutObject(pkt_obj *object, char *line, int lineSize)
{
	int i=0,r=0,n=0;
	char *name;

	name=MibID2Name2((int *) object->ObjOji,object->ObjOjiLen,&n);
	if((r=PutName(name,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	if((r=PutIndex((int *) object->ObjOji+n,object->ObjOjiLen-n,line+i,lineSize-i))<0)
		return -1;
	i+=r; 
	line[i]='=';
	i++;
	if((r=PutValue(object,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	return i;
}

int PutIdentifier(pkt_obj *object, char *line, int lineSize)
{
	int i=0,r=0,n=0;
	char *name;

	name=MibID2Name2((int *) object->ObjOji,object->ObjOjiLen,&n);
	if((r=PutName(name,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	if((r=PutIndex((int *) object->ObjOji+n,object->ObjOjiLen-n,line+i,lineSize-i))<0)
		return -1;
	i+=r; 
	return i;
}



int PutName(char *name, char *line, int lineSize)
{
	int i=0;

	strcpy(line+i,name);
	i=strlen(name);
	return i;
}

int PutValue(pkt_obj *object, char *line, int lineSize)
{
	int i=0,r=0,n=0,u;
	char *s;

	switch(object->ObjTag)
	{
		case PKT_NULL:   
			sprintf(line+i,"NULL");
			i+=4;
		case PKT_INTEGER:
			sprintf(line+i,"%ld%n",object->ObjSyn.SynLngInt,&r);
			i+=r;
			break;
		case PKT_OCTETSTRING:
			if (IsVisible((unsigned char *) object->ObjSyn.SynBufChr,object->ObjSynLen))
			{
				object->ObjSyn.SynBufChr[object->ObjSynLen]='\0';
				line[i]='"';
				i++;
				strcpy(line+i,object->ObjSyn.SynBufChr);
				i+=object->ObjSynLen;
				line[i]='"';
				i++;
			}
			else
			{		
				u=(unsigned char)object->ObjSyn.SynBufChr[0];
				if(sprintf(line+i, "%02x%n", u, &r) == NULL)
					return (-1);
				i+=r;
				for(n=1;n<object->ObjSynLen;n++)
				{
					u=(unsigned char)object->ObjSyn.SynBufChr[n];
					if (sprintf(line+i, ":%02x%n", u, &r) == NULL)
						return (-1);
					i+=r;
				}
			}
			break;
		case PKT_OBJECTIDENTIFIER:
			u=object->ObjSyn.SynBufInt[0];
			if(sprintf(line+i, "%u%n", u, &r) == NULL)
                		return (-1);
			i+=r;
			for(n=1;n<object->ObjSynLen;n++)
			{
				u=object->ObjSyn.SynBufInt[n];
				if (sprintf(line+i, ".%u%n", u, &r) == NULL)
                			return (-1);
				i+=r;
			}
			break;
		case PKT_IPADDRESS:
			u=(unsigned char)object->ObjSyn.SynBufChr[0];
			if (sprintf(line+i, "%u%n", u, &r) == NULL)
                		return (-1);
			i+=r;
			for(n=1;n<4;n++)
			{
				u=(unsigned char)object->ObjSyn.SynBufChr[n];
				if (sprintf(line+i, ".%u%n", u, &r) == NULL)
                			return (-1);
				i+=r;
			}
			break;
		case PKT_COUNTER:
        	case PKT_GAUGE:
        	case PKT_TIMETICKS:
            		sprintf (line+i, "%lu%n", object->ObjSyn.SynLngUns,&r);
			i +=r;
            		break;
		case PKT_OPAQUE:
            		break;
	}	
	return i;
}
       
		
		
int PutIndex(int *index, int indexLength, char *line, int lineSize)
{	
	int i=0,r=0,n=0,u;
	
	line[i]='[';
	i++;
	if(indexLength==0)
	{
		line[i]=']';
		i++;
		return i;
	}
	u=index[0];
	if(sprintf(line+i, "%u%n", u, &r) == NULL)
		return (-1);
	i+=r;
	for(n=1;n<indexLength;n++)
	{
		u=index[n];
		if (sprintf(line+i, ".%u%n", u, &r) == NULL)
			return (-1);
		i+=r;
	}
	line[i]=']';
	i++;
	return i;
}

int IsVisible(unsigned char *s, int n)
{
	unsigned char c;

	while(n-->0)
	{
		c=*s++;
		if(c>126 || (c<32 && c!=10 && c!=13) )
			return 0;
	}
	return 1;
}
