/*
 * snmpstatus.c - send snmp GET requests to a network entity.
 *
 */
/***********************************************************
	Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>

#include "snmp.h"
#include "snmp_impl.h"
#include "asn1.h"
#include "snmp_client.h"
#include "snmp_api.h"
#include "mib.h"

#include "data.h"

#define SERVER
#ifndef SERVER
#include <curses.h>
#endif SERVER
#define COL_HEIGHT 20
#define COL_LENGTH 30
#define INIT_STR "#Init\n"
#define RESET_STR "#Reset\n"

struct timeval timeout = {10,10};
int sock;

int	snmp_dump_packet = 0;

oid	objid_sysDescr[] = {1, 3, 6, 1, 2, 1, 1, 1, 0};
int	length_sysDescr = sizeof(objid_sysDescr)/sizeof(oid);
oid	objid_sysUpTime[] = {1, 3, 6, 1, 2, 1, 1, 3, 0};
int	length_sysUpTime = sizeof(objid_sysUpTime)/sizeof(oid);
oid	objid_ifAdminStatus[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 7};
int	length_ifAdminStatus = sizeof(objid_ifAdminStatus)/sizeof(oid);
oid	objid_ifOperStatus[] = {1, 3, 6, 1, 2, 1, 2, 2, 1, 8};
int	length_ifOperStatus = sizeof(objid_ifOperStatus)/sizeof(oid);

int	debug = 0;

extern struct node *getnode();

main(argc, argv)
    int	    argc;
    char    *argv[];
{
    struct snmp_session session, *ss;
    struct snmp_pdu *pdu, *response;
    struct variable_list *vars;
    int	arg;
    char *setup_name = NULL;
    char    name[256];
    char    buf[64];
    int	    good_var, index;
    int	    status, count;
    int	    sleep_time = 20;
    u_long  admin_down_interfaces = 0;
    u_long  oper_down_interfaces = 0;
    u_long  really_down_interfaces;
    u_long  uptime = 0;
    time_t  timestamp;
    struct stat stat_buffer;
    struct node *nodelist, *current_node;
    extern struct node *readsetup();

    int len,  new_sock, line_no;
    fd_set r_flag, w_flag, x_flag;
    char buffer[128];
    struct sockaddr_in sock_addr;

    /*
     * usage: snmpstatus setup_file
     */
    for(arg = 1; arg < argc; arg++){
	if (argv[arg][0] == '-'){
	    switch(argv[arg][1]){
		case 'd':
		    debug++;
		    if (debug > 5)
			snmp_dump_packet++;
		    break;
		default:
		    printf("invalid option: -%c\n", argv[arg][1]);
		    break;
	    }
	    continue;
	}
	if (setup_name == NULL){
	    setup_name = argv[arg];
	} else {
	    printf("usage: snmpstatus setup-file \n");
	    exit(1);
	}
    }
    if (!(setup_name)){
	printf("usage: snmpstatus setup-file \n");
	exit(1);
    }

    nodelist = readsetup(setup_name);
    if (stat(setup_name, &stat_buffer) != 0) {
	perror("snmpstatus: stat");
	exit(1);
    }
    timestamp = stat_buffer.st_mtime;
    
    sock = Inet_register();

    for (;;) {

       if (debug)
	fprintf (stderr, "Going into select\n");
       FD_ZERO (&r_flag);
       FD_ZERO (&x_flag);
       FD_ZERO (&w_flag);
       FD_SET  (sock, &r_flag);
       select (getdtablesize(), &r_flag, &w_flag, &x_flag, &timeout);
       if (FD_ISSET(sock, &r_flag)) {
	if (debug)
	 fprintf (stderr, "Going into accept\n");
          len = sizeof(sock_addr);
          new_sock=accept(sock, sock_addr , &len);
	  if (debug)
           fprintf (stderr, "Getting outof accept\n");
          if (new_sock == -1) 
             {perror ("Error in accept");}
          else {
	    if (debug)
               fprintf (stderr, "New socket: %d\n", new_sock);
            init_screen (new_sock);
          }
       }


	/* stat the file ... it might be a good idea to keep it open */
        if (stat(setup_name, &stat_buffer) != 0) {
	    perror("snmpstatus: stat");
	    exit(1);
        }
	/* and reread if changed */
        if (timestamp != stat_buffer.st_mtime) {
	    /* reread the setup file */
	    freenode(nodelist);
            nodelist = readsetup(setup_name);
    	    timestamp = stat_buffer.st_mtime;
            restart();
        }
            

        current_node = nodelist;
        line_no = -1;
	while (current_node != NULL) {
            line_no ++;
	    admin_down_interfaces = 0;
	    oper_down_interfaces = 0;
	    bzero((char *)&session, sizeof(struct snmp_session));
	    session.peername = current_node->ipaddress;
	    session.community = (u_char *)current_node->community;
	    session.community_len = strlen(session.community);
	    session.retries = 4;
	    session.timeout = 10000 * current_node->timeout;
	    session.authenticator = NULL;
	    snmp_synch_setup(&session);
	    ss = snmp_open(&session);
	    if (ss == NULL){
	        fprintf(stderr,"Couldn't open snmp\n");
		exit(-1);
	    }

	    strcpy(name, "No System Description Available");
	    pdu = snmp_pdu_create(GET_REQ_MSG);

	    snmp_add_null_var(pdu, objid_sysDescr, length_sysDescr);
	    snmp_add_null_var(pdu, objid_sysUpTime, length_sysUpTime);

retry:
	    status = snmp_synch_response(ss, pdu, &response);
	    if (status == STAT_SUCCESS){
	        if (response->errstat == SNMP_ERR_NOERROR){
	            for(vars = response->variables; vars; 
			vars = vars->next_variable)
		      {
		        if (vars->name_length == length_sysDescr &&
			    !bcmp((char *)objid_sysDescr, 
			    (char*)vars->name, sizeof(objid_sysDescr)))
			  {
			    bcopy((char *)vars->val.string, name, 
				  vars->val_len);
			    name[vars->val_len] = '\0';
			  }
			if (vars->name_length == length_sysUpTime &&
			    !bcmp((char *)objid_sysUpTime, 
				  (char*)vars->name, sizeof(objid_sysUpTime)))
			  {
			    uptime = *vars->val.integer;
			  }
		      }
		  } else {
		    printf("Error in packet.\nReason: %s\n", 
			   snmp_errstring(response->errstat));
		    if (response->errstat == SNMP_ERR_NOSUCHNAME){
		      printf("This name doesn't exist: ");
		      for(count = 1, vars = response->variables; 
			  vars && count != response->errindex;
			  vars = vars->next_variable, count++)
			;
		      if (vars)
			print_objid(vars->name, vars->name_length);
		      printf("\n");
		    }
		    if ((pdu = snmp_fix_pdu(response, GET_REQ_MSG)) != NULL)
		      goto retry;
		  }

	      } else {
		if (status == STAT_TIMEOUT)
                   curses_write (line_no, TRUE, 
                        sprintf (buffer, "No Response from %s", 
                           current_node->name));
	      	else     /* status == STAT_ERROR */
			curses_write (line_no, TRUE, "An error occurred");
		current_node = current_node->next;
/*	    	if (response) {
	     	   snmp_free_pdu(response);
*/		   response = NULL;
/*		} */
	    	snmp_close(ss);  
		continue;
	      }

	    if (response) {
	      snmp_free_pdu(response);
	      response = NULL;
	    }
	    pdu = snmp_pdu_create(GETNEXT_REQ_MSG);

	    snmp_add_null_var(pdu, objid_ifOperStatus, length_ifOperStatus);

	    good_var = 1;
	    while(good_var == 1){
	      good_var = 0;
	      status = snmp_synch_response(ss, pdu, &response);
	      if (status == STAT_SUCCESS){
		if (response->errstat == SNMP_ERR_NOERROR){
		  pdu = snmp_pdu_create(GETNEXT_REQ_MSG);

		  index = 0;
		  for(vars = response->variables; vars; 
		      vars = vars->next_variable){
		    if (index == 0 && vars->name_length >= length_ifOperStatus
			&& !bcmp((char *)objid_ifOperStatus, 
				 (char *)vars->name,
				 sizeof(objid_ifOperStatus)))
		      {
			if (*vars->val.integer != MIB_IFSTATUS_UP)
			  oper_down_interfaces++;
			snmp_add_null_var(pdu, vars->name, vars->name_length);
			good_var++;
		      }
		    index++;
		  }
		} else {
		  printf("Error in packet.\nReason: %s\n", 
			 snmp_errstring(response->errstat));
		  if (response->errstat == SNMP_ERR_NOSUCHNAME){
		    printf("This name doesn't exist: ");
		    for(count = 1, vars = response->variables; 
			vars && count != response->errindex;
			vars = vars->next_variable, count++)
			    ;
		    if (vars)
			print_objid(vars->name, vars->name_length);
		    printf("\n");
		  }
		}

	      } else {
		if (status == STAT_TIMEOUT)
		    curses_write (line_no, TRUE, sprintf 
                        ( buffer, "No Response from %s", current_node->name));
	      	else     /* status == STAT_ERROR */
			curses_write (line_no, TRUE,"An error occurred");
		current_node = current_node->next;
/*	    	if (response) {
	     	   snmp_free_pdu(response);a  */
		   response = NULL;
/*		} */
	    	snmp_close(ss);  
		continue;
	      }

	      if (status == STAT_SUCCESS)
	      	if (response) {
			snmp_free_pdu(response);
			response = NULL;
	      	}
	    }

	    if (status != STAT_SUCCESS)
		continue;

	    really_down_interfaces = oper_down_interfaces -
				     current_node->ifdown;
	    curses_write (line_no, really_down_interfaces,
                 sprintf (buffer, "%8s %10s %2d", current_node->name,
                   uptime_string(uptime, buf),
                   really_down_interfaces));
 
	    snmp_close(ss);  
	    current_node = current_node->next;
	  }
          refresh();
          /*select (getdtablesize(), -1, 0, -1, &timeout);*/
	  /*sleep(sleep_time);*/
      }

}

#ifdef SERVER
struct sockaddr_in sock_addr;

curses_write (line_no, invert, str)
int line_no, invert;
char * str;
{
char l_buf[512];
    if (debug)
      printf ("Curses_write: invert=%d, str=[%s]\n", invert, str);
    sprintf (l_buf, "%4d  %s\n", invert, str);
    write_sockets (l_buf);
}

refresh()
{
    write_sockets (RESET_STR);
}

restart()
{
    write_sockets("#Changed\n");
}

write_sockets(str)
char * str;
{
int i,j;
/*fprintf (stderr, "Write_sockets: <%s>\n", str);*/
    /*strcat (str, "\n");*/
    for (i=(sock+1); i<getdtablesize(); i++) {
       j=sizeof(sock_addr);
       if (getpeername (i, &sock_addr, &j) == 0)  {
/*fprintf (stderr, "Going to write on socket %d\n", i);*/
          if (write(i, str, strlen(str)) != strlen(str)) {
/*          if (send (i, str, strlen(str), 0) != strlen(str)) { */
                  perror ("cannot write on socket");
                  close (i);
           }
       } else {
	  close(i);
       }
    }

}


init_screen (i)
int i;
{
   if (debug)
    fprintf (stderr, "Init_scr %d\n", i);
   if (write (i, INIT_STR, strlen(INIT_STR)) != strlen (INIT_STR)) {
    perror ("Error in init_scr");
    close (i);
  }
}

#else
curses_write (line_no, invert, str)
int line_no, invert;
char * str;
{
      if (invert) standout();
      move ((line_no % COL_HEIGHT), (COL_LENGTH * (line_no / COL_HEIGHT)));
      addstr (str);
      if (invert) standend();

}
#endif SERVER
