
#include <sys/types.h>
#include <string.h>
#include <stdio.h>

#include "data.h"

extern char *malloc();

/* allocates a node structure and fill it with info from the setup
   file, returns NULL if the setup is used up */
struct node *getnode(file)
FILE *file;
{
    struct node *tmpnode;
    char buffer[BUFSIZ];
    int len;
    int eol;
    int got_a_line = 0;
    char *cur_tok;

    while (!got_a_line) {
        fgets(buffer, BUFSIZ, file);
	len = strlen(buffer);

	eol = (len == 0) || (buffer[len-1] == '\n');

	/* check for comment */
	if (buffer[0] != '#') {
	    /* allocate node */
	    if ((tmpnode=(struct node *)malloc(sizeof(struct node))) == NULL) {
	        perror("snmpstatus: node malloc");
                exit(1);
	    }
	    /* parse the string */
	    /* */
	    if ((cur_tok = strtok(buffer, " \t\n")) == NULL) {
	        fprintf(stderr,"snmpstatus: setup file, missing node\n");
		exit(2);
	    }
	    if ((tmpnode->name = malloc(strlen(cur_tok)+1)) == NULL) { 
	        perror("snmpstatus: name malloc");
		exit(1);
	    }
	    strcpy(tmpnode->name, cur_tok);
	    /* */
	    if ((cur_tok = strtok(NULL, " \t\n")) == NULL) {
	        fprintf(stderr,"snmpstatus: setup, missing address for %s\n",
			tmpnode->name);
		exit(2);
	    }
	    if ((tmpnode->ipaddress = malloc(strlen(cur_tok)+1)) == NULL) { 
	        perror("snmpstatus: ipaddress malloc");
		exit(1);
	    }
	    strcpy(tmpnode->ipaddress, cur_tok);
	    /* */
	    if ((cur_tok = strtok(NULL, " \t\n")) == NULL) {
	        fprintf(stderr,"snmpstatus: setup, missing community for %s\n",
			tmpnode->name);
		exit(2);
	    }
	    if ((tmpnode->community = malloc(strlen(cur_tok)+1)) == NULL) { 
	        perror("snmpstatus: community malloc");
		exit(1);
	    }
	    strcpy(tmpnode->community, cur_tok);
	    /* */
	    if ((cur_tok = strtok(NULL, " \t\n")) == NULL) {
	        fprintf(stderr,"snmpstatus: setup, missing timeout for %s\n",
			tmpnode->name);
		exit(2);
	    }
	    tmpnode->timeout = atoi(cur_tok);
	    /* */
	    if ((cur_tok = strtok(NULL, " \t\n")) == NULL) {
	        fprintf(stderr,"snmpstatus: setup, missing ifdown for %s\n",
			tmpnode->name);
		exit(2);
	    }
	    tmpnode->ifdown = atoi(cur_tok);
	    /* initialize the rest of the fields */
	    tmpnode->sysdes = NULL;
	    tmpnode->uptime = 0;
	    tmpnode->iflist = NULL;
	    tmpnode->next = NULL;

	    /* ok we've got something now */
	    got_a_line = 1;
	}

	/* discard rest of line */
	while (!feof(file) && !eol) {
	    fgets(buffer, BUFSIZ, file);
	    len = strlen(buffer);
	    eol = (len == 0) || (buffer[len-1] == '\n');
	}
    
	if (feof(file))
	    return NULL;
	
    }
    return tmpnode;
}

/* free a node and anything that is still connected to it */
freenode(node_ptr)
struct node *node_ptr;
{
	if (node_ptr->next != NULL) {
		freenode(node_ptr->next);
		/* freee the interface list here ! */
		node_ptr->next = NULL;
	}
	free(node_ptr);
}


struct node *readsetup(setup_name)
char *setup_name;
{   

    struct node *nodelist, *current_node;
    FILE *setup_file;

    /* Read in the setup file allocating the node structures as neccessary */
    if ((setup_file = fopen(setup_name, "r")) ==  NULL) {
        perror("snmpstatus: setup-file");
	exit(1);
    }

    if (!feof(setup_file)) {
        nodelist = getnode(setup_file);
	current_node = nodelist;
        while (!feof(setup_file)) {
	    current_node->next = getnode(setup_file);
	    current_node = current_node->next;
        }
    }
    fclose(setup_file);
    return nodelist;
}
