#include <curses.h>
#include <stdio.h>
#include <signal.h>

#include "defs.h"

#define COL_HEIGHT LINES
#define COL_LENGTH 30

#define COL(i) (COL_LENGTH * (i / (COL_HEIGHT-1)))
#define ROW(i) (i % (COL_HEIGHT-1))


#define N_LINES 64
#define TRUE (1)
#define FALSE (0)

extern int highlight [N_LINES];
extern char lines [N_LINES][64];
extern int  n_lines;

extern int close_connection();

void *winsize();
void chgsize();
void *cleanup();

int restart = 0;
int i;
char buffer [128];
int debug = 0;

main () {

   int ring = 0;
   int result;
   int len, j;

   connect_server ();
   signal(SIGWINCH, winsize);
   signal(SIGTERM, cleanup);
   signal(SIGKILL, cleanup);
   initscr();
   for (;;) {
      if ((result = read_data(TRUE)) != OK) {
	if (result == E_NODATA) {
         standout();
         move (COL_HEIGHT, 1);
         addstr ("Server not responding!!\");
         standend();
         refresh();
	}
	if (result == RESTART) {
	 clear();
	}
	continue;
      }
      if (restart) 
	chgsize();
      for (i =0; i< n_lines; i++) {
         if (highlight[i]) {
		standout();
		ring = 1;
	 }
         move (ROW(i), COL(i));
         addstr (lines[i]);
         if (highlight[i]) standend();
	 if ((len = strlen(lines[i])) < (COL_LENGTH-5))
		for (j=0;j<(COL_LENGTH-len-5);j++)
			addch(' ');
      }
      refresh();
      if (ring) {
	write(0,"\007\007\007",3);
	ring = 0;
      }
   }
   /* NOT REACHED */
}

void chgsize()
{
	if (debug)
	   fprintf(stderr,"Changing window size\n");
	LINES = 0;
	COLS = 0;
	initscr();
	restart = 0;
}

void *winsize()
{
   if (debug)
     fprintf(stderr,"Got WINCH signal\n");
   restart = 1;
}

void *cleanup()
{
	close_connection();
	endwin();
}
