;
; Get the load of a Beholders device
;
; Sage should be called with two arguments:
;
; Sage <beholder> <device-nr>
;
(macro (sageload str)
  (if (load str) 
      #t
      (load (string-append (getenv "SAGEPATH") str))))
(sageload "util.s")
(sageload "sage.s")
(sageload "walk.s")
(sageload "display.s")
;
; Function to retrieve the load data of a beholder-connection
;
(define (beholder-load con device )
  (define time-var 
    (list->dotted (append '(1 3 6 1 4 1 99 2 1 1 2) (list device))))
  (define pkts     
    (list->dotted (append '(1 3 6 1 4 1 99 2 1 1 6) (list device))))
  (define bytes    
    (list->dotted (append '(1 3 6 1 4 1 99 2 1 1 7) (list device))))
  (define ans
     (snmp-get 
       con
       "public" 
	5000000 
	10 
	(list 
	  (list time-var 0 0)
	  (list pkts 0 0)
	  (list bytes 0 0))))
  (list
   (list-ref (list-ref ans 0) 2)
   (list-ref (list-ref ans 1) 2)
   (list-ref (list-ref ans 2) 2)))
;
; display the load of this period
;
(define  (display-load time dpkts dbytes)
  (define tps (/ time 100.0))
  (define bps (/ dbytes tps))
  (define pps (/ dpkts tps))
  (define tld (floor (+ 0.5 (/ (+ (* bps 8) (* pps 96)) 100000))))
  (display-string (number->string tps) 10)
  (display-string (number->string (round bps)) 10)
  (display-string (number->string (round pps)) 10)
  (display-string (number->string tld) 10)
  (display (string-fill! (make-string (/ tld 2 )) #\*)))
;
; get the repeated load
;
(define (repeat-load con dev start slp)
    (define load (beholder-load con dev))
    (display-load
     (- (list-ref load 0) (list-ref start 0))
     (- (list-ref load 1) (list-ref start 1))
     (- (list-ref load 2) (list-ref start 2)))
    (newline)
    (sleep (* slp  1000000))
    (repeat-load con dev load slp))

(if (not (= argc 3))
    ( begin
      (display "Call as: load <beholder> <device> <interval>")
      (newline)
      (exit)))

(define curcon (snmp-open (car argv) 161))

 (repeat-load 
	  curcon 
	  (string->number (list-ref argv 1)) 
	  (beholder-load curcon (string->number (list-ref argv 1)))
	  (string->number (list-ref argv 2)))

(snmp-close curcon)

(set-trace! 0)					
