/* 1445, Sun 17 Jul 94

   NMC.C:  First attempt at a manager for the AU Accounting Meter

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#include <sys/param.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>
#include <errno.h>

#include <string.h>
#include <malloc.h>

#include "ausnmp.h"

#include "snmp.h"
#include "snmpimpl.h"
#include "asn1.h"
#include "snmpclnt.h"
#include "snmpapi.h"
#include "mib.h"

#define EXTERN
#include "nmc.h"

void no_write_warning(struct meter_status *ms)
{
   if (ms->no_write_warned) return;
   printf("Community %s doesn't have write access to meter %s!\n"
      "   Collections won't trigger recovery of idle flows <<<\n",
      ms->community,ms->name);
   fprintf(log,
      "Community %s doesn't have write access to meter!\n"
      "   Collections won't trigger recovery of idle flows <<<\n",
      ms->community,ms->name);
   if (ms->statsreqd) {
      printf("   Meter statistics won't be zeroed after collections <<<\n");
      fprintf(log,
         "   Meter statistics won't be zeroed after collections <<<\n");
      }
   ms->no_write_warned = 1;
   }

int create_meter(struct meter_status *ms)
{
   char filename[NAME_LN*2];
   time_t t;  char *ts;
   unsigned char a,b, n;

   if (ms->name[0] == NULL || ms->community == 0) {
      printf("Meter name or community not specified !!!\n");
      return 0;
      }
   if (testing) printf("About to create_meter name=%s, community=%s\n", 
      ms->name, ms->community);

   if (!start_snmp_session(ms)) return 0;

   ms->status = MT_MANAGE;
   if (meter_info(ms)) {
      ms->status |= (MT_UP | MT_INFO);
      meter_print(stdout,ms);
      meter_print(log,ms);
      if (!meter_is_current(ms)) {
         printf("Warning: meter %s (version %s) not same as NeMaC!\n",
            ms->name,ms->version);
         fprintf(log,
            "Warning: meter %s (version %s) not same as NeMaC!\n",
            ms->name,ms->version);
         }
      fflush(log);
      }
   else {
      printf("Couldn't get meter info from %s!\n"
         "   Does community %s have read or write access to the meter?\n",
         ms->name,ms->community);
      fprintf(log,"Couldn't get meter info from %s!\n",
         "   Does community %s have read or write access to the meter?\n",
         ms->name,ms->community);
      fflush(log);
      return 0;
      }

   set_meter_params(ms);

   if (ms->rulefile[0] == NULL)  /* No rule file specified */
      ms->ruleset = ms->CurrentRuleSet;
   else {  /* Download the rules we want to use */
      parse_rulefile(ms,listrules,0);
      if (rferrors != 0) return 0;
      }
   ++nmeters;

   if (!ms->write_OK) no_write_warning(ms);

   ms->OurLastCollectTime = 1L;
   ms->snmp_delay = 90;  /* Wait 90 ms after an snmp request */

   sprintf(filename, "%s.flows", ms->name);  /* Open flows file */
   ms->flows = wfopen(filename);

   time(&t);  ts = fmt_time(&t);
   fprintf(ms->flows, 
      "##NeTraMet v%s:  -c%d -r %s %s  %u flows  starting at %s\n",
      ms->version,interval,ms->rulefile,ms->name, ms->MaxFlows, ts);
   fprintf(ms->flows, "#Format: ");
   if ((n = ms->format[a = 0]) != NULL) for (;;) {
      for (b = 1; attribs[b].index != n; ++b) ;
      fprintf(ms->flows,attribs[b].name);
      if ((n = ms->format[a+1]) == NULL) break;
      fprintf(ms->flows,ms->separator[a++]);
      }
   fprintf(ms->flows,"\n");
   fflush(ms->flows);
   }

char cfname[NAME_LN], rfname[NAME_LN],
   meter[NAME_LN], community[NAME_LN];

void main(argc,argv)
int argc;
char *argv[];
{
   int syntax;
   char *ap, arg[NAME_LN];
   int a;
   time_t t1,t2;  int busy_seconds;
   struct meter_status *ms, *nms;

   if (argc < 2) {
      printf("NeMaC [options] meter-name community\n\n");
      exit(0);
      }

   printf("NeMaC: NeTraMet Manager & Controller V2.2\n");

   syntax = verbose = testing = listrules = 0;
   interval = 120;  /* Default 2 minutes */
   strcpy(cfname, CFGFILE);
   rfname[0] = meter[0] = community[0] = NULL;

   for (a = 1; a < argc; ++a) {
      if (argv[a][0] == '-') {
	 switch (argv[a][1]) {
	 case 'd':
	    snmp_dump_packet++;
	    break;
	 case 'c':
            ap = argv[a]+2;
            if (*ap == NULL) ap = argv[++a];
	    interval = atoi(ap);
	    break;
	 case 'l':
	    listrules++;
	    break;
	 case 'r':
	    strcpy(rfname, argv[++a]);  /* Rule file name */
	    break;
	 case 'f':
	    strcpy(cfname, argv[++a]);  /* Config file name */
	    break;
	 case 's':
	    syntax++;
	    break;
	 case 't':
	    testing++;
	    break;
	 case 'v':
	    verbose++;
	    break;
	 default:
	    printf("Invalid option: -%c\n", argv[a][1]);
	    break;
	    }
	 continue;
	 }
      if (meter[0] == NULL) strcpy(meter,argv[a]);
      else if (community[0] == NULL) strcpy(community,argv[a]);
      }

   if (syntax) {  /* Test a rule file */
      ms = (struct meter_status *)calloc(sizeof(struct meter_status), 1);
      strcpy(ms->rulefile,rfname);
      parse_rulefile(ms,1,1);
      printf("\n%d errors in rule file %s\n\n", rferrors,rfname);
      exit(0);
      }

   init_mib();  /* Initialise SNMP handler */

   log = wfopen(LOGFILE);
   time(&t1);
   if (!parse_open(cfname)) {  /* No config file */
      first_meter = (struct meter_status *)calloc
         (sizeof(struct meter_status), 1);
      strcpy(first_meter->rulefile,rfname);
      strcpy(first_meter->name,meter);
      strcpy((char *)first_meter->community,community);
      first_meter->write_OK = 1;
      }
   else for (first_meter = NULL; ; ) {  /* Parse config file */
      ms = (struct meter_status *)calloc(sizeof(struct meter_status), 1);
      strcpy(ms->rulefile,rfname);
      ms->write_OK = 1;
      do {  /* Start with first char of a line */
	 nextchar();
	 if (ic == EOF) break;
	 } while (lic != '\n');
      if (ic == EOF) break;
      getarg(arg);
      for ( ; arg[0] == '-'; ) {
         ap = &arg[2];
         switch (arg[1]) {
         case 'g':
            if (*ap == NULL) getarg(ap = arg);
	    ms->GCIntervalReqd = atoi(ap);
            break;
         case 'h':
            if (*ap == NULL) getarg(ap = arg);
	    ms->HighWaterMark = atoi(ap);
            break;
         case 'i':
            if (*ap == NULL) getarg(ap = arg);
	    ms->InactivityTime = atoi(ap);
            break;
         case 'n':
            if (*ap == NULL) getarg(ap = arg);
	    ms->SamplingRate = atoi(ap);
            break;
         case 'r':
            getarg(ms->rulefile);
            break;
            }
         getarg(arg);
         }
      strcpy(ms->name,arg);
      getarg((char *)ms->community);
      if (first_meter == NULL) first_meter = ms;
      else for (nms = first_meter; ; nms = nms->next) {
         if (nms->next == NULL) {
            nms->next = ms;  break;
            }
         }
      }

   for (nmeters = 0, ms = first_meter; ms; ms = ms->next)
      create_meter(ms);

   if (nmeters == 0) {
      printf("No meters to monitor !!!\n");
      exit(0);
      }

   for (;;) {
      for (ms = first_meter; ms; ms = ms->next)
         if (ms->status & MT_MANAGE) monitor(ms);

      if (verbose) {
         for (ms = first_meter; ms; ms = ms->next)
            if (ms->status & MT_MANAGE) meter_print(stdout,ms);
         }

      if (interval == 0) exit(0);
      time(&t2);  busy_seconds = t2-t1;
      if (busy_seconds < interval) sleep(interval-busy_seconds);
      time(&t1);
      }
   }


void write_attrib(FILE *f, struct flow_info *fp, unsigned char col)
{
/*   char pal = addr_len[fp->LowPeerType]; */
   char pal = fp->LowPeerType > AT_OTHER ? MAC_ADDR_LEN 
      : addr_len[fp->LowPeerType];
   switch(col) {
   case FTFLOWINDEX:  /* Used to synchronise column blobs */
      fprintf(f,"%u",fp->FlowIndex);
      break;
   case FTFLOWSTATUS:
      fprintf(f,"%u",fp->FlowStatus);
      break;
   case FTLOWINTERFACE:
      fprintf(f,"%u",fp->LowInterface);
      break;
   case FTLOWADJACENTTYPE:
      fprintf(f,"%u",fp->LowAdjType);
      break;
   case FTLOWADJACENTADDRESS:
      printaddress(f,fp->LowAdjAddress,MAC_ADDR_LEN);
      break;
   case FTLOWADJACENTMASK:
      printaddress(f,fp->LowAdjMask,MAC_ADDR_LEN);
      break;
   case FTLOWPEERTYPE:
      fprintf(f,"%u",fp->LowPeerType);
      break;
   case FTLOWPEERTYPEMASK:
      fprintf(f,"%u",fp->LowPeerTypeMask);
      break;
   case FTLOWPEERADDRESS:
      printaddress(f,fp->LowPeerAddress,pal);
      break;
   case FTLOWPEERMASK:
      printaddress(f,fp->LowPeerMask,pal);
      break;
   case FTLOWDETAILTYPE:
      fprintf(f,"%u",fp->LowDetailType);
      break;
   case FTLOWDETAILTYPEMASK:
      fprintf(f,"%u",fp->LowDetailTypeMask);
      break;
   case FTLOWDETAILADDRESS:
      printaddress(f,fp->LowDetailAddress,DETAIL_ADDR_LEN);
      break;
   case FTLOWDETAILMASK:
      printaddress(f,fp->LowDetailMask,DETAIL_ADDR_LEN);
      break;
   case FTHIINTERFACE:
      fprintf(f,"%u",fp->HighInterface);
      break;
   case FTHIADJACENTTYPE:
      fprintf(f,"%u",fp->HighAdjType);
      break;
   case FTHIADJACENTADDRESS:
      printaddress(f,fp->HighAdjAddress,MAC_ADDR_LEN);
      break;
   case FTHIADJACENTMASK:
      printaddress(f,fp->HighAdjMask,MAC_ADDR_LEN);
      break;
   case FTHIPEERTYPE:
      fprintf(f,"%u",fp->HighPeerType);
      break;
   case FTHIPEERTYPEMASK:
      fprintf(f,"%u",fp->HighPeerTypeMask);
      break;
   case FTHIPEERADDRESS:
      printaddress(f,fp->HighPeerAddress,pal);
      break;
   case FTHIPEERMASK:
      printaddress(f,fp->HighPeerMask,pal);
      break;
   case FTHIDETAILTYPE:
      fprintf(f,"%u",fp->HighDetailType);
      break;
   case FTHIDETAILTYPEMASK:
      fprintf(f,"%u",fp->HighDetailTypeMask);
      break;
   case FTHIDETAILADDRESS:
      printaddress(f,fp->HighDetailAddress,DETAIL_ADDR_LEN);
      break;
   case FTHIDETAILMASK:
      printaddress(f,fp->HighDetailMask,DETAIL_ADDR_LEN);
      break;
   case FTRULESET:
      fprintf(f,"%u",fp->FlowRuleSet);
      break;
   case FTFLOWTYPE:
      fprintf(f,"%u",fp->FlowType);
      break;
   case FTUPOCTETS:
      fprintf(f,"%lu",fp->FwdBytes);
      break;
   case FTUPPDUS:
      fprintf(f,"%lu",fp->FwdPackets);
      break;
   case FTDOWNOCTETS:
      fprintf(f,"%lu",fp->BackBytes);
      break;
   case FTDOWNPDUS:
      fprintf(f,"%lu",fp->BackPackets);
      break;
   case FTFIRSTTIME:
      fprintf(f,"%lu",fp->FirstTime);
      break;
   case FTLASTTIME:
      fprintf(f,"%lu",fp->LastTime);
      break;
      }
   }

unsigned short getshort(ucp)
unsigned char *ucp;
{
   return ucp[0]<<8 | ucp[1];
   }

unsigned long getlong(ucp)
unsigned char *ucp;
{
   return ucp[0]<<24 | ucp[1]<<16 | ucp[2]<<8 | ucp[3];
   }

unsigned short get_slice(struct meter_status *ms,
   unsigned short first_row, unsigned char col, 
   unsigned char first)
{
   int fn, row, n, r, sz;
   struct flow_info *fp;
   unsigned char *ucp;
   fn = first_row;  row = 0;
   if (column_info(ms,column_blob, col,ms->OurLastCollectTime,&fn) != 0) {
      for (ucp = column_blob;  row < MX_BLOB_FLOWS;  ) {
         fp = &flows[row];
         n = netshort(getshort(ucp));  ucp += 2;  /* Flow nbr */
         if (n < 2) break;  /* No more active flows in blob */
         sz = attribs[col].len;
         switch (col) {
	 case FTFLOWINDEX:  /* Used to synchronise column blobs */
	    break;
	 case FTFLOWSTATUS:
            fp->FlowStatus = *ucp;
            break;
	 case FTLOWINTERFACE:
            fp->LowInterface = *ucp;
            break;
	 case FTLOWADJACENTTYPE:
            fp->LowAdjType = *ucp;
            break;
	 case FTLOWADJACENTADDRESS:
	    bcopy(ucp,fp->LowAdjAddress,MAC_ADDR_LEN);
	    break;
	 case FTLOWADJACENTMASK:
	    bcopy(ucp,fp->LowAdjMask,MAC_ADDR_LEN);
	    break;
	 case FTLOWPEERTYPE:
            fp->LowPeerType = *ucp;
	    break;
	 case FTLOWPEERTYPEMASK:
            fp->LowPeerTypeMask = *ucp;
	    break;
	 case FTLOWPEERADDRESS:
            memset((char *)fp->LowPeerAddress,0,PEER_ADDR_LEN);
            sz = *ucp++;
	    bcopy(ucp,fp->LowPeerAddress,sz);
	    break;
	 case FTLOWPEERMASK:
            memset((char *)fp->LowPeerMask,0,PEER_ADDR_LEN);
            sz = *ucp++;
	    bcopy(ucp,fp->LowPeerMask,sz);
	    break;
	 case FTLOWDETAILTYPE:
            fp->LowDetailType = *ucp;
	    break;
	 case FTLOWDETAILTYPEMASK:
            fp->LowDetailTypeMask = *ucp;
	    break;
	 case FTLOWDETAILADDRESS:
	    bcopy(ucp,fp->LowDetailAddress,DETAIL_ADDR_LEN);
	    break;
	 case FTLOWDETAILMASK:
	    bcopy(ucp,fp->LowDetailMask,DETAIL_ADDR_LEN);
	    break;
	 case FTHIINTERFACE:
            fp->HighInterface = *ucp;
            break;
	 case FTHIADJACENTTYPE:
            fp->HighAdjType = *ucp;
	    break;
	 case FTHIADJACENTADDRESS:
	    bcopy(ucp,fp->HighAdjAddress,MAC_ADDR_LEN);
	    break;
	 case FTHIADJACENTMASK:
	    bcopy(ucp,fp->HighAdjMask,MAC_ADDR_LEN);
	    break;
	 case FTHIPEERTYPE:
            fp->HighPeerType = *ucp;
	    break;
	 case FTHIPEERTYPEMASK:
            fp->HighPeerTypeMask = *ucp;
	    break;
	 case FTHIPEERADDRESS:
            memset((char *)fp->HighPeerAddress,0,PEER_ADDR_LEN);
            sz = *ucp++;
	    bcopy(ucp,fp->HighPeerAddress,sz);
	    break;
	 case FTHIPEERMASK:
            memset((char *)fp->HighPeerMask,0,PEER_ADDR_LEN);
            sz = *ucp++;
	    bcopy(ucp,fp->HighPeerMask,sz);
	    break;
	 case FTHIDETAILTYPE:
            fp->HighDetailType = *ucp;
	    break;
	 case FTHIDETAILTYPEMASK:
            fp->HighDetailTypeMask = *ucp;
	    break;
	 case FTHIDETAILADDRESS:
	    bcopy(ucp,fp->HighDetailAddress,DETAIL_ADDR_LEN);
	    break;
	 case FTHIDETAILMASK:
	    bcopy(ucp,fp->HighDetailMask,DETAIL_ADDR_LEN);
	    break;
	 case FTRULESET:
            fp->FlowRuleSet = *ucp;
	    break;
	 case FTFLOWTYPE:
            fp->FlowType = *ucp;
	    break;
         case FTUPOCTETS:
            fp->FwdBytes = netlong(getlong(ucp));
            break;
	 case FTUPPDUS:
            fp->FwdPackets = netlong(getlong(ucp));
	    break;
	 case FTDOWNOCTETS:
            fp->BackBytes = netlong(getlong(ucp));
	    break;
	 case FTDOWNPDUS:
            fp->BackPackets = netlong(getlong(ucp));
	    break;
	 case FTFIRSTTIME:
            fp->FirstTime = netlong(getlong(ucp));
	    break;
	 case FTLASTTIME:
            fp->LastTime = netlong(getlong(ucp));
	    break;
	    }
         ucp += sz;
         if (first) {
            fp->FlowIndex = n;  ++row;
	    }
         else {
            if (n == fp->FlowIndex) ++row;
            }
         }
      }	
   if (first) flows[row].FlowIndex = n;  /* Return end-of-blob marker */
   return row;  /* Nbr of rows may decrease with later columns */
   }

void monitor(ms)  /* Called every interval for each meter */
struct meter_status *ms;
{
   time_t t;  char *ts;
   unsigned short activeflows, first_row, nrows, r;
   unsigned char a, col, first;
   unsigned long aps,apb;
   unsigned int i,j;
   struct flow_info *fp;

   time(&t);  ts = fmt_time(&t);
   if (!(ms->status & MT_INFO)) {  /* No info */
      if (meter_info(ms))  /* Got some */
	 ms->status |= (MT_UP | MT_INFO);
      return;
      }
   if (!ms->write_OK) no_write_warning(ms);
   if (meter_info(ms) == 0) {  /* Lost contact */
      if (ms->status & MT_UP) {  /* Was up */
	 fprintf(log,"%s -- %s: No response\n", ts,ms->name);
         fflush(log);  
	 if (verbose) printf("%s -- %s: No response\n", ts,ms->name);
	 }
      ms->status &= ~MT_UP;  /* Mark as 'down' */
      return;
      }
   if (!(ms->status & MT_UP)) {  /* Have contact now, was down */
      fprintf(log,"%s -- %s: Regained contact\n", ts,ms->name);
      fflush(log);  
      if (verbose) printf("%s -- %s: Regained contact\n", ts,ms->name);
      ms->write_OK = 1;  ms->no_write_warned = 0;
      }
   ms->status |= MT_UP;

   /* Meter processing .. */

   set_collect_time(ms,1);  /* Tell meter we're starting a collection */

   fprintf(ms->flows, 
      "#Time: %s %s Flows from %lu to %lu\n",
      ts,ms->name, ms->OurLastCollectTime,ms->uptime);

   if (ms->statsreqd) {
      if (ms->StatsTime != 0) {
         aps = (ms->NbrPackets*10+5L)/(ms->StatsTime*10L);
         apb = (ms->TotPktBacklog*10+5L)/(ms->StatsTime*10L);
         }
      else {
         aps = apb = 0;
         }
      fprintf(ms->flows,"#Stats: aps=%lu apb=%lu mps=%lu mpb=%lu lsp=%lu", 
         aps,apb, ms->MaxPktRate,ms->MaxPktBacklog, ms->LostPackets);
      fprintf(ms->flows," avi=%u.%u mni=%u.%u",
         ms->AvIdle1000/10,ms->AvIdle1000%10,
         ms->MinIdle1000/10,ms->MinIdle1000%10);
      if (ms->NbrPackets != 0)
         i = (ms->RuleMatches*100L+5L)/(ms->NbrPackets*10L);
      else i = 0;
      fprintf(ms->flows," fiu=%u frc=%lu gci=%u rpp=%u.%u",
         ms->NbrFlows,ms->FlowsRecovered,ms->GCInterval, i/10,i%10);
      if (ms->NbrPackets != 0)
         i = (ms->HashSearches*100L+5L)/(ms->NbrPackets*10L);
      else i = 0;
      if (ms->HashSearches != 0) {
         j = (ms->HashCompares*100L+5L)/(ms->HashSearches*10L);
         }
      else j = 0;
      fprintf(ms->flows," tpp=%u.%u cpt=%u.%u tts=%u tsu=%u\n",
	 i/10,i%10, j/10,j%10, ms->TotalHashSize,ms->NbrHashEntries);
      }

   if (ms->format[0] != 0) {  /* Collect flow data */
      activeflows = 0;  first_row = 1;
      do {
         for (first = 1, a = 0;  (col = col_order[a]) != NULL; ++a) {
            if (ms->required[col] == 0) continue;
            r = get_slice(ms, first_row,col, first);
            if (first) {
               nrows = r;  first = 0;
	       }
            else if (r < nrows) nrows = r;
            }
         if (testing) fprintf(ms->flows,
            "#monitor(): first_row=%u, nrows=%u, next_row=%d, end_mark=%u\n",
               first_row, nrows, 
               nrows != 0 ? flows[nrows-1].FlowIndex : -1,
               flows[nrows].FlowIndex);
         activeflows += nrows;
         if (nrows != 0) {
            first_row = flows[nrows-1].FlowIndex;  /* Last data row */
            for (r = 0; r != nrows; ++r) {
               for (col = ms->format[a = 0]; ; ) {
                  if (col != NULL) write_attrib(ms->flows, &flows[r],col);
                  if ((col = ms->format[a+1]) == NULL) break;
                  fprintf(ms->flows,ms->separator[a++]);
                  }
               fprintf(ms->flows,"\n");
               }
            }
         } while (flows[nrows].FlowIndex != 0);
      }

   fflush(ms->flows);
   if (verbose) printf(
      "%s %s: %d active flows from %lu to %lu\n",
      ts,ms->name, activeflows, ms->OurLastCollectTime,ms->uptime);

   ms->OurLastCollectTime = ms->uptime - 1L;
      /* -1 to make sure we don't miss any flows.  We may
         collect some of them twice, but we don't mind that */
   }

void meter_print(FILE *f,struct meter_status *ms)
{
   time_t t;  char tsbuf[32];
   struct timeval tv;
   char buf[32];

   if (!verbose) return;

   time(&t);  strcpy(tsbuf,fmt_time(&t));
   gettimeofday(&tv, (struct timezone *)0);
   tv.tv_sec -= ms->uptime / 100;
   if ((ms->uptime % 100)*10000 > tv.tv_usec) {
      tv.tv_sec--;
      tv.tv_usec += 1000000;
      }
   tv.tv_usec -= (ms->uptime % 100)*10000;
   fprintf(f,"%s -- %s: %s\n\tUp %s (since %s)\n",
      tsbuf,ms->name, ms->descr, uptime_string(ms->uptime, buf),
      fmt_time(&tv.tv_sec));
   }
