/* 1713, Wed 16 Feb 94

   FLOWDATA.H:  Global declarations for fd_filter and fd_extract

   Copyright (C) 1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#ifndef EXTERN
#define EXTERN  extern
#define DECLARE  0
#define INIT(v)
#else
#define EXTERN
#define DECLARE  1
#define INIT(v)  = v
#endif

extern int errno;

EXTERN int snmp_dump_packet INIT(0);

EXTERN int verbose, testing, listrules;

#define MXTAGS  200
#define MXCOLS   20

#define MAC_ADDR_LEN      6
#define PEER_ADDR_LEN    20
#define DETAIL_ADDR_LEN   2

#define RULE_ADDR_LEN    20

#define string_value(a)  (attribs[a].len > 4)

#define STR_LEN   64

struct flow_info {  /* Accounting flow as viewed by programs */
   unsigned int FlowIndex;
   unsigned int LowInterface, HighInterface;
   unsigned int LowAdjType, HighAdjType;
   char LowAdjAddress[STR_LEN+1], LowAdjMask[STR_LEN+1],
      HighAdjAddress[STR_LEN+1], HighAdjMask[STR_LEN+1];
   unsigned int
      LowPeerType,LowPeerTypeMask, HighPeerType,HighPeerTypeMask;
   char LowPeerAddress[STR_LEN+1], LowPeerMask[STR_LEN+1],
      HighPeerAddress[STR_LEN+1], HighPeerMask[STR_LEN+1];
   unsigned int
      LowDetailType,LowDetailTypeMask,  HighDetailType,HighDetailTypeMask;
   unsigned int   LowDetailAddress, LowDetailMask,
      HighDetailAddress, HighDetailMask;
   unsigned int FlowStatus, FlowRuleSet, FlowType;
   unsigned int
      FwdPackets,FwdBytes,  BackPackets,BackBytes,
      FirstTime,LastTime;
   unsigned int  /* New attributes (created by fd_filter) */
      upbci,   /* To byte rate (bytes since last sample) */
      dnbci,   /* From byte rate */
      uppci,   /* To packet rate */
      dnpci,   /* From packet rate */
      TagNbr;  /* Tag nbr */
   };
EXTERN struct flow_info curr_flow;


#define AT_IGNORE     0  /* Addr_type values */
#define AT_ADJACENT   1
#define AT_IP         2
#define AT_CLNS       3
#define AT_IDPR       4
#define AT_DECNET     5
#define AT_NOVELL     6
#define AT_ETHERTALK  7
#define AT_DETAIL     8
#define AT_OTHER     12

#define PT_ICMP       1  /* IP protocol type values */
#define PT_TCP        6
#define PT_UDP       17

#define WNP_FTPDATA  20  /* Well-known tcp/udp port numbers */
#define WNP_FTP      21
#define WNP_TELNET   23
#define WNP_SMTP     25
#define WNP_DOMAIN   53
#define WNP_NNTP    119
#define WNP_NTP     123
#define WNP_SNMP    161

#define RA_COUNT      1
#define RA_TALLY      2
#define RA_AGGREGATE  3
#define RA_SUCCEED    4
#define RA_FAIL       5
#define RA_PUSHTO     6
#define RA_POPTO      7
#define RA_GOTO       8

#define RF_SET       -2  /* -1 is EOF !!! */
#define RF_RULES     -3
#define RF_ACTIONS   -4
#define RF_FORMAT    -5
#define RF_STATS     -6
#define RF_TAG       -7
#define RF_COLUMN    -8
#define RF_TIME      -9

#define EX_SCALE    -51  /* Keywords for fd_extract */
#define EX_KILO     -52
#define EX_MEGA     -53
#define EX_ELAPSED  -54
#define EX_CLOCK    -55
#define EX_SECS     -56
#define EX_MINS     -57
#define EX_HOURS    -58
#define EX_DAYS     -59

#define FTFLOWINDEX		1  /* Flow table attribute values */
#define FTFLOWSTATUS		2

#define FTLOWINTERFACE          3
#define FTLOWADJACENTTYPE       4
#define FTLOWADJACENTADDRESS    5
#define FTLOWADJACENTMASK       6
#define FTLOWPEERTYPE		7
#define FTLOWPEERTYPEMASK	8
#define FTLOWPEERADDRESS	9
#define FTLOWPEERMASK	       10
#define FTLOWDETAILTYPE        11
#define FTLOWDETAILTYPEMASK    12
#define FTLOWDETAILADDRESS     13
#define FTLOWDETAILMASK        14
#define FTLOWSUBSCRIBERID      15
#define FTLOWSUBSCRIBERMASK    16
#define FTHIINTERFACE          17
#define FTHIADJACENTTYPE       18
#define FTHIADJACENTADDRESS    19
#define FTHIADJACENTMASK       20
#define FTHIPEERTYPE	       21
#define FTHIPEERTYPEMASK       22
#define FTHIPEERADDRESS	       23
#define FTHIPEERMASK	       24
#define FTHIDETAILTYPE         25
#define FTHIDETAILTYPEMASK     26
#define FTHIDETAILADDRESS      27
#define FTHIDETAILMASK         28
#define FTHISUBSCRIBERID       29
#define FTHISUBSCRIBERMASK     30

#define FTSUBSCRIBERID         31
#define FTSUBSCRIBERMASK       32

#define FTPDUSCALE             33
#define FTOCTETSCALE           34
#define FTRULESET              35
#define FTFLOWTYPE             36

#define FTUPOCTETS	       37
#define FTUPPDUS	       38
#define FTDOWNOCTETS	       39
#define FTDOWNPDUS	       40

#define FTFIRSTTIME	       41
#define FTLASTTIME	       42

#define FTUPOCTETRATE          43  /* Attributes added by fd_filter */
#define FTUPPDURATE	       44
#define FTDOWNOCTETRATE	       45
#define FTDOWNPDURATE	       46
#define FTTAGNBR               47

#define NATTRIBS         FTTAGNBR

typedef union {
   unsigned int *intval;
   char *charval;
   } val;
struct attrib_info {
   char *name;
   unsigned char index;
   unsigned char len;
   val value;
   };

#define SZ_ATTRIBS  (1+NATTRIBS+8)
EXTERN struct attrib_info attribs[SZ_ATTRIBS]
#if DECLARE
   = {
   "null",                   0,                     0,	NULL,
   "flowindex",              FTFLOWINDEX,           2,	NULL,
   "flowstatus",             FTFLOWSTATUS,          0,	NULL,
   "sourceinterface",        FTLOWINTERFACE,        1,	NULL,
   "sourceadjacenttype",     FTLOWADJACENTTYPE,     1,	NULL,
   "sourceadjacentaddress",  FTLOWADJACENTADDRESS,  MAC_ADDR_LEN,  NULL,
   "sourceadjacentmask",     FTLOWADJACENTMASK,     MAC_ADDR_LEN,  NULL,
   "sourcepeertypemask",     FTLOWPEERTYPEMASK,     1,	NULL,
   "sourcepeertype",         FTLOWPEERTYPE,         1,	NULL,
   "sourcepeeraddress",      FTLOWPEERADDRESS,      PEER_ADDR_LEN,  NULL,
   "sourcepeermask",         FTLOWPEERMASK,         PEER_ADDR_LEN,  NULL,
   "sourcetranstypemask",    FTLOWDETAILTYPEMASK,   1,	NULL,
   "sourcetranstype",        FTLOWDETAILTYPE,       1,	NULL,
   "sourcetransaddress",     FTLOWDETAILADDRESS,    DETAIL_ADDR_LEN,  NULL,
   "sourcetransmask",        FTLOWDETAILMASK,       DETAIL_ADDR_LEN,  NULL,
   "sourcesubscriberid",     FTLOWSUBSCRIBERID,     0,	NULL,
   "sourcesubscribermask",   FTLOWSUBSCRIBERMASK,   0,	NULL,
   "destinterface",          FTHIINTERFACE,         1,  NULL,
   "destadjacenttype",       FTHIADJACENTTYPE,      1,	NULL,
   "destadjacentaddress",    FTHIADJACENTADDRESS,   MAC_ADDR_LEN,  NULL,
   "destadjacentmask",       FTHIADJACENTMASK,      MAC_ADDR_LEN,  NULL,
   "destpeertypemask",       FTHIPEERTYPEMASK,      1,	NULL,
   "destpeertype",           FTHIPEERTYPE,          1,	NULL,
   "destpeeraddress",        FTHIPEERADDRESS,       PEER_ADDR_LEN,  NULL,
   "destpeermask",           FTHIPEERMASK,          PEER_ADDR_LEN,  NULL,
   "desttranstypemask",      FTHIDETAILTYPEMASK,    1,	NULL,
   "desttranstype",          FTHIDETAILTYPE,        1,	NULL,
   "desttransaddress",       FTHIDETAILADDRESS,     DETAIL_ADDR_LEN,  NULL,
   "desttransmask",          FTHIDETAILMASK,        DETAIL_ADDR_LEN,  NULL,
   "destsubscriberid",       FTHISUBSCRIBERID,      0,  NULL,
   "destsubscribermask",     FTHISUBSCRIBERMASK,    0,  NULL,
   "subscriberid",           FTSUBSCRIBERID,        0,  NULL,
   "subscribermask",         FTSUBSCRIBERMASK,      0,  NULL,
   "pduscale",               FTPDUSCALE,            0,  NULL,
   "octetscale",             FTOCTETSCALE,          0,  NULL,
   "flowruleset",            FTRULESET,             1,  NULL,
   "flowtype",               FTFLOWTYPE,            1,	NULL,
   "tooctets",               FTUPOCTETS,            4,  NULL,
   "topdus",                 FTUPPDUS,              4,  NULL,
   "fromoctets",             FTDOWNOCTETS,          4,  NULL,
   "frompdus",               FTDOWNPDUS,            4,  NULL,
   "firsttime",              FTFIRSTTIME,           4,  NULL,
   "lasttime",               FTLASTTIME,            4,  NULL,

   "tooctetrate",            FTUPOCTETRATE,         4,  NULL,
   "topdurate",              FTUPPDURATE,           4,  NULL,
   "fromoctetrate",          FTDOWNOCTETRATE,       4,  NULL,
   "frompdurate",            FTDOWNPDURATE,         4,  NULL,
   "tagnbr",		     FTTAGNBR,		    4,  NULL,

   "sourcedetailtypemask",   FTLOWDETAILTYPEMASK,   1,	NULL,
   "sourcedetailtype",       FTLOWDETAILTYPE,       1,	NULL,
   "sourcedetailaddress",    FTLOWDETAILADDRESS,    DETAIL_ADDR_LEN,  NULL,
   "sourcedetailmask",       FTLOWDETAILMASK,       DETAIL_ADDR_LEN,  NULL,
   "destdetailtypemask",     FTHIDETAILTYPEMASK,    1,	NULL,
   "destdetailtype",         FTHIDETAILTYPE,        1,	NULL,
   "destdetailaddress",      FTHIDETAILADDRESS,     DETAIL_ADDR_LEN,  NULL,
   "destdetailmask",         FTHIDETAILMASK,        DETAIL_ADDR_LEN,  NULL
   }
#endif
   ;

struct flow_stats {

   unsigned char format[1+NATTRIBS];
   char *separator[1+NATTRIBS];
   unsigned char required[1+NATTRIBS];

   FILE *flows;
   };



EXTERN FILE *rfp;  /* Scanner globals */
EXTERN char inbuf[500],*ibp, ebuf[80];  /* Input, error message buffers */
EXTERN int lic, ic,  /* Last input char, current input char */
   iblisted, rule_line, rferrors;


/* Forward procedure declarations .. */

/* Functions declared in fd_parse.c */

char *gnbr(unsigned int *n, char *s);
char *gcstring(char *s, int *len);

int parse_open(char *fn);
void p_error(char *msg);
int nextchar(void);
int nexttoken(void);
void getfdstring(char *arg);
int wordis(char *p, char *w);
int getword(void);
int getnbr(void);

void scan_format(struct flow_stats *fs, int single_record, int list);

val attrib_ptr(struct flow_info *fip, int a);
char *get_value(val v, int a, char *pb);
void put_value(FILE *out, int a, val v);
