


/*
 *  This is a template program for feeding a site using NewsClip
 *  Use your filter program in "batch" mode:
 *  First create a .newsrc file with the groups you wish to feed to
 *  the remote site.  No "las" file is needed.   Adjust the distributions
 *  below, or put them in a file and change the init code.
 *
 *  Now run your filter program as follows, regularly from the cron, when
 *  it is time to batch news for the remote site:
 *
 *		nclip mode=batch n=newsrcfile >/usr/spool/batch/sitename
 *
 *  On the standard output, it lists the files to be fed.  This can then
 *  be fed to the news sendbatch program.
 *
 *  Be sure to change the "feedsite" string in the article() procedure,
 *  and the distributions below.
 */

database distfeed;		/* distributions to be fed */

header string array control : "control", " ";	/* parse control messages */

extern string array xref;		/* to eliminate crossposts */
					/* Or use an alternate crosspost
					   eliminator -- see below */
extern newsgroup array Rdistribution;

extern string array path;		/* the path line */

procedure init()
{
	distfeed = fresh_database( 30 );
	/* alternatedly, use read_database to keep this in a file */
	/*	distfeed = read_database( "distfile" ); */


	/* Note in the following cases that the distribution must be coded
	   or the article will not be sent.  The 'world' distribution is
	   there only for articles truly posted to that distribution.  It
	   need not be present for general articles.  In order to feed an
	   article, it must be posted to one of the distributions listed,
	   *and* be in the .newsrc file controlling the feeding.  If you
	   put "news.misc" in the .newsrc, it will not be feed in its
	   entirety unless "news" is a distribution listed below.

	   BUT: You can change the code as you like.  Take out the distribution
	   filter altogether and get the entire contents of the groups in
	   the .newsrc, for example.
	  */

	/* hard code the desired distributions */
	distfeed["comp"]++;
	distfeed["rec"]++;
	distfeed["news"]++;
	distfeed["misc"]++;
	distfeed["soc"]++;
	distfeed["talk"]++;
	distfeed["sci"]++;
	distfeed["alt"]++;
	distfeed["biz"]++;
	distfeed["trial"]++;
	/* distfeed["clari"]++;	 Only to paid ClariNet subscribers */
	distfeed["world"]++;
	distfeed["na"]++;
	distfeed["can"]++;	/* pick your country */
	distfeed["usa"]++;
	distfeed["to"]++;		/* for the to.sitename group */
	distfeed["ont"]++;		
	distfeed["kw"]++;
	distfeed["uw"]++;
}

/* This procedure rejects all articles that are not in a distribution
   that we are supposed to get.  You can alter this to reject articles that
   aren't entirely for your distribution, if you like.  It just takes the
   left side of the names in the distribution (newsgroups) list, and checks
   to see if they are in the database of desired distributions.

   The Rdistribution variable is special.  It is the Distribution header if
   that is defined, or the Newsgroups header if it isn't -- ie. the true
   distribution list.  It is thus always defined.
 */

procedure check_dist()
{
	int i;
	extern string left( string, int );
	/* reject all articles not in a distribution we get */

	/* scan distributions, return if one matches what we are fed */
	for( i = 0; i < count( Rdistribution ); i++ )
		if( left( Rdistribution[i], 1 ) in distfeed )
			return;
	/* nothing matched, reject this article */
	reject;
}

/* This special procedure handles control messages, searching for the
 * 'newgroup' message.
 */

procedure do_control()
{
	extern procedure subscribe( string );

	/* look for newgroup control messages */

	/* add code here to accept newgroups only from certain people, if
	   you like */

	if( control != nilarray && count(control) >= 2 &&
			control[0] == "newgroup" )
		subscribe( control[1] );
}

/* the main article procedure, where you might put in filter code */

procedure article()
{
	extern newsgroup main_newsgroup;
	check_dist();			/* check article is in our dist */


	/* handle control articles with special subscribing code */
	if( main_newsgroup == #control ) 
		do_control();

	/* reject any article that came from the feed site.  In this case
	   the feed site is hard coded, but you could pass it as a command
	   line option to avoid having multiple programs for similar sites
	   In fact, in this case reject all non-local articles */

	if( count(path) > 2 || "maytag" in path || "watmath" in path )
		reject;

	/* you might want to be clever here, and also reject articles that
	   have been to other feeds of the site you are feeding.  Chances
	   are, if an article's been there, your destination already has
	   it.  This makes really short loops more efficient, although some
	   risk is involved
	 */


	/* now insert code here to filter out undesired articles */

	/* otherwise accept all articles */
	accept;
}

/* The procedure below, called at the start of "article", provides
 * an alternate means for rejection of cross-posted articles, even if
 * your site doesn't properly support the Xrefs line */

 /* DON'T USE THIS PROCEDURE AND DEFINE THE XREFS HEADER AT THE SAME TIME */

procedure reject_xref()
{
	int i;
	extern newsgroup main_newsgroup;
	extern int newsrc_group( newsgroup );


	/* loop through the groups on the Newsgroups line.  Find the
	 * first one that is a subscribed group.  If that's the current
	 * group, get on with processing the article.  If it's another group,
	 * reject the article, as we will process it when we get to that
	 * first subscribed group.  ie. the article in exactly one of the
	 * groups on the Newsgroups line -- the first one of those that we
	 * subscribe to.
	 */

	for( i = 0; i < count(newsgroups); i++ )
		if( newsrc_group( newsgroups[i] ) )
			if( newsgroups[i] == main_newsgroup )
				return;		/* do nothing, first valid grp*/
			 else
				reject;		/* skip the article */
}

/*
	The B news "sys" file contains some selection options.  You should be
	able to code many of these easily in Newsclip, plus a bunch more.

	For example, the 'L' option sends only local articles.  To do this,
	accept only articles where domain(Rsender) == my_domain, or
	articles where count(path) <= 2 (or some other number, if you want
	to broaden the definition of 'local').

	Sending only moderated groups is easy -- you can put only such
	groups in the .newsrc, or check for the Approved line -- you can
	even check that the Approved line is the moderator you want if
	there can be multiple moderators.

	Newsclip lets you do a lot more than this of course.
 */
