
/*
 * Output C code from generated and typechecked code trees.
 */
 /*
  * Newsclip(TM) Compiler Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip compiler for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed before compiling.
  * A short time evaluation of this product is also permitted.  See the file
  * 'Licence' in the library source directory for details.
  */

#include "nc.h"

int indent_level = 0;		/* how far to indent each line */

out( tp )
nodep tp;			/* the tree pointer */
{
	extern struct node_info node_table[];
	extern char *union_names[];	/* names of gen type union members */
	extern char *typabbrevs[];	/* short names for types */
	int nt;			/* node type */
	char *tail;		/* stuff to print after printing the node */
	dtype otype;

	if( !tp )
		return;

	nt = tp->ntype;
	tail = "";

	/* Output the special casting functions based on type change marks */

	switch( tp->nflags & CAST_MASK ) {
		case CAST_NGNAME:
			cout( "ngn(" );
			tail = ")";
			break;
		case CAST_MAILNAME:
			cout( "mailname(" );
			tail = ")";
			break;
		case CAST_DATE:
			cout( "(datehold)(" );
			tail = ")";
			break;
		case CAST_INT:
			cout( "(int)(" );
			tail = ")";
			break;
		}

	/* deal with the special cases */
	switch( nt ) {
		case N_LIST:
			listprint( (listp)tp, "\n" );
			return 0;
		case N_FOREACH:
			{
			dtype atype;
			dtype vtype;

			atype = kid1(tp)->ndtype;
			vtype = kid0(tp)->ndtype;
			if( insist_variable( kid0(tp) ) )
				break ;

			if( atype & T_ARRAY ) {
				extern char *union_names[];
				codeprint( tp, "{int i;\n" );
				codeprint( tp, "array *thear;\n" );
				codeprint( tp, "thear = !1t;\n" );
				codeprint( tp, "for( i = 0; !0t = thear->vals[i]." );
				codeprint( tp, union_names[atype&T_BASETYPE] );
				codeprint( tp, ", i < thear->arsize; i++ )!>\n" );
				out( kid2(tp) );
				codeprint( tp, "\n!<}" );
				}
			 else if( atype == T_DATABASE ) {
				codeprint( tp, "{dbptr base;\n" );
				codeprint( tp, "userdb *dbrec;\n" );
				codeprint( tp, "base = !1t;\n" );
				codeprint( tp, "for( dbrec = ufirst_rec(base); dbrec && (!0t = dbrec->name); dbrec = unext_rec(base,dbrec) )!>\n" );
				out( kid2(tp) );
				codeprint( tp, "\n!<}" );
				}
			break ;
			}
		case N_INDEX:
			{
			dtype k0t;
			k0t = kid0(tp)->ndtype;
			if( k0t == T_DATABASE ) {
				if( tp->nflags & NF_LVALUE )
					codeprint( tp,
						"(db_create(!0t,!1t)->intval)");
				 else
					codeprint( tp,
						"db_lookup(!0t,!1t)" );
				}
			 else {
				
				codeprint( tp, "!0t->vals[!1t]." );
				cout( union_names[ kid0(tp)->ndtype
								& T_BASETYPE ]);
				}
			break;
			}
		case N_EQ:
			if( kid0(tp)->ndtype == T_STRING )
				codeprint( tp, "str_eq(!0t,!1t)" );
			 else
				codeprint( tp, "!0t == !1t" );
			break;
		case N_NE:
			if( kid0(tp)->ndtype == T_STRING )
				codeprint( tp, "!!str_eq(!0t,!1t)" );
			 else
				codeprint( tp, "!0t !!= !1t" );
				
			break;
		case N_NOT_IN:
			coutc( '!' );
		case N_IN:
			{
			dtype k0t;

			k0t = kid0(tp)->ndtype;
			if( kid1(tp)->ndtype == T_DATABASE ) {
				if( k0t & T_ARRAY )
					codeprint(tp,"arr_in_db(!0t,!1t)");
				 else
					codeprint(tp,"str_in_db(!0t,!1t)" );
				}
			 else {
				/* must be a search in array */
				/* arrays carry their types with them */
				if( k0t & T_ARRAY )
					cout("arr");
				 else
					cout(typabbrevs[k0t]);
				codeprint( tp, "_in_arr(!0t,!1t)" );
				}
			}
			break;
		case N_NOT_HAS:
			coutc( '!' );
		case N_HAS: {
			dtype k0t,k1t;

			k0t = kid0(tp)->ndtype;
			if( (k0t & T_ARRAY) )
				cout( "arr" );
			 else 
				cout( typabbrevs[k0t] );
			cout( "_has_" );
			k1t = kid1(tp)->ndtype;
			if( kid1(tp)->ntype == N_PATTERN )
				cout( "pat" );
			 else if( k1t & T_ARRAY )
				cout( "arr" );
			 else
				cout( typabbrevs[k1t] );
			codeprint( tp, "(!0t,!1t)" );
				
			break;
			}
		case N_PARSE:
			cprintf( "uprepare_var(%d,",kid0(tp)->ndtype );
			if( kid2(tp) )
				codeprint( tp, "&!0t,!1t,!2t)" );
			 else
				codeprint( tp, "&!0t,!1t,(char *)0)" );
			break;
		case N_ARINIT:
			codeprint( tp, "!0t = fresh_array(!1t," );
			cprintf( "%d)",kid0(tp)->ndtype );
			break;
		case N_CALL:
			{
			extern int in_routine;
			if( ((symptr)kid0(kid0(tp)))->sflags & SF_LOCAL &&
							in_routine != ST_FUNC )
				codeprint( tp, "{!0t(!1,); if( score == Accept || score == Reject ) return;}" );
			 else
				codeprint( tp, "!0t(!1,);" );
			}
			break;
		default:
			codeprint( tp, node_table[nt].printcode );
			break;
		}

	cout( tail );

}


codeprint( tp, code )
nodep tp;			/* node being printed */
char *code;			/* code to print */
{
	register char *cp;		/* pointer into print code */
	nodep kid;

	for( cp = code; *cp; cp++ )
		if( *cp == '!' ) {
			if( *++cp >= '0' && *cp <= '9' )
				kid = tp->kids[*cp++-'0'];
			switch( *cp ) {
				case 0:
				case '!':
					coutc( '!' );
					break;
				case 't':
					out( kid );
					break;
				case 'd':
					if( kid ) {
						kid = kid0(kid);
						typeprint(((symptr)kid)->type);
						coutc( ' ' );
						}
					 else
						break;
				case 'i':
					/* preface user names with a 'U' */
					locout( (symptr)kid );
					break;
				case 'n':
				case 'N':
				case 'P':
					{
					char ibuf[20];
					sprintf( ibuf, "%d", (int)kid );
					cout( ibuf );
					break;
					}
				case '$':
					/* for now  worry about escapes later */
					patrout( (char *)kid );
					break;
				case 'l':
					listprint( (listp)kid, "\n" );
					break;
				case ',':
					listprint( (listp)kid, ", " );
					break;
				case '<':
					if( indent_level > 0 )
						--indent_level;
					break;
				case '>':
					++indent_level;
					break;
				default:
					coutc( *cp );
				}
			}
		 else
			coutc( *cp );
				
}


char *union_names[] = {
"uinteger",
"uinteger",
"udate",
"uinteger",
"ustring",
"uusername"
};

char *typenames[] = {
"",
"int",
"datehold",
"newsgroup",
"char *",
"username *",
"dbptr",
"text"
};

char *typabbrevs[] = {
"nul",
"int",
"date",
"ng",
"str",
"name",
"db",
"text"
};


/* print the name of a type */

typeprint( type )
dtype type;
{
	if( type & T_ARRAY )
		cout( "array *" );
	 else
		cout( typenames[ type & T_BASETYPE ] );
}

/* output a byte to the C output file */

coutc( ch )
char ch;
{
	extern FILE *outstream;

	if( ch == '\n' )
		newline();
	 else
		putc( ch, outstream );
}

/* output a string to the C output file */

cout( str )
char *str;
{
	register char *p;
	extern FILE *outstream;

	for( p = str; *p; p++ ) {
		if( *p == '\n' )
			newline();
		 else
			putc( *p, outstream );
		}
}

/* a new line on the output stream */

newline()
{
	int i;
	extern FILE *outstream;


	putc( '\n', outstream );
	for( i = 0; i < indent_level; i++ )
		putc( '\t', outstream );
}

listprint( lp, delim )
listp lp;		/* head of the list */
char *delim;		/* delimiter to put between lists */
{
	listp ourlist;

	for( ourlist = lp; lp; lp = lp->next ) {
		out( lp->kid );
		if( lp->next )
			cout( delim );
		}

}

outsubr( thesym, atlist, code )
symptr thesym;			/* id of the subroutine */
listp atlist;			/* argument list */
nodep code;			/* internal code */
{
	listp sclist;

	indent_level = 0;
	if( thesym->decl_type != ST_PROC ) {
		typeprint( thesym->type );
		coutc( '\n' );
		}
	locout( thesym );
	coutc( '(' );
	for( sclist = atlist; sclist; sclist = sclist->next ) {
		nodep decvar;
		nodep decid;
		symptr idsym;

		if( (decvar = sclist->kid) && (decid = kid0(decvar)) &&
				(idsym = (symptr)kid0(decid)) ) {
			locout( idsym );
			if( sclist->next )
				cout( ", " );
			}
		}
	cout( ")\n" );
	/* now type declare the args */
	for( sclist = atlist; sclist; sclist = sclist->next ) {
		nodep decvar;
		nodep decid;
		symptr idsym;

		if( (decvar = sclist->kid) && (decid = kid0(decvar)) &&
				(idsym = (symptr)kid0(decid)) ) {
			typeprint(idsym->type);
			coutc( ' ' );
			locout( idsym );
			cout( ";\n" );
			}
		}
	indent_level++;
	cout( "{\n" );
	out( code );
	indent_level = 0;
	cout( "\n}\n" );

}

/* output a local symbol name */

locout( sym )
symptr sym;
{
	if( sym->sflags & SF_LOCAL )
		coutc( 'U' );
	cout( sym->name );
}

/* output a string that might be a pattern.
   We read the string from our source, and it contains backslashes,
   expected to act as C escapes.  Those will be \\, \" and backslash
   followed by a letter or an octal number.   These codes will be
   put into the C source as is, so that they turn into the desired
   escapted character.

   If a backslash precedes another character, we will assume that the
   user wanted a real backslash, to escape something for pattern matching.
   We thus double the backslash

   There will be no newslines in this string.
 */

patrout( str )
char *str;
{
	extern FILE *outstream;
	bool escaped;
	char *p;

	putc( '"', outstream );

	escaped = FALSE;

	for( p = str; *p; p++ ) {
		putc( *p, outstream );
		if( *p == '\\' && !escaped ) {
			if( !isalnum(p[1]) && p[1] != '"' && p[1] != '\\' )
				putc( '\\', outstream );
			escaped = TRUE;
			}
		 else
		 	escaped = FALSE;
		}

	putc( '"', outstream );
	
}

