
#include "where.h"

#ifndef ACTFILE
# define ACTFILE	"/lg/lib/news/active"
# define OLDACTFILE	"/lg/lib/news/active.prev"
#endif

#ifndef SPOOLDIR
# define SPOOLDIR	"/u/news"
#endif

typedef long	artnum;
typedef unsigned char boolean;


typedef struct _group {
	char		 *name;		/* Ptr to the storage key.	    */
	struct _group	 *next;		/* Ptr to next hash bucket.	    */
	unsigned char	 flags;		/* Flags -- facts about the bucket. */
	long		group_date;	/* last update to this group */
	artnum		active_lowest;
	artnum		active_highest;
	artnum		recent_article;	/* recent article threshold */
	int		subscribers;	/* subscribers, including sites */
	int		user_subscribers;	/* subscribers, no sites */
	int		recent_readers;	/* read group recently */
	unsigned short	gflags;
	char		group_char;	/* active file flag */
	} group;

/* how far to expand low volume groups to scan better for readers */

#define MULTIPLIER	5


#define GF_DEAD		1		/* group is probably dead */
#define GF_NOGROUP	2		/* group is disabled here */


#define MAX_GNAME	80		/* max length of newsgroup name */
#define MAX_LLEN	512		/* max line length */
#define	MAX_OLD_ARTS	80		/* max old articles to forward */


extern char *strtok();
extern long atol();
extern char *make_spoolname();

#define TRUE 1
#define FALSE 0

	/* seconds in a day */
#define DAY 86400
