.TH WHOIS3 1
.SH NAME
whois3 \- query RIPE Whois server
.SH SYNOPSIS
.B whois3 [-h 
.I host 
.B | --host=
.I host
.B ] [-p
.I port
.B | --port=
.I port
.B ]
.I [whois_options] [whois_query]

.B whois3 [-h
.I host 
.B | --host=
.I host
.B ] [-p
.I port
.B | --port=
.I port
.B ]
-k
.SH DESCRIPTION
.B whois3
allows you to query the RIPE Whois server,
.IR whois.ripe.net .
Most options specified are passed through unchanged to the Whois server.
You can specify an alterate server name and port through the
.I host
and
.I port
options.

To perform a single query, specify any desired flags and the query
as arguments to
.B whois3 .
The query will be performed and the results displayed.

To perform multiple queries, use the
.B -k
option.  Then each query is read from input, sent to the server, and the
result displayed.  Standard input redirection operators work as
expected, allowing you to perform batches of queries by redirecting
input from a file or another program.
.SH OPTIONS
.IP "-h host | --host=host"
Query the server 
.I host
instead of the default server, 
.IR whois.ripe.net .
You may specify either the host name or IP address.
.IP "-p port | --port=port"
Use the port
.I port.
If not specified, then the system default port is used if defined,
otherwise port 43 is used.
.IP -k
Send multiple queries to the server.  Each line of standard input is
read and sent as a query to the server.  Note that if this option is
specified then no query can be specified on the command line.  Also,
this option only works with servers that implement the RIPE extensions 
to the Whois query protocol.
.SH DETAILS ABOUT THE RIPE WHOIS SERVER
The RIPE Whois server responds to queries based on their format, as
documented in the following sections.
.B "These queries and options only apply to the RIPE Whois server."
