/******************
  Copyright (c) 2001,2002                         RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#if 0
We have received errors both from select() and fcntl() claiming that 
they were called on bad file descriptors in "impossible" situations.
The theory is that some other thread has closed the file descriptor.
This can happen, for instance, if another thread attempts to call
close() twice on the same integer.  For example:

   ret_val = 0;
   connect(fd, &addr, sizeof(addr));
     .
     .
     .
   if (error) {
       close(fd);
       ret_val = -1;
       goto get_out;
   }
     .
     .
     .
   get_out:
       close(fd);          /* OOOPS!!!  Bogus second call to close() */
       return ret_val;

In an effort to detect this condition, we introduce this wrapper, which
sets the file descriptor to -1 (an illegal file number) while closing.  
This means that subsequent calls can detect the -1 value and issue an
appropriate warning.

Shane, 2001-07-02
#endif /* 0 */

#include "rip.h"

#include <unistd.h>
#include <stdio.h>
#include <errno.h>

/* undefine our wrappers so we can use the real functions */
#undef close
#undef fclose

int 
fdwrap_close (int *fd, const char *file, int line)
{
    int open_fd;

    /* save the passed file descriptor, and set to -1 */
    open_fd = *fd;
    *fd = -1;

    /* check to see if we've closed this already */
    if (open_fd < 0) {
        /* report error */
        ER_perror(FAC_UT, UT_DUPCLOSE, 
            "close() called on closed file descriptor from %s:%d",
            file, line);

        /* return error */
        errno = EBADF;
        return -1;
    } else {
        /* the usual case, call close() */
        return close(open_fd);
    }
}

int 
fdwrap_fclose (FILE **fp, const char *file, int line)
{
    FILE *open_fp;

    /* save the passed file handle, and set to NULL */
    open_fp = *fp;
    *fp = NULL;

    /* check to see if we've closed this already */
    if (open_fp == NULL) {
        /* report error */
        ER_perror(FAC_UT, UT_DUPCLOSE,
            "fclose() called on closed file handle from %s:%d",
            file, line);

        /* return error */
        errno = EBADF;
        return EOF;
    } else {
        /* the usual case, call fclose() */
        return fclose(open_fp);
    }
}

