/***************************************
  $Revision: 1.2 $

  Radix tree (rx).  er_PM_errors.h - definition of errors for the radix module

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Andrei Robachevsky

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* step 1 */

typedef enum {
	 LOW_PM_OK=0,
	 LOW_PM_BADINP,
	 LOW_PM_INVRANG,
	 LOW_PM_UKNSRC,
	 LOW_PM_NOSQLC,
	 LOW_PM_NOSERN
} PM_err_code_t;

/* step 2 */

#define PM_OK		ER_SEV_I + (FAC_PM<<16) + LOW_PM_OK
#define PM_BADINP       ER_SEV_W + (FAC_PM<<16) + LOW_PM_BADINP
#define PM_INVRANG      ER_SEV_W + (FAC_PM<<16) + LOW_PM_INVRANG
#define PM_UKNSRC       ER_SEV_W + (FAC_PM<<16) + LOW_PM_UKNSRC
#define PM_NOSQLC       ER_SEV_E + (FAC_PM<<16) + LOW_PM_NOSQLC 
#define PM_NOSERN       ER_SEV_E + (FAC_PM<<16) + LOW_PM_NOSERN

/* step 3 */

#ifdef ER_IMPL

er_list_t PM_mod_err[]={
  { ERDUP(PM_OK),  	"OK" },
  { ERDUP(PM_BADINP),  	"Bad input" },
  { ERDUP(PM_INVRANG),  "Invalid serials range" }, 
  { ERDUP(PM_UKNSRC),  	"Unknown source" },
  { ERDUP(PM_NOSQLC),   "No SQL connection" },
  { ERDUP(PM_NOSERN),   "Cannot get serials" },
  ER_LASTTXT
};

#endif /* ER_IMPL */
