/******************
  Copyright (c) 2002                                        RIPE NCC

  All Rights Reserved

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* defined in the inc file */

#ifndef ER_YACC_HELPER_H
#define ER_YACC_HELPER_H

#ifdef __cplusplus
extern "C" {
#endif

void myerror(void *ypar, char *s);
er_ret_t mysetsev(lexerr_t *erst, int ismax, char *spec);
void mycleanup(void *ypar);
void er_yy_tracelog(char *fmt, ...);
int ER_parse_spec(char *buf, char **ert);

/* defined for the lex file */
void lexcleancurbuf(void);
int er_yylex();

/* defined in the lex generated file */
extern void er_yy_delete_buffer();
extern void er_yy_switch_to_buffer();

#ifdef __cplusplus
}
#endif


#endif /* ER_YACC_HELPER_H */
