<%
'************************************************
' Shop subroutines  VP-ASP 6.00
' Numerous product, date  category subroutines
' Nov 11,2005     Fix top sellers Mysql
' nOV 12, 2005    Fix langip
' Dec 31, 2005    Fix fieldvalue mismatch Issue 729
' Dec 31  2005    Update navigateshowcategoriesstyled
' Sep 12 2006	  Added code to CheckDeliveryFree to 
'				  always have free shipping for gift certificate
'*************************************************
Sub SetupProductFieldsXXX (ProdFields, ProdHeaders) 
dim tempfields,swords(20),swordscount,i
tempfields=getconfig("xproductfields")
parserecord tempfields,swords,swordscount,","
redim prodFields(swordscount-1)
for i = 0 to swordscount-1
   prodfields(i)=swords(i)
next   
end sub
'
Sub SetupSearchFields (SearchFields)
dim tempfields,swords(20),swordscount,i
IF strSearchFields = "" THEN
	tempfields=getconfig("xsearchfields")
	ELSE
	tempfields = strSearchFields
END IF
parserecord tempfields,swords,swordscount,","
redim SearchFields(swordscount-1)
for i = 0 to swordscount-1
   searchfields(i)=swords(i)
next   
end sub
'
'*******************************************************************
' This routine puts fields into the cart
'****************************************************************
' Shopcartformat Formats field in cart
Sub GetNameInCart (Rsitem, dbc)
dim tempfields,cartfields(20),fieldcount,i, fieldvalue
dim tempcatalogid
tempfields=getconfig("xcartfields")
if tempfields = "" then
	shoperror getlang("langcommonno") & " "  & getlang("langsearchfields") & " to " & getlang("langeditdisplay")
end if

parserecord tempfields,cartfields,fieldcount,","
nameincart=""
tempcatalogid=rsitem("catalogid")
for i = 0 to fieldcount-1
   If cartfields(i)="cdescription" then
         fieldvalue= memCDescription
         fieldvalue=translatelanguage(dbc, "products", "cdescription","catalogid", tempcatalogid, fieldvalue)
   else
      fieldvalue=rsitem(cartfields(i))
      If lcase(cartfields(i))="cname" then 
           fieldvalue=translatelanguage(dbc, "products", "cname","catalogid", tempcatalogid, fieldvalue)
      end if     
   end if   
   if not isnull(fieldvalue) then    
       if nameincart<>"" then 
          nameincart=nameincart & "<br>"
        end if
         nameincart=nameincart & fieldvalue
    end if      
next   
end sub
Function GetMailCR
'GetMailCR= Chr(13)
GetMailCR= Chr(13) & chr(10)
end function
'
'***************************************************************
' Used throughout the code to create a text form box
'***************************************************************
Sub CreateCustRow (caption, fieldname, fieldvalue, required)
Dim aster
If required="Yes" then 
    aster="* "
else 
    aster="  "
end if
Response.write tablerow & tablecolumn 
Response.write aster & Caption & TablecolumnEnd
Response.write tablecolumn
%><input class="txtfield" style="width:100%" name="<%=fieldname%>" value="<%=fieldvalue%>"><%
Response.write tablecolumnend & tableRowend
end sub
'
Sub CreateCustRowP (caption, fieldname, fieldvalue, required)
Dim aster
If required="Yes" then 
    aster="* "
else 
    aster="  "
end if
Response.write tablerow & tablecolumn 
Response.write aster & Caption & TablecolumnEnd
Response.write tablecolumn
%>
<input class="txtfield" type=password name="<%=fieldname%>" value="<%=fieldvalue%>">
<%
Response.write tablecolumnend & tableRowend
end sub

'******************************************************************
' used in the admin section to create a text form box
'*******************************************************************
Sub FormatEditRow (caption,fieldname,fieldvalue)
dim capdisplay
capdisplay=caption
if capdisplay="" then
       capdisplay=fieldname
end if       
Response.Write TableRow 
Response.write TableColumn & capdisplay & TableColumnEnd
Response.write TableColumn & "<input size=40 name=" & fieldname & " value=" & Chr(34) & fieldvalue & Chr(34) & ">" & vbcrlf
Response.write tableColumnEnd
Response.write TableRowEnd
end sub

Sub FormatEditRowBoolean (caption,fieldname,fieldvalue, Yesnos, Yesnocount)',helpfile)
dim capdisplay
capdisplay=caption
if capdisplay="" then
       capdisplay=fieldname
end if       
Response.Write TableRow 
Response.write "<td width='200'>" & capdisplay & "</td>"
Response.write "<td>" 
GenerateselectNV YesNos,fieldvalue,fieldname,yesnocount, ""
Response.write tableColumnEnd
If helpfile<>"" and getconfig("xproducthelp")="Yes" then 
'  FormatEditHelp fieldname, helpfile
end if  
Response.write TableRowEnd
end sub
'******************************************************************
' used in admin section to create a static equivalent of a text box
'*******************************************************************
Sub FormatEditRowStatic (caption,fieldname,fieldvalue)
dim capdisplay, yfont
capdisplay=caption
if capdisplay="" then
       capdisplay=fieldname
end if 
yfont=xTableRowFont      
Response.Write TableRow 
Response.write TableColumn & capdisplay & TableColumnEnd
Response.write TableColumn &  Yfont & fieldvalue  & xTableRowFontEnd
Response.write tableColumnEnd
Response.write TableRowEnd
end sub

'***********************************************************
' used in admin area to ceate a multirow text area
'************************************************************
Sub FormatEditRowTextArea (caption,fieldname,fieldvalue)
dim capdisplay, rows
capdisplay=caption
if capdisplay="" then
       capdisplay=fieldname
end if 
rows=3      
Response.Write TableRow 
Response.write TableColumn & capdisplay & TableColumnEnd
response.write "<td><Textarea rows=" & rows & " cols=40  name='" & fieldname & "'>" & fieldvalue & "</textarea>" & vbcrlf
Response.write tableColumnEnd
Response.write TableRowEnd
end sub
'***********************************************************************
' if doing help for products and categories
'************************************************************************
Sub FormatEditHelpHeader
if getconfig("xproducthelp")<>"Yes" then exit sub
%>
<script language="JavaScript">
<!-- 
function openWindow(url) {
  popupWin = window.open(url,'new_page','width=500,height=300,scrollbars=yes,resizable=yes,menubar=no,toolbar=no,location=no,status=no,directories=no,copyhistory=no')
  popupWin.focus();
}
// done hiding -->
</script>
<%
end sub
'********************************************************************
' write help column for products and categories
'*******************************************************************
Sub FormatEditHelp(fieldname, helpfile)
if getconfig("xproducthelp")<>"Yes" then exit sub
response.write "<td width='25' align='center'>"
%>
<a href="JavaScript:openWindow('<%=helpfile%>#<%=fieldname%>')"><img src="vpasp_configquestion.gif" border="0"></a>
<%
response.write tablecolumnend
end sub
'
'****************************************************************
' creates category drop down list
'***************************************************************
Sub NavigateShowCategories()
If getconfig("Xnavigatecategories")="No" then exit sub
If getconfig("xlogonrequired")="Yes" then
   If getsess("login")="" then
     exit sub
   end if
end if
If getconfig("init")="" then exit sub     
dim cid, name,catSQL,i
dim strcategory, catcount, categories,maxcategories
Dim catdbc,catrs, hassubcategory,mylink
'catcount=getsess("catcount")
If catcount="" then catcount=0
If xusefilesession="Yes" then
   catcount=0
end if   
If catcount=0  then
  catcount=0
  maxcategories=getconfig("xmaxcategories")
  redim categories(maxcategories)
  ShopOpenDatabaseP catdbc
  If not catdbc.state=adStateOpen  then
      shopclosedatabase catdbc
      exit sub
  end if    
  catSQL="Select * from categories where highercategoryid=0 and cathide is null "
  If getconfig("xselectproductsbylanguage")="Yes" and getsess("language")<>"" then
        catsql=catsql & " and (catlanguage='" & getsess("language") & "'"
        catsql=catsql & " or catlanguage is null)"
  end if
	'VP-ASP 6.08 - Order by config option rather than hardcoded
	 if getconfig("xsortcategories") <> "" then
        catSQL=catsql & " order by " & getconfig("xsortcategories")
    else
        catSQL=catsql & " order by catdescription"
    end if
'  catSQL=catsql & " order by catdescription" 

  set catrs=catdbc.execute(catsql)
  While Not catrs.EOF and catcount<maxcategories
   cid=catrs("categoryid")
   name=catrs("catdescription")
   name=translatelanguage(catdbc, "categories", "catedescription","categoryid", cid, name)
   hassubcategory=catrs("hassubcategory")
   If isnull(hassubcategory) then
     hassubcategory=""
   end if  
   if hasSubcategory ="" then
        mylink="<a HREF=""shopdisplayproducts.asp?id=" & cid & "&amp;cat=" & Server.URLEncode(name) & addwebsesslink & """>" &  name & "</a>" 
   else
      mylink="<a HREF=""shopdisplaycategories.asp?id=" & cid & "&amp;cat=" & Server.URLEncode(name) & addwebsesslink & """>" &  name & "...</a>"
   end if
   categories(catcount)=mylink
   catcount=catcount+1
   catrs.MoveNext
  Wend
  setsessa "categories",categories
  setsess "catcount",catcount
  catrs.Close
  set catrs=nothing
  ShopCloseDatabase catdbc
end if
'
catcount=getsess("catcount")
categories=getsessa("categories")
response.write NavCatTable 
for i = 0 to catcount-1
     mylink=categories(i)
     response.write NavCatRow & NavCatColumn  
     response.write mylink
     response.write NavCatColumnend
  next
  response.write "</table>"
  exit sub
end sub

'Displays stylesheet driven menu
Sub NavigateShowCategoriesStyled()
If getconfig("Xnavigatecategories")="No" then exit sub
If getconfig("xlogonrequired")="Yes" then
   If getsess("login")="" then
     exit sub
   end if
end if
If getconfig("init")="" then exit sub     
dim cid, name,catSQL,i
dim strcategory, catcount, categories,maxcategories
Dim catdbc,catrs, hassubcategory,mylink
'catcount=getsess("catcount")
If catcount="" then catcount=0
If xusefilesession="Yes" then
   catcount=0
end if   
If catcount=0  then
  catcount=0
  maxcategories=getconfig("xmaxcategories")
  redim categories(maxcategories)
  ShopOpenDatabaseP catdbc
  If not catdbc.state=adStateOpen  then
      shopclosedatabase catdbc
      exit sub
  end if    
  catSQL="Select * from categories where highercategoryid=0 and cathide is null "
  if getconfig("xproductmatch")="Yes" then
    catsql=catsql & " and productmatch='" & xproductmatch & "'"
	
	'VP-ASP 6.09 - when using product matching show categories with no association
	catsql=catsql & " OR (productmatch is null and highercategoryid = 0)" 
  end if 
  if getconfig("xproductmatchcustomer")="Yes" then
    if GetSess("CustomerProductGroup")<>"" then
       catsql=catsql & " and (customermatch like '%" & getsess("customerProductgroup") & "%'"
       catsql=catsql & " or customermatch is null)"
    else
       catsql=catsql & " and customermatch is null"
   end if 
 end if 
  If getconfig("xselectproductsbylanguage")="Yes" and getsess("language")<>"" then
        catsql=catsql & " and (catlanguage='" & getsess("language") & "'"
        catsql=catsql & " or catlanguage is null)"
  end if
	'VP-ASP 6.08 - Order by config option rather than hardcoded
   catSQL=catsql & " order by " & getconfig("xsortcategories") 
'  catSQL=catsql & " order by catdescription" 
   set catrs=catdbc.execute(catsql)
  While Not catrs.EOF and catcount<maxcategories
   cid=catrs("categoryid")
   name=catrs("catdescription")
   name=translatelanguage(catdbc, "categories", "catdescription","categoryid", cid, name)
   hassubcategory=catrs("hassubcategory")
   If isnull(hassubcategory) then
     hassubcategory=""
   end if  
   if hasSubcategory ="" then
        mylink="<a HREF=""shopdisplayproducts.asp?id=" & cid & "&amp;cat=" & Server.URLEncode(name) & addwebsesslink & """>" &  name & "</a>" 
   else
      mylink="<a HREF=""shopdisplaycategories.asp?id=" & cid & "&amp;cat=" & Server.URLEncode(name) & addwebsesslink & """>" &  name & "...</a>"
   end if
   categories(catcount)=mylink
   catcount=catcount+1
   catrs.MoveNext
  Wend
  setsessa "categories",categories
  setsess "catcount",catcount
  catrs.Close
  set catrs=nothing
  ShopCloseDatabase catdbc
end if
'
catcount=getsess("catcount")
categories=getsessa("categories")
%>
<table border=0 cellpadding=0 cellspacing=0 width="100%">
<%
for i = 0 to catcount-1
     mylink=categories(i)
%>
  <tr valign='top'>
    <td class=leftmenumain>
<%
     response.write mylink
%>
    </td>
  </tr>
<%  
next
%>
</table>
<%
  exit sub
end sub


' MiniCart
'*******************************************************************
' Create mini cart
' If passed value "SHORT" it creates a small mini cart
'*******************************************************************
Sub NavigateShowMiniCart (itype)
' VP-ASP 5.00
dim showtype
showtype=ucase(itype)
Dim scartItem, arrCart, displayprice
dim dualtotal, dualsubtotal, dualprice
dim totalquantity, totalproductquantity
Dim i, CartFields, total, subtotal, name, quantity, price
scartItem = GetSess("CartCount")
arrCart = GetSessA("CartArray")
If scartitem="" then exit sub
if scartitem=0 then exit sub
dim hideprice

hideprice = false
if getconfig("xdisplayprices") <> "Yes" then
	hideprice = true
end if
if getconfig("xpriceloggedinonly") = "Yes" then
	if Getsess ("login") = "" then
		hideprice = true
	end if
end if

If getconfig("Xnavigateminicart")="No" then exit sub
response.write "<center><br><br>"
If showtype<>"SHORT" Then
  Response.write Minitable 
  response.write MiniTitleRow
  response.write MiniNameTitleColumn & minititlefont & getlang("langProductDescription") & "</b>"  & Minifontend
  response.write MiniPriceColumn & minititlefont &  getlang("langProductQuantity") & "</b>" & Minifontend
 If hideprice <> true then
   response.write MiniPriceColumn & minititlefont & getlang("langProductPrice") & "</b>" & Minifontend
   response.write MiniPriceColumn & minititlefont & getlang("langProductTotal")  & "</b>" & Minifontend
   If getconfig("xdualprice")="Yes" then
     response.write MiniPriceColumn & minititlefont & getlang("langDualPrice") & "</b>" & Minifontend
     response.write MiniPriceColumn & minititlefont & getlang("langDualTotal")  & "</b>" & Minifontend
   end if
 end if 
 Response.write "</tr>"  
end if 

if getconfig("xLCID")<>"" then
   Session.LCID=getconfig("xLCID")             ' set user supplied LCID
end if
total = 0
totalquantity=scartitem
totalproductquantity=0
For i = 1 to scartItem
  Quantity =arrCart(cQuantity,i)
  Price=arrCart(cUnitPrice,i)
  dualprice=arrCart(cdualPrice,i)
  If dualprice="" then dualprice=0
  Name=arrCart(cProductMiniName,i)
  if name="" then 
    Name=arrCart(cProductName,i)
  end if  
  	dim nameconn2
	shopopendatabaseP nameconn2
	name=translatelanguage(nameconn2, "products", "cname","catalogid", arrCart(cProductid,i), name)
	shopclosedatabase nameconn2

  subtotal=quantity*price
  dualsubtotal=quantity*dualprice
  Total=total+subtotal
  dualtotal=dualtotal+dualsubtotal
  totalproductquantity=totalproductquantity+quantity
  If showtype<>"SHORT" Then
   Price=shopformatcurrency(price,getconfig("xdecimalpoint"))
   response.write minirow
   Response.write MiniNameColumn & Minifont &  name &  minicolumnend
   Response.write MiniPricecolumn & MiniFont &  quantity & minicolumnend
    If hideprice <> true then
    Response.write MiniPriceColumn & MiniFont &  Price & minicolumnend
    Response.write MiniPriceColumn & Minifont &  shopformatcurrency(subtotal,getconfig("xdecimalpoint")) & minicolumnend
    If getconfig("xdualprice")="Yes" then
      dualPrice=formatnumber(dualprice,getconfig("xdecimalpoint"))
      Response.write MiniPriceColumn & MiniFont &  dualPrice & minicolumnend
      Response.write MiniPriceColumn & Minifont &  ShopFormatDualCurrency(dualsubtotal,getconfig("xdecimalpoint")) & minicolumnend
    end if 
   end if
   response.write "</tr>"
  end if 
next
If showtype="SHORT" Then
  Response.write MinitableShort 
  response.write MinititleRow
  response.write MiniPriceColumn & minifont &  getlang("langProductQuantity") & Minifontend
  If hideprice <> True then
   response.write MiniPriceColumn & minifont & getlang("langProductPrice") & "</b>" & Minifontend
  end if
  response.write "</tr>"
  response.write minirow
  Response.write  MinipriceColumn & Minifont & totalproductquantity & Minicolumnend
  If hideprice <> true then
  Response.write MinipriceColumn  & minifont & shopformatcurrency(total,getconfig("xdecimalpoint")) & Minicolumnend
  end if
else
 If hideprice <> true then
  response.write "<tr><td>" & minifont & "<b>" & getlang("langMiniexcludes") & "</b>" & minicolumnend & "<td></td>"
  response.write MiniPricecolumn & minifont & minifontend
  response.write MiniPriceColumn & minifont & shopformatcurrency(total,getconfig("xdecimalpoint")) & minifontend
  If getconfig("xdualprice")="Yes" then
    response.write "<td></td>" & MiniPriceColumn & minifont & ShopFormatDualCurrency(dualtotal,getconfig("xdecimalpoint")) & minifontend
  end if  
end if  
end if
response.write "</tr></table>"
If Getconfig("xcurrencylink")="Yes"  Then 
   dim url, cprice
   cprice=shopformatnumber(total,getconfig("xdecimalpoint"))
  url="http://www.x-rates.com/cgi-bin/cgicalc.cgi?value=" &  cprice & "&base=" & Getconfig("Xcurrencybase")
  	  Response.write "<br><a href='" & url & "' target='_blank'>" & "Convert " & Getconfig("xcurrencybase") & " "  & cprice & "</a></b>"
end if  
response.write "</center>"
end sub

Sub NavigateShowMiniCartRight (itype)
'****************************
' VP-ASP 6.00
' formats the minicart in the right menu
'
' Added functionality to remove extended display when "short" option is passed
' VPASP - Michael - 11 Jan 2006
'****************************

dim showtype, sqlmininav
showtype=ucase(itype)
Dim scartItem, arrCart, displayprice
dim dualtotal, dualsubtotal, dualprice
dim totalquantity, totalproductquantity
Dim i, CartFields, total, subtotal, name, quantity, price, URLCart
scartItem = GetSess("CartCount")
arrCart = GetSessA("CartArray")
If (scartitem="") OR (scartitem=0) then 
	response.write getlang("langcartisempty")
	exit sub
end if
dim hideprice

hideprice = false
if getconfig("xdisplayprices") <> "Yes" then
	hideprice = true
end if
if getconfig("xpriceloggedinonly") = "Yes" then
	if Getsess ("login") = "" then
		hideprice = true
	end if
end if

If getconfig("Xnavigateminicart")="No" then exit sub
If showtype<>"SHORT" Then
 If hideprice <> true then
   If getconfig("xdualprice")="Yes" then
   end if
 end if 
end if 

if getconfig("xLCID")<>"" then
   Session.LCID=getconfig("xLCID")             ' set user supplied LCID
end if
total = 0
totalquantity=scartitem
totalproductquantity=0
For i = 1 to scartItem
  Quantity =arrCart(cQuantity,i)
  Price=arrCart(cUnitPrice,i)
  dualprice=arrCart(cdualPrice,i)
  If dualprice="" then dualprice=0
   name=arrcart(cproductname,i)
   URLCart=arrCart(cproductid,i)
    If len(name)>50 then
      name=mid(name,1,50)
    end if   
	dim nameconn
	'VP-ASP 6.09 - changed below database open to shopopendatabaseP to allow for split databases
	shopopendatabaseP nameconn

	'VP-ASP 6.08 - Show Parent Name before product name, if applicable
	'VP-ASP 6.08a - Change variable SQL to SQLMININAV
	sqlmininav = "select catalogid, highercatalogid, cname from products where catalogid = " & URLCart
	dim namers, cname, pname
	set namers = nameconn.execute(sqlmininav)
	if not namers.eof then
		if namers("highercatalogid") > "" then
			cname = namers("cname")
			cname = translatelanguage(nameconn, "products", "cname","catalogid", namers("catalogid"), cname)

			'VP-ASP 6.08a - Change variable SQL to SQLMININAV
			sqlmininav = "select catalogid, cname from products where catalogid = " & namers("highercatalogid")
			set namers = nameconn.execute(sqlmininav)
			
			if not namers.eof then
				pname = namers("cname")
				pname = translatelanguage(nameconn, "products", "cname","catalogid", namers("catalogid"), pname)
				name= pname & " - " & cname
			else
				name=translatelanguage(nameconn, "products", "cname","catalogid", arrCart(cProductid,i), name)
			end if
		else
			name=translatelanguage(nameconn, "products", "cname","catalogid", arrCart(cProductid,i), name)
		end if
	else
		name=translatelanguage(nameconn, "products", "cname","catalogid", arrCart(cProductid,i), name)
	end if
	closerecordset nameconn
	shopclosedatabase nameconn
  subtotal=quantity*price
  dualsubtotal=quantity*dualprice
  total=total+subtotal
  dualtotal=dualtotal+dualsubtotal
  totalproductquantity=totalproductquantity+quantity
   Price=shopformatcurrency(price,getconfig("xdecimalpoint"))

If showtype<>"SHORT" Then
%>
<table width="100%" cellpadding="2" cellspacing="0">
<tr>
	<td valign="top"><%=quantity%></td>
	<td valign="top"><%
		dim exdsql, exdrs, exdconn
		ShopOpenDatabaseP exdconn
		exdsql = "select cdescurl from products where catalogid = " & arrCart(cProductid,i)
		set exdrs = exdconn.execute(exdsql)
		if not exdrs.eof then
			strDescurl = exdrs("cdescurl")
		end if
	   CloseRecordset exdrs
	   ShopCloseDatabase exdconn

		if isnull(strDescurl) then
		   strdescurl=""
		end if

		If strDescURL<>"" then
		    If getconfig("xAddCatalogid")="Yes" then
		       'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
		       strDescURL=strDescURL & "?id=" & arrCart(cProductid,i) & "&bc=no"
		    end if
		else
		    If getconfig("xGenerateShopexdLink")="Yes" then
		         strdescurl="shopexd.asp"
'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
		         strDescURL=strDescURL & "?id=" & arrCart(cProductid,i) & "&bc=no"
		    end if
		end if
		
		if strdescurl > "" then%>
			<a class=cartminilinks href='<%=strDescURL%>'><%=name%></a></td>
		<%else%>
			<%=name%>
		<%end if%>
</tr>
<tr>
	<td valign="top">&nbsp;</td>
	<td valign="top"><%
    If hideprice <> true then
      If getconfig("xdualprice")="Yes" then
	  	dualPrice=formatnumber(dualprice,getconfig("xdecimalpoint"))%>
		<table width="100%" cellpadding="2" cellspacing="0">
		<tr>
			<td valign="top" align="left"><%=Price%></td>
			<td valign="top" align="right"><%=ShopFormatDualCurrency(dualsubtotal,getconfig("xdecimalpoint"))%></td>
		</tr>
		</table><%
      else
		response.write Price
      end if 	  
    end if  %></td>
</tr>
</table>

 <br>
<%
End If
next

If showtype<>"SHORT" Then
  response.write "</td></tr><tr><td class=""cartsubtotalminicart"">"
  response.write "<hr size=""1"" noshade color=""#cccccc"">"
End If
	if hideprice <> true then
	If showtype="SHORT" Then
		response.write getlang("langcart01") & totalproductquantity & "<br/>"
	End If
  response.write getlang("langcommonsubtotal") & ": " & shopformatcurrency(total,getconfig("xdecimalpoint")) & vbcrlf
  If getconfig("xdualprice")="Yes" then
    response.write ShopFormatDualCurrency(dualtotal,getconfig("xdecimalpoint"))
  end if  
	 end if
  response.write "<br><a href='shopaddtocart.asp'>" & getlang("langcommonviewcart") & "</a>" & vbcrlf

	'VP-ASP 6.09 - add currency link to bottom of minicart
	If Getconfig("xcurrencylink")="Yes"  Then 
	   dim url, cprice
	   cprice=shopformatnumber(total,getconfig("xdecimalpoint"))
	  url="http://www.x-rates.com/cgi-bin/cgicalc.cgi?value=" &  cprice & "&base=" & Getconfig("Xcurrencybase")
	  Response.write "<br><a href='" & url & "' target='_blank'>" & "Convert " & Getconfig("xcurrencybase") & " "  & cprice & "</a></b>"
	end if  
end sub


'********************************************************************
' creates quick go to categories
' currently used in shoppage_header.htm
'*********************************************************************
Sub NavigateShowAllCategories()
If getconfig("xlogonrequired")="Yes" then
   If getsess("login")="" then
     exit sub
   end if
end if 
if getconfig("init")="" then exit sub    
dim cid, name,catSQL,i
dim strcategory, catcount, categories,maxcategories, categoryids, subcategories
Dim catdbc,catrs, hassubcategory,mylink
dim strpagename
catcount=getsess("allcatcount")
If catcount="" then catcount=0
If getconfig("xtranslate")="Yes" then
  catcount=0
end if  
If catcount=0  then
  catcount=0
  maxcategories=getconfig("xmaxcategories")
  redim categories(maxcategories)
  redim categoryids(maxcategories)
  redim subcategories(maxcategories)
  ShopOpenDatabaseP catdbc
    If not catdbc.state=adStateOpen  then
      shopclosedatabase catdbc
      exit sub
  end if    
  catSQL="Select * from categories where cathide is null order by catdescription"
  set catrs=catdbc.execute(catsql)
  While Not catrs.EOF and catcount<maxcategories
   cid=catrs("categoryid")
   name=catrs("catdescription")
   name=translatelanguage(catdbc, "categories", "catdescription","categoryid", cid, name)
   hassubcategory=catrs("hassubcategory")
   if isnull(hassubcategory) then hassubcategory=""
   categories(catcount)=name
   categoryids(catcount)=cid
   subcategories(catcount)=hassubcategory
   catcount=catcount+1
   catrs.MoveNext
  Wend
  setsessa "allcategories",categories
  setsessa "allcategoryids",categoryids
  setsess "allcatcount",catcount
  setsessa "allcatsubcategories",subcategories
  catrs.Close
  set catrs=nothing
  ShopCloseDatabase catdbc
end if
dim optionval, category
catcount=getsess("allcatcount")
categories=getsessa("allcategories")
categoryids=getsessa("allcategoryids")
subcategories=getsessa("allcatsubcategories")
%>
<form name='catnavForm'>
<select name="menu" onChange = "self.location = document.catnavForm.menu[document.catnavForm.menu.selectedIndex].value;" style="color: #000000; font-size: 8 pt; font-family: Verdana" size="1">
<option selected><%=getlang("langcat01")%></option>
<%
dim url, suffix

For i = 0 to catcount-1
  cid=categoryids(i)
  category=categories(i) 
  hassubcategory=subcategories(i)
  if hassubcategory<>"" then 
    strPageName = "shopdisplaycategories.asp"
    suffix="..."    
  else 
    strPageName = "shopdisplayproducts.asp"
    suffix=""
  end if 
  url="" & strPageName & "?id=" & cid & "&cat=" & server.urlencode(category)
  url=addwebsess(url)
'  url="shopdisplayproducts.asp?id=" & cid & "&cat=" & server.urlencode(category)
  response.write "<option value='" & url & "'>" & category & Suffix &  "</option>" & vbcrlf
next
response.write "</select></form>"
end sub

Sub CorrectBooleanProgram (fieldvalue)
'If it is yes set to 1 else set to 0
If isnull(fieldvalue) or fieldvalue=""  then
   fieldvalue=0
end if
' Dec 31, fix   
If not isnumeric(fieldvalue) then
   fieldvalue=0
end if   
'
If fieldvalue<>0 then
   fieldvalue=yesnos(0)    ' Yes
else
   fieldvalue=yesnos(1)    ' no
end if
end sub

Sub CorrectBooleanHuman (fieldvalue)
'If it is yes set to 1 else set to 0
If fieldvalue=yesnos(0) then
   fieldvalue=1
else
   fieldvalue=0
end if      
end sub
'
'**************************************************************
' Used in shipping calculation to get total weight including
' feature weight
'***********************************************************
' Get total weight of products
Sub GetTotalProductWeight (conn,totalWeight,totalfeatureweight)
dim prodid, prodcode, prodname, Prodquantity, ProdPrice, prodweight
dim rsitem, deliveryarray, deliverytype, prodfeatures
dim i, calculate
dim featureweight
dim weight, shipsql
scartItem = GetSess("CartCount")
arrCart =   GetSessA("CartArray")
totalweight=0
totalfeatureweight=0
' go through all products
For i = 1 to scartItem
    Calculate=True
    prodid=arrCart(cProductid,i)
    prodcode=arrCart(cProductCode,i)
    prodname= arrCart(cProductname,i)
    Prodquantity=arrCart(cQuantity,i)
    ProdPrice=arrCart(cUnitPrice, i)
    ProdFeatures=arrCart(cProductFeatures, i)
    Prodweight=arrCart(cProductweight, i)
    DeliveryArray=arrCart(cDelivery, i)
    If getconfig("Xdeliveryshipping")="Yes"  and isarray(deliveryarray) then
       Deliverytype=Deliveryarray(dDeliveryType)
       If Deliveryarray(dDeliveryType)<>getlang("langDeliverySelf") then
          Calculate=False
       end if
    end  if
    If calculate=True then
       weight=prodweight
      ' Debugwrite "name=" & prodname & " quantity " & prodquantity & " weight=" & weight
       if weight<>""  and isnumeric(weight) then
          weight=csng(weight)
        else
           weight=0
        end if
       
        weight=weight*ProdQuantity 
        TotalWeight=weight+totalweight
        If Getconfig("xfeatureweight")="Yes" and prodfeatures<>"" then
            GetTotalfeatureweight conn, prodid, prodfeatures, featureweight
        end if
        featureweight=featureweight*prodquantity
        totalfeatureweight=totalfeatureweight+featureweight
     end if 
Next
TotalWeight=totalweight+Totalfeatureweight      
SetSess "Totalweight",Totalweight
'debugwrite "totalweight=" & totalweight
end sub

'*********************************************************************
' features come in as a list 5,9,11
' reread the feature record and get weight from featureother1
'****************************************************************
Sub GetTotalfeatureweight (dbc, prodid, prodfeatures, featureweight)
dim sql, rs, tweight, totalweight, weight
dim words(50), wordcount,i
featureweight=0
if prodfeatures="" then exit sub
parserecord prodfeatures,words,wordcount,","
totalweight=0
for i = 0 to wordcount-1
   weight=0 
   sql="select * from prodfeatures where id=" & words(i)
    set rs=dbc.execute(sql)
   if not rs.eof then
      tweight=rs("featureweight")
       if not isnull(tweight) then
         if isnumeric(tweight) then
             weight=csng(tweight)
         end if
       end if
    end if
    totalweight=totalweight+weight 
    closerecordset rs
next
featureweight=totalweight
'debugwrite "feature weight=" & totalweight    
end sub

'***********************************************************************
' write login form for shopcustomer, shopcustadminlogin
'************************************************************************
Sub ShopLOginForm_old
Dim caption
If getconfig("xcustomeruserid")="Yes" then 
      caption=getlang("langAdminUsername")
else
     caption=getlang("langStatusEmail")
end if
If ucase(getconfig("Xpassword"))="YES" then
	Response.Write("<form name=form1 method=Post action=shoplogin.asp>")
	Response.Write TableDefLogin
        Response.Write (tablerow)
   If ucase(getconfig("xPasswordLastname"))="YES" then
        response.write (tablecolumn & getlang("langCustLastname") & tablecolumnend & "<td><input size=20 name=strLastname value=" & Chr(34) & strLastname & Chr(34) & "></td>")
   end if
	Response.Write(tablecolumn & caption & tablecolumnend & Tablecolumn &  "<input size=20 name=strEmail>" & tablecolumnend)
        Response.Write(tablecolumn & getlang("langLoginPassword") & tablecolumnend & Tablecolumn & "<input size=10 type=password name=strPassword>" & tablecolumnend)
        response.write tablecolumn
        shopbutton getconfig("xbuttonlogin"),getlang("langcommonlogin"),""
        Response.write Tablecolumnend
        Response.write "</tr></table>"
        addwebsessform
        response.write "</form>"
        response.write ("<a href=shopmailpwd.asp?pwd=yes" & addwebsesslink & ">" & getlang("langLoginForgot") & "</a>")
else
	Response.Write("<form name=form1 method=Post action=shoplogin.asp>")
   	Response.Write TableDefLogin
	Response.Write(tablerow & tablecolumn & getlang("langCustLastname") & tablecolumnend & "<td><input size=20 name=strLastname value=" & Chr(34) & strLastname & Chr(34) & "></td>")
	Response.Write(tablecolumn & getlang("langCustEmail") & tablecolumnend & "<td><input size=20 name=strEmail" & "></td>")
	response.write tablecolumn
	shopbutton getconfig("xbuttonlogin"), getlang("langcommonlogin"),""
	Response.write Tablecolumnend
        Response.write "</tr></table>"
        addwebsessform
        response.write "</form>"
end if
end sub


Sub ShopLOginForm
Dim caption
If getconfig("xcustomeruserid")="Yes" then 
      caption=getlang("langAdminUsername")
else
     caption=getlang("langStatusEmail")
end if
%><table width="90%" cellspacing="6" cellpadding="6">
	<tr>
		<td colspan="2"><table width="100%">
			<tr>
				<td valign="middle" align="left"><h2><%=getlang("langCust01")%></h2></td>
				<td valign="top"><div align="right"><img src="images/site/customerlogin.gif" border="0"></div></td>
			</tr>
		</table></td>
	</tr>
	<tr>
		<!--VP-ASP 6.08 - Translate titles and buttons-->
		<td align="left"><strong><%=getlang("langlogin03")%></strong></td>
		<td align="left"><strong><%=getlang("langcommonlogin")%></strong></td>
	</tr>
	<tr>
		<td valign="top" class="dottedBorder" width="50%" align="left">
		<% dim currentpage
			currentpage = request.ServerVariables("SCRIPT_NAME")
			currentpage = right(currentpage, len(currentpage) - instrrev(currentpage, "/"))
			
			If currentpage = "shopcustadminlogin.asp" then
				If getconfig("xAllowcustomerregister")="Yes" Then%>
					<%=getlang("langnewcustomerregister01")%>
					<br><br><br>
					<div align="right"><input type="button" class="submitbtn" value="<%=getlang("langcommonsignup")%>" onclick="location.href='shopcustregister.asp'"></div>
				<%end if 
			else%>
					<%=getlang("langnewcustomerregister02")%>
					<br><br><br>
					<div align="right"><input type="button" class="submitbtn" value="<%=getlang("langcommonsignup")%>" onclick="location.href='shopcustomer.asp?new=yes'"></div>				
			<%end if%>
		</td>
		<td valign="top" class="dottedBorder" width="50%" align="left">
			<%=getlang("langreturningcustomers")%>
			<br>
			<% If ucase(getconfig("Xpassword"))="YES" then %>
			<form name=form1 method=Post action="shoplogin.asp">
				<table cellpadding=2 cellspacing=1 border=0 width="100%">
					<% If ucase(getconfig("xPasswordLastname"))="YES" then %>
					<tr>
						<td width="30%"><%=getlang("langCustLastname")%></td>
						<td><input class="textarea" size=20 name=strLastname value="<%=Chr(34) & strLastname & Chr(34)%>"></td>
					</tr>
					<% end if %>
					<tr>
						<td width="30%"><%=caption%></td>
						<td><input class="textarea" size=20 name=strEmail></td>
					</tr>
					<tr>
						<td width="30%"><%=getlang("langLoginPassword")%></td>
						<td><input size=10 class="textarea" type=password name=strPassword></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td><div align="right"><%shopbutton getconfig("xbuttonlogin"),getlang("langcommonlogin"),""%></div></td>
					</tr>
				</table>
				<% addwebsessform %>
				</form>
				<div align="center"><a href="shopmailpwd.asp?pwd=yes<%addwebsesslink%>"><%=getlang("langLoginForgot")%></a></div>
			<% else %>
				<form name=form1 method=Post action=shoplogin.asp>
				 <table cellpadding=2 cellspacing=1 border=0 width="100%">
					<tr>
						<td width="30%"><%=getlang("langCustLastname")%></td>
						<td><input class="textarea" size=20 name=strLastname value=<%=Chr(34) & strLastname & Chr(34)%>></td>
					</tr>
					<tr>
						<td width="30%"><%=getlang("langCustEmail")%></td>
						<td><input size=20 class="textarea" name=strEmail></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td><div align="right"><%shopbutton getconfig("xbuttonlogin"), getlang("langcommonlogin"),""%></div></td>
					</tr>
				</table>
				<%addwebsessform%>
				</form>
			<% end if %>
		</td>
	</tr>
</table><%
end sub
'*********************************************************************
' Display all products in a quick shop list
'********************************************************************
Sub NavigateShowProducts
dim dbc, rs, sql
shopopendatabaseP dbc
%>
<form name='prodnavForm'>
<select name="menu" onChange = "self.location = document.prodnavForm.menu[document.prodnavForm.menu.selectedIndex].value;" style="color: #000000; font-size: 8 pt; font-family: Verdana" size="1">
<%
sql="SELECT * FROM products ORDER by catalogid"
set rs=dbc.execute(sql)
Do While Not rs.EOF '
%>
<OPTION VALUE="<%getconfig("xmysite")%>shopaddtocart.asp?productid=<%= rs("catalogid") %>&quantity=1"> <%= rs("cname") %> </option>
<%
rs.MoveNext
Loop 
response.write "</SELECT></form>"
Closerecordset rs
shopclosedatabase dbc
end sub

Sub NavigateTopTen
if getconfig("xtopsellers") <> "Yes" then exit sub
If getconfig("xlogonrequired")="Yes" then
   If GetSess("Login")="" then
      exit sub
   end if
end if
If getconfig("xshopclosed")="Yes" then
   If Getsess("Login")="Force" then
      exit sub
   end if
   if getsess("shopadmin")="" then
      shoperror getlang("Langshopclosed")
   end if   
end if   
'******************************************************
' Find all products sold
'*******************************************************
dim strsql, dbc, odbc, useorderdb
Dim rs

strsql="select o.catalogid, sum(o.numitems) as sumofnumitems"
strsql=strsql & " from oitems o, orders p"
if getconfig("xtopsellersprocessedonly") = "Yes" then
	'VP-ASP 6.08 - xdatabase was incorrectly used in (instr(lcase(xdatabasetype), "mysql")>0)
	if ucase(xdatabasetype)="SQLSERVER" OR getconfig("xmysql") = "Yes" OR (instr(lcase(xdatabasetype), "mysql")>0) then
		strsql=strsql & " WHERE o.orderid=p.orderid and p.oprocessed=1"
	else
		strsql=strsql & " WHERE o.orderid=p.orderid and p.oprocessed=TRUE"
	end if
end if
strsql=strsql & " GROUP BY o.catalogid"
'VP-ASP 6.08 - xdatabase was incorrectly used in (instr(lcase(xdatabasetype), "mysql")>0)
if getconfig("xmysql") = "Yes" OR (instr(lcase(xdatabasetype), "mysql")>0)then
	strsql=strsql & " ORDER BY sumofnumitems DESC"
else
	strsql=strsql & " ORDER BY sum(o.numitems) DESC"
end if



'strsql="select sum(oitems.numitems) as sumofnumitems, oitems.catalogid AS catalogid "
'strsql=strsql & "from oitems "
'strsql=strsql & "inner join products on oitems.catalogid = products.catalogid "
'strsql=strsql & "where products.highercatalogid IS NULL "
'strsql=strsql & "GROUP BY oitems.catalogid "
'strsql=strsql & "UNION "
'strsql=strsql & "select sum(oitems.numitems) as sumofnumitems, products.highercatalogid AS catalogid "
'strsql=strsql & "from oitems "
'strsql=strsql & "inner join products on oitems.catalogid = products.catalogid "
'strsql=strsql & "where NOT products.highercatalogid IS NULL "
'strsql=strsql & "GROUP BY products.highercatalogid "
'strsql=strsql & "ORDER BY sumofnumitems DESC "
openorderdb odbc
set rs=odbc.execute(strsql)
TopTenProducedetail odbc,rs
closerecordset rs
shopclosedatabase odbc
end sub
'******************************************************************
' Format the top ten products
'*******************************************************************
'VP-ASP 6.08 - Sub re-written to hide out of stock products
Sub TopTenProduceDetail (dbc,rs)
dim count, fieldvalue, prs, scriptresponder, filename, lngcatalogid, ordercount,hideprod
dim strcname, strhcname, psql, pdbc,lnghighercatalogid 
dim limit
limit=cint(getconfig("xtopsellerlimit"))
if limit = "" or isnull(limit) then
	limit = 5
end if
'limit=10
count=0
Response.write "<table border=0 cellpadding=0 cellspacing=0 width=""100%"">"
do While Not rs.EOF and count<limit 
	hideprod = false
	lngcatalogid=rs("catalogid")
   ordercount=rs("sumofnumitems")

	shopopendatabaseP pdbc
	psql = "select cname, highercatalogid, hide from products where catalogid = " & lngcatalogid
	set prs=pdbc.execute(psql)
	
	if not prs.eof then
		if prs("highercatalogid") > "" then
			lnghighercatalogid = prs("highercatalogid")
else
lnghighercatalogid = ""
		end if
		end if
	closerecordset prs
	
	if lnghighercatalogid > "" then
		psql="select p.cname AS cname, p.cstock as cstock, hp.cname AS hpcname, hp.hide from products p, products hp where p.highercatalogid = hp.catalogid AND p.catalogid =" & lngcatalogid
	else
	   psql="select * from products where catalogid=" & lngcatalogid		
	end if
   set prs=pdbc.execute(psql)
   If not prs.eof then	
' response.write prs("cname") & "/" & count & "/" & limit & "<BR>"
if (prs("hide") = 1) or (lcase(prs("hide")) = "true") then
hideprod = true
end if

if getconfig("xstockcontrol")= "Yes" then
	dim stocklowlevel
	if getconfig("xstocklow") = "" or ISNULL(getconfig("xstocklow")) then 
		stocklowlevel = 0
	else
		stocklowlevel = getconfig("xstocklow")
	end if


	'VP-ASP 6.09 - If stockcontrol is on and the stock field of product was blank, there was an error here.
	dim dbproductstock
	dbproductstock = prs("cstock")
	if isNull(dbproductstock) Or dbproductstock = "" Then
		dbproductstock = 0
	end if

	if cint(dbproductstock) <= cint(stocklowlevel) then
			hideprod = true
	end if

'	if cint(prs("cstock")) <= cint(stocklowlevel) then
'			hideprod = true
'	end if
end if

if lnghighercatalogid > "" then
strcname = prs("cname")
	 strhcname = prs("hpcname")
	 strhcname=translatelanguage(dbc, "products", "cname","catalogid", lnghighercatalogid, strhcname) 
	 strcname = translatelanguage(dbc, "products", "cname","catalogid", lngcatalogid, strcname)
	 strcname = strhcname & " - " & strcname
	else
	 strcname=prs("cname")
	 strcname=translatelanguage(dbc, "products", "cname","catalogid", lngcatalogid, strcname)
	end if
	
	if hideprod <> true then
		 Response.write "<tr>"
		 filename=getconfig("xcrosslinkurl")
	
		if lnghighercatalogid > "" then
			 If ucase(filename)="SHOPEXD.ASP" then
			'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
			  scriptresponder="shopexd.asp?id=" & lnghighercatalogid & "&bc=no"
			 else
			 'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
			  scriptresponder="shopquery.asp?catalogid=" & lnghighercatalogid & "&bc=no"
			 end if    	
		else
			 If ucase(filename)="SHOPEXD.ASP" then
			  'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
			  scriptresponder="shopexd.asp?id=" & rs("catalogid") & "&bc=no"
			 else
			  'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
			  scriptresponder="shopquery.asp?catalogid=" & rs("catalogid") & "&bc=no"
			 end if    
		end if

		 fieldvalue="<a HREF=" & scriptresponder &">" & strcname & "</a>"
		 Response.write "<td class=""leftmenumain"">" & fieldvalue & "</td>"
		 Response.write "</tr>"
		 count=count+1
	   end if
	end if
   closerecordset prs
   shopclosedatabase pdbc
   rs.movenext
loop
%>
</table>
<%
end sub


Sub  Navigateshowalphabet
'**********************************************************************
' create a list of letters with hyperlink to display products starting with
' those letters
' If your language has different characters please replace them in myarray
'****************************************************************************
dim alphaarray(100), alphak, letters, alphacount
If getconfig("xalphabetdisplay")<>"Yes" then exit sub
letters = getconfig("xalphabet")
if letters="" then exit sub
parserecord letters,alphaarray, alphacount,"," 
response.write TableDef & tablerow & tablecolumn
for alphak=0 to alphacount-1
   response.write "<a href='shopquery.asp?queryprefix=No&cname=" & alphaarray(alphak) & addwebsesslink & "'>" & alphaarray(alphak) & "</a>"
   response.write "&nbsp;"
next
response.write tablecolumnend & tablerowend & tabledefend
End Sub

Function GetProductOrderTotal
dim Prodquantity, ProdPrice
dim scartItem,arrCart, total
scartItem = GetSess("CartCount")
arrCart =   GetSessA("CartArray")
total=0
' go through all products
For i = 1 to scartItem
    Prodquantity=arrCart(cQuantity,i)
    ProdPrice=arrCart(cUnitPrice, i)
    total=total+prodquantity*prodprice
Next
SetSess "Productordertotal",Total
GetProductOrderTotal=total
end function

Function NavigateProducttotal 
	Dim i, stotal, iqtytotal
	Dim arrCart, cartcount
	Dim Quantity							
	iQtyTotal = 0
	stotal=0
	arrCart = GetSessA("CartArray")
	cartcount=getsess("cartcount")
	For i = 1 to cartcount
	  Quantity =arrCart(cQuantity,i)
	  sTotal = sTotal + Quantity * cDbl("0" & arrCart(cUnitPrice,i))
	  iQtyTotal = iQtyTotal + Quantity
	Next
	navigateproducttotal= shopformatcurrency(sTotal,getconfig("xdecimalpoint"))
end function	
Function NavigateProductQuantity 
	Dim i, stotal, qtytotal
	Dim arrCart, cartcount
	Dim Quantity							
	QtyTotal = 0
	arrCart = GetSessA("CartArray")
	cartcount=getsess("cartcount")
	For i = 1 to cartcount
	  Quantity =arrCart(cQuantity,i)
	  Qtytotal = Qtytotal + Quantity
	Next
	navigateproductquantity=QtyTotal
end function	

Function GenerateDateList (name, currentvalue, maxvalue, daysofweek, excludelist)
dim i, j, count, downame, currentdate, displaypart
dim value, dow, dayscount, daysarray(10)
dim selected, excludes(10), excludecount
parserecord daysofweek, daysarray,dayscount, ","
If excludelist<>"" then
   parserecord excludelist, excludes, excludecount,","
   for i=0 to excludecount-1
      If not isnumeric(excludes(i)) then excludes(i)=0
      excludes(i)=clng(excludes(i))
   next   
end if
currentdate=currentvalue
If  not isdate(currentdate) then
   currentdate=date()
else
  currentdate=cdate(currentdate)
end if   
count=0
value="<SELECT name='" & name & "'>" 
do while maxvalue>count
   if currentdate=currentvalue then
        Selected="Selected"
   else
       Selected=""
   end if
   dow=weekday(currentdate)
  ' debugwrite currentdate & " " & dow
   downame=daysarray(dow-1)
   If excludecount>0 then
      for j =0 to excludecount-1
         if dow=(excludes(j)) then
            downame=""
            exit for
         end if
       next
   end if
   If downame<>"" Then 
     count=count+1          
     Displaypart = currentdate & " " & downame
     value=value & "<OPTION " & selected & " value='" & currentdate & "'>" & displaypart & "</OPTION>"
   end if
   currentdate=currentdate+1  
  ' debugwrite value
loop
value=value & "</select>"
Generatedatelist=value
end function

'****************************************************************************
' SQL injection Function
'***************************************************************************
function Gettextfield(fieldname)
dim fieldvalue
dim badchars, i
fieldvalue=request(fieldname) 
if fieldvalue="" then
   gettextfield=fieldvalue
   exit function
end if
badChars = array("select", "drop", ";", "--", "insert",  "delete", "xp_","union","char","@@") 
for i = 0 to uBound(badChars) 
   if instr(1,fieldvalue,badchars(i),1)>0 then
      fieldvalue=""
      gettextfield=fieldvalue
      exit function
   end if    
next 
fieldvalue=replace(fieldvalue,"'","''")
gettextfield=fieldvalue
end function 

'****************************************************************************
' SQL injection Function
'***************************************************************************
function GetIntField(fieldname)
dim fieldvalue
fieldvalue=request(fieldname)
if fieldvalue<>"" then 
   if not isnumeric(fieldvalue) then
      fieldvalue=""
   end if   
end if
GetIntField=fieldvalue
end function 

'**************************************************************
' Used in shipping calculation to get total weight including
' feature weight
'***********************************************************
' Get total weight of products
Sub CalculateShippingdetails (conn,totalWeight,totalfeatureweight, cost, quantity)
dim prodid, prodcode, prodname, Prodquantity, ProdPrice, prodweight
dim rsitem, deliveryarray, deliverytype, prodfeatures
dim i, calculate
dim featureweight
dim weight, shipsql
scartItem = GetSess("CartCount")
arrCart =   GetSessA("CartArray")
totalweight=0
totalfeatureweight=0
quantity=0
cost=0
' go through all products
For i = 1 to scartItem
    Calculate=True
    prodid=arrCart(cProductid,i)
    prodcode=arrCart(cProductCode,i)
    prodname= arrCart(cProductname,i)
    Prodquantity=arrCart(cQuantity,i)
    ProdPrice=arrCart(cUnitPrice, i)
    ProdFeatures=arrCart(cProductFeatures, i)
    Prodweight=arrCart(cProductweight, i)
    calculate=checkdeliveryfree(conn, prodid)
    If calculate=True then
       weight=prodweight
      ' Debugwrite "name=" & prodname & " quantity " & prodquantity & " weight=" & weight
       if weight<>""  and isnumeric(weight) then
          weight=csng(weight)
        else
           weight=0
        end if
        weight=weight*ProdQuantity 
        TotalWeight=weight+totalweight
        If Getconfig("xfeatureweight")="Yes" and prodfeatures<>"" then
            GetTotalfeatureweight conn, prodid, prodfeatures, featureweight
        end if
        featureweight=featureweight*prodquantity
        totalfeatureweight=totalfeatureweight+featureweight
        quantity=quantity+prodquantity
        cost=cost+(prodquantity*prodprice)
     end if 
Next
TotalWeight=totalweight+Totalfeatureweight  
'Debugwrite "weight=" & totalweight & " cost=" & cost & "quantity=" & quantity  
SetSess "Totalweight",Totalweight
'debugwrite "totalweight=" & totalweight
end sub

'************************************************************************
' read product record to see if it has free shiping
' returns true if product does NOT have free shipping
'***************************************************************************
Function CheckDeliveryFree(prodconn, prodid)
' returns true if product should be used in calculation
dim psql, prs, rc, shippingfree
rc=true
' ignore specific products from any shipping calculate if false is returned    
If getconfig("xshippingfreeproducts")<>"Yes" then 
   checkdeliveryfree=rc            
   exit function
end if

'VP-ASP 6.09 - always have free shipping for gift certs
if prodid = getconfig("xgiftproductid") then
 rc=false
 checkdeliveryfree=rc    
 exit function
end if

psql="select * from products where catalogid=" & prodid
set prs=prodconn.execute(psql)
if not prs.eof then
    shippingfree=prs("freeshipping")
    if not isnull(shippingfree) then
        if shippingfree<>0 then
            rc=false
         end if
    end if
end if
closerecordset prs
checkdeliveryfree=rc            
end function

Sub ShopConvertCurrencyLink (total, link)
link=""
dim msg
If Getconfig("xproductconvertcurrency")<>"Yes"  Then exit sub
  dim url, cprice
  cprice=shopformatnumber(total,getconfig("xdecimalpoint"))
  msg=getlang("langconvert") & " " & cprice 
  url="<a href=""#"" OnClick=""window.open('http://www.x-rates.com/cgi-bin/cgicalc.cgi?value=" & cprice & "&base=" & getconfig("xcurrencybase") & "','','width=550,height=400,menubar=no,toolbar=no,location=no,status=no,directories=no,copyhistory=no,resizable=yes,scrollbars=yes')"">"
  url=url & msg 
  url=url & "</a>"
  link=url
end sub

'
'****************************************************************
' creates category drop down list
'***************************************************************
Sub NavigateShowContent()
If getconfig("xlogonrequired")="Yes" then
   If getsess("login")="" then
     exit sub
   end if
end if
If getconfig("init")="" then exit sub     
dim cid, name,catSQL,i, contentlist, contentarray, contentcount
dim strcategory, catcount, maxcontentarray, strpagename
Dim catdbc,catrs, prevname,mylink
contentcount=getsess("contentcount")
If contentcount="" then contentcount=0
If contentcount=0  then
  maxcontentarray=20
  redim contentarray(maxcontentarray)
  ShopOpenDatabase catdbc
  If not catdbc.state=adStateOpen  then
      shopclosedatabase catdbc
      exit sub
  end if    
  catSQL="Select * from content where hide=0 "
  catSQL=catsql & " order by messagetype,contentid desc"
  set catrs=catdbc.execute(catsql)
  While Not catrs.EOF and contentcount<maxcontentarray
   name=catrs("messagetype")
   if lcase(name)<>lcase(prevname) then 
        mylink=name
        contentarray(contentcount)=name
        contentcount=contentcount+1
        prevname=name
   end if          
   catrs.MoveNext
  Wend
  setsessa "contentarray",contentarray
  setsess "contentcount",contentcount
  catrs.Close
  set catrs=nothing
  ShopCloseDatabase catdbc
end if
contentcount=getsess("contentcount")
contentarray=getsessa("contentarray")
If contentcount="" then exit sub
if contentcount=0 then exit sub
%>
<form name='contentnavForm'>
<select name="menu" onChange = "self.location = document.contentnavForm.menu[document.contentnavForm.menu.selectedIndex].value;" style="color: #000000; font-size: 8 pt; font-family: Verdana" size="1">
<option selected><%=getlang("langcontent")%></option>
<%
dim url, suffix, contentlink
strpagename="shopcontent.asp"
For i = 0 to contentcount-1
  contentlink=contentarray(i) 
  url="" & strPageName & "?type=" & server.urlencode(contentlink)
  url=addwebsess(url)
  response.write "<option value='" & url & "'>" & contentlink &  "</option>" & vbcrlf
next
response.write "</select></form>"
end sub
'
'
'***************************************************************************
' display all categories and their subcategories
' VP-ASP 5.00
' Nov 29, 2004
'*****************************************************************************
Sub NavigateShowCategorylist
dim sql, rs, level, rc, catdescription, spacing, categoryid
dim highercategoryid, hassubcategory
Dim dbconn
highercategoryid=0
shopopendatabaseP dbconn
navGeneratesql sql, highercategoryid
set rs=dbconn.execute(sql)
Response.write "<table width='60%'>"
response.write "<tr>"
response.write "<td align=left>"
do while not rs.eof
    navGetcategoryfields rs,categoryid, hassubcategory, catdescription, rc, dbconn
    If rc=0 then 
       spacing=0
       FormatcategoryList categoryid, catdescription, spacing
        If hassubcategory<>"" then 
          Formatsubcategories categoryid,spacing, dbconn
       end if   
    end if
    rs.movenext   
loop
closerecordset rs
shopclosedatabase dbconn
Response.write "</td></tr></table>"
end sub

Sub NavGetcategoryfields (rs, categoryid, hassubcategory, strcategory, rc, catdbc)
   dim strcathide
   categoryid=rs("categoryid")
   strcategory=rs("catdescription")
   strcategory=translatelanguage(catdbc, "categories", "catdescription","categoryid", categoryid, strcategory)
   hassubcategory=rs("hassubcategory")
   If isnull(hassubcategory) then
      hassubcategory=""
   end if
   strcathide=rs("cathide")          ' hide field
   if isnull(strcathide) then
      rc=0
   else
      rc=4
   end if
end sub

Sub navGeneratesql (sql, highercategoryid)
SQL="Select * from categories "
sql = Sql & " where highercategoryid=" & highercategoryid
if getconfig("xproductmatch")="Yes" then
     sql=sql & " and productmatch='" & xproductmatch & "'"
end if 
if getconfig("xproductmatchcustomer")="Yes" then
   if GetSess("CustomerProductGroup")<>"" then
      sql=sql & " and customermatch='" & getsess("customerProductgroup") & "'"
    end if  
end if 
If getconfig("xselectproductsbylanguage")="Yes" and getsess("language")<>"" then
     sql=sql & " and (catlanguage='" & getsess("language") & "'"
     sql=sql & " or catlanguage is null)"
end if    
sql=sql & " order by " & Getconfig("xsortcategories") 
end sub

Sub FormatcategoryList (id, name, spacing)
dim i
If spacing>0 then
  for i = 0 to spacing
     response.write "&nbsp;&nbsp;"
  next
end if     
response.write "<a HREF=""shopdisplayproducts.asp?id=" & id & "&amp;cat=" & Server.URLEncode(name) & """>" &  name & "</a>"  & "<br>" & vbcrlf
end sub

Sub Formatsubcategories (categoryid, spacing, dbconn)
dim sql, rs, rc, catdescription, hassubcategory
navGeneratesql sql, categoryid
Set rs=dbconn.execute(sql)
spacing=spacing+1
do while not rs.eof
    navGetcategoryfields rs,categoryid, hassubcategory, catdescription, rc, dbconn
    If rc=0 then 
       FormatcategoryList categoryid, catdescription,  spacing
       If hassubcategory<>"" then 
          Formatsubcategories categoryid, spacing, dbconn
       end if   
    end if
    rs.movenext        
loop
spacing=spacing-1    
closerecordset rs
end sub
'******************************************************************************
' associated products could be
' crossselling
' also bought
'***************************************************************************
Sub FormatassociatedProducts (dbc, sql, headercaption, displaylimit) 
dim rs, strcDescURL, strurl, tempname, strmessage, tempcatalogid, tempdesc
dim limit, dcount
If Getconfig("Xcrosssellingimage")="Yes" then
    FormatAssociatedwithImages dbc, sql, headercaption, displaylimit
    exit sub
end if    

dim hideprice
hideprice = false
if getconfig("xdisplayprices") <> "Yes" then
	hideprice = true
end if
if getconfig("xpriceloggedinonly") = "Yes" then
	if Getsess ("login") = "" then
		hideprice = true
	end if
end if

if displaylimit="" then
    limit=99999
else
    limit=clng(displaylimit)
end if 
dcount=0       
set rs=dbc.execute(sql)
if not rs.eof then%>
	<strong><%=headercaption%></strong>
	<table cellpadding="4">
<%end if
Do While Not rs.EOF and dcount<limit
   strCDescURL=rs("cdescurl")
   If isnull(Strcdescurl) then
         strCDescURL=getconfig("xCrossLinkURL")
   end if
   if ucase(strcDESCURL)="SHOPEXD.ASP" then
	'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
       strurl="shopexd.asp?id=" & rs("catalogid") & "&bc=no"
   Else
   	'VP-ASP 6.08a - added bc=no to stop breadcrumb appearing in page
   	strurl="shopquery.asp?catalogid=" & rs("catalogid") & "&bc=no"
   End if
   strurl=addwebsess(strurl)
   tempname=Rs("cname")
   tempdesc = rs("cdescription")
   tempcatalogid=rs("catalogid")
   tempname=translatelanguage(dbc, "products", "cname","catalogid", tempcatalogid, tempname)
   tempdesc=translatelanguage(dbc, "products", "cdescription","catalogid", tempcatalogid, tempdesc)
	%><tr>
		<td align="left"><a href='<%=strURL%>'><%=tempname%></a></td>
		<td align="left"><%=tempdesc%></td>
		<%if hideprice <> true then%>
		<td align="center"><%=shopformatcurrency(rs("cprice"), getconfig("xdecimalpoint"))%></td>
		<%else%>
		<td align="center">&nbsp;</td>
		<%end if%>
	</tr><%
   'strMessage=strMessage & "<br><a href='" & strURL & "'>" & tempname & "</a>"		
   RS.MoveNext
   dcount=dcount+1
loop
closerecordset rs
		%></tr>
	</table><%
'strMessage="<BR>" & headercaption & strMessage
'Response.write strmessage
end sub
'*****************************************************************
' Cros Selling with images
'****************************************************************
Sub FormatAssociatedwithImages (dbc, sql, headercaption, displaylimit)
dim rs
dim headerok
dim limit, dcount
if displaylimit="" then
    limit=99999
else
    limit=clng(displaylimit)
end if 
dcount=0       
set rs=dbc.execute(sql)
If rs.eof then
  closerecordset rs
  exit sub
end if  
%><strong><%=Headercaption%></strong>
<br>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td><%
'Response.write reporttabledef & reportheadrow & ReportHeadColumn
'Response.write 
'Response.write ReportHeadColumnEnd & reportrowend & tabledefend & reporttabledef
headerok=true
Do While Not rs.EOF and dcount<limit
   FormatAssociatedRow rs
   RS.MoveNext
   dcount=dcount+1
Loop
Closerecordset rs
if headerok=true then
%>          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td>
      <hr color=#cccccc noShade size=1>
    </td>
  </tr>
</table><%
end if   	
end sub

'**********************************************************************
' format one row of crossselling. 
' all products must have an image
'**************************************************************************
Sub FormatAssociatedrow (rs)
dim hideprice
hideprice = false
if getconfig("xdisplayprices") <> "Yes" then
	hideprice = true
end if
if getconfig("xpriceloggedinonly") = "Yes" then
	if Getsess ("login") = "" then
		hideprice = true
	end if
end if
dim catalogid, imagefile, cname, cprice, url, cdescription
dim buttonimage, buttontext, buttonname
buttonimage=Getconfig("xbuttonmoreinfo")
buttontext=getlang("langProductExtendeddescription")
buttonname="View"
if isNull(buttonimage) Or buttonimage="" then
	buttonimage=""
end if
catalogid=rs("catalogid")
imagefile=rs("cimageurl")
URL=rs("cdescurl")
If isnull(url) then
    URL=getconfig("xCrossLinkURL")
end if
if ucase(URL)="SHOPEXD.ASP" then
       url="shopexd.asp?id=" & rs("catalogid") & "&bc=no"
else
	url="shopquery.asp?catalogid=" & rs("catalogid") & "&bc=no"
end if
' add translate
cname=rs("cname")
cdescription = rs("cdescription")
dim assocdbc
shopopendatabase assocdbc
cname=translatelanguage(assocdbc, "products", "cname","catalogid", catalogid, cname)
cdescription = translatelanguage(assocdbc, "products", "cdescription","catalogid", catalogid, cdescription)
shopclosedatabase assocdbc
'Response.write reportdetailrow
%><table width="100%" border="0" cellspacing="2" cellpadding="2">
              <tr>
                <td width="20%" valign=top>
		          <a href="<%=url%>"><img src="<%=imagefile%>" width='60' height='60' border='0'></a>	
				</td>
                <td width="50%" valign=top align="left"> <span class=hdrproduct><a href="<%=url%>"><%=cname%></a></span>
					<br><%=cdescription%></td>
                <td width="30%" align=right valign=top>
				<%if hideprice <> true then %>
                  Our Price: <span class='price'><%=shopformatcurrency(rs("cprice"), getconfig("xdecimalpoint"))%></span><br>
				<%end if%>
				 <p><b><a href="<%=url%>"><%=getlang("langproductclick")%></a></b></p>
				</td>

              </tr>
            </table><%
'response.write "</tr>"
end sub


Sub loginlogouttoggle
	'VP-ASP 6.08 - restore cookie if enabled so this displays correctly
	if getconfig("xcookielogin") = "Yes" then
		RestoreCustomerDetailsCookie
	end if 
	
	if Getsess ("lastname") > "" then%>
		<a href="shopcustadminlogin.asp?new=yes" class="small-black-text"><%=getLang("langcommonlogout")%></a>
	<%else%>
		<a href="shopcustadminlogin.asp" class="small-black-text"><%=getLang("langcommonlogin")%></a>
	<%end if
End sub

Sub welcomenote
	'VP-ASP 6.08 - restore cookie if enabled so this displays correctly
	if getconfig("xcookielogin") = "Yes" then
		RestoreCustomerDetailsCookie
	end if 
	
	if Getsess ("lastname") > "" then
		response.write getlang("langloggedinas") & " " & Getsess("Firstname") & " " & Getsess("lastname")
	else
		response.write getlang("langnotloggedin")
	end if
end sub

Sub DisplayIPAddress
dim ipaddress
ipaddress=request.servervariables("REMOTE_ADDR")

If getconfig("xdisplayIPAddress")="Yes" then 
%>
<table width='40%' border='0' cellspacing='4' cellpadding='4'>
  <tr>
    <td width='14%' class='small' align='left'><img src='images/misc/warn.gif'></td>
    <td width='86%' class='small' align='left'><%=getlang("langipwarn01")%></td>
  </tr>
  <tr>
    <td width='14%' class='small' align='left'>&nbsp;</td>
	<td><strong><%=request.ServerVariables("REMOTE_ADDR") & "<BR>"%></strong></td>
  </tr>
  <tr>
    <td width='14%' class='small' align='left'>&nbsp;</td>
    <td width='86%' class='small' align='left'><%=getlang("langipwarn02")%></td>
  </tr>
</table>
<%
End If
End Sub

sub inserturchinstats

end sub
%>