<?php
// ! Support file only, run AjaxTable.html instead !
// This file is used as both Data_Url and Upload_Url
// Generates data for TreeGrid when no data received or saves received changes to database
// Single file, without using TreeGridFramework.php

// --- Database switching ---
require_once("IncDbTxt.php");                 // Routines to connect to database via text file database
$db = new Database("Database");               // Database in folder "Database"

header("Content-Type: text/xml; charset=utf-8"); 

// --- Generating data ---
$rows = $db->Query("SELECT * FROM TableData ORDER BY Project,Resource")->GetRows();
$Prj = ""; $Res = ""; $S = "";
foreach($rows as $row){
   $P = $row["Project"];
   $R = $row["Resource"];
   if($R != $Res && $Res != "") $S .= "/>";     // End previous resource row
   if($P != $Prj){               // New project row
      If($Prj != "") $S .= "</I>";   // Ends previous project row
      $Prj = $P;
      $S .= "<I Def='Node' Project='" . htmlspecialchars($Prj,ENT_QUOTES) . "'>";
      }
   If($R != $Res){              // New resource row
      $Res = $R;
      $S .= "<I Project='" . htmlspecialchars($Res,ENT_QUOTES) . "' ";
      }
   $H = $row["Hours"]; if($H==floor($H)) $H = floor($H);  // !!! TreeGrid cannot accept float value ending with .0, like 40.0
   $S .= "W" . floor($row["Week"]) . "='" . $H . "' ";      //Week = Hours (like W42='17')
   }
if($Res != "") $S .= "/>";     // End previous resource row
if($Prj != "") $S .= "</I>;"   // Ends previous project row
// --------------------------------------------------------------------------
?><Grid>
   <Body>
      <B>
         <?php echo $S;?>
      </B>
   </Body>
</Grid>