/*
 * Decompiled with CFR 0.152.
 */
import com.install4j.api.CustomScreen;
import com.install4j.api.Util;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.components.DirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.security.GeneralSecurityException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.co.argosytelcrest.configuration.JDBCConfiguration;

public class SelectDataDirectory
extends CustomScreen {
    private static final long serialVersionUID = 6140544128736292132L;
    private static final String CONFIG_CLASS = "uk.co.argosytelcrest.passwordsafe.configuration.JDBCConfiguration";
    private DirectoryChooser dataDirectory;
    private JPanel chooserContainer;
    private boolean databaseConfigured = false;

    public SelectDataDirectory() throws GeneralSecurityException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        JDBCConfiguration jDBCConfiguration = JDBCConfiguration.getConfiguration(CONFIG_CLASS);
        if (jDBCConfiguration.getDBType() != null && jDBCConfiguration.getDBType().length() > 0) {
            this.databaseConfigured = true;
        }
        if (this.databaseConfigured) {
            this.add(new JLabel("Your database appears to be already configured. Please click Next."), gridBagConstraints);
        } else {
            this.add(new JLabel("Please select the directory to store the EPS data in"), gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            this.chooserContainer = new JPanel(new BorderLayout());
            this.add(this.chooserContainer, gridBagConstraints);
        }
    }

    public String getTitle() {
        return "Where should the EPS store its database?";
    }

    public String getSubTitle() {
        return "Please select a directory for the EPS to store data in.";
    }

    public boolean isFillVertical() {
        return true;
    }

    public boolean isFillHorizontal() {
        return true;
    }

    public boolean next() {
        if (!this.databaseConfigured) {
            File file = this.dataDirectory.getSelectedDirectory();
            if (!file.exists() && !file.mkdir()) {
                Util.showMessage((String)"The chosen directory could not be created.", (int)0);
                return false;
            }
            if (file == null || !file.isDirectory() || !file.canWrite()) {
                Util.showMessage((String)"Please select a writable directory.", (int)0);
                return false;
            }
            try {
                JDBCConfiguration jDBCConfiguration = JDBCConfiguration.getConfiguration(CONFIG_CLASS);
                if (jDBCConfiguration.getDBType() == null || jDBCConfiguration.getDBType().length() == 0) {
                    Class.forName("org.hsqldb.jdbcDriver");
                    jDBCConfiguration.setDatabaseType("HSQLDB");
                    jDBCConfiguration.setDriver("org.hsqldb.jdbcDriver");
                    jDBCConfiguration.setURL("jdbc:hsqldb:/" + file.getCanonicalPath() + "/pwsafe-hsqldb");
                    jDBCConfiguration.setUsername("sa");
                    jDBCConfiguration.setPassword("");
                    jDBCConfiguration.store(CONFIG_CLASS);
                    jDBCConfiguration.initialiseDatabase();
                }
            }
            catch (Exception exception) {
                Util.showMessage((String)("Error during database configuration : " + exception.getLocalizedMessage()), (int)0);
                return false;
            }
        }
        return true;
    }

    public synchronized void activated() {
        if (this.dataDirectory == null && !this.databaseConfigured) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = installerConfig.getApplicationName();
            this.dataDirectory = new DirectoryChooser(this.getInstallerContext().getInstallationDirectory(), string, null, null);
            this.chooserContainer.add((Component)this.dataDirectory, "Center");
            super.activated();
            this.dataDirectory.focusTextField();
        }
    }
}

