/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class FileUtil {
    public static final String URL_FILE_PREFIX = "file:";
    public static final String URL_JAR_PREFIX = "jar:file:";

    private FileUtil() {
    }

    public static long getFileSize(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        randomAccessFile.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileUtil.pumpStream(fileInputStream, fileOutputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void extractFile(InputStream inputStream, File file) throws IOException {
        FileUtil.extractFile(inputStream, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(InputStream inputStream, File file, CopyProgressListener copyProgressListener) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            FileUtil.pumpStream(inputStream, fileOutputStream, copyProgressListener);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void emptyDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                FileUtil.deleteDirectory(file2);
                file2.delete();
                continue;
            }
            file2.delete();
        }
    }

    public static void deleteDirectory(File file) {
        FileUtil.emptyDirectory(file);
        file.delete();
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        FileUtil.copyDirectory(file, file2, bl, null, null);
    }

    public static void copyDirectory(File file, File file2, boolean bl, Collection collection, Collection collection2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = new File(file, fileArray[i].getName()).getCanonicalFile();
            if (collection2 != null && collection2.contains(file3)) continue;
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory() && bl) {
                if (!file4.exists() && !file4.mkdirs()) {
                    throw new IOException("Cannot create " + file2.getPath());
                }
                FileUtil.copyDirectory(file3, file4, true, collection, collection2);
                continue;
            }
            boolean bl2 = false;
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && !bl2) {
                    String string = ((String)iterator.next()).toLowerCase();
                    if (!file3.getName().toLowerCase().endsWith(string)) continue;
                    bl2 = true;
                }
            }
            if (bl2) continue;
            FileUtil.copyFile(file3, file4);
        }
    }

    public static long pumpCharStream(Reader reader, Writer writer) throws IOException {
        int n;
        long l = 0L;
        while ((n = reader.read()) != -1) {
            writer.write(n);
            ++l;
        }
        writer.flush();
        return l;
    }

    public static long pumpStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtil.pumpStream(inputStream, outputStream, null);
    }

    public static long pumpStream(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
            if (copyProgressListener == null || copyProgressListener.progressPerformed(n)) continue;
            return -1L;
        }
        return l;
    }

    public static LoadingDescriptor getLoadingDescriptor(Class clazz) {
        String string;
        boolean bl;
        String string2 = clazz.getName().replace('.', '/') + ".class";
        String string3 = string2.substring(string2.lastIndexOf(47) + 1);
        String string4 = clazz.getResource(string3).toString();
        String string5 = string4.substring(0, string4.lastIndexOf(string2) - 1);
        if (string5.startsWith(URL_JAR_PREFIX)) {
            bl = true;
            string = string5.substring(URL_JAR_PREFIX.length(), string5.length() - 1);
            int n = string5.lastIndexOf(47);
            if (n == -1) {
                n = string5.lastIndexOf(92);
            }
            if (n == -1) {
                return null;
            }
            string5 = string5.substring(URL_JAR_PREFIX.length(), n);
        } else if (string5.startsWith(URL_FILE_PREFIX)) {
            bl = false;
            string = string5 = string5.substring(URL_FILE_PREFIX.length());
        } else {
            return null;
        }
        return new LoadingDescriptor(new File(string5), new File(string), bl);
    }

    public static interface CopyProgressListener {
        public boolean progressPerformed(long var1);
    }

    public static class LoadingDescriptor {
        private File baseDir;
        private File classpathDir;
        private boolean loadedFromJAR;

        private LoadingDescriptor(File file, File file2, boolean bl) {
            this.baseDir = file;
            this.classpathDir = file2;
            this.loadedFromJAR = bl;
        }

        public File getBaseDir() {
            return this.baseDir;
        }

        public File getClasspathDir() {
            return this.classpathDir;
        }

        public boolean isLoadedFromJAR() {
            return this.loadedFromJAR;
        }
    }
}

