/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.InstallerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class UnixFileSystem {
    public static void setMode(int n, File file) {
        UnixFileSystem.setMode(Integer.toOctalString(n & 0x1FF), file);
    }

    public static void setMode(String string, File file) {
        if (InstallerUtil.isMacOS()) {
            UnixFileSystem.setModeMac(string, file);
        } else {
            UnixFileSystem.setModeNonMac(string, file);
        }
    }

    private static void setModeMac(String string, File file) {
        try {
            File file2 = File.createTempFile("i4j", ".sh");
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file2)), "UTF-8"));
            printWriter.println("#!/bin/sh");
            printWriter.println("chmod " + string + " \"" + file.getAbsolutePath() + "\"");
            printWriter.close();
            String[] stringArray = new String[]{"/bin/sh", file2.getAbsolutePath()};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            process.destroy();
            file2.delete();
        }
        catch (IOException iOException) {
            System.err.println("Could not set mode for " + file.getAbsolutePath());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void setModeNonMac(String string, File file) {
        String[] stringArray = new String[]{"chmod", string, file.getAbsolutePath()};
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            process.destroy();
        }
        catch (IOException iOException) {
            System.err.println("Could not set mode for " + file.getAbsolutePath());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void createLink(String string, File file) throws IOException {
        file.delete();
        Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", string, file.getAbsolutePath()});
        try {
            process.waitFor();
            process.destroy();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        process.destroy();
    }
}

