/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDisplay
extends JPanel {
    private JLabel lblStatus;
    private JLabel lblDetail;
    private JProgressBar progressBar;
    private IndeterminateUpdaterThread indeterminateUpdaterThread;
    private GridBagConstraints gc;

    public ProgressDisplay() {
        this.setupControls();
        this.setupComponent();
    }

    public void setStatusMessage(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        this.lblStatus.setText(string);
    }

    public void setDetailMessage(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        this.lblDetail.setText(string);
    }

    public void setPercentCompleted(int n) {
        this.progressBar.setValue(n <= 100 ? n : 100);
    }

    private void setupControls() {
        this.lblStatus = new JLabel(" ");
        this.lblDetail = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0, 100);
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        this.gc = new GridBagConstraints();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.fill = 2;
        this.add((Component)this.lblStatus, this.gc);
        ++this.gc.gridy;
        this.add((Component)this.lblDetail, this.gc);
        ++this.gc.gridy;
        this.add((Component)this.progressBar, this.gc);
        ++this.gc.gridy;
    }

    public void setIndeterminateProgress(boolean bl) {
        if (!bl) {
            if (this.indeterminateUpdaterThread == null) {
                return;
            }
            this.indeterminateUpdaterThread.cancel();
            try {
                this.indeterminateUpdaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            final int n = this.indeterminateUpdaterThread.getOldValue();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressDisplay.this.setPercentCompleted(n);
                }
            });
            this.indeterminateUpdaterThread = null;
        } else {
            if (this.indeterminateUpdaterThread != null) {
                return;
            }
            this.indeterminateUpdaterThread = new IndeterminateUpdaterThread();
            this.indeterminateUpdaterThread.start();
        }
    }

    public void activate() {
    }

    private class IndeterminateUpdaterThread
    extends Thread {
        private int oldValue;
        private boolean canceled;

        public IndeterminateUpdaterThread() {
            this.oldValue = ProgressDisplay.this.progressBar.getValue();
        }

        public void run() {
            while (!this.canceled) {
                for (int i = 0; i <= 100; i += 5) {
                    final int n = i;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProgressDisplay.this.setPercentCompleted(n);
                        }
                    });
                    try {
                        Thread.sleep(80L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void cancel() {
            this.canceled = true;
        }

        public int getOldValue() {
            return this.oldValue;
        }
    }
}

