/*
 * Decompiled with CFR 0.152.
 */
package uk.co.argosytelcrest.dbabstraction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.co.argosytelcrest.dbabstraction.ColumnSpecification;
import uk.co.argosytelcrest.dbabstraction.DALInterface;
import uk.co.argosytelcrest.dbabstraction.IndexSpecification;
import uk.co.argosytelcrest.dbabstraction.TableSpecification;
import uk.co.argosytelcrest.utils.DatabaseConnectionUtils;

public abstract class AbstractDAL
implements DALInterface {
    protected Map m_translationMap = new Hashtable();
    private boolean usesColumnOnAdd = true;
    protected boolean m_supportsUnique = true;
    protected Connection connection;

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void startTableDefinition(StringBuffer stringBuffer, TableSpecification tableSpecification) {
        stringBuffer.append("create table ");
        stringBuffer.append(tableSpecification.getName());
        stringBuffer.append('(');
    }

    protected void endTableDefinition(StringBuffer stringBuffer) {
        stringBuffer.append(')');
    }

    protected void addColumnDefinition(StringBuffer stringBuffer, ColumnSpecification columnSpecification) {
        stringBuffer.append(columnSpecification.getName());
        stringBuffer.append(' ');
        stringBuffer.append(this.m_translationMap.get(columnSpecification.getType()));
        if (columnSpecification.getRejectNulls()) {
            stringBuffer.append(" NOT NULL");
        }
        if (columnSpecification.getUniqueOnly() && this.m_supportsUnique) {
            stringBuffer.append(" UNIQUE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(TableSpecification tableSpecification) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("select * from ");
        stringBuffer.append(tableSpecification.getName());
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
            }
            Logger.getAnonymousLogger().log(Level.WARNING, "Warning; Attempt to re-create " + tableSpecification.getName() + " blocked");
            return;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            statement.close();
        }
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        this.startTableDefinition(stringBuffer2, tableSpecification);
        Iterator iterator = tableSpecification.getColumnSpecificationIterator();
        while (iterator.hasNext()) {
            this.addColumnDefinition(stringBuffer2, (ColumnSpecification)iterator.next());
            stringBuffer2.append(',');
        }
        stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        this.endTableDefinition(stringBuffer2);
        this.runSQLUpdate(stringBuffer2.toString());
        Iterator iterator2 = tableSpecification.getIndexSpecificationIterator();
        while (iterator2.hasNext()) {
            IndexSpecification indexSpecification = (IndexSpecification)iterator2.next();
            this.addIndex(indexSpecification);
        }
    }

    public void addColumn(String string, ColumnSpecification columnSpecification) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("ALTER TABLE ");
        stringBuffer.append(string);
        stringBuffer.append(" ADD ");
        if (this.getUsesColumnOnAdd()) {
            stringBuffer.append("COLUMN ");
        }
        this.addColumnDefinition(stringBuffer, columnSpecification);
        this.runSQLUpdate(stringBuffer.toString());
    }

    public void addIndex(IndexSpecification indexSpecification) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("CREATE ");
        if (indexSpecification.containsUnique()) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append("INDEX ");
        stringBuffer.append(indexSpecification.getIndexName());
        stringBuffer.append(" ON ");
        stringBuffer.append(indexSpecification.getTableName());
        stringBuffer.append(" (");
        Iterator iterator = indexSpecification.getColumns().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(',');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(')');
        this.runSQLUpdate(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runSQLQuery(String string) throws SQLException {
        boolean bl;
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = null;
        try {
            statement.setMaxRows(1);
            resultSet = statement.executeQuery(string);
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DatabaseConnectionUtils.close(resultSet);
            DatabaseConnectionUtils.close(statement);
            throw throwable;
        }
        DatabaseConnectionUtils.close(resultSet);
        DatabaseConnectionUtils.close(statement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSQLUpdate(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            statement.executeUpdate(string);
        }
        finally {
            DatabaseConnectionUtils.close(statement);
        }
    }

    public boolean getUsesColumnOnAdd() {
        return this.usesColumnOnAdd;
    }

    public void setUsesColumnOnAdd(boolean bl) {
        this.usesColumnOnAdd = bl;
    }
}

