/*
 * Decompiled with CFR 0.152.
 */
package uk.co.argosytelcrest.configuration;

import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import uk.co.argosytelcrest.dbabstraction.ColumnSpecification;
import uk.co.argosytelcrest.dbabstraction.DALInterface;
import uk.co.argosytelcrest.dbabstraction.IndexSpecification;
import uk.co.argosytelcrest.dbabstraction.TableSpecification;
import uk.co.argosytelcrest.utils.DatabaseConnectionUtils;

public abstract class JDBCConfiguration {
    private static final String HSQLDB_DATABASE_TYPE = "HSQLDB";
    private static final String DB2_DATABASE_TYPE = "DB2";
    private static final String MYSQL_DATABASE_TYPE = "MySQL";
    private static final String ORACLE_DATABASE_TYPE = "Oracle";
    private static final String POSTGRESQL_DATABASE_TYPE = "PostgreSQL";
    private static final String SQLSERVER_DATABASE_TYPE = "SQL Server 2000";
    private static final String SQLSERVER_2K5_DATABASE_TYPE = "SQL Server 2005";
    private static final byte[] PASSWORD_AES_KEY = new byte[]{84, -54, 102, -106, 30, -63, 98, 125, 52, 22, 34, 44, -39, 86, 11, -120};
    public static final String TEST_SQL = "SELECT user_id   FROM application_users  WHERE user_id= '0'";
    public static final String[] DATABASE_TYPES = new String[]{"HSQLDB", "DB2", "MySQL", "Oracle", "PostgreSQL", "SQL Server 2000", "SQL Server 2005"};
    private String dbType;
    private String driver;
    private String url;
    private String username;
    private String password;
    private static final String DB_TYPE_PARAMETER = "db.type";
    private static final String DRIVER_PARAMETER = "jdbc.driver";
    private static final String URL_PARAMETER = "jdbc.url";
    private static final String USERNAME_PARAMETER = "jdbc.username";
    private static final String PASSWORD_PARAMETER = "jdbc.password";
    private static final String ENCRYPTED_PASSWORD_PARAMETER = "jdbc.password.encrypted";
    private static final String AUTO_INIT = "jdbc.autoinit";
    private Preferences prefs;

    public void loadConfiguration(Class clazz) throws GeneralSecurityException {
        this.prefs = Preferences.userNodeForPackage(clazz);
        this.dbType = this.prefs.get(DB_TYPE_PARAMETER, null);
        if (this.dbType == null) {
            this.prefs = Preferences.systemNodeForPackage(clazz);
            this.dbType = this.prefs.get(DB_TYPE_PARAMETER, null);
        }
        this.driver = this.prefs.get(DRIVER_PARAMETER, null);
        this.url = this.prefs.get(URL_PARAMETER, null);
        this.username = this.prefs.get(USERNAME_PARAMETER, null);
        byte[] byArray = this.prefs.getByteArray(ENCRYPTED_PASSWORD_PARAMETER, null);
        if (byArray == null) {
            this.password = this.prefs.get(PASSWORD_PARAMETER, null);
            if (this.password != null) {
                this.prefs.putByteArray(ENCRYPTED_PASSWORD_PARAMETER, this.encryptPasswordText(this.password));
                this.prefs.remove(PASSWORD_PARAMETER);
            }
        } else {
            this.password = this.decryptPasswordText(byArray);
        }
    }

    public void store(String string) throws GeneralSecurityException, ClassNotFoundException, BackingStoreException {
        this.prefs = Preferences.systemNodeForPackage(Class.forName(string));
        this.prefs.put(DB_TYPE_PARAMETER, this.dbType);
        this.prefs.put(DRIVER_PARAMETER, this.driver);
        this.prefs.put(URL_PARAMETER, this.url);
        this.prefs.put(USERNAME_PARAMETER, this.username);
        this.prefs.putByteArray(ENCRYPTED_PASSWORD_PARAMETER, this.encryptPasswordText(this.password));
        this.prefs.flush();
    }

    private byte[] encryptPasswordText(String string) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(PASSWORD_AES_KEY, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKeySpec);
        byte[] byArray = cipher.doFinal(string.getBytes());
        return byArray;
    }

    private String decryptPasswordText(byte[] byArray) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(PASSWORD_AES_KEY, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKeySpec);
        byte[] byArray2 = cipher.doFinal(byArray);
        return new String(byArray2);
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public boolean isAutoInitSet() {
        String string = this.prefs.get(AUTO_INIT, "N");
        return string.toLowerCase().charAt(0) == 'y';
    }

    public void cleanAutoInit() {
        this.prefs.remove(AUTO_INIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(boolean bl) {
        block7: {
            boolean bl2;
            if (this.driver == null || this.url == null || this.username == null || this.password == null) {
                return false;
            }
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Class.forName(this.driver);
                connection = this.getRawConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(TEST_SQL);
                bl2 = true;
                DatabaseConnectionUtils.close(resultSet);
            }
            catch (Exception exception) {
                if (bl) {
                    Logger.getLogger(this.getClass().toString()).log(Level.WARNING, "Error testing database.", exception);
                }
                break block7;
            }
            finally {
                DatabaseConnectionUtils.close(resultSet);
                DatabaseConnectionUtils.close(statement);
                DatabaseConnectionUtils.close(connection);
            }
            DatabaseConnectionUtils.close(statement);
            DatabaseConnectionUtils.close(connection);
            return bl2;
        }
        return false;
    }

    public abstract void initialiseDatabase() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException;

    protected String[] getInitialisationCommands() {
        return new String[0];
    }

    private TableSpecification getApplicationUsersTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("application_users");
        tableSpecification.addColumnSpecification(new ColumnSpecification("user_id", ColumnSpecification.TYPE_ID, true, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("user_name", ColumnSpecification.TYPE_SHORT_STRING, true, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("user_pass", ColumnSpecification.TYPE_SHORT_STRING, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("full_name", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("email", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("access_key", ColumnSpecification.TYPE_LONG_STRING, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("admin_access_key", ColumnSpecification.TYPE_LONG_STRING, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("last_login", ColumnSpecification.TYPE_SHORT_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("login_attempts", ColumnSpecification.TYPE_INT));
        tableSpecification.addColumnSpecification(new ColumnSpecification("disabled", ColumnSpecification.TYPE_CHAR));
        tableSpecification.addIndexSpecification(new IndexSpecification("au_uid", "application_users", "user_id"));
        return tableSpecification;
    }

    private TableSpecification getGroupsTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("groups");
        tableSpecification.addColumnSpecification(new ColumnSpecification("group_id", ColumnSpecification.TYPE_ID, true, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("group_name", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("enabled", ColumnSpecification.TYPE_CHAR));
        tableSpecification.addIndexSpecification(new IndexSpecification("gp_gid", "groups", "group_id"));
        return tableSpecification;
    }

    private TableSpecification getUACTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("user_access_control");
        tableSpecification.addColumnSpecification(new ColumnSpecification("user_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("item_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("modify_key", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("read_key", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addIndexSpecification(new IndexSpecification("uac_uid", "user_access_control", "user_id"));
        IndexSpecification indexSpecification = new IndexSpecification("uac_uidiid", "user_access_control");
        indexSpecification.addColumn("user_id");
        indexSpecification.addColumn("item_id");
        tableSpecification.addIndexSpecification(indexSpecification);
        return tableSpecification;
    }

    private TableSpecification getMembershipTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("membership");
        tableSpecification.addColumnSpecification(new ColumnSpecification("group_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("user_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("access_key", ColumnSpecification.TYPE_LONG_STRING, false, true));
        IndexSpecification indexSpecification = new IndexSpecification("mb_giduid", "membership");
        indexSpecification.addColumn("group_id");
        indexSpecification.addColumn("user_id");
        tableSpecification.addIndexSpecification(indexSpecification);
        return tableSpecification;
    }

    private TableSpecification getGACTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("group_access_control");
        tableSpecification.addColumnSpecification(new ColumnSpecification("group_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("item_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("modify_key", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("read_key", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addIndexSpecification(new IndexSpecification("gac_gid", "group_access_control", "group_id"));
        IndexSpecification indexSpecification = new IndexSpecification("gac_gidiid", "group_access_control");
        indexSpecification.addColumn("group_id");
        indexSpecification.addColumn("item_id");
        tableSpecification.addIndexSpecification(indexSpecification);
        return tableSpecification;
    }

    private TableSpecification getEventLogTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("event_log");
        tableSpecification.addColumnSpecification(new ColumnSpecification("user_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("item_id", ColumnSpecification.TYPE_ID));
        tableSpecification.addColumnSpecification(new ColumnSpecification("item_datetime", ColumnSpecification.TYPE_ID));
        tableSpecification.addColumnSpecification(new ColumnSpecification("datetime", ColumnSpecification.TYPE_SHORT_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("event", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("stamp", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addIndexSpecification(new IndexSpecification("el_dt", "event_log", "datetime"));
        tableSpecification.addIndexSpecification(new IndexSpecification("el_uid", "event_log", "user_id"));
        return tableSpecification;
    }

    private TableSpecification getConfigurationTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("configuration");
        tableSpecification.addColumnSpecification(new ColumnSpecification("property_name", ColumnSpecification.TYPE_SHORT_STRING, true, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("property_value", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addIndexSpecification(new IndexSpecification("cf_pnme", "configuration", "property_name"));
        return tableSpecification;
    }

    protected TableSpecification getHierarchyTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("hierarchy");
        tableSpecification.addColumnSpecification(new ColumnSpecification("node_id", ColumnSpecification.TYPE_SHORT_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("name", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("parent_id", ColumnSpecification.TYPE_SHORT_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("type", ColumnSpecification.TYPE_INT));
        tableSpecification.addIndexSpecification(new IndexSpecification("hi_nid", "hierarchy", "node_id"));
        tableSpecification.addIndexSpecification(new IndexSpecification("hi_pid", "hierarchy", "parent_id"));
        return tableSpecification;
    }

    public void initialiseDatabase(DALInterface dALInterface) throws SQLException {
        dALInterface.createTable(this.getEventLogTableSpecification());
        dALInterface.createTable(this.getGroupsTableSpecification());
        dALInterface.createTable(this.getMembershipTableSpecification());
        dALInterface.createTable(this.getUACTableSpecification());
        dALInterface.createTable(this.getGACTableSpecification());
        dALInterface.createTable(this.getConfigurationTableSpecification());
        dALInterface.createTable(this.getApplicationUsersTableSpecification());
        dALInterface.createTable(this.getHierarchyTableSpecification());
        String[] stringArray = this.getInitialisationCommands();
        for (int i = 0; i < stringArray.length; ++i) {
            dALInterface.runSQLUpdate(stringArray[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DB Type: ");
        stringBuffer.append(this.dbType);
        stringBuffer.append(", Driver: ");
        stringBuffer.append(this.driver);
        stringBuffer.append(", URL: ");
        stringBuffer.append(this.url);
        stringBuffer.append(", Username: ");
        stringBuffer.append(this.username);
        stringBuffer.append(", Password: ");
        stringBuffer.append(this.password);
        return stringBuffer.toString();
    }

    public void setDatabaseType(String string) {
        this.dbType = string;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int hashCode() {
        return this.dbType.hashCode() | this.driver.hashCode() | this.url.hashCode() | this.username.hashCode() | this.password.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDBCConfiguration)) {
            return false;
        }
        JDBCConfiguration jDBCConfiguration = (JDBCConfiguration)object;
        return this.dbType.equals(jDBCConfiguration.dbType) && this.driver.equals(jDBCConfiguration.driver) && this.url.equals(jDBCConfiguration.url) && this.username.equals(jDBCConfiguration.username) && this.password.equals(jDBCConfiguration.password);
    }

    public Connection getRawConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.supportsTransactionIsolationLevel(1)) {
            connection.setTransactionIsolation(1);
        }
        return connection;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDBType() {
        return this.dbType;
    }

    public String getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static JDBCConfiguration getConfiguration(String string) throws GeneralSecurityException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(string);
        JDBCConfiguration jDBCConfiguration = (JDBCConfiguration)clazz.newInstance();
        jDBCConfiguration.loadConfiguration(clazz);
        return jDBCConfiguration;
    }
}

