/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Loader;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static Log log = LogFactory.getLog(XmlConfiguration.class);
    private static Class[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static Class[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static XmlParser __parser;
    private XmlParser.Node _config;
    private Map _idMap = new HashMap();

    private static synchronized void initParser() throws IOException {
        if (__parser != null) {
            return;
        }
        __parser = new XmlParser();
        URL uRL = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_3.dtd");
        __parser.redirectEntity("configure.dtd", uRL);
        __parser.redirectEntity("configure_1_3.dtd", uRL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_3.dtd", uRL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", uRL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.3//EN", uRL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", uRL);
        URL uRL2 = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_2.dtd");
        __parser.redirectEntity("configure_1_2.dtd", uRL2);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_2.dtd", uRL2);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.2//EN", uRL2);
        URL uRL3 = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_1.dtd");
        __parser.redirectEntity("configure_1_1.dtd", uRL3);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_1.dtd", uRL3);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.1//EN", uRL3);
        URL uRL4 = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_0.dtd");
        __parser.redirectEntity("configure_1_0.dtd", uRL4);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_0.dtd", uRL4);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.0//EN", uRL4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL uRL) throws SAXException, IOException {
        XmlConfiguration.initParser();
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(uRL.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String string) throws SAXException, IOException {
        XmlConfiguration.initParser();
        string = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure 1.2//EN\" \"http://jetty.mortbay.org/configure_1_2.dtd\">" + string;
        InputSource inputSource = new InputSource(new StringReader(string));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(inputSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream inputStream) throws SAXException, IOException {
        XmlConfiguration.initParser();
        InputSource inputSource = new InputSource(inputStream);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(inputSource);
        }
    }

    public void configure(Object object) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class clazz = this.nodeClass(this._config);
        if (clazz != null) {
            if (object != null && !clazz.isInstance(object)) {
                throw new IllegalArgumentException("Object is not of type " + clazz);
            }
            if (object == null) {
                object = clazz.newInstance();
            }
        }
        this.configure(object, this._config, 0);
    }

    public Object newInstance() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class clazz = this.nodeClass(this._config);
        Object var2_2 = null;
        if (clazz != null) {
            var2_2 = clazz.newInstance();
        }
        this.configure(var2_2, this._config, 0);
        return var2_2;
    }

    private Class nodeClass(XmlParser.Node node) throws ClassNotFoundException {
        String string = node.getAttribute("class");
        if (string == null) {
            return null;
        }
        return Loader.loadClass(XmlConfiguration.class, string);
    }

    private void configure(Object object, XmlParser.Node node, int n) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        block21: {
            XmlParser.Node node2 = null;
            try {
                while (n < node.size()) {
                    Object object2 = node.get(n);
                    if (!(object2 instanceof String)) {
                        node2 = (XmlParser.Node)object2;
                        String string = node2.getTag();
                        if ("Set".equals(string)) {
                            this.set(object, node2);
                        } else if ("Put".equals(string)) {
                            this.put(object, node2);
                        } else if ("Call".equals(string)) {
                            this.call(object, node2);
                        } else if ("Get".equals(string)) {
                            this.get(object, node2);
                        } else if ("New".equals(string)) {
                            this.newObj(object, node2);
                        } else if ("Ref".equals(string)) {
                            this.refObj(object, node2);
                        } else {
                            throw new IllegalStateException("Unknown tag: " + string);
                        }
                    }
                    ++n;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                log.warn((Object)("Exception at " + node2.toString()), invocationTargetException.getTargetException());
                throw invocationTargetException;
            }
            catch (Error error) {
                log.debug(node2);
                throw error;
            }
            catch (Exception exception) {
                log.debug(node2);
                if (exception instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)exception;
                }
                if (exception instanceof InvocationTargetException) {
                    throw (InvocationTargetException)exception;
                }
                if (exception instanceof IllegalAccessException) {
                    throw (IllegalAccessException)exception;
                }
                if (!(exception instanceof RuntimeException)) break block21;
                throw (RuntimeException)exception;
            }
        }
    }

    private void set(Object object, XmlParser.Node node) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method[] methodArray;
        String string = node.getAttribute("name");
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Object object2 = this.value(object, node);
        Object[] objectArray = new Object[]{object2};
        Class<?> clazz = this.nodeClass(node);
        if (clazz != null) {
            object = null;
        } else {
            clazz = object.getClass();
        }
        Class[] classArray = new Class[]{Object.class};
        if (object2 != null) {
            classArray[0] = object2.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(object + "." + string2 + "(" + classArray[0] + " " + object2 + ")"));
        }
        try {
            Method method = clazz.getMethod(string2, classArray);
            method.invoke(object, objectArray);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogSupport.ignore(log, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogSupport.ignore(log, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogSupport.ignore(log, noSuchMethodException);
        }
        try {
            Field field = classArray[0].getField("TYPE");
            classArray[0] = (Class)field.get(null);
            Method method = clazz.getMethod(string2, classArray);
            method.invoke(object, objectArray);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LogSupport.ignore(log, noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogSupport.ignore(log, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogSupport.ignore(log, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogSupport.ignore(log, noSuchMethodException);
        }
        try {
            methodArray = clazz.getField(string);
            if (Modifier.isPublic(methodArray.getModifiers())) {
                methodArray.set(object, object2);
                return;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LogSupport.ignore(log, noSuchFieldException);
        }
        methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
            if (!string2.equals(methodArray[i].getName()) || methodArray[i].getParameterTypes().length != 1) continue;
            try {
                method = methodArray[i];
                methodArray[i].invoke(object, objectArray);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogSupport.ignore(log, illegalArgumentException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogSupport.ignore(log, illegalAccessException);
            }
        }
        if (method != null) {
            try {
                Class clazz2 = method.getParameterTypes()[0];
                if (clazz2.isPrimitive()) {
                    for (int i = 0; i < __primitives.length; ++i) {
                        if (!clazz2.equals(__primitives[i])) continue;
                        clazz2 = __primitiveHolders[i];
                        break;
                    }
                }
                Constructor<?> constructor = clazz2.getConstructor(classArray);
                objectArray[0] = constructor.newInstance(objectArray);
                method.invoke(object, objectArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LogSupport.ignore(log, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LogSupport.ignore(log, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                LogSupport.ignore(log, instantiationException);
            }
        }
        throw new NoSuchMethodException(clazz + "." + string2 + "(" + classArray[0] + ")");
    }

    private void put(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("Object for put is not a Map: " + object);
        }
        Map map = (Map)object;
        String string = node.getAttribute("name");
        Object object2 = this.value(object, node);
        map.put(string, object2);
        if (log.isDebugEnabled()) {
            log.debug((Object)(object + ".put(" + string + "+" + object2 + ")"));
        }
    }

    private Object get(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = this.nodeClass(node);
        if (clazz != null) {
            object = null;
        } else {
            clazz = object.getClass();
        }
        String string = node.getAttribute("name");
        String string2 = node.getAttribute("id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("get " + string));
        }
        try {
            Method method = clazz.getMethod("get" + string.substring(0, 1).toUpperCase() + string.substring(1), null);
            object = method.invoke(object, (Object[])null);
            this.configure(object, node, 0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = clazz.getField(string);
                object = field.get(object);
                this.configure(object, node, 0);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw noSuchMethodException;
            }
        }
        if (string2 != null) {
            this._idMap.put(string2, object);
        }
        return object;
    }

    private Object call(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        String string = node.getAttribute("id");
        Class<?> clazz = this.nodeClass(node);
        if (clazz != null) {
            object = null;
        } else if (object != null) {
            clazz = object.getClass();
        }
        if (clazz == null) {
            throw new IllegalArgumentException(node.toString());
        }
        int n = 0;
        int n2 = node.size();
        for (int i = 0; i < node.size(); ++i) {
            Object object2 = node.get(i);
            if (object2 instanceof String) continue;
            if (!((XmlParser.Node)object2).getTag().equals("Arg")) {
                n2 = i;
                break;
            }
            ++n;
        }
        Object[] objectArray = new Object[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Object object3 = node.get(n3);
            if (!(object3 instanceof String)) {
                objectArray[n4++] = this.value(object, (XmlParser.Node)object3);
            }
            ++n3;
        }
        String string2 = node.getAttribute("name");
        if (log.isDebugEnabled()) {
            log.debug((Object)("call " + string2));
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2) || methodArray[i].getParameterTypes().length != n || Modifier.isStatic(methodArray[i].getModifiers()) != (object == null) || object == null && methodArray[i].getDeclaringClass() != clazz) continue;
            Object object4 = null;
            boolean bl = false;
            try {
                object4 = methodArray[i].invoke(object, objectArray);
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogSupport.ignore(log, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogSupport.ignore(log, illegalArgumentException);
            }
            if (!bl) continue;
            if (string != null) {
                this._idMap.put(string, object4);
            }
            this.configure(object4, node, n2);
            return object4;
        }
        throw new IllegalStateException("No Method: " + node + " on " + clazz);
    }

    private Object newObj(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Object object2;
        Class clazz = this.nodeClass(node);
        String string = node.getAttribute("id");
        int n = 0;
        int n2 = node.size();
        for (int i = 0; i < node.size(); ++i) {
            Object object3 = node.get(i);
            if (object3 instanceof String) continue;
            if (!((XmlParser.Node)object3).getTag().equals("Arg")) {
                n2 = i;
                break;
            }
            ++n;
        }
        Object[] objectArray = new Object[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            object2 = node.get(n3);
            if (!(object2 instanceof String)) {
                objectArray[n4++] = this.value(object, (XmlParser.Node)object2);
            }
            ++n3;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new " + clazz));
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (n4 = 0; constructorArray != null && n4 < constructorArray.length; ++n4) {
            if (constructorArray[n4].getParameterTypes().length != n) continue;
            object2 = null;
            boolean bl = false;
            try {
                object2 = constructorArray[n4].newInstance(objectArray);
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogSupport.ignore(log, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                LogSupport.ignore(log, instantiationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogSupport.ignore(log, illegalArgumentException);
            }
            if (!bl) continue;
            if (string != null) {
                this._idMap.put(string, object2);
            }
            this.configure(object2, node, n2);
            return object2;
        }
        throw new IllegalStateException("No Constructor: " + node + " on " + object);
    }

    private Object refObj(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        String string = node.getAttribute("id");
        object = this._idMap.get(string);
        if (object == null) {
            throw new IllegalStateException("No object for id=" + string);
        }
        this.configure(object, node, 0);
        return object;
    }

    private Object newArray(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class clazz = Object.class;
        String string = node.getAttribute("type");
        String string2 = node.getAttribute("id");
        if (string != null && (clazz = TypeUtil.fromName(string)) == null) {
            clazz = "String".equals(string) ? String.class : ("URL".equals(string) ? URL.class : ("InetAddress".equals(string) ? InetAddress.class : ("InetAddrPort".equals(string) ? InetAddrPort.class : Loader.loadClass(XmlConfiguration.class, string))));
        }
        Object object2 = Array.newInstance(clazz, node.size());
        if (string2 != null) {
            this._idMap.put(string2, object);
        }
        for (int i = 0; i < node.size(); ++i) {
            Object object3 = node.get(i);
            if (object3 instanceof String) continue;
            XmlParser.Node node2 = (XmlParser.Node)object3;
            if (!node2.getTag().equals("Item")) {
                throw new IllegalStateException("Not an Item");
            }
            string2 = node2.getAttribute("id");
            Object object4 = this.value(object, node2);
            if (object4 != null) {
                Array.set(object2, i, object4);
            }
            if (string2 == null) continue;
            this._idMap.put(string2, object4);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object value(Object object, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Object object2 = null;
        String string = node.getAttribute("type");
        String string2 = node.getAttribute("ref");
        if (string2 != null) {
            object2 = this._idMap.get(string2);
        } else {
            int n;
            Object object3;
            if (node.size() == 0) {
                if ("String".equals(string)) {
                    return "";
                }
                return null;
            }
            int n2 = node.size() - 1;
            if (string == null || !"String".equals(string)) {
                object3 = null;
                for (n = 0; n <= n2 && (object3 = node.get(n)) instanceof String && ((String)(object3 = ((String)object3).trim())).length() <= 0; ++n) {
                }
                while (n < n2 && (object3 = node.get(n2)) instanceof String && ((String)(object3 = ((String)object3).trim())).length() <= 0) {
                    --n2;
                }
                if (n > n2) {
                    return null;
                }
            }
            if (n == n2) {
                object2 = this.itemValue(object, node.get(n));
            } else {
                Object object4 = object3 = new StringBuffer();
                synchronized (object4) {
                    for (int i = n; i <= n2; ++i) {
                        Object object5 = node.get(i);
                        ((StringBuffer)object3).append(this.itemValue(object, object5));
                    }
                    object2 = ((StringBuffer)object3).toString();
                }
            }
        }
        if (object2 == null) {
            if ("String".equals(string)) {
                return "";
            }
            return null;
        }
        if (string == null) {
            if (object2 != null && object2 instanceof String) {
                return ((String)object2).trim();
            }
            return object2;
        }
        if ("String".equals(string) || "java.lang.String".equals(string)) {
            return object2.toString();
        }
        Class clazz = TypeUtil.fromName(string);
        if (clazz != null) {
            return TypeUtil.valueOf(clazz, object2.toString());
        }
        if ("URL".equals(string) || "java.net.URL".equals(string)) {
            if (object2 instanceof URL) {
                return object2;
            }
            try {
                return new URL(object2.toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new InvocationTargetException(malformedURLException);
            }
        }
        if ("InetAddress".equals(string) || "java.net.InetAddress".equals(string)) {
            if (object2 instanceof InetAddress) {
                return object2;
            }
            try {
                return InetAddress.getByName(object2.toString());
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvocationTargetException(unknownHostException);
            }
        }
        if ("InetAddrPort".equals(string) || "org.mortbay.util.InetAddrPort".equals(string)) {
            if (object2 instanceof InetAddrPort) {
                return object2;
            }
            try {
                return new InetAddrPort(object2.toString());
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvocationTargetException(unknownHostException);
            }
        }
        throw new IllegalStateException("Unknown type " + string);
    }

    private Object itemValue(Object object, Object object2) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (object2 instanceof String) {
            return object2;
        }
        XmlParser.Node node = (XmlParser.Node)object2;
        String string = node.getTag();
        if ("Call".equals(string)) {
            return this.call(object, node);
        }
        if ("Get".equals(string)) {
            return this.get(object, node);
        }
        if ("New".equals(string)) {
            return this.newObj(object, node);
        }
        if ("Ref".equals(string)) {
            return this.refObj(object, node);
        }
        if ("Array".equals(string)) {
            return this.newArray(object, node);
        }
        if ("SystemProperty".equals(string)) {
            String string2 = node.getAttribute("name");
            String string3 = node.getAttribute("default");
            return System.getProperty(string2, string3);
        }
        log.warn((Object)("Unknown value tag: " + node), new Throwable());
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                new XmlConfiguration(Resource.newResource(stringArray[i]).getURL()).newInstance();
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }
}

