/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class UrlEncoded
extends MultiMap {
    private static Log log = LogFactory.getLog(UrlEncoded.class);

    public UrlEncoded(UrlEncoded urlEncoded) {
        super((Map)urlEncoded);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String string) {
        super(6);
        this.decode(string, StringUtil.__ISO_8859_1);
    }

    public UrlEncoded(String string, String string2) {
        super(6);
        this.decode(string, string2);
    }

    public void decode(String string) {
        UrlEncoded.decodeTo(string, this, StringUtil.__ISO_8859_1);
    }

    public void decode(String string, String string2) {
        UrlEncoded.decodeTo(string, this, string2);
    }

    public String encode() {
        return this.encode(StringUtil.__ISO_8859_1, false);
    }

    public String encode(String string) {
        return this.encode(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String encode(String string, boolean bl) {
        StringBuffer stringBuffer;
        if (string == null) {
            string = StringUtil.__ISO_8859_1;
        }
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(128);
        synchronized (stringBuffer2) {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = entry.getKey().toString();
                Object v = entry.getValue();
                int n = LazyList.size(v);
                if (n == 0) {
                    stringBuffer.append(UrlEncoded.encodeString(string2, string));
                    if (bl) {
                        stringBuffer.append('=');
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append('&');
                        }
                        Object object = LazyList.get(v, i);
                        stringBuffer.append(UrlEncoded.encodeString(string2, string));
                        if (object != null) {
                            String string3 = object.toString();
                            if (string3.length() > 0) {
                                stringBuffer.append('=');
                                stringBuffer.append(UrlEncoded.encodeString(string3, string));
                                continue;
                            }
                            if (!bl) continue;
                            stringBuffer.append('=');
                            continue;
                        }
                        if (!bl) continue;
                        stringBuffer.append('=');
                    }
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append('&');
            }
            return stringBuffer.toString();
        }
    }

    public static void decodeTo(String string, MultiMap multiMap) {
        UrlEncoded.decodeTo(string, multiMap, StringUtil.__ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String string, MultiMap multiMap, String string2) {
        if (string2 == null) {
            string2 = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string3 = null;
            String string4 = null;
            int n = -1;
            boolean bl = false;
            block9: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        string4 = bl ? UrlEncoded.decodeString(string, n + 1, i - n - 1, string2) : string.substring(n + 1, i);
                        n = i;
                        bl = false;
                        if (string3 == null) continue block9;
                        multiMap.add(string3, string4);
                        string3 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string3 != null) continue block9;
                        string3 = bl ? UrlEncoded.decodeString(string, n + 1, i - n - 1, string2) : string.substring(n + 1, i);
                        n = i;
                        bl = false;
                        continue block9;
                    }
                    case '+': {
                        bl = true;
                        continue block9;
                    }
                    case '%': {
                        bl = true;
                    }
                }
            }
            if (string3 != null) {
                string4 = bl ? UrlEncoded.decodeString(string, n + 1, string.length() - n - 1, string2) : string.substring(n + 1);
                multiMap.add(string3, string4);
            } else if (n < string.length()) {
                string3 = bl ? UrlEncoded.decodeString(string, n + 1, string.length() - n - 1, string2) : string.substring(n + 1);
                multiMap.add(string3, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(byte[] byArray, int n, int n2, MultiMap multiMap, String string) {
        if (byArray == null || n2 == 0) {
            return;
        }
        if (string == null) {
            string = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap2 = multiMap;
        synchronized (multiMap2) {
            try {
                int n3 = n;
                int n4 = n + n2;
                int n5 = n;
                String string2 = null;
                String string3 = null;
                block11: while (n3 < n4) {
                    byte by = byArray[n3++];
                    switch ((char)by) {
                        case '&': {
                            string3 = new String(byArray, n, n5, string);
                            if (string2 != null) {
                                multiMap.add(string2, string3);
                                string2 = null;
                            }
                            n5 = n;
                            continue block11;
                        }
                        case '=': {
                            if (string2 != null) continue block11;
                            string2 = new String(byArray, n, n5, string);
                            n5 = n;
                            continue block11;
                        }
                        case '+': {
                            byArray[n5++] = 32;
                            continue block11;
                        }
                        case '%': {
                            int n6 = 225;
                            byte by2 = (byte)n6;
                            byArray[n5++] = (byte)((TypeUtil.convertHexDigit(byArray[n3++]) << 4) + TypeUtil.convertHexDigit(byArray[n3++]));
                            continue block11;
                        }
                    }
                    byArray[n5++] = by;
                }
                if (string2 != null) {
                    string3 = new String(byArray, n, n5, string);
                    multiMap.add(string2, string3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.warn((Object)"EXCEPTION ", (Throwable)unsupportedEncodingException);
            }
        }
    }

    public static String decodeString(String string) {
        return UrlEncoded.decodeString(string, 0, string.length(), StringUtil.__ISO_8859_1);
    }

    public static String decodeString(String string, String string2) {
        return UrlEncoded.decodeString(string, 0, string.length(), string2);
    }

    public static String decodeString(String string, int n, int n2, String string2) {
        if (string2 == null) {
            string2 = StringUtil.__ISO_8859_1;
        }
        byte[] byArray = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalArgumentException("Not encoded");
            }
            if (c == '+') {
                if (byArray == null) {
                    byArray = new byte[n2 * 2];
                    string.getBytes(n, n + i, byArray, 0);
                    n3 = i;
                }
                byArray[n3++] = 32;
                continue;
            }
            if (c == '%' && i + 2 < n2) {
                char c2 = string.charAt(n + i + 1);
                byte by = c2 >= 'a' && c2 <= 'z' ? (byte)(10 + c2 - 97) : (c2 >= 'A' && c2 <= 'Z' ? (byte)(10 + c2 - 65) : (byte)(c2 - 48));
                c2 = string.charAt(n + i + 2);
                by = c2 >= 'a' && c2 <= 'z' ? (byte)(by * 16 + 10 + c2 - 97) : (c2 >= 'A' && c2 <= 'Z' ? (byte)(by * 16 + 10 + c2 - 65) : (byte)(by * 16 + c2 - 48));
                if (byArray == null) {
                    byArray = new byte[n2 * 2];
                    string.getBytes(n, n + i, byArray, 0);
                    n3 = i;
                }
                i += 2;
                byArray[n3++] = by;
                continue;
            }
            if (n3 <= 0) continue;
            byArray[n3++] = (byte)c;
        }
        if (byArray == null) {
            if (n == 0 && string.length() == n2) {
                return string;
            }
            return string.substring(n, n + n2);
        }
        try {
            return new String(byArray, 0, n3, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, 0, n3);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, StringUtil.__ISO_8859_1);
    }

    public static String encodeString(String string, String string2) {
        if (string2 == null) {
            string2 = StringUtil.__ISO_8859_1;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"EXCEPTION ", (Throwable)unsupportedEncodingException);
            byArray = string.getBytes();
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[byArray.length * 3];
        int n2 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 32) {
                bl = false;
                byArray2[n2++] = 43;
                continue;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57) {
                byArray2[n2++] = by;
                continue;
            }
            bl = false;
            byArray2[n2++] = 37;
            byte by2 = (byte)((by & 0xF0) >> 4);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
            by2 = (byte)(by & 0xF);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
        }
        if (bl) {
            return string;
        }
        try {
            return new String(byArray2, 0, n2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"EXCEPTION ", (Throwable)unsupportedEncodingException);
            return new String(byArray2, 0, n2);
        }
    }

    public Object clone() {
        return super.clone();
    }
}

